"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const schema_utils_1 = require("@trezor/schema-utils");
const transport_1 = require("@trezor/transport");
const constants_1 = require("../constants");
const AbstractMethod_1 = require("../core/AbstractMethod");
const events_1 = require("../events");
class BleUnpair extends AbstractMethod_1.AbstractMethod {
    init() {
        this.allowDeviceMode = [events_1.UI.INITIALIZE, events_1.UI.SEEDLESS];
        this.requiredPermissions = ['management'];
        this.useDeviceState = false;
        this.skipFinalReload = true;
        const { payload } = this;
        this.params = {
            all: payload.all,
        };
        (0, schema_utils_1.Assert)(constants_1.PROTO.BleUnpair, payload);
    }
    async run() {
        const cmd = this.device.getCommands();
        try {
            const response = await cmd.typedCall('BleUnpair', 'Success', this.params);
            return response.message;
        }
        catch (error) {
            if (this.device.bluetoothProps &&
                error.message === transport_1.TRANSPORT_ERROR.INTERFACE_DATA_TRANSFER) {
                throw constants_1.ERRORS.TypedError('Device_Disconnected');
            }
            throw error;
        }
    }
}
exports.default = BleUnpair;
//# sourceMappingURL=bleUnpair.js.map