import { PROTO } from '../../constants';
import type { TypedCall } from '../../device/DeviceCommands';
import type { BitcoinNetworkInfo } from '../../types';
import type { RefTransaction, SignedTransaction, TransactionOptions } from '../../types/api/bitcoin';
export interface SignTxHelperProps {
    typedCall: TypedCall;
    txRequest: PROTO.TxRequest;
    refTxs: Record<string, RefTransaction>;
    inputs: PROTO.TxInputType[];
    outputs: PROTO.TxOutputType[];
    paymentRequests: PROTO.PaymentRequest[];
    serializedTx: string[];
    signatures: string[];
}
export interface SignTxHelperParams {
    typedCall: TypedCall;
    inputs: PROTO.TxInputType[];
    outputs: PROTO.TxOutputType[];
    paymentRequests?: PROTO.PaymentRequest[];
    refTxs: RefTransaction[];
    options: TransactionOptions;
    coinInfo: BitcoinNetworkInfo;
}
export declare const signTx: ({ typedCall, inputs, outputs, paymentRequests, refTxs, options, coinInfo, }: SignTxHelperParams) => Promise<SignedTransaction>;
//# sourceMappingURL=signtx.d.ts.map