"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createPendingTransaction = void 0;
const bigNumber_1 = require("@trezor/utils/lib/bigNumber");
const pathUtils_1 = require("../../utils/pathUtils");
const createPendingTransaction = (tx, { addresses, inputs, outputs, }) => {
    const valueOut = outputs.reduce((sum, out) => (0, bigNumber_1.BigNumber)(sum).plus(out.amount), new bigNumber_1.BigNumber('0'));
    const valueIn = inputs.reduce((sum, ins) => (0, bigNumber_1.BigNumber)(sum).plus(ins.amount), new bigNumber_1.BigNumber('0'));
    const allAddresses = addresses.unused.concat(addresses.used, addresses.change);
    const findAddress = ({ address_n }) => {
        const path = address_n ? (0, pathUtils_1.getSerializedPath)(address_n) : undefined;
        return allAddresses
            .filter(address => address.path === path)
            .map(address => address.address);
    };
    return {
        txid: tx.getId(),
        hex: tx.toHex(),
        blockHeight: 0,
        blockTime: Math.floor(Date.now() / 1000),
        confirmations: 0,
        vsize: tx.virtualSize(),
        size: tx.weight(),
        value: valueOut.toString(),
        valueIn: valueIn.toString(),
        fees: valueIn.minus(valueOut).toString(),
        vin: inputs.map((ins, n) => ({
            n,
            txid: ins.prev_hash,
            vout: ins.prev_index,
            isAddress: true,
            addresses: findAddress(ins),
            value: ins.amount.toString(),
            sequence: ins.sequence,
        })),
        vout: outputs.map((out, n) => {
            let transformedAddresses = [];
            if (out.address) {
                transformedAddresses = [out.address];
            }
            else if ('op_return_data' in out) {
                transformedAddresses = [
                    `OP_RETURN (${Buffer.from(out.op_return_data, 'hex').toString('ascii')})`,
                ];
            }
            else {
                transformedAddresses = findAddress(out);
            }
            return {
                n,
                isAddress: out.script_type !== 'PAYTOOPRETURN',
                addresses: transformedAddresses,
                value: out.amount.toString(),
            };
        }),
    };
};
exports.createPendingTransaction = createPendingTransaction;
//# sourceMappingURL=createPendingTx.js.map