import { ComposeOutput, TransactionInputOutputSortingStrategy } from '@trezor/utxo-lib';
import { Blockchain } from '../../backend/BlockchainLink';
import { BitcoinFeeLevels } from '../../backend/fees/BitcoinFeeLevels';
import type { BitcoinNetworkInfo, DiscoveryAccount } from '../../types';
import type { ComposeResult, ComposeUtxo, ComposedInputs } from '../../types/api/composeTransaction';
type Options = {
    account: DiscoveryAccount;
    utxos: ComposeUtxo[];
    outputs: ComposeOutput[];
    coinInfo: BitcoinNetworkInfo;
    baseFee?: number;
    sortingStrategy: TransactionInputOutputSortingStrategy;
};
export declare class TransactionComposer {
    account: DiscoveryAccount;
    utxos: ComposedInputs[];
    outputs: ComposeOutput[];
    coinInfo: BitcoinNetworkInfo;
    blockHeight: number;
    baseFee: number;
    sortingStrategy: TransactionInputOutputSortingStrategy;
    feeLevels: BitcoinFeeLevels;
    composed: {
        [key: string]: ComposeResult;
    };
    constructor(options: Options);
    init(blockchain: Blockchain): Promise<void>;
    composeAllFeeLevels(): boolean;
    composeCustomFee(fee: string): void;
    getFeeLevelList(): ({
        blocks?: undefined;
        feePerByte?: undefined;
        name: string;
        fee: "0";
        disabled: true;
    } | {
        blocks: number;
        name: string;
        fee: string;
        feePerByte: string;
        minutes: number;
        total: string;
    })[];
    compose(feeRate: string): ComposeResult;
    dispose(): void;
}
export {};
//# sourceMappingURL=TransactionComposer.d.ts.map