import EventEmitter from 'events';
import { CoreEventMessage, IFrameLoaded } from '@trezor/connect/lib/events';
import type { ConnectSettings } from '@trezor/connect/lib/types';
import { Log } from '@trezor/connect/lib/utils/debug';
import { AbstractMessageChannel, Message } from '@trezor/connect-common/lib/messageChannel/abstract';
import type { IntervalId, TimerId } from '@trezor/type-utils';
import { Deferred } from '@trezor/utils';
export declare class PopupManager extends EventEmitter {
    popupWindow: {
        mode: 'tab';
        tab: chrome.tabs.Tab;
    } | {
        mode: 'window';
        window: Window;
    } | undefined;
    settings: ConnectSettings;
    origin: string;
    locked: boolean;
    channel: AbstractMessageChannel<CoreEventMessage>;
    channelIframe?: AbstractMessageChannel<CoreEventMessage>;
    handshakePromise: Deferred<void> | undefined;
    iframeHandshakePromise: Deferred<IFrameLoaded['payload']> | undefined;
    popupPromise: Deferred<void> | undefined;
    requestTimeout: TimerId | undefined;
    openTimeout: TimerId | undefined;
    closeInterval: IntervalId | undefined;
    extensionTabId: number;
    logger: Log;
    constructor(settings: ConnectSettings, { logger }: {
        logger: Log;
    });
    request(): Promise<void>;
    unlock(): void;
    open(): void;
    buildPopupUrl(src: string): string;
    openWrapper(url: string): void;
    private injectContentScript;
    handleCoreMessage(message: Message<CoreEventMessage>): void;
    handleExtensionMessage(data: Message<CoreEventMessage>): void;
    handleMessage(data: Message<CoreEventMessage>): void;
    clear(focus?: boolean): void;
    close(): void;
    postMessage(message: CoreEventMessage): Promise<void>;
    private isWebExtensionWithTab;
    emitClosed(): void;
}
//# sourceMappingURL=index.d.ts.map