import { AbstractMessageChannel, AbstractMessageChannelConstructorParams, Message } from '@trezor/connect-common';
export declare class WindowWindowChannel<IncomingMessages extends {
    type: string;
    channel?: {
        peer: string;
        here: string;
    };
    payload?: any;
}> extends AbstractMessageChannel<IncomingMessages> {
    _windowHere: Window;
    _listener: typeof WindowWindowChannel.prototype.listener;
    constructor({ windowHere, windowPeer, channel, logger, origin, legacyMode, }: Pick<AbstractMessageChannelConstructorParams, 'channel' | 'logger' | 'legacyMode'> & {
        windowHere: Window;
        windowPeer: () => Window | undefined;
        origin: string;
    });
    listener(event: MessageEvent<Message<IncomingMessages>>): void;
    connect(): void;
    disconnect(): void;
}
//# sourceMappingURL=window-window.d.ts.map