"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TcpSocket = void 0;
const net_1 = require("net");
const base_1 = require("./base");
class TcpSocket extends base_1.SocketBase {
    openSocket(listener) {
        const socket = new net_1.Socket();
        this.configureSocket(socket);
        this.bindSocket(socket, listener);
        return new Promise((resolve, reject) => {
            const errorHandler = (err) => reject(err);
            socket.on('error', errorHandler);
            socket.connect(this.port, this.host, () => {
                socket.removeListener('error', errorHandler);
                resolve(socket);
            });
        });
    }
}
exports.TcpSocket = TcpSocket;
//# sourceMappingURL=tcp.js.map