"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BatchingJsonRpcClient = void 0;
const json_rpc_1 = require("./json-rpc");
const TIMEOUT_MS = 50;
const MAX_QUEUE_LENGTH = 15;
class BatchingJsonRpcClient extends json_rpc_1.JsonRpcClient {
    queue = [];
    batchTimer;
    timeoutMs;
    maxQueueLength;
    batchingDisabled = false;
    constructor(options) {
        super();
        this.timeoutMs = options?.timeoutMs || TIMEOUT_MS;
        this.maxQueueLength = options?.maxQueueLength || MAX_QUEUE_LENGTH;
    }
    send(message) {
        if (this.batchingDisabled) {
            super.send(message);
            return;
        }
        const { queue } = this;
        queue.push(message);
        if (this.batchTimer)
            clearTimeout(this.batchTimer);
        this.batchTimer = setTimeout(() => {
            this.batchTimer = undefined;
            while (queue.length) {
                const q = queue.splice(0, this.maxQueueLength);
                const content = q.length > 1 ? `[${q.join(',')}]` : q[0];
                super.send(content);
            }
        }, this.timeoutMs);
    }
    onMessage(body) {
        const msg = JSON.parse(body);
        this.log('RECEIVED:', msg);
        if (Array.isArray(msg)) {
            msg.forEach(this.response, this);
        }
        else {
            this.response(msg);
        }
    }
}
exports.BatchingJsonRpcClient = BatchingJsonRpcClient;
//# sourceMappingURL=batching.js.map