// Automatically generated by xdrgen on 2024-09-12T11:09:00-08:00
// DO NOT EDIT or your changes may be overwritten
import { Operation } from './index';

export {};

// Hidden namespace as hack to work around name collision.
declare namespace xdrHidden {
  // tslint:disable-line:strict-export-declare-modifiers
  class Operation2<T extends Operation = Operation> {
    constructor(attributes: {
      sourceAccount: null | xdr.MuxedAccount;
      body: xdr.OperationBody;
    });

    sourceAccount(value?: null | xdr.MuxedAccount): null | xdr.MuxedAccount;

    body(value?: xdr.OperationBody): xdr.OperationBody;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): xdr.Operation;

    static write(value: xdr.Operation, io: Buffer): void;

    static isValid(value: xdr.Operation): boolean;

    static toXDR(value: xdr.Operation): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): xdr.Operation;

    static fromXDR(input: string, format: 'hex' | 'base64'): xdr.Operation;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }
}

export namespace xdr {
  export import Operation = xdrHidden.Operation2; // tslint:disable-line:strict-export-declare-modifiers

  type Hash = Opaque[]; // workaround, cause unknown

  interface SignedInt {
    readonly MAX_VALUE: 2147483647;
    readonly MIN_VALUE: -2147483648;
    read(io: Buffer): number;
    write(value: number, io: Buffer): void;
    isValid(value: number): boolean;
    toXDR(value: number): Buffer;
    fromXDR(input: Buffer, format?: 'raw'): number;
    fromXDR(input: string, format: 'hex' | 'base64'): number;
    validateXDR(input: Buffer, format?: 'raw'): boolean;
    validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  interface UnsignedInt {
    readonly MAX_VALUE: 4294967295;
    readonly MIN_VALUE: 0;
    read(io: Buffer): number;
    write(value: number, io: Buffer): void;
    isValid(value: number): boolean;
    toXDR(value: number): Buffer;
    fromXDR(input: Buffer, format?: 'raw'): number;
    fromXDR(input: string, format: 'hex' | 'base64'): number;
    validateXDR(input: Buffer, format?: 'raw'): boolean;
    validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  interface Bool {
    read(io: Buffer): boolean;
    write(value: boolean, io: Buffer): void;
    isValid(value: boolean): boolean;
    toXDR(value: boolean): Buffer;
    fromXDR(input: Buffer, format?: 'raw'): boolean;
    fromXDR(input: string, format: 'hex' | 'base64'): boolean;
    validateXDR(input: Buffer, format?: 'raw'): boolean;
    validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class Hyper {
    low: number;

    high: number;

    unsigned: boolean;

    constructor(
      values: string | bigint | number | (string | bigint | number)[],
    );

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static toXDR(value: Hyper): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): Hyper;

    static fromXDR(input: string, format: 'hex' | 'base64'): Hyper;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;

    static readonly MAX_VALUE: Hyper;

    static readonly MIN_VALUE: Hyper;

    static read(io: Buffer): Hyper;

    static write(value: Hyper, io: Buffer): void;

    static fromString(input: string): Hyper;

    static fromBytes(low: number, high: number): Hyper;

    static isValid(value: Hyper): boolean;

    toBigInt(): bigint;

    toString(): string;
  }

  class UnsignedHyper {
    low: number;

    high: number;

    unsigned: boolean;

    constructor(
      values: string | bigint | number | (string | bigint | number)[],
    );

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static toXDR(value: UnsignedHyper): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): UnsignedHyper;

    static fromXDR(input: string, format: 'hex' | 'base64'): UnsignedHyper;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;

    static readonly MAX_VALUE: UnsignedHyper;

    static readonly MIN_VALUE: UnsignedHyper;

    static read(io: Buffer): UnsignedHyper;

    static write(value: UnsignedHyper, io: Buffer): void;

    static fromString(input: string): UnsignedHyper;

    static fromBytes(low: number, high: number): UnsignedHyper;

    static isValid(value: UnsignedHyper): boolean;

    toBigInt(): bigint;

    toString(): string;
  }

  class XDRString {
    constructor(maxLength: 4294967295);

    read(io: Buffer): Buffer;

    readString(io: Buffer): string;

    write(value: string | Buffer, io: Buffer): void;

    isValid(value: string | number[] | Buffer): boolean;

    toXDR(value: string | Buffer): Buffer;

    fromXDR(input: Buffer, format?: 'raw'): Buffer;

    fromXDR(input: string, format: 'hex' | 'base64'): Buffer;

    validateXDR(input: Buffer, format?: 'raw'): boolean;

    validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class XDRArray<T> {
    read(io: Buffer): Buffer;

    write(value: T[], io: Buffer): void;

    isValid(value: T[]): boolean;

    toXDR(value: T[]): Buffer;

    fromXDR(input: Buffer, format?: 'raw'): T[];

    fromXDR(input: string, format: 'hex' | 'base64'): T[];

    validateXDR(input: Buffer, format?: 'raw'): boolean;

    validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class Opaque {
    constructor(length: number);

    read(io: Buffer): Buffer;

    write(value: Buffer, io: Buffer): void;

    isValid(value: Buffer): boolean;

    toXDR(value: Buffer): Buffer;

    fromXDR(input: Buffer, format?: 'raw'): Buffer;

    fromXDR(input: string, format: 'hex' | 'base64'): Buffer;

    validateXDR(input: Buffer, format?: 'raw'): boolean;

    validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class VarOpaque extends Opaque {}

  class Option {
    constructor(childType: {
      read(io: any): any;
      write(value: any, io: Buffer): void;
      isValid(value: any): boolean;
    });

    read(io: Buffer): any;

    write(value: any, io: Buffer): void;

    isValid(value: any): boolean;

    toXDR(value: any): Buffer;

    fromXDR(input: Buffer, format?: 'raw'): any;

    fromXDR(input: string, format: 'hex' | 'base64'): any;

    validateXDR(input: Buffer, format?: 'raw'): boolean;

    validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScpStatementType {
    readonly name:
      | 'scpStPrepare'
      | 'scpStConfirm'
      | 'scpStExternalize'
      | 'scpStNominate';

    readonly value: 0 | 1 | 2 | 3;

    static scpStPrepare(): ScpStatementType;

    static scpStConfirm(): ScpStatementType;

    static scpStExternalize(): ScpStatementType;

    static scpStNominate(): ScpStatementType;
  }

  class AssetType {
    readonly name:
      | 'assetTypeNative'
      | 'assetTypeCreditAlphanum4'
      | 'assetTypeCreditAlphanum12'
      | 'assetTypePoolShare';

    readonly value: 0 | 1 | 2 | 3;

    static assetTypeNative(): AssetType;

    static assetTypeCreditAlphanum4(): AssetType;

    static assetTypeCreditAlphanum12(): AssetType;

    static assetTypePoolShare(): AssetType;
  }

  class ThresholdIndices {
    readonly name:
      | 'thresholdMasterWeight'
      | 'thresholdLow'
      | 'thresholdMed'
      | 'thresholdHigh';

    readonly value: 0 | 1 | 2 | 3;

    static thresholdMasterWeight(): ThresholdIndices;

    static thresholdLow(): ThresholdIndices;

    static thresholdMed(): ThresholdIndices;

    static thresholdHigh(): ThresholdIndices;
  }

  class LedgerEntryType {
    readonly name:
      | 'account'
      | 'trustline'
      | 'offer'
      | 'data'
      | 'claimableBalance'
      | 'liquidityPool'
      | 'contractData'
      | 'contractCode'
      | 'configSetting'
      | 'ttl';

    readonly value: 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9;

    static account(): LedgerEntryType;

    static trustline(): LedgerEntryType;

    static offer(): LedgerEntryType;

    static data(): LedgerEntryType;

    static claimableBalance(): LedgerEntryType;

    static liquidityPool(): LedgerEntryType;

    static contractData(): LedgerEntryType;

    static contractCode(): LedgerEntryType;

    static configSetting(): LedgerEntryType;

    static ttl(): LedgerEntryType;
  }

  class AccountFlags {
    readonly name:
      | 'authRequiredFlag'
      | 'authRevocableFlag'
      | 'authImmutableFlag'
      | 'authClawbackEnabledFlag';

    readonly value: 1 | 2 | 4 | 8;

    static authRequiredFlag(): AccountFlags;

    static authRevocableFlag(): AccountFlags;

    static authImmutableFlag(): AccountFlags;

    static authClawbackEnabledFlag(): AccountFlags;
  }

  class TrustLineFlags {
    readonly name:
      | 'authorizedFlag'
      | 'authorizedToMaintainLiabilitiesFlag'
      | 'trustlineClawbackEnabledFlag';

    readonly value: 1 | 2 | 4;

    static authorizedFlag(): TrustLineFlags;

    static authorizedToMaintainLiabilitiesFlag(): TrustLineFlags;

    static trustlineClawbackEnabledFlag(): TrustLineFlags;
  }

  class LiquidityPoolType {
    readonly name: 'liquidityPoolConstantProduct';

    readonly value: 0;

    static liquidityPoolConstantProduct(): LiquidityPoolType;
  }

  class OfferEntryFlags {
    readonly name: 'passiveFlag';

    readonly value: 1;

    static passiveFlag(): OfferEntryFlags;
  }

  class ClaimPredicateType {
    readonly name:
      | 'claimPredicateUnconditional'
      | 'claimPredicateAnd'
      | 'claimPredicateOr'
      | 'claimPredicateNot'
      | 'claimPredicateBeforeAbsoluteTime'
      | 'claimPredicateBeforeRelativeTime';

    readonly value: 0 | 1 | 2 | 3 | 4 | 5;

    static claimPredicateUnconditional(): ClaimPredicateType;

    static claimPredicateAnd(): ClaimPredicateType;

    static claimPredicateOr(): ClaimPredicateType;

    static claimPredicateNot(): ClaimPredicateType;

    static claimPredicateBeforeAbsoluteTime(): ClaimPredicateType;

    static claimPredicateBeforeRelativeTime(): ClaimPredicateType;
  }

  class ClaimantType {
    readonly name: 'claimantTypeV0';

    readonly value: 0;

    static claimantTypeV0(): ClaimantType;
  }

  class ClaimableBalanceIdType {
    readonly name: 'claimableBalanceIdTypeV0';

    readonly value: 0;

    static claimableBalanceIdTypeV0(): ClaimableBalanceIdType;
  }

  class ClaimableBalanceFlags {
    readonly name: 'claimableBalanceClawbackEnabledFlag';

    readonly value: 1;

    static claimableBalanceClawbackEnabledFlag(): ClaimableBalanceFlags;
  }

  class ContractDataDurability {
    readonly name: 'temporary' | 'persistent';

    readonly value: 0 | 1;

    static temporary(): ContractDataDurability;

    static persistent(): ContractDataDurability;
  }

  class EnvelopeType {
    readonly name:
      | 'envelopeTypeTxV0'
      | 'envelopeTypeScp'
      | 'envelopeTypeTx'
      | 'envelopeTypeAuth'
      | 'envelopeTypeScpvalue'
      | 'envelopeTypeTxFeeBump'
      | 'envelopeTypeOpId'
      | 'envelopeTypePoolRevokeOpId'
      | 'envelopeTypeContractId'
      | 'envelopeTypeSorobanAuthorization';

    readonly value: 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9;

    static envelopeTypeTxV0(): EnvelopeType;

    static envelopeTypeScp(): EnvelopeType;

    static envelopeTypeTx(): EnvelopeType;

    static envelopeTypeAuth(): EnvelopeType;

    static envelopeTypeScpvalue(): EnvelopeType;

    static envelopeTypeTxFeeBump(): EnvelopeType;

    static envelopeTypeOpId(): EnvelopeType;

    static envelopeTypePoolRevokeOpId(): EnvelopeType;

    static envelopeTypeContractId(): EnvelopeType;

    static envelopeTypeSorobanAuthorization(): EnvelopeType;
  }

  class BucketListType {
    readonly name: 'live' | 'hotArchive' | 'coldArchive';

    readonly value: 0 | 1 | 2;

    static live(): BucketListType;

    static hotArchive(): BucketListType;

    static coldArchive(): BucketListType;
  }

  class BucketEntryType {
    readonly name: 'metaentry' | 'liveentry' | 'deadentry' | 'initentry';

    readonly value: -1 | 0 | 1 | 2;

    static metaentry(): BucketEntryType;

    static liveentry(): BucketEntryType;

    static deadentry(): BucketEntryType;

    static initentry(): BucketEntryType;
  }

  class HotArchiveBucketEntryType {
    readonly name:
      | 'hotArchiveMetaentry'
      | 'hotArchiveArchived'
      | 'hotArchiveLive'
      | 'hotArchiveDeleted';

    readonly value: -1 | 0 | 1 | 2;

    static hotArchiveMetaentry(): HotArchiveBucketEntryType;

    static hotArchiveArchived(): HotArchiveBucketEntryType;

    static hotArchiveLive(): HotArchiveBucketEntryType;

    static hotArchiveDeleted(): HotArchiveBucketEntryType;
  }

  class ColdArchiveBucketEntryType {
    readonly name:
      | 'coldArchiveMetaentry'
      | 'coldArchiveArchivedLeaf'
      | 'coldArchiveDeletedLeaf'
      | 'coldArchiveBoundaryLeaf'
      | 'coldArchiveHash';

    readonly value: -1 | 0 | 1 | 2 | 3;

    static coldArchiveMetaentry(): ColdArchiveBucketEntryType;

    static coldArchiveArchivedLeaf(): ColdArchiveBucketEntryType;

    static coldArchiveDeletedLeaf(): ColdArchiveBucketEntryType;

    static coldArchiveBoundaryLeaf(): ColdArchiveBucketEntryType;

    static coldArchiveHash(): ColdArchiveBucketEntryType;
  }

  class StellarValueType {
    readonly name: 'stellarValueBasic' | 'stellarValueSigned';

    readonly value: 0 | 1;

    static stellarValueBasic(): StellarValueType;

    static stellarValueSigned(): StellarValueType;
  }

  class LedgerHeaderFlags {
    readonly name:
      | 'disableLiquidityPoolTradingFlag'
      | 'disableLiquidityPoolDepositFlag'
      | 'disableLiquidityPoolWithdrawalFlag';

    readonly value: 1 | 2 | 4;

    static disableLiquidityPoolTradingFlag(): LedgerHeaderFlags;

    static disableLiquidityPoolDepositFlag(): LedgerHeaderFlags;

    static disableLiquidityPoolWithdrawalFlag(): LedgerHeaderFlags;
  }

  class LedgerUpgradeType {
    readonly name:
      | 'ledgerUpgradeVersion'
      | 'ledgerUpgradeBaseFee'
      | 'ledgerUpgradeMaxTxSetSize'
      | 'ledgerUpgradeBaseReserve'
      | 'ledgerUpgradeFlags'
      | 'ledgerUpgradeConfig'
      | 'ledgerUpgradeMaxSorobanTxSetSize';

    readonly value: 1 | 2 | 3 | 4 | 5 | 6 | 7;

    static ledgerUpgradeVersion(): LedgerUpgradeType;

    static ledgerUpgradeBaseFee(): LedgerUpgradeType;

    static ledgerUpgradeMaxTxSetSize(): LedgerUpgradeType;

    static ledgerUpgradeBaseReserve(): LedgerUpgradeType;

    static ledgerUpgradeFlags(): LedgerUpgradeType;

    static ledgerUpgradeConfig(): LedgerUpgradeType;

    static ledgerUpgradeMaxSorobanTxSetSize(): LedgerUpgradeType;
  }

  class TxSetComponentType {
    readonly name: 'txsetCompTxsMaybeDiscountedFee';

    readonly value: 0;

    static txsetCompTxsMaybeDiscountedFee(): TxSetComponentType;
  }

  class LedgerEntryChangeType {
    readonly name:
      | 'ledgerEntryCreated'
      | 'ledgerEntryUpdated'
      | 'ledgerEntryRemoved'
      | 'ledgerEntryState';

    readonly value: 0 | 1 | 2 | 3;

    static ledgerEntryCreated(): LedgerEntryChangeType;

    static ledgerEntryUpdated(): LedgerEntryChangeType;

    static ledgerEntryRemoved(): LedgerEntryChangeType;

    static ledgerEntryState(): LedgerEntryChangeType;
  }

  class ContractEventType {
    readonly name: 'system' | 'contract' | 'diagnostic';

    readonly value: 0 | 1 | 2;

    static system(): ContractEventType;

    static contract(): ContractEventType;

    static diagnostic(): ContractEventType;
  }

  class ErrorCode {
    readonly name: 'errMisc' | 'errData' | 'errConf' | 'errAuth' | 'errLoad';

    readonly value: 0 | 1 | 2 | 3 | 4;

    static errMisc(): ErrorCode;

    static errData(): ErrorCode;

    static errConf(): ErrorCode;

    static errAuth(): ErrorCode;

    static errLoad(): ErrorCode;
  }

  class IpAddrType {
    readonly name: 'iPv4' | 'iPv6';

    readonly value: 0 | 1;

    static iPv4(): IpAddrType;

    static iPv6(): IpAddrType;
  }

  class MessageType {
    readonly name:
      | 'errorMsg'
      | 'auth'
      | 'dontHave'
      | 'getPeers'
      | 'peers'
      | 'getTxSet'
      | 'txSet'
      | 'generalizedTxSet'
      | 'transaction'
      | 'getScpQuorumset'
      | 'scpQuorumset'
      | 'scpMessage'
      | 'getScpState'
      | 'hello'
      | 'surveyRequest'
      | 'surveyResponse'
      | 'sendMore'
      | 'sendMoreExtended'
      | 'floodAdvert'
      | 'floodDemand'
      | 'timeSlicedSurveyRequest'
      | 'timeSlicedSurveyResponse'
      | 'timeSlicedSurveyStartCollecting'
      | 'timeSlicedSurveyStopCollecting';

    readonly value:
      | 0
      | 2
      | 3
      | 4
      | 5
      | 6
      | 7
      | 17
      | 8
      | 9
      | 10
      | 11
      | 12
      | 13
      | 14
      | 15
      | 16
      | 20
      | 18
      | 19
      | 21
      | 22
      | 23
      | 24;

    static errorMsg(): MessageType;

    static auth(): MessageType;

    static dontHave(): MessageType;

    static getPeers(): MessageType;

    static peers(): MessageType;

    static getTxSet(): MessageType;

    static txSet(): MessageType;

    static generalizedTxSet(): MessageType;

    static transaction(): MessageType;

    static getScpQuorumset(): MessageType;

    static scpQuorumset(): MessageType;

    static scpMessage(): MessageType;

    static getScpState(): MessageType;

    static hello(): MessageType;

    static surveyRequest(): MessageType;

    static surveyResponse(): MessageType;

    static sendMore(): MessageType;

    static sendMoreExtended(): MessageType;

    static floodAdvert(): MessageType;

    static floodDemand(): MessageType;

    static timeSlicedSurveyRequest(): MessageType;

    static timeSlicedSurveyResponse(): MessageType;

    static timeSlicedSurveyStartCollecting(): MessageType;

    static timeSlicedSurveyStopCollecting(): MessageType;
  }

  class SurveyMessageCommandType {
    readonly name: 'surveyTopology' | 'timeSlicedSurveyTopology';

    readonly value: 0 | 1;

    static surveyTopology(): SurveyMessageCommandType;

    static timeSlicedSurveyTopology(): SurveyMessageCommandType;
  }

  class SurveyMessageResponseType {
    readonly name:
      | 'surveyTopologyResponseV0'
      | 'surveyTopologyResponseV1'
      | 'surveyTopologyResponseV2';

    readonly value: 0 | 1 | 2;

    static surveyTopologyResponseV0(): SurveyMessageResponseType;

    static surveyTopologyResponseV1(): SurveyMessageResponseType;

    static surveyTopologyResponseV2(): SurveyMessageResponseType;
  }

  class OperationType {
    readonly name:
      | 'createAccount'
      | 'payment'
      | 'pathPaymentStrictReceive'
      | 'manageSellOffer'
      | 'createPassiveSellOffer'
      | 'setOptions'
      | 'changeTrust'
      | 'allowTrust'
      | 'accountMerge'
      | 'inflation'
      | 'manageData'
      | 'bumpSequence'
      | 'manageBuyOffer'
      | 'pathPaymentStrictSend'
      | 'createClaimableBalance'
      | 'claimClaimableBalance'
      | 'beginSponsoringFutureReserves'
      | 'endSponsoringFutureReserves'
      | 'revokeSponsorship'
      | 'clawback'
      | 'clawbackClaimableBalance'
      | 'setTrustLineFlags'
      | 'liquidityPoolDeposit'
      | 'liquidityPoolWithdraw'
      | 'invokeHostFunction'
      | 'extendFootprintTtl'
      | 'restoreFootprint';

    readonly value:
      | 0
      | 1
      | 2
      | 3
      | 4
      | 5
      | 6
      | 7
      | 8
      | 9
      | 10
      | 11
      | 12
      | 13
      | 14
      | 15
      | 16
      | 17
      | 18
      | 19
      | 20
      | 21
      | 22
      | 23
      | 24
      | 25
      | 26;

    static createAccount(): OperationType;

    static payment(): OperationType;

    static pathPaymentStrictReceive(): OperationType;

    static manageSellOffer(): OperationType;

    static createPassiveSellOffer(): OperationType;

    static setOptions(): OperationType;

    static changeTrust(): OperationType;

    static allowTrust(): OperationType;

    static accountMerge(): OperationType;

    static inflation(): OperationType;

    static manageData(): OperationType;

    static bumpSequence(): OperationType;

    static manageBuyOffer(): OperationType;

    static pathPaymentStrictSend(): OperationType;

    static createClaimableBalance(): OperationType;

    static claimClaimableBalance(): OperationType;

    static beginSponsoringFutureReserves(): OperationType;

    static endSponsoringFutureReserves(): OperationType;

    static revokeSponsorship(): OperationType;

    static clawback(): OperationType;

    static clawbackClaimableBalance(): OperationType;

    static setTrustLineFlags(): OperationType;

    static liquidityPoolDeposit(): OperationType;

    static liquidityPoolWithdraw(): OperationType;

    static invokeHostFunction(): OperationType;

    static extendFootprintTtl(): OperationType;

    static restoreFootprint(): OperationType;
  }

  class RevokeSponsorshipType {
    readonly name: 'revokeSponsorshipLedgerEntry' | 'revokeSponsorshipSigner';

    readonly value: 0 | 1;

    static revokeSponsorshipLedgerEntry(): RevokeSponsorshipType;

    static revokeSponsorshipSigner(): RevokeSponsorshipType;
  }

  class HostFunctionType {
    readonly name:
      | 'hostFunctionTypeInvokeContract'
      | 'hostFunctionTypeCreateContract'
      | 'hostFunctionTypeUploadContractWasm'
      | 'hostFunctionTypeCreateContractV2';

    readonly value: 0 | 1 | 2 | 3;

    static hostFunctionTypeInvokeContract(): HostFunctionType;

    static hostFunctionTypeCreateContract(): HostFunctionType;

    static hostFunctionTypeUploadContractWasm(): HostFunctionType;

    static hostFunctionTypeCreateContractV2(): HostFunctionType;
  }

  class ContractIdPreimageType {
    readonly name:
      | 'contractIdPreimageFromAddress'
      | 'contractIdPreimageFromAsset';

    readonly value: 0 | 1;

    static contractIdPreimageFromAddress(): ContractIdPreimageType;

    static contractIdPreimageFromAsset(): ContractIdPreimageType;
  }

  class SorobanAuthorizedFunctionType {
    readonly name:
      | 'sorobanAuthorizedFunctionTypeContractFn'
      | 'sorobanAuthorizedFunctionTypeCreateContractHostFn'
      | 'sorobanAuthorizedFunctionTypeCreateContractV2HostFn';

    readonly value: 0 | 1 | 2;

    static sorobanAuthorizedFunctionTypeContractFn(): SorobanAuthorizedFunctionType;

    static sorobanAuthorizedFunctionTypeCreateContractHostFn(): SorobanAuthorizedFunctionType;

    static sorobanAuthorizedFunctionTypeCreateContractV2HostFn(): SorobanAuthorizedFunctionType;
  }

  class SorobanCredentialsType {
    readonly name:
      | 'sorobanCredentialsSourceAccount'
      | 'sorobanCredentialsAddress';

    readonly value: 0 | 1;

    static sorobanCredentialsSourceAccount(): SorobanCredentialsType;

    static sorobanCredentialsAddress(): SorobanCredentialsType;
  }

  class MemoType {
    readonly name:
      | 'memoNone'
      | 'memoText'
      | 'memoId'
      | 'memoHash'
      | 'memoReturn';

    readonly value: 0 | 1 | 2 | 3 | 4;

    static memoNone(): MemoType;

    static memoText(): MemoType;

    static memoId(): MemoType;

    static memoHash(): MemoType;

    static memoReturn(): MemoType;
  }

  class PreconditionType {
    readonly name: 'precondNone' | 'precondTime' | 'precondV2';

    readonly value: 0 | 1 | 2;

    static precondNone(): PreconditionType;

    static precondTime(): PreconditionType;

    static precondV2(): PreconditionType;
  }

  class ArchivalProofType {
    readonly name: 'existence' | 'nonexistence';

    readonly value: 0 | 1;

    static existence(): ArchivalProofType;

    static nonexistence(): ArchivalProofType;
  }

  class ClaimAtomType {
    readonly name:
      | 'claimAtomTypeV0'
      | 'claimAtomTypeOrderBook'
      | 'claimAtomTypeLiquidityPool';

    readonly value: 0 | 1 | 2;

    static claimAtomTypeV0(): ClaimAtomType;

    static claimAtomTypeOrderBook(): ClaimAtomType;

    static claimAtomTypeLiquidityPool(): ClaimAtomType;
  }

  class CreateAccountResultCode {
    readonly name:
      | 'createAccountSuccess'
      | 'createAccountMalformed'
      | 'createAccountUnderfunded'
      | 'createAccountLowReserve'
      | 'createAccountAlreadyExist';

    readonly value: 0 | -1 | -2 | -3 | -4;

    static createAccountSuccess(): CreateAccountResultCode;

    static createAccountMalformed(): CreateAccountResultCode;

    static createAccountUnderfunded(): CreateAccountResultCode;

    static createAccountLowReserve(): CreateAccountResultCode;

    static createAccountAlreadyExist(): CreateAccountResultCode;
  }

  class PaymentResultCode {
    readonly name:
      | 'paymentSuccess'
      | 'paymentMalformed'
      | 'paymentUnderfunded'
      | 'paymentSrcNoTrust'
      | 'paymentSrcNotAuthorized'
      | 'paymentNoDestination'
      | 'paymentNoTrust'
      | 'paymentNotAuthorized'
      | 'paymentLineFull'
      | 'paymentNoIssuer';

    readonly value: 0 | -1 | -2 | -3 | -4 | -5 | -6 | -7 | -8 | -9;

    static paymentSuccess(): PaymentResultCode;

    static paymentMalformed(): PaymentResultCode;

    static paymentUnderfunded(): PaymentResultCode;

    static paymentSrcNoTrust(): PaymentResultCode;

    static paymentSrcNotAuthorized(): PaymentResultCode;

    static paymentNoDestination(): PaymentResultCode;

    static paymentNoTrust(): PaymentResultCode;

    static paymentNotAuthorized(): PaymentResultCode;

    static paymentLineFull(): PaymentResultCode;

    static paymentNoIssuer(): PaymentResultCode;
  }

  class PathPaymentStrictReceiveResultCode {
    readonly name:
      | 'pathPaymentStrictReceiveSuccess'
      | 'pathPaymentStrictReceiveMalformed'
      | 'pathPaymentStrictReceiveUnderfunded'
      | 'pathPaymentStrictReceiveSrcNoTrust'
      | 'pathPaymentStrictReceiveSrcNotAuthorized'
      | 'pathPaymentStrictReceiveNoDestination'
      | 'pathPaymentStrictReceiveNoTrust'
      | 'pathPaymentStrictReceiveNotAuthorized'
      | 'pathPaymentStrictReceiveLineFull'
      | 'pathPaymentStrictReceiveNoIssuer'
      | 'pathPaymentStrictReceiveTooFewOffers'
      | 'pathPaymentStrictReceiveOfferCrossSelf'
      | 'pathPaymentStrictReceiveOverSendmax';

    readonly value:
      | 0
      | -1
      | -2
      | -3
      | -4
      | -5
      | -6
      | -7
      | -8
      | -9
      | -10
      | -11
      | -12;

    static pathPaymentStrictReceiveSuccess(): PathPaymentStrictReceiveResultCode;

    static pathPaymentStrictReceiveMalformed(): PathPaymentStrictReceiveResultCode;

    static pathPaymentStrictReceiveUnderfunded(): PathPaymentStrictReceiveResultCode;

    static pathPaymentStrictReceiveSrcNoTrust(): PathPaymentStrictReceiveResultCode;

    static pathPaymentStrictReceiveSrcNotAuthorized(): PathPaymentStrictReceiveResultCode;

    static pathPaymentStrictReceiveNoDestination(): PathPaymentStrictReceiveResultCode;

    static pathPaymentStrictReceiveNoTrust(): PathPaymentStrictReceiveResultCode;

    static pathPaymentStrictReceiveNotAuthorized(): PathPaymentStrictReceiveResultCode;

    static pathPaymentStrictReceiveLineFull(): PathPaymentStrictReceiveResultCode;

    static pathPaymentStrictReceiveNoIssuer(): PathPaymentStrictReceiveResultCode;

    static pathPaymentStrictReceiveTooFewOffers(): PathPaymentStrictReceiveResultCode;

    static pathPaymentStrictReceiveOfferCrossSelf(): PathPaymentStrictReceiveResultCode;

    static pathPaymentStrictReceiveOverSendmax(): PathPaymentStrictReceiveResultCode;
  }

  class PathPaymentStrictSendResultCode {
    readonly name:
      | 'pathPaymentStrictSendSuccess'
      | 'pathPaymentStrictSendMalformed'
      | 'pathPaymentStrictSendUnderfunded'
      | 'pathPaymentStrictSendSrcNoTrust'
      | 'pathPaymentStrictSendSrcNotAuthorized'
      | 'pathPaymentStrictSendNoDestination'
      | 'pathPaymentStrictSendNoTrust'
      | 'pathPaymentStrictSendNotAuthorized'
      | 'pathPaymentStrictSendLineFull'
      | 'pathPaymentStrictSendNoIssuer'
      | 'pathPaymentStrictSendTooFewOffers'
      | 'pathPaymentStrictSendOfferCrossSelf'
      | 'pathPaymentStrictSendUnderDestmin';

    readonly value:
      | 0
      | -1
      | -2
      | -3
      | -4
      | -5
      | -6
      | -7
      | -8
      | -9
      | -10
      | -11
      | -12;

    static pathPaymentStrictSendSuccess(): PathPaymentStrictSendResultCode;

    static pathPaymentStrictSendMalformed(): PathPaymentStrictSendResultCode;

    static pathPaymentStrictSendUnderfunded(): PathPaymentStrictSendResultCode;

    static pathPaymentStrictSendSrcNoTrust(): PathPaymentStrictSendResultCode;

    static pathPaymentStrictSendSrcNotAuthorized(): PathPaymentStrictSendResultCode;

    static pathPaymentStrictSendNoDestination(): PathPaymentStrictSendResultCode;

    static pathPaymentStrictSendNoTrust(): PathPaymentStrictSendResultCode;

    static pathPaymentStrictSendNotAuthorized(): PathPaymentStrictSendResultCode;

    static pathPaymentStrictSendLineFull(): PathPaymentStrictSendResultCode;

    static pathPaymentStrictSendNoIssuer(): PathPaymentStrictSendResultCode;

    static pathPaymentStrictSendTooFewOffers(): PathPaymentStrictSendResultCode;

    static pathPaymentStrictSendOfferCrossSelf(): PathPaymentStrictSendResultCode;

    static pathPaymentStrictSendUnderDestmin(): PathPaymentStrictSendResultCode;
  }

  class ManageSellOfferResultCode {
    readonly name:
      | 'manageSellOfferSuccess'
      | 'manageSellOfferMalformed'
      | 'manageSellOfferSellNoTrust'
      | 'manageSellOfferBuyNoTrust'
      | 'manageSellOfferSellNotAuthorized'
      | 'manageSellOfferBuyNotAuthorized'
      | 'manageSellOfferLineFull'
      | 'manageSellOfferUnderfunded'
      | 'manageSellOfferCrossSelf'
      | 'manageSellOfferSellNoIssuer'
      | 'manageSellOfferBuyNoIssuer'
      | 'manageSellOfferNotFound'
      | 'manageSellOfferLowReserve';

    readonly value:
      | 0
      | -1
      | -2
      | -3
      | -4
      | -5
      | -6
      | -7
      | -8
      | -9
      | -10
      | -11
      | -12;

    static manageSellOfferSuccess(): ManageSellOfferResultCode;

    static manageSellOfferMalformed(): ManageSellOfferResultCode;

    static manageSellOfferSellNoTrust(): ManageSellOfferResultCode;

    static manageSellOfferBuyNoTrust(): ManageSellOfferResultCode;

    static manageSellOfferSellNotAuthorized(): ManageSellOfferResultCode;

    static manageSellOfferBuyNotAuthorized(): ManageSellOfferResultCode;

    static manageSellOfferLineFull(): ManageSellOfferResultCode;

    static manageSellOfferUnderfunded(): ManageSellOfferResultCode;

    static manageSellOfferCrossSelf(): ManageSellOfferResultCode;

    static manageSellOfferSellNoIssuer(): ManageSellOfferResultCode;

    static manageSellOfferBuyNoIssuer(): ManageSellOfferResultCode;

    static manageSellOfferNotFound(): ManageSellOfferResultCode;

    static manageSellOfferLowReserve(): ManageSellOfferResultCode;
  }

  class ManageOfferEffect {
    readonly name:
      | 'manageOfferCreated'
      | 'manageOfferUpdated'
      | 'manageOfferDeleted';

    readonly value: 0 | 1 | 2;

    static manageOfferCreated(): ManageOfferEffect;

    static manageOfferUpdated(): ManageOfferEffect;

    static manageOfferDeleted(): ManageOfferEffect;
  }

  class ManageBuyOfferResultCode {
    readonly name:
      | 'manageBuyOfferSuccess'
      | 'manageBuyOfferMalformed'
      | 'manageBuyOfferSellNoTrust'
      | 'manageBuyOfferBuyNoTrust'
      | 'manageBuyOfferSellNotAuthorized'
      | 'manageBuyOfferBuyNotAuthorized'
      | 'manageBuyOfferLineFull'
      | 'manageBuyOfferUnderfunded'
      | 'manageBuyOfferCrossSelf'
      | 'manageBuyOfferSellNoIssuer'
      | 'manageBuyOfferBuyNoIssuer'
      | 'manageBuyOfferNotFound'
      | 'manageBuyOfferLowReserve';

    readonly value:
      | 0
      | -1
      | -2
      | -3
      | -4
      | -5
      | -6
      | -7
      | -8
      | -9
      | -10
      | -11
      | -12;

    static manageBuyOfferSuccess(): ManageBuyOfferResultCode;

    static manageBuyOfferMalformed(): ManageBuyOfferResultCode;

    static manageBuyOfferSellNoTrust(): ManageBuyOfferResultCode;

    static manageBuyOfferBuyNoTrust(): ManageBuyOfferResultCode;

    static manageBuyOfferSellNotAuthorized(): ManageBuyOfferResultCode;

    static manageBuyOfferBuyNotAuthorized(): ManageBuyOfferResultCode;

    static manageBuyOfferLineFull(): ManageBuyOfferResultCode;

    static manageBuyOfferUnderfunded(): ManageBuyOfferResultCode;

    static manageBuyOfferCrossSelf(): ManageBuyOfferResultCode;

    static manageBuyOfferSellNoIssuer(): ManageBuyOfferResultCode;

    static manageBuyOfferBuyNoIssuer(): ManageBuyOfferResultCode;

    static manageBuyOfferNotFound(): ManageBuyOfferResultCode;

    static manageBuyOfferLowReserve(): ManageBuyOfferResultCode;
  }

  class SetOptionsResultCode {
    readonly name:
      | 'setOptionsSuccess'
      | 'setOptionsLowReserve'
      | 'setOptionsTooManySigners'
      | 'setOptionsBadFlags'
      | 'setOptionsInvalidInflation'
      | 'setOptionsCantChange'
      | 'setOptionsUnknownFlag'
      | 'setOptionsThresholdOutOfRange'
      | 'setOptionsBadSigner'
      | 'setOptionsInvalidHomeDomain'
      | 'setOptionsAuthRevocableRequired';

    readonly value: 0 | -1 | -2 | -3 | -4 | -5 | -6 | -7 | -8 | -9 | -10;

    static setOptionsSuccess(): SetOptionsResultCode;

    static setOptionsLowReserve(): SetOptionsResultCode;

    static setOptionsTooManySigners(): SetOptionsResultCode;

    static setOptionsBadFlags(): SetOptionsResultCode;

    static setOptionsInvalidInflation(): SetOptionsResultCode;

    static setOptionsCantChange(): SetOptionsResultCode;

    static setOptionsUnknownFlag(): SetOptionsResultCode;

    static setOptionsThresholdOutOfRange(): SetOptionsResultCode;

    static setOptionsBadSigner(): SetOptionsResultCode;

    static setOptionsInvalidHomeDomain(): SetOptionsResultCode;

    static setOptionsAuthRevocableRequired(): SetOptionsResultCode;
  }

  class ChangeTrustResultCode {
    readonly name:
      | 'changeTrustSuccess'
      | 'changeTrustMalformed'
      | 'changeTrustNoIssuer'
      | 'changeTrustInvalidLimit'
      | 'changeTrustLowReserve'
      | 'changeTrustSelfNotAllowed'
      | 'changeTrustTrustLineMissing'
      | 'changeTrustCannotDelete'
      | 'changeTrustNotAuthMaintainLiabilities';

    readonly value: 0 | -1 | -2 | -3 | -4 | -5 | -6 | -7 | -8;

    static changeTrustSuccess(): ChangeTrustResultCode;

    static changeTrustMalformed(): ChangeTrustResultCode;

    static changeTrustNoIssuer(): ChangeTrustResultCode;

    static changeTrustInvalidLimit(): ChangeTrustResultCode;

    static changeTrustLowReserve(): ChangeTrustResultCode;

    static changeTrustSelfNotAllowed(): ChangeTrustResultCode;

    static changeTrustTrustLineMissing(): ChangeTrustResultCode;

    static changeTrustCannotDelete(): ChangeTrustResultCode;

    static changeTrustNotAuthMaintainLiabilities(): ChangeTrustResultCode;
  }

  class AllowTrustResultCode {
    readonly name:
      | 'allowTrustSuccess'
      | 'allowTrustMalformed'
      | 'allowTrustNoTrustLine'
      | 'allowTrustTrustNotRequired'
      | 'allowTrustCantRevoke'
      | 'allowTrustSelfNotAllowed'
      | 'allowTrustLowReserve';

    readonly value: 0 | -1 | -2 | -3 | -4 | -5 | -6;

    static allowTrustSuccess(): AllowTrustResultCode;

    static allowTrustMalformed(): AllowTrustResultCode;

    static allowTrustNoTrustLine(): AllowTrustResultCode;

    static allowTrustTrustNotRequired(): AllowTrustResultCode;

    static allowTrustCantRevoke(): AllowTrustResultCode;

    static allowTrustSelfNotAllowed(): AllowTrustResultCode;

    static allowTrustLowReserve(): AllowTrustResultCode;
  }

  class AccountMergeResultCode {
    readonly name:
      | 'accountMergeSuccess'
      | 'accountMergeMalformed'
      | 'accountMergeNoAccount'
      | 'accountMergeImmutableSet'
      | 'accountMergeHasSubEntries'
      | 'accountMergeSeqnumTooFar'
      | 'accountMergeDestFull'
      | 'accountMergeIsSponsor';

    readonly value: 0 | -1 | -2 | -3 | -4 | -5 | -6 | -7;

    static accountMergeSuccess(): AccountMergeResultCode;

    static accountMergeMalformed(): AccountMergeResultCode;

    static accountMergeNoAccount(): AccountMergeResultCode;

    static accountMergeImmutableSet(): AccountMergeResultCode;

    static accountMergeHasSubEntries(): AccountMergeResultCode;

    static accountMergeSeqnumTooFar(): AccountMergeResultCode;

    static accountMergeDestFull(): AccountMergeResultCode;

    static accountMergeIsSponsor(): AccountMergeResultCode;
  }

  class InflationResultCode {
    readonly name: 'inflationSuccess' | 'inflationNotTime';

    readonly value: 0 | -1;

    static inflationSuccess(): InflationResultCode;

    static inflationNotTime(): InflationResultCode;
  }

  class ManageDataResultCode {
    readonly name:
      | 'manageDataSuccess'
      | 'manageDataNotSupportedYet'
      | 'manageDataNameNotFound'
      | 'manageDataLowReserve'
      | 'manageDataInvalidName';

    readonly value: 0 | -1 | -2 | -3 | -4;

    static manageDataSuccess(): ManageDataResultCode;

    static manageDataNotSupportedYet(): ManageDataResultCode;

    static manageDataNameNotFound(): ManageDataResultCode;

    static manageDataLowReserve(): ManageDataResultCode;

    static manageDataInvalidName(): ManageDataResultCode;
  }

  class BumpSequenceResultCode {
    readonly name: 'bumpSequenceSuccess' | 'bumpSequenceBadSeq';

    readonly value: 0 | -1;

    static bumpSequenceSuccess(): BumpSequenceResultCode;

    static bumpSequenceBadSeq(): BumpSequenceResultCode;
  }

  class CreateClaimableBalanceResultCode {
    readonly name:
      | 'createClaimableBalanceSuccess'
      | 'createClaimableBalanceMalformed'
      | 'createClaimableBalanceLowReserve'
      | 'createClaimableBalanceNoTrust'
      | 'createClaimableBalanceNotAuthorized'
      | 'createClaimableBalanceUnderfunded';

    readonly value: 0 | -1 | -2 | -3 | -4 | -5;

    static createClaimableBalanceSuccess(): CreateClaimableBalanceResultCode;

    static createClaimableBalanceMalformed(): CreateClaimableBalanceResultCode;

    static createClaimableBalanceLowReserve(): CreateClaimableBalanceResultCode;

    static createClaimableBalanceNoTrust(): CreateClaimableBalanceResultCode;

    static createClaimableBalanceNotAuthorized(): CreateClaimableBalanceResultCode;

    static createClaimableBalanceUnderfunded(): CreateClaimableBalanceResultCode;
  }

  class ClaimClaimableBalanceResultCode {
    readonly name:
      | 'claimClaimableBalanceSuccess'
      | 'claimClaimableBalanceDoesNotExist'
      | 'claimClaimableBalanceCannotClaim'
      | 'claimClaimableBalanceLineFull'
      | 'claimClaimableBalanceNoTrust'
      | 'claimClaimableBalanceNotAuthorized';

    readonly value: 0 | -1 | -2 | -3 | -4 | -5;

    static claimClaimableBalanceSuccess(): ClaimClaimableBalanceResultCode;

    static claimClaimableBalanceDoesNotExist(): ClaimClaimableBalanceResultCode;

    static claimClaimableBalanceCannotClaim(): ClaimClaimableBalanceResultCode;

    static claimClaimableBalanceLineFull(): ClaimClaimableBalanceResultCode;

    static claimClaimableBalanceNoTrust(): ClaimClaimableBalanceResultCode;

    static claimClaimableBalanceNotAuthorized(): ClaimClaimableBalanceResultCode;
  }

  class BeginSponsoringFutureReservesResultCode {
    readonly name:
      | 'beginSponsoringFutureReservesSuccess'
      | 'beginSponsoringFutureReservesMalformed'
      | 'beginSponsoringFutureReservesAlreadySponsored'
      | 'beginSponsoringFutureReservesRecursive';

    readonly value: 0 | -1 | -2 | -3;

    static beginSponsoringFutureReservesSuccess(): BeginSponsoringFutureReservesResultCode;

    static beginSponsoringFutureReservesMalformed(): BeginSponsoringFutureReservesResultCode;

    static beginSponsoringFutureReservesAlreadySponsored(): BeginSponsoringFutureReservesResultCode;

    static beginSponsoringFutureReservesRecursive(): BeginSponsoringFutureReservesResultCode;
  }

  class EndSponsoringFutureReservesResultCode {
    readonly name:
      | 'endSponsoringFutureReservesSuccess'
      | 'endSponsoringFutureReservesNotSponsored';

    readonly value: 0 | -1;

    static endSponsoringFutureReservesSuccess(): EndSponsoringFutureReservesResultCode;

    static endSponsoringFutureReservesNotSponsored(): EndSponsoringFutureReservesResultCode;
  }

  class RevokeSponsorshipResultCode {
    readonly name:
      | 'revokeSponsorshipSuccess'
      | 'revokeSponsorshipDoesNotExist'
      | 'revokeSponsorshipNotSponsor'
      | 'revokeSponsorshipLowReserve'
      | 'revokeSponsorshipOnlyTransferable'
      | 'revokeSponsorshipMalformed';

    readonly value: 0 | -1 | -2 | -3 | -4 | -5;

    static revokeSponsorshipSuccess(): RevokeSponsorshipResultCode;

    static revokeSponsorshipDoesNotExist(): RevokeSponsorshipResultCode;

    static revokeSponsorshipNotSponsor(): RevokeSponsorshipResultCode;

    static revokeSponsorshipLowReserve(): RevokeSponsorshipResultCode;

    static revokeSponsorshipOnlyTransferable(): RevokeSponsorshipResultCode;

    static revokeSponsorshipMalformed(): RevokeSponsorshipResultCode;
  }

  class ClawbackResultCode {
    readonly name:
      | 'clawbackSuccess'
      | 'clawbackMalformed'
      | 'clawbackNotClawbackEnabled'
      | 'clawbackNoTrust'
      | 'clawbackUnderfunded';

    readonly value: 0 | -1 | -2 | -3 | -4;

    static clawbackSuccess(): ClawbackResultCode;

    static clawbackMalformed(): ClawbackResultCode;

    static clawbackNotClawbackEnabled(): ClawbackResultCode;

    static clawbackNoTrust(): ClawbackResultCode;

    static clawbackUnderfunded(): ClawbackResultCode;
  }

  class ClawbackClaimableBalanceResultCode {
    readonly name:
      | 'clawbackClaimableBalanceSuccess'
      | 'clawbackClaimableBalanceDoesNotExist'
      | 'clawbackClaimableBalanceNotIssuer'
      | 'clawbackClaimableBalanceNotClawbackEnabled';

    readonly value: 0 | -1 | -2 | -3;

    static clawbackClaimableBalanceSuccess(): ClawbackClaimableBalanceResultCode;

    static clawbackClaimableBalanceDoesNotExist(): ClawbackClaimableBalanceResultCode;

    static clawbackClaimableBalanceNotIssuer(): ClawbackClaimableBalanceResultCode;

    static clawbackClaimableBalanceNotClawbackEnabled(): ClawbackClaimableBalanceResultCode;
  }

  class SetTrustLineFlagsResultCode {
    readonly name:
      | 'setTrustLineFlagsSuccess'
      | 'setTrustLineFlagsMalformed'
      | 'setTrustLineFlagsNoTrustLine'
      | 'setTrustLineFlagsCantRevoke'
      | 'setTrustLineFlagsInvalidState'
      | 'setTrustLineFlagsLowReserve';

    readonly value: 0 | -1 | -2 | -3 | -4 | -5;

    static setTrustLineFlagsSuccess(): SetTrustLineFlagsResultCode;

    static setTrustLineFlagsMalformed(): SetTrustLineFlagsResultCode;

    static setTrustLineFlagsNoTrustLine(): SetTrustLineFlagsResultCode;

    static setTrustLineFlagsCantRevoke(): SetTrustLineFlagsResultCode;

    static setTrustLineFlagsInvalidState(): SetTrustLineFlagsResultCode;

    static setTrustLineFlagsLowReserve(): SetTrustLineFlagsResultCode;
  }

  class LiquidityPoolDepositResultCode {
    readonly name:
      | 'liquidityPoolDepositSuccess'
      | 'liquidityPoolDepositMalformed'
      | 'liquidityPoolDepositNoTrust'
      | 'liquidityPoolDepositNotAuthorized'
      | 'liquidityPoolDepositUnderfunded'
      | 'liquidityPoolDepositLineFull'
      | 'liquidityPoolDepositBadPrice'
      | 'liquidityPoolDepositPoolFull';

    readonly value: 0 | -1 | -2 | -3 | -4 | -5 | -6 | -7;

    static liquidityPoolDepositSuccess(): LiquidityPoolDepositResultCode;

    static liquidityPoolDepositMalformed(): LiquidityPoolDepositResultCode;

    static liquidityPoolDepositNoTrust(): LiquidityPoolDepositResultCode;

    static liquidityPoolDepositNotAuthorized(): LiquidityPoolDepositResultCode;

    static liquidityPoolDepositUnderfunded(): LiquidityPoolDepositResultCode;

    static liquidityPoolDepositLineFull(): LiquidityPoolDepositResultCode;

    static liquidityPoolDepositBadPrice(): LiquidityPoolDepositResultCode;

    static liquidityPoolDepositPoolFull(): LiquidityPoolDepositResultCode;
  }

  class LiquidityPoolWithdrawResultCode {
    readonly name:
      | 'liquidityPoolWithdrawSuccess'
      | 'liquidityPoolWithdrawMalformed'
      | 'liquidityPoolWithdrawNoTrust'
      | 'liquidityPoolWithdrawUnderfunded'
      | 'liquidityPoolWithdrawLineFull'
      | 'liquidityPoolWithdrawUnderMinimum';

    readonly value: 0 | -1 | -2 | -3 | -4 | -5;

    static liquidityPoolWithdrawSuccess(): LiquidityPoolWithdrawResultCode;

    static liquidityPoolWithdrawMalformed(): LiquidityPoolWithdrawResultCode;

    static liquidityPoolWithdrawNoTrust(): LiquidityPoolWithdrawResultCode;

    static liquidityPoolWithdrawUnderfunded(): LiquidityPoolWithdrawResultCode;

    static liquidityPoolWithdrawLineFull(): LiquidityPoolWithdrawResultCode;

    static liquidityPoolWithdrawUnderMinimum(): LiquidityPoolWithdrawResultCode;
  }

  class InvokeHostFunctionResultCode {
    readonly name:
      | 'invokeHostFunctionSuccess'
      | 'invokeHostFunctionMalformed'
      | 'invokeHostFunctionTrapped'
      | 'invokeHostFunctionResourceLimitExceeded'
      | 'invokeHostFunctionEntryArchived'
      | 'invokeHostFunctionInsufficientRefundableFee';

    readonly value: 0 | -1 | -2 | -3 | -4 | -5;

    static invokeHostFunctionSuccess(): InvokeHostFunctionResultCode;

    static invokeHostFunctionMalformed(): InvokeHostFunctionResultCode;

    static invokeHostFunctionTrapped(): InvokeHostFunctionResultCode;

    static invokeHostFunctionResourceLimitExceeded(): InvokeHostFunctionResultCode;

    static invokeHostFunctionEntryArchived(): InvokeHostFunctionResultCode;

    static invokeHostFunctionInsufficientRefundableFee(): InvokeHostFunctionResultCode;
  }

  class ExtendFootprintTtlResultCode {
    readonly name:
      | 'extendFootprintTtlSuccess'
      | 'extendFootprintTtlMalformed'
      | 'extendFootprintTtlResourceLimitExceeded'
      | 'extendFootprintTtlInsufficientRefundableFee';

    readonly value: 0 | -1 | -2 | -3;

    static extendFootprintTtlSuccess(): ExtendFootprintTtlResultCode;

    static extendFootprintTtlMalformed(): ExtendFootprintTtlResultCode;

    static extendFootprintTtlResourceLimitExceeded(): ExtendFootprintTtlResultCode;

    static extendFootprintTtlInsufficientRefundableFee(): ExtendFootprintTtlResultCode;
  }

  class RestoreFootprintResultCode {
    readonly name:
      | 'restoreFootprintSuccess'
      | 'restoreFootprintMalformed'
      | 'restoreFootprintResourceLimitExceeded'
      | 'restoreFootprintInsufficientRefundableFee';

    readonly value: 0 | -1 | -2 | -3;

    static restoreFootprintSuccess(): RestoreFootprintResultCode;

    static restoreFootprintMalformed(): RestoreFootprintResultCode;

    static restoreFootprintResourceLimitExceeded(): RestoreFootprintResultCode;

    static restoreFootprintInsufficientRefundableFee(): RestoreFootprintResultCode;
  }

  class OperationResultCode {
    readonly name:
      | 'opInner'
      | 'opBadAuth'
      | 'opNoAccount'
      | 'opNotSupported'
      | 'opTooManySubentries'
      | 'opExceededWorkLimit'
      | 'opTooManySponsoring';

    readonly value: 0 | -1 | -2 | -3 | -4 | -5 | -6;

    static opInner(): OperationResultCode;

    static opBadAuth(): OperationResultCode;

    static opNoAccount(): OperationResultCode;

    static opNotSupported(): OperationResultCode;

    static opTooManySubentries(): OperationResultCode;

    static opExceededWorkLimit(): OperationResultCode;

    static opTooManySponsoring(): OperationResultCode;
  }

  class TransactionResultCode {
    readonly name:
      | 'txFeeBumpInnerSuccess'
      | 'txSuccess'
      | 'txFailed'
      | 'txTooEarly'
      | 'txTooLate'
      | 'txMissingOperation'
      | 'txBadSeq'
      | 'txBadAuth'
      | 'txInsufficientBalance'
      | 'txNoAccount'
      | 'txInsufficientFee'
      | 'txBadAuthExtra'
      | 'txInternalError'
      | 'txNotSupported'
      | 'txFeeBumpInnerFailed'
      | 'txBadSponsorship'
      | 'txBadMinSeqAgeOrGap'
      | 'txMalformed'
      | 'txSorobanInvalid';

    readonly value:
      | 1
      | 0
      | -1
      | -2
      | -3
      | -4
      | -5
      | -6
      | -7
      | -8
      | -9
      | -10
      | -11
      | -12
      | -13
      | -14
      | -15
      | -16
      | -17;

    static txFeeBumpInnerSuccess(): TransactionResultCode;

    static txSuccess(): TransactionResultCode;

    static txFailed(): TransactionResultCode;

    static txTooEarly(): TransactionResultCode;

    static txTooLate(): TransactionResultCode;

    static txMissingOperation(): TransactionResultCode;

    static txBadSeq(): TransactionResultCode;

    static txBadAuth(): TransactionResultCode;

    static txInsufficientBalance(): TransactionResultCode;

    static txNoAccount(): TransactionResultCode;

    static txInsufficientFee(): TransactionResultCode;

    static txBadAuthExtra(): TransactionResultCode;

    static txInternalError(): TransactionResultCode;

    static txNotSupported(): TransactionResultCode;

    static txFeeBumpInnerFailed(): TransactionResultCode;

    static txBadSponsorship(): TransactionResultCode;

    static txBadMinSeqAgeOrGap(): TransactionResultCode;

    static txMalformed(): TransactionResultCode;

    static txSorobanInvalid(): TransactionResultCode;
  }

  class CryptoKeyType {
    readonly name:
      | 'keyTypeEd25519'
      | 'keyTypePreAuthTx'
      | 'keyTypeHashX'
      | 'keyTypeEd25519SignedPayload'
      | 'keyTypeMuxedEd25519';

    readonly value: 0 | 1 | 2 | 3 | 256;

    static keyTypeEd25519(): CryptoKeyType;

    static keyTypePreAuthTx(): CryptoKeyType;

    static keyTypeHashX(): CryptoKeyType;

    static keyTypeEd25519SignedPayload(): CryptoKeyType;

    static keyTypeMuxedEd25519(): CryptoKeyType;
  }

  class PublicKeyType {
    readonly name: 'publicKeyTypeEd25519';

    readonly value: 0;

    static publicKeyTypeEd25519(): PublicKeyType;
  }

  class SignerKeyType {
    readonly name:
      | 'signerKeyTypeEd25519'
      | 'signerKeyTypePreAuthTx'
      | 'signerKeyTypeHashX'
      | 'signerKeyTypeEd25519SignedPayload';

    readonly value: 0 | 1 | 2 | 3;

    static signerKeyTypeEd25519(): SignerKeyType;

    static signerKeyTypePreAuthTx(): SignerKeyType;

    static signerKeyTypeHashX(): SignerKeyType;

    static signerKeyTypeEd25519SignedPayload(): SignerKeyType;
  }

  class BinaryFuseFilterType {
    readonly name:
      | 'binaryFuseFilter8Bit'
      | 'binaryFuseFilter16Bit'
      | 'binaryFuseFilter32Bit';

    readonly value: 0 | 1 | 2;

    static binaryFuseFilter8Bit(): BinaryFuseFilterType;

    static binaryFuseFilter16Bit(): BinaryFuseFilterType;

    static binaryFuseFilter32Bit(): BinaryFuseFilterType;
  }

  class ScValType {
    readonly name:
      | 'scvBool'
      | 'scvVoid'
      | 'scvError'
      | 'scvU32'
      | 'scvI32'
      | 'scvU64'
      | 'scvI64'
      | 'scvTimepoint'
      | 'scvDuration'
      | 'scvU128'
      | 'scvI128'
      | 'scvU256'
      | 'scvI256'
      | 'scvBytes'
      | 'scvString'
      | 'scvSymbol'
      | 'scvVec'
      | 'scvMap'
      | 'scvAddress'
      | 'scvContractInstance'
      | 'scvLedgerKeyContractInstance'
      | 'scvLedgerKeyNonce';

    readonly value:
      | 0
      | 1
      | 2
      | 3
      | 4
      | 5
      | 6
      | 7
      | 8
      | 9
      | 10
      | 11
      | 12
      | 13
      | 14
      | 15
      | 16
      | 17
      | 18
      | 19
      | 20
      | 21;

    static scvBool(): ScValType;

    static scvVoid(): ScValType;

    static scvError(): ScValType;

    static scvU32(): ScValType;

    static scvI32(): ScValType;

    static scvU64(): ScValType;

    static scvI64(): ScValType;

    static scvTimepoint(): ScValType;

    static scvDuration(): ScValType;

    static scvU128(): ScValType;

    static scvI128(): ScValType;

    static scvU256(): ScValType;

    static scvI256(): ScValType;

    static scvBytes(): ScValType;

    static scvString(): ScValType;

    static scvSymbol(): ScValType;

    static scvVec(): ScValType;

    static scvMap(): ScValType;

    static scvAddress(): ScValType;

    static scvContractInstance(): ScValType;

    static scvLedgerKeyContractInstance(): ScValType;

    static scvLedgerKeyNonce(): ScValType;
  }

  class ScErrorType {
    readonly name:
      | 'sceContract'
      | 'sceWasmVm'
      | 'sceContext'
      | 'sceStorage'
      | 'sceObject'
      | 'sceCrypto'
      | 'sceEvents'
      | 'sceBudget'
      | 'sceValue'
      | 'sceAuth';

    readonly value: 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9;

    static sceContract(): ScErrorType;

    static sceWasmVm(): ScErrorType;

    static sceContext(): ScErrorType;

    static sceStorage(): ScErrorType;

    static sceObject(): ScErrorType;

    static sceCrypto(): ScErrorType;

    static sceEvents(): ScErrorType;

    static sceBudget(): ScErrorType;

    static sceValue(): ScErrorType;

    static sceAuth(): ScErrorType;
  }

  class ScErrorCode {
    readonly name:
      | 'scecArithDomain'
      | 'scecIndexBounds'
      | 'scecInvalidInput'
      | 'scecMissingValue'
      | 'scecExistingValue'
      | 'scecExceededLimit'
      | 'scecInvalidAction'
      | 'scecInternalError'
      | 'scecUnexpectedType'
      | 'scecUnexpectedSize';

    readonly value: 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9;

    static scecArithDomain(): ScErrorCode;

    static scecIndexBounds(): ScErrorCode;

    static scecInvalidInput(): ScErrorCode;

    static scecMissingValue(): ScErrorCode;

    static scecExistingValue(): ScErrorCode;

    static scecExceededLimit(): ScErrorCode;

    static scecInvalidAction(): ScErrorCode;

    static scecInternalError(): ScErrorCode;

    static scecUnexpectedType(): ScErrorCode;

    static scecUnexpectedSize(): ScErrorCode;
  }

  class ContractExecutableType {
    readonly name: 'contractExecutableWasm' | 'contractExecutableStellarAsset';

    readonly value: 0 | 1;

    static contractExecutableWasm(): ContractExecutableType;

    static contractExecutableStellarAsset(): ContractExecutableType;
  }

  class ScAddressType {
    readonly name: 'scAddressTypeAccount' | 'scAddressTypeContract';

    readonly value: 0 | 1;

    static scAddressTypeAccount(): ScAddressType;

    static scAddressTypeContract(): ScAddressType;
  }

  class ScEnvMetaKind {
    readonly name: 'scEnvMetaKindInterfaceVersion';

    readonly value: 0;

    static scEnvMetaKindInterfaceVersion(): ScEnvMetaKind;
  }

  class ScMetaKind {
    readonly name: 'scMetaV0';

    readonly value: 0;

    static scMetaV0(): ScMetaKind;
  }

  class ScSpecType {
    readonly name:
      | 'scSpecTypeVal'
      | 'scSpecTypeBool'
      | 'scSpecTypeVoid'
      | 'scSpecTypeError'
      | 'scSpecTypeU32'
      | 'scSpecTypeI32'
      | 'scSpecTypeU64'
      | 'scSpecTypeI64'
      | 'scSpecTypeTimepoint'
      | 'scSpecTypeDuration'
      | 'scSpecTypeU128'
      | 'scSpecTypeI128'
      | 'scSpecTypeU256'
      | 'scSpecTypeI256'
      | 'scSpecTypeBytes'
      | 'scSpecTypeString'
      | 'scSpecTypeSymbol'
      | 'scSpecTypeAddress'
      | 'scSpecTypeOption'
      | 'scSpecTypeResult'
      | 'scSpecTypeVec'
      | 'scSpecTypeMap'
      | 'scSpecTypeTuple'
      | 'scSpecTypeBytesN'
      | 'scSpecTypeUdt';

    readonly value:
      | 0
      | 1
      | 2
      | 3
      | 4
      | 5
      | 6
      | 7
      | 8
      | 9
      | 10
      | 11
      | 12
      | 13
      | 14
      | 16
      | 17
      | 19
      | 1000
      | 1001
      | 1002
      | 1004
      | 1005
      | 1006
      | 2000;

    static scSpecTypeVal(): ScSpecType;

    static scSpecTypeBool(): ScSpecType;

    static scSpecTypeVoid(): ScSpecType;

    static scSpecTypeError(): ScSpecType;

    static scSpecTypeU32(): ScSpecType;

    static scSpecTypeI32(): ScSpecType;

    static scSpecTypeU64(): ScSpecType;

    static scSpecTypeI64(): ScSpecType;

    static scSpecTypeTimepoint(): ScSpecType;

    static scSpecTypeDuration(): ScSpecType;

    static scSpecTypeU128(): ScSpecType;

    static scSpecTypeI128(): ScSpecType;

    static scSpecTypeU256(): ScSpecType;

    static scSpecTypeI256(): ScSpecType;

    static scSpecTypeBytes(): ScSpecType;

    static scSpecTypeString(): ScSpecType;

    static scSpecTypeSymbol(): ScSpecType;

    static scSpecTypeAddress(): ScSpecType;

    static scSpecTypeOption(): ScSpecType;

    static scSpecTypeResult(): ScSpecType;

    static scSpecTypeVec(): ScSpecType;

    static scSpecTypeMap(): ScSpecType;

    static scSpecTypeTuple(): ScSpecType;

    static scSpecTypeBytesN(): ScSpecType;

    static scSpecTypeUdt(): ScSpecType;
  }

  class ScSpecUdtUnionCaseV0Kind {
    readonly name: 'scSpecUdtUnionCaseVoidV0' | 'scSpecUdtUnionCaseTupleV0';

    readonly value: 0 | 1;

    static scSpecUdtUnionCaseVoidV0(): ScSpecUdtUnionCaseV0Kind;

    static scSpecUdtUnionCaseTupleV0(): ScSpecUdtUnionCaseV0Kind;
  }

  class ScSpecEntryKind {
    readonly name:
      | 'scSpecEntryFunctionV0'
      | 'scSpecEntryUdtStructV0'
      | 'scSpecEntryUdtUnionV0'
      | 'scSpecEntryUdtEnumV0'
      | 'scSpecEntryUdtErrorEnumV0';

    readonly value: 0 | 1 | 2 | 3 | 4;

    static scSpecEntryFunctionV0(): ScSpecEntryKind;

    static scSpecEntryUdtStructV0(): ScSpecEntryKind;

    static scSpecEntryUdtUnionV0(): ScSpecEntryKind;

    static scSpecEntryUdtEnumV0(): ScSpecEntryKind;

    static scSpecEntryUdtErrorEnumV0(): ScSpecEntryKind;
  }

  class ContractCostType {
    readonly name:
      | 'wasmInsnExec'
      | 'memAlloc'
      | 'memCpy'
      | 'memCmp'
      | 'dispatchHostFunction'
      | 'visitObject'
      | 'valSer'
      | 'valDeser'
      | 'computeSha256Hash'
      | 'computeEd25519PubKey'
      | 'verifyEd25519Sig'
      | 'vmInstantiation'
      | 'vmCachedInstantiation'
      | 'invokeVmFunction'
      | 'computeKeccak256Hash'
      | 'decodeEcdsaCurve256Sig'
      | 'recoverEcdsaSecp256k1Key'
      | 'int256AddSub'
      | 'int256Mul'
      | 'int256Div'
      | 'int256Pow'
      | 'int256Shift'
      | 'chaCha20DrawBytes'
      | 'parseWasmInstructions'
      | 'parseWasmFunctions'
      | 'parseWasmGlobals'
      | 'parseWasmTableEntries'
      | 'parseWasmTypes'
      | 'parseWasmDataSegments'
      | 'parseWasmElemSegments'
      | 'parseWasmImports'
      | 'parseWasmExports'
      | 'parseWasmDataSegmentBytes'
      | 'instantiateWasmInstructions'
      | 'instantiateWasmFunctions'
      | 'instantiateWasmGlobals'
      | 'instantiateWasmTableEntries'
      | 'instantiateWasmTypes'
      | 'instantiateWasmDataSegments'
      | 'instantiateWasmElemSegments'
      | 'instantiateWasmImports'
      | 'instantiateWasmExports'
      | 'instantiateWasmDataSegmentBytes'
      | 'sec1DecodePointUncompressed'
      | 'verifyEcdsaSecp256r1Sig'
      | 'bls12381EncodeFp'
      | 'bls12381DecodeFp'
      | 'bls12381G1CheckPointOnCurve'
      | 'bls12381G1CheckPointInSubgroup'
      | 'bls12381G2CheckPointOnCurve'
      | 'bls12381G2CheckPointInSubgroup'
      | 'bls12381G1ProjectiveToAffine'
      | 'bls12381G2ProjectiveToAffine'
      | 'bls12381G1Add'
      | 'bls12381G1Mul'
      | 'bls12381G1Msm'
      | 'bls12381MapFpToG1'
      | 'bls12381HashToG1'
      | 'bls12381G2Add'
      | 'bls12381G2Mul'
      | 'bls12381G2Msm'
      | 'bls12381MapFp2ToG2'
      | 'bls12381HashToG2'
      | 'bls12381Pairing'
      | 'bls12381FrFromU256'
      | 'bls12381FrToU256'
      | 'bls12381FrAddSub'
      | 'bls12381FrMul'
      | 'bls12381FrPow'
      | 'bls12381FrInv';

    readonly value:
      | 0
      | 1
      | 2
      | 3
      | 4
      | 5
      | 6
      | 7
      | 8
      | 9
      | 10
      | 11
      | 12
      | 13
      | 14
      | 15
      | 16
      | 17
      | 18
      | 19
      | 20
      | 21
      | 22
      | 23
      | 24
      | 25
      | 26
      | 27
      | 28
      | 29
      | 30
      | 31
      | 32
      | 33
      | 34
      | 35
      | 36
      | 37
      | 38
      | 39
      | 40
      | 41
      | 42
      | 43
      | 44
      | 45
      | 46
      | 47
      | 48
      | 49
      | 50
      | 51
      | 52
      | 53
      | 54
      | 55
      | 56
      | 57
      | 58
      | 59
      | 60
      | 61
      | 62
      | 63
      | 64
      | 65
      | 66
      | 67
      | 68
      | 69;

    static wasmInsnExec(): ContractCostType;

    static memAlloc(): ContractCostType;

    static memCpy(): ContractCostType;

    static memCmp(): ContractCostType;

    static dispatchHostFunction(): ContractCostType;

    static visitObject(): ContractCostType;

    static valSer(): ContractCostType;

    static valDeser(): ContractCostType;

    static computeSha256Hash(): ContractCostType;

    static computeEd25519PubKey(): ContractCostType;

    static verifyEd25519Sig(): ContractCostType;

    static vmInstantiation(): ContractCostType;

    static vmCachedInstantiation(): ContractCostType;

    static invokeVmFunction(): ContractCostType;

    static computeKeccak256Hash(): ContractCostType;

    static decodeEcdsaCurve256Sig(): ContractCostType;

    static recoverEcdsaSecp256k1Key(): ContractCostType;

    static int256AddSub(): ContractCostType;

    static int256Mul(): ContractCostType;

    static int256Div(): ContractCostType;

    static int256Pow(): ContractCostType;

    static int256Shift(): ContractCostType;

    static chaCha20DrawBytes(): ContractCostType;

    static parseWasmInstructions(): ContractCostType;

    static parseWasmFunctions(): ContractCostType;

    static parseWasmGlobals(): ContractCostType;

    static parseWasmTableEntries(): ContractCostType;

    static parseWasmTypes(): ContractCostType;

    static parseWasmDataSegments(): ContractCostType;

    static parseWasmElemSegments(): ContractCostType;

    static parseWasmImports(): ContractCostType;

    static parseWasmExports(): ContractCostType;

    static parseWasmDataSegmentBytes(): ContractCostType;

    static instantiateWasmInstructions(): ContractCostType;

    static instantiateWasmFunctions(): ContractCostType;

    static instantiateWasmGlobals(): ContractCostType;

    static instantiateWasmTableEntries(): ContractCostType;

    static instantiateWasmTypes(): ContractCostType;

    static instantiateWasmDataSegments(): ContractCostType;

    static instantiateWasmElemSegments(): ContractCostType;

    static instantiateWasmImports(): ContractCostType;

    static instantiateWasmExports(): ContractCostType;

    static instantiateWasmDataSegmentBytes(): ContractCostType;

    static sec1DecodePointUncompressed(): ContractCostType;

    static verifyEcdsaSecp256r1Sig(): ContractCostType;

    static bls12381EncodeFp(): ContractCostType;

    static bls12381DecodeFp(): ContractCostType;

    static bls12381G1CheckPointOnCurve(): ContractCostType;

    static bls12381G1CheckPointInSubgroup(): ContractCostType;

    static bls12381G2CheckPointOnCurve(): ContractCostType;

    static bls12381G2CheckPointInSubgroup(): ContractCostType;

    static bls12381G1ProjectiveToAffine(): ContractCostType;

    static bls12381G2ProjectiveToAffine(): ContractCostType;

    static bls12381G1Add(): ContractCostType;

    static bls12381G1Mul(): ContractCostType;

    static bls12381G1Msm(): ContractCostType;

    static bls12381MapFpToG1(): ContractCostType;

    static bls12381HashToG1(): ContractCostType;

    static bls12381G2Add(): ContractCostType;

    static bls12381G2Mul(): ContractCostType;

    static bls12381G2Msm(): ContractCostType;

    static bls12381MapFp2ToG2(): ContractCostType;

    static bls12381HashToG2(): ContractCostType;

    static bls12381Pairing(): ContractCostType;

    static bls12381FrFromU256(): ContractCostType;

    static bls12381FrToU256(): ContractCostType;

    static bls12381FrAddSub(): ContractCostType;

    static bls12381FrMul(): ContractCostType;

    static bls12381FrPow(): ContractCostType;

    static bls12381FrInv(): ContractCostType;
  }

  class ConfigSettingId {
    readonly name:
      | 'configSettingContractMaxSizeBytes'
      | 'configSettingContractComputeV0'
      | 'configSettingContractLedgerCostV0'
      | 'configSettingContractHistoricalDataV0'
      | 'configSettingContractEventsV0'
      | 'configSettingContractBandwidthV0'
      | 'configSettingContractCostParamsCpuInstructions'
      | 'configSettingContractCostParamsMemoryBytes'
      | 'configSettingContractDataKeySizeBytes'
      | 'configSettingContractDataEntrySizeBytes'
      | 'configSettingStateArchival'
      | 'configSettingContractExecutionLanes'
      | 'configSettingBucketlistSizeWindow'
      | 'configSettingEvictionIterator'
      | 'configSettingContractParallelComputeV0';

    readonly value:
      | 0
      | 1
      | 2
      | 3
      | 4
      | 5
      | 6
      | 7
      | 8
      | 9
      | 10
      | 11
      | 12
      | 13
      | 14;

    static configSettingContractMaxSizeBytes(): ConfigSettingId;

    static configSettingContractComputeV0(): ConfigSettingId;

    static configSettingContractLedgerCostV0(): ConfigSettingId;

    static configSettingContractHistoricalDataV0(): ConfigSettingId;

    static configSettingContractEventsV0(): ConfigSettingId;

    static configSettingContractBandwidthV0(): ConfigSettingId;

    static configSettingContractCostParamsCpuInstructions(): ConfigSettingId;

    static configSettingContractCostParamsMemoryBytes(): ConfigSettingId;

    static configSettingContractDataKeySizeBytes(): ConfigSettingId;

    static configSettingContractDataEntrySizeBytes(): ConfigSettingId;

    static configSettingStateArchival(): ConfigSettingId;

    static configSettingContractExecutionLanes(): ConfigSettingId;

    static configSettingBucketlistSizeWindow(): ConfigSettingId;

    static configSettingEvictionIterator(): ConfigSettingId;

    static configSettingContractParallelComputeV0(): ConfigSettingId;
  }

  const Value: VarOpaque;

  const Thresholds: Opaque;

  const String32: XDRString;

  const String64: XDRString;

  type SequenceNumber = Int64;

  const DataValue: VarOpaque;

  type PoolId = Hash;

  const AssetCode4: Opaque;

  const AssetCode12: Opaque;

  type SponsorshipDescriptor = undefined | AccountId;

  const UpgradeType: VarOpaque;

  const TxExecutionThread: XDRArray<TransactionEnvelope>;

  const ParallelTxExecutionStage: XDRArray<TransactionEnvelope[]>;

  const LedgerEntryChanges: XDRArray<LedgerEntryChange>;

  const EncryptedBody: VarOpaque;

  const PeerStatList: XDRArray<PeerStats>;

  const TimeSlicedPeerDataList: XDRArray<TimeSlicedPeerData>;

  const TxAdvertVector: XDRArray<Hash>;

  const TxDemandVector: XDRArray<Hash>;

  const ProofLevel: XDRArray<ArchivalProofNode>;

  const Hash: Opaque;

  const Uint256: Opaque;

  const Uint32: UnsignedInt;

  const Int32: SignedInt;

  class Uint64 extends UnsignedHyper {}

  class Int64 extends Hyper {}

  type TimePoint = Uint64;

  type Duration = Uint64;

  const Signature: VarOpaque;

  const SignatureHint: Opaque;

  type NodeId = PublicKey;

  type AccountId = PublicKey;

  const ScVec: XDRArray<ScVal>;

  const ScMap: XDRArray<ScMapEntry>;

  const ScBytes: VarOpaque;

  const ScString: XDRString;

  const ScSymbol: XDRString;

  const ContractCostParams: XDRArray<ContractCostParamEntry>;

  class ScpBallot {
    constructor(attributes: { counter: number; value: Buffer });

    counter(value?: number): number;

    value(value?: Buffer): Buffer;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScpBallot;

    static write(value: ScpBallot, io: Buffer): void;

    static isValid(value: ScpBallot): boolean;

    static toXDR(value: ScpBallot): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScpBallot;

    static fromXDR(input: string, format: 'hex' | 'base64'): ScpBallot;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScpNomination {
    constructor(attributes: {
      quorumSetHash: Buffer;
      votes: Buffer[];
      accepted: Buffer[];
    });

    quorumSetHash(value?: Buffer): Buffer;

    votes(value?: Buffer[]): Buffer[];

    accepted(value?: Buffer[]): Buffer[];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScpNomination;

    static write(value: ScpNomination, io: Buffer): void;

    static isValid(value: ScpNomination): boolean;

    static toXDR(value: ScpNomination): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScpNomination;

    static fromXDR(input: string, format: 'hex' | 'base64'): ScpNomination;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScpStatementPrepare {
    constructor(attributes: {
      quorumSetHash: Buffer;
      ballot: ScpBallot;
      prepared: null | ScpBallot;
      preparedPrime: null | ScpBallot;
      nC: number;
      nH: number;
    });

    quorumSetHash(value?: Buffer): Buffer;

    ballot(value?: ScpBallot): ScpBallot;

    prepared(value?: null | ScpBallot): null | ScpBallot;

    preparedPrime(value?: null | ScpBallot): null | ScpBallot;

    nC(value?: number): number;

    nH(value?: number): number;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScpStatementPrepare;

    static write(value: ScpStatementPrepare, io: Buffer): void;

    static isValid(value: ScpStatementPrepare): boolean;

    static toXDR(value: ScpStatementPrepare): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScpStatementPrepare;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ScpStatementPrepare;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScpStatementConfirm {
    constructor(attributes: {
      ballot: ScpBallot;
      nPrepared: number;
      nCommit: number;
      nH: number;
      quorumSetHash: Buffer;
    });

    ballot(value?: ScpBallot): ScpBallot;

    nPrepared(value?: number): number;

    nCommit(value?: number): number;

    nH(value?: number): number;

    quorumSetHash(value?: Buffer): Buffer;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScpStatementConfirm;

    static write(value: ScpStatementConfirm, io: Buffer): void;

    static isValid(value: ScpStatementConfirm): boolean;

    static toXDR(value: ScpStatementConfirm): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScpStatementConfirm;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ScpStatementConfirm;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScpStatementExternalize {
    constructor(attributes: {
      commit: ScpBallot;
      nH: number;
      commitQuorumSetHash: Buffer;
    });

    commit(value?: ScpBallot): ScpBallot;

    nH(value?: number): number;

    commitQuorumSetHash(value?: Buffer): Buffer;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScpStatementExternalize;

    static write(value: ScpStatementExternalize, io: Buffer): void;

    static isValid(value: ScpStatementExternalize): boolean;

    static toXDR(value: ScpStatementExternalize): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScpStatementExternalize;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ScpStatementExternalize;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScpStatement {
    constructor(attributes: {
      nodeId: NodeId;
      slotIndex: Uint64;
      pledges: ScpStatementPledges;
    });

    nodeId(value?: NodeId): NodeId;

    slotIndex(value?: Uint64): Uint64;

    pledges(value?: ScpStatementPledges): ScpStatementPledges;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScpStatement;

    static write(value: ScpStatement, io: Buffer): void;

    static isValid(value: ScpStatement): boolean;

    static toXDR(value: ScpStatement): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScpStatement;

    static fromXDR(input: string, format: 'hex' | 'base64'): ScpStatement;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScpEnvelope {
    constructor(attributes: { statement: ScpStatement; signature: Buffer });

    statement(value?: ScpStatement): ScpStatement;

    signature(value?: Buffer): Buffer;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScpEnvelope;

    static write(value: ScpEnvelope, io: Buffer): void;

    static isValid(value: ScpEnvelope): boolean;

    static toXDR(value: ScpEnvelope): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScpEnvelope;

    static fromXDR(input: string, format: 'hex' | 'base64'): ScpEnvelope;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScpQuorumSet {
    constructor(attributes: {
      threshold: number;
      validators: NodeId[];
      innerSets: ScpQuorumSet[];
    });

    threshold(value?: number): number;

    validators(value?: NodeId[]): NodeId[];

    innerSets(value?: ScpQuorumSet[]): ScpQuorumSet[];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScpQuorumSet;

    static write(value: ScpQuorumSet, io: Buffer): void;

    static isValid(value: ScpQuorumSet): boolean;

    static toXDR(value: ScpQuorumSet): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScpQuorumSet;

    static fromXDR(input: string, format: 'hex' | 'base64'): ScpQuorumSet;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class AlphaNum4 {
    constructor(attributes: { assetCode: Buffer; issuer: AccountId });

    assetCode(value?: Buffer): Buffer;

    issuer(value?: AccountId): AccountId;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): AlphaNum4;

    static write(value: AlphaNum4, io: Buffer): void;

    static isValid(value: AlphaNum4): boolean;

    static toXDR(value: AlphaNum4): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): AlphaNum4;

    static fromXDR(input: string, format: 'hex' | 'base64'): AlphaNum4;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class AlphaNum12 {
    constructor(attributes: { assetCode: Buffer; issuer: AccountId });

    assetCode(value?: Buffer): Buffer;

    issuer(value?: AccountId): AccountId;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): AlphaNum12;

    static write(value: AlphaNum12, io: Buffer): void;

    static isValid(value: AlphaNum12): boolean;

    static toXDR(value: AlphaNum12): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): AlphaNum12;

    static fromXDR(input: string, format: 'hex' | 'base64'): AlphaNum12;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class Price {
    constructor(attributes: { n: number; d: number });

    n(value?: number): number;

    d(value?: number): number;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): Price;

    static write(value: Price, io: Buffer): void;

    static isValid(value: Price): boolean;

    static toXDR(value: Price): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): Price;

    static fromXDR(input: string, format: 'hex' | 'base64'): Price;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class Liabilities {
    constructor(attributes: { buying: Int64; selling: Int64 });

    buying(value?: Int64): Int64;

    selling(value?: Int64): Int64;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): Liabilities;

    static write(value: Liabilities, io: Buffer): void;

    static isValid(value: Liabilities): boolean;

    static toXDR(value: Liabilities): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): Liabilities;

    static fromXDR(input: string, format: 'hex' | 'base64'): Liabilities;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class Signer {
    constructor(attributes: { key: SignerKey; weight: number });

    key(value?: SignerKey): SignerKey;

    weight(value?: number): number;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): Signer;

    static write(value: Signer, io: Buffer): void;

    static isValid(value: Signer): boolean;

    static toXDR(value: Signer): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): Signer;

    static fromXDR(input: string, format: 'hex' | 'base64'): Signer;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class AccountEntryExtensionV3 {
    constructor(attributes: {
      ext: ExtensionPoint;
      seqLedger: number;
      seqTime: TimePoint;
    });

    ext(value?: ExtensionPoint): ExtensionPoint;

    seqLedger(value?: number): number;

    seqTime(value?: TimePoint): TimePoint;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): AccountEntryExtensionV3;

    static write(value: AccountEntryExtensionV3, io: Buffer): void;

    static isValid(value: AccountEntryExtensionV3): boolean;

    static toXDR(value: AccountEntryExtensionV3): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): AccountEntryExtensionV3;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): AccountEntryExtensionV3;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class AccountEntryExtensionV2 {
    constructor(attributes: {
      numSponsored: number;
      numSponsoring: number;
      signerSponsoringIDs: SponsorshipDescriptor[];
      ext: AccountEntryExtensionV2Ext;
    });

    numSponsored(value?: number): number;

    numSponsoring(value?: number): number;

    signerSponsoringIDs(
      value?: SponsorshipDescriptor[],
    ): SponsorshipDescriptor[];

    ext(value?: AccountEntryExtensionV2Ext): AccountEntryExtensionV2Ext;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): AccountEntryExtensionV2;

    static write(value: AccountEntryExtensionV2, io: Buffer): void;

    static isValid(value: AccountEntryExtensionV2): boolean;

    static toXDR(value: AccountEntryExtensionV2): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): AccountEntryExtensionV2;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): AccountEntryExtensionV2;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class AccountEntryExtensionV1 {
    constructor(attributes: {
      liabilities: Liabilities;
      ext: AccountEntryExtensionV1Ext;
    });

    liabilities(value?: Liabilities): Liabilities;

    ext(value?: AccountEntryExtensionV1Ext): AccountEntryExtensionV1Ext;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): AccountEntryExtensionV1;

    static write(value: AccountEntryExtensionV1, io: Buffer): void;

    static isValid(value: AccountEntryExtensionV1): boolean;

    static toXDR(value: AccountEntryExtensionV1): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): AccountEntryExtensionV1;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): AccountEntryExtensionV1;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class AccountEntry {
    constructor(attributes: {
      accountId: AccountId;
      balance: Int64;
      seqNum: SequenceNumber;
      numSubEntries: number;
      inflationDest: null | AccountId;
      flags: number;
      homeDomain: string | Buffer;
      thresholds: Buffer;
      signers: Signer[];
      ext: AccountEntryExt;
    });

    accountId(value?: AccountId): AccountId;

    balance(value?: Int64): Int64;

    seqNum(value?: SequenceNumber): SequenceNumber;

    numSubEntries(value?: number): number;

    inflationDest(value?: null | AccountId): null | AccountId;

    flags(value?: number): number;

    homeDomain(value?: string | Buffer): string | Buffer;

    thresholds(value?: Buffer): Buffer;

    signers(value?: Signer[]): Signer[];

    ext(value?: AccountEntryExt): AccountEntryExt;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): AccountEntry;

    static write(value: AccountEntry, io: Buffer): void;

    static isValid(value: AccountEntry): boolean;

    static toXDR(value: AccountEntry): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): AccountEntry;

    static fromXDR(input: string, format: 'hex' | 'base64'): AccountEntry;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TrustLineEntryExtensionV2 {
    constructor(attributes: {
      liquidityPoolUseCount: number;
      ext: TrustLineEntryExtensionV2Ext;
    });

    liquidityPoolUseCount(value?: number): number;

    ext(value?: TrustLineEntryExtensionV2Ext): TrustLineEntryExtensionV2Ext;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TrustLineEntryExtensionV2;

    static write(value: TrustLineEntryExtensionV2, io: Buffer): void;

    static isValid(value: TrustLineEntryExtensionV2): boolean;

    static toXDR(value: TrustLineEntryExtensionV2): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): TrustLineEntryExtensionV2;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): TrustLineEntryExtensionV2;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TrustLineEntryV1 {
    constructor(attributes: {
      liabilities: Liabilities;
      ext: TrustLineEntryV1Ext;
    });

    liabilities(value?: Liabilities): Liabilities;

    ext(value?: TrustLineEntryV1Ext): TrustLineEntryV1Ext;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TrustLineEntryV1;

    static write(value: TrustLineEntryV1, io: Buffer): void;

    static isValid(value: TrustLineEntryV1): boolean;

    static toXDR(value: TrustLineEntryV1): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): TrustLineEntryV1;

    static fromXDR(input: string, format: 'hex' | 'base64'): TrustLineEntryV1;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TrustLineEntry {
    constructor(attributes: {
      accountId: AccountId;
      asset: TrustLineAsset;
      balance: Int64;
      limit: Int64;
      flags: number;
      ext: TrustLineEntryExt;
    });

    accountId(value?: AccountId): AccountId;

    asset(value?: TrustLineAsset): TrustLineAsset;

    balance(value?: Int64): Int64;

    limit(value?: Int64): Int64;

    flags(value?: number): number;

    ext(value?: TrustLineEntryExt): TrustLineEntryExt;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TrustLineEntry;

    static write(value: TrustLineEntry, io: Buffer): void;

    static isValid(value: TrustLineEntry): boolean;

    static toXDR(value: TrustLineEntry): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): TrustLineEntry;

    static fromXDR(input: string, format: 'hex' | 'base64'): TrustLineEntry;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class OfferEntry {
    constructor(attributes: {
      sellerId: AccountId;
      offerId: Int64;
      selling: Asset;
      buying: Asset;
      amount: Int64;
      price: Price;
      flags: number;
      ext: OfferEntryExt;
    });

    sellerId(value?: AccountId): AccountId;

    offerId(value?: Int64): Int64;

    selling(value?: Asset): Asset;

    buying(value?: Asset): Asset;

    amount(value?: Int64): Int64;

    price(value?: Price): Price;

    flags(value?: number): number;

    ext(value?: OfferEntryExt): OfferEntryExt;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): OfferEntry;

    static write(value: OfferEntry, io: Buffer): void;

    static isValid(value: OfferEntry): boolean;

    static toXDR(value: OfferEntry): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): OfferEntry;

    static fromXDR(input: string, format: 'hex' | 'base64'): OfferEntry;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class DataEntry {
    constructor(attributes: {
      accountId: AccountId;
      dataName: string | Buffer;
      dataValue: Buffer;
      ext: DataEntryExt;
    });

    accountId(value?: AccountId): AccountId;

    dataName(value?: string | Buffer): string | Buffer;

    dataValue(value?: Buffer): Buffer;

    ext(value?: DataEntryExt): DataEntryExt;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): DataEntry;

    static write(value: DataEntry, io: Buffer): void;

    static isValid(value: DataEntry): boolean;

    static toXDR(value: DataEntry): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): DataEntry;

    static fromXDR(input: string, format: 'hex' | 'base64'): DataEntry;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ClaimantV0 {
    constructor(attributes: {
      destination: AccountId;
      predicate: ClaimPredicate;
    });

    destination(value?: AccountId): AccountId;

    predicate(value?: ClaimPredicate): ClaimPredicate;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ClaimantV0;

    static write(value: ClaimantV0, io: Buffer): void;

    static isValid(value: ClaimantV0): boolean;

    static toXDR(value: ClaimantV0): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ClaimantV0;

    static fromXDR(input: string, format: 'hex' | 'base64'): ClaimantV0;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ClaimableBalanceEntryExtensionV1 {
    constructor(attributes: {
      ext: ClaimableBalanceEntryExtensionV1Ext;
      flags: number;
    });

    ext(
      value?: ClaimableBalanceEntryExtensionV1Ext,
    ): ClaimableBalanceEntryExtensionV1Ext;

    flags(value?: number): number;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ClaimableBalanceEntryExtensionV1;

    static write(value: ClaimableBalanceEntryExtensionV1, io: Buffer): void;

    static isValid(value: ClaimableBalanceEntryExtensionV1): boolean;

    static toXDR(value: ClaimableBalanceEntryExtensionV1): Buffer;

    static fromXDR(
      input: Buffer,
      format?: 'raw',
    ): ClaimableBalanceEntryExtensionV1;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ClaimableBalanceEntryExtensionV1;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ClaimableBalanceEntry {
    constructor(attributes: {
      balanceId: ClaimableBalanceId;
      claimants: Claimant[];
      asset: Asset;
      amount: Int64;
      ext: ClaimableBalanceEntryExt;
    });

    balanceId(value?: ClaimableBalanceId): ClaimableBalanceId;

    claimants(value?: Claimant[]): Claimant[];

    asset(value?: Asset): Asset;

    amount(value?: Int64): Int64;

    ext(value?: ClaimableBalanceEntryExt): ClaimableBalanceEntryExt;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ClaimableBalanceEntry;

    static write(value: ClaimableBalanceEntry, io: Buffer): void;

    static isValid(value: ClaimableBalanceEntry): boolean;

    static toXDR(value: ClaimableBalanceEntry): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ClaimableBalanceEntry;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ClaimableBalanceEntry;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LiquidityPoolConstantProductParameters {
    constructor(attributes: { assetA: Asset; assetB: Asset; fee: number });

    assetA(value?: Asset): Asset;

    assetB(value?: Asset): Asset;

    fee(value?: number): number;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LiquidityPoolConstantProductParameters;

    static write(
      value: LiquidityPoolConstantProductParameters,
      io: Buffer,
    ): void;

    static isValid(value: LiquidityPoolConstantProductParameters): boolean;

    static toXDR(value: LiquidityPoolConstantProductParameters): Buffer;

    static fromXDR(
      input: Buffer,
      format?: 'raw',
    ): LiquidityPoolConstantProductParameters;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): LiquidityPoolConstantProductParameters;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LiquidityPoolEntryConstantProduct {
    constructor(attributes: {
      params: LiquidityPoolConstantProductParameters;
      reserveA: Int64;
      reserveB: Int64;
      totalPoolShares: Int64;
      poolSharesTrustLineCount: Int64;
    });

    params(
      value?: LiquidityPoolConstantProductParameters,
    ): LiquidityPoolConstantProductParameters;

    reserveA(value?: Int64): Int64;

    reserveB(value?: Int64): Int64;

    totalPoolShares(value?: Int64): Int64;

    poolSharesTrustLineCount(value?: Int64): Int64;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LiquidityPoolEntryConstantProduct;

    static write(value: LiquidityPoolEntryConstantProduct, io: Buffer): void;

    static isValid(value: LiquidityPoolEntryConstantProduct): boolean;

    static toXDR(value: LiquidityPoolEntryConstantProduct): Buffer;

    static fromXDR(
      input: Buffer,
      format?: 'raw',
    ): LiquidityPoolEntryConstantProduct;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): LiquidityPoolEntryConstantProduct;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LiquidityPoolEntry {
    constructor(attributes: {
      liquidityPoolId: PoolId;
      body: LiquidityPoolEntryBody;
    });

    liquidityPoolId(value?: PoolId): PoolId;

    body(value?: LiquidityPoolEntryBody): LiquidityPoolEntryBody;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LiquidityPoolEntry;

    static write(value: LiquidityPoolEntry, io: Buffer): void;

    static isValid(value: LiquidityPoolEntry): boolean;

    static toXDR(value: LiquidityPoolEntry): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): LiquidityPoolEntry;

    static fromXDR(input: string, format: 'hex' | 'base64'): LiquidityPoolEntry;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ContractDataEntry {
    constructor(attributes: {
      ext: ExtensionPoint;
      contract: ScAddress;
      key: ScVal;
      durability: ContractDataDurability;
      val: ScVal;
    });

    ext(value?: ExtensionPoint): ExtensionPoint;

    contract(value?: ScAddress): ScAddress;

    key(value?: ScVal): ScVal;

    durability(value?: ContractDataDurability): ContractDataDurability;

    val(value?: ScVal): ScVal;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ContractDataEntry;

    static write(value: ContractDataEntry, io: Buffer): void;

    static isValid(value: ContractDataEntry): boolean;

    static toXDR(value: ContractDataEntry): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ContractDataEntry;

    static fromXDR(input: string, format: 'hex' | 'base64'): ContractDataEntry;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ContractCodeCostInputs {
    constructor(attributes: {
      ext: ExtensionPoint;
      nInstructions: number;
      nFunctions: number;
      nGlobals: number;
      nTableEntries: number;
      nTypes: number;
      nDataSegments: number;
      nElemSegments: number;
      nImports: number;
      nExports: number;
      nDataSegmentBytes: number;
    });

    ext(value?: ExtensionPoint): ExtensionPoint;

    nInstructions(value?: number): number;

    nFunctions(value?: number): number;

    nGlobals(value?: number): number;

    nTableEntries(value?: number): number;

    nTypes(value?: number): number;

    nDataSegments(value?: number): number;

    nElemSegments(value?: number): number;

    nImports(value?: number): number;

    nExports(value?: number): number;

    nDataSegmentBytes(value?: number): number;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ContractCodeCostInputs;

    static write(value: ContractCodeCostInputs, io: Buffer): void;

    static isValid(value: ContractCodeCostInputs): boolean;

    static toXDR(value: ContractCodeCostInputs): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ContractCodeCostInputs;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ContractCodeCostInputs;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ContractCodeEntryV1 {
    constructor(attributes: {
      ext: ExtensionPoint;
      costInputs: ContractCodeCostInputs;
    });

    ext(value?: ExtensionPoint): ExtensionPoint;

    costInputs(value?: ContractCodeCostInputs): ContractCodeCostInputs;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ContractCodeEntryV1;

    static write(value: ContractCodeEntryV1, io: Buffer): void;

    static isValid(value: ContractCodeEntryV1): boolean;

    static toXDR(value: ContractCodeEntryV1): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ContractCodeEntryV1;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ContractCodeEntryV1;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ContractCodeEntry {
    constructor(attributes: {
      ext: ContractCodeEntryExt;
      hash: Buffer;
      code: Buffer;
    });

    ext(value?: ContractCodeEntryExt): ContractCodeEntryExt;

    hash(value?: Buffer): Buffer;

    code(value?: Buffer): Buffer;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ContractCodeEntry;

    static write(value: ContractCodeEntry, io: Buffer): void;

    static isValid(value: ContractCodeEntry): boolean;

    static toXDR(value: ContractCodeEntry): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ContractCodeEntry;

    static fromXDR(input: string, format: 'hex' | 'base64'): ContractCodeEntry;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TtlEntry {
    constructor(attributes: { keyHash: Buffer; liveUntilLedgerSeq: number });

    keyHash(value?: Buffer): Buffer;

    liveUntilLedgerSeq(value?: number): number;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TtlEntry;

    static write(value: TtlEntry, io: Buffer): void;

    static isValid(value: TtlEntry): boolean;

    static toXDR(value: TtlEntry): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): TtlEntry;

    static fromXDR(input: string, format: 'hex' | 'base64'): TtlEntry;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LedgerEntryExtensionV1 {
    constructor(attributes: {
      sponsoringId: SponsorshipDescriptor;
      ext: LedgerEntryExtensionV1Ext;
    });

    sponsoringId(value?: SponsorshipDescriptor): SponsorshipDescriptor;

    ext(value?: LedgerEntryExtensionV1Ext): LedgerEntryExtensionV1Ext;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LedgerEntryExtensionV1;

    static write(value: LedgerEntryExtensionV1, io: Buffer): void;

    static isValid(value: LedgerEntryExtensionV1): boolean;

    static toXDR(value: LedgerEntryExtensionV1): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): LedgerEntryExtensionV1;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): LedgerEntryExtensionV1;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LedgerEntry {
    constructor(attributes: {
      lastModifiedLedgerSeq: number;
      data: LedgerEntryData;
      ext: LedgerEntryExt;
    });

    lastModifiedLedgerSeq(value?: number): number;

    data(value?: LedgerEntryData): LedgerEntryData;

    ext(value?: LedgerEntryExt): LedgerEntryExt;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LedgerEntry;

    static write(value: LedgerEntry, io: Buffer): void;

    static isValid(value: LedgerEntry): boolean;

    static toXDR(value: LedgerEntry): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): LedgerEntry;

    static fromXDR(input: string, format: 'hex' | 'base64'): LedgerEntry;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LedgerKeyAccount {
    constructor(attributes: { accountId: AccountId });

    accountId(value?: AccountId): AccountId;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LedgerKeyAccount;

    static write(value: LedgerKeyAccount, io: Buffer): void;

    static isValid(value: LedgerKeyAccount): boolean;

    static toXDR(value: LedgerKeyAccount): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): LedgerKeyAccount;

    static fromXDR(input: string, format: 'hex' | 'base64'): LedgerKeyAccount;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LedgerKeyTrustLine {
    constructor(attributes: { accountId: AccountId; asset: TrustLineAsset });

    accountId(value?: AccountId): AccountId;

    asset(value?: TrustLineAsset): TrustLineAsset;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LedgerKeyTrustLine;

    static write(value: LedgerKeyTrustLine, io: Buffer): void;

    static isValid(value: LedgerKeyTrustLine): boolean;

    static toXDR(value: LedgerKeyTrustLine): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): LedgerKeyTrustLine;

    static fromXDR(input: string, format: 'hex' | 'base64'): LedgerKeyTrustLine;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LedgerKeyOffer {
    constructor(attributes: { sellerId: AccountId; offerId: Int64 });

    sellerId(value?: AccountId): AccountId;

    offerId(value?: Int64): Int64;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LedgerKeyOffer;

    static write(value: LedgerKeyOffer, io: Buffer): void;

    static isValid(value: LedgerKeyOffer): boolean;

    static toXDR(value: LedgerKeyOffer): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): LedgerKeyOffer;

    static fromXDR(input: string, format: 'hex' | 'base64'): LedgerKeyOffer;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LedgerKeyData {
    constructor(attributes: {
      accountId: AccountId;
      dataName: string | Buffer;
    });

    accountId(value?: AccountId): AccountId;

    dataName(value?: string | Buffer): string | Buffer;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LedgerKeyData;

    static write(value: LedgerKeyData, io: Buffer): void;

    static isValid(value: LedgerKeyData): boolean;

    static toXDR(value: LedgerKeyData): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): LedgerKeyData;

    static fromXDR(input: string, format: 'hex' | 'base64'): LedgerKeyData;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LedgerKeyClaimableBalance {
    constructor(attributes: { balanceId: ClaimableBalanceId });

    balanceId(value?: ClaimableBalanceId): ClaimableBalanceId;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LedgerKeyClaimableBalance;

    static write(value: LedgerKeyClaimableBalance, io: Buffer): void;

    static isValid(value: LedgerKeyClaimableBalance): boolean;

    static toXDR(value: LedgerKeyClaimableBalance): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): LedgerKeyClaimableBalance;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): LedgerKeyClaimableBalance;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LedgerKeyLiquidityPool {
    constructor(attributes: { liquidityPoolId: PoolId });

    liquidityPoolId(value?: PoolId): PoolId;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LedgerKeyLiquidityPool;

    static write(value: LedgerKeyLiquidityPool, io: Buffer): void;

    static isValid(value: LedgerKeyLiquidityPool): boolean;

    static toXDR(value: LedgerKeyLiquidityPool): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): LedgerKeyLiquidityPool;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): LedgerKeyLiquidityPool;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LedgerKeyContractData {
    constructor(attributes: {
      contract: ScAddress;
      key: ScVal;
      durability: ContractDataDurability;
    });

    contract(value?: ScAddress): ScAddress;

    key(value?: ScVal): ScVal;

    durability(value?: ContractDataDurability): ContractDataDurability;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LedgerKeyContractData;

    static write(value: LedgerKeyContractData, io: Buffer): void;

    static isValid(value: LedgerKeyContractData): boolean;

    static toXDR(value: LedgerKeyContractData): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): LedgerKeyContractData;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): LedgerKeyContractData;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LedgerKeyContractCode {
    constructor(attributes: { hash: Buffer });

    hash(value?: Buffer): Buffer;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LedgerKeyContractCode;

    static write(value: LedgerKeyContractCode, io: Buffer): void;

    static isValid(value: LedgerKeyContractCode): boolean;

    static toXDR(value: LedgerKeyContractCode): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): LedgerKeyContractCode;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): LedgerKeyContractCode;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LedgerKeyConfigSetting {
    constructor(attributes: { configSettingId: ConfigSettingId });

    configSettingId(value?: ConfigSettingId): ConfigSettingId;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LedgerKeyConfigSetting;

    static write(value: LedgerKeyConfigSetting, io: Buffer): void;

    static isValid(value: LedgerKeyConfigSetting): boolean;

    static toXDR(value: LedgerKeyConfigSetting): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): LedgerKeyConfigSetting;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): LedgerKeyConfigSetting;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LedgerKeyTtl {
    constructor(attributes: { keyHash: Buffer });

    keyHash(value?: Buffer): Buffer;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LedgerKeyTtl;

    static write(value: LedgerKeyTtl, io: Buffer): void;

    static isValid(value: LedgerKeyTtl): boolean;

    static toXDR(value: LedgerKeyTtl): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): LedgerKeyTtl;

    static fromXDR(input: string, format: 'hex' | 'base64'): LedgerKeyTtl;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class BucketMetadata {
    constructor(attributes: { ledgerVersion: number; ext: BucketMetadataExt });

    ledgerVersion(value?: number): number;

    ext(value?: BucketMetadataExt): BucketMetadataExt;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): BucketMetadata;

    static write(value: BucketMetadata, io: Buffer): void;

    static isValid(value: BucketMetadata): boolean;

    static toXDR(value: BucketMetadata): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): BucketMetadata;

    static fromXDR(input: string, format: 'hex' | 'base64'): BucketMetadata;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ColdArchiveArchivedLeaf {
    constructor(attributes: { index: number; archivedEntry: LedgerEntry });

    index(value?: number): number;

    archivedEntry(value?: LedgerEntry): LedgerEntry;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ColdArchiveArchivedLeaf;

    static write(value: ColdArchiveArchivedLeaf, io: Buffer): void;

    static isValid(value: ColdArchiveArchivedLeaf): boolean;

    static toXDR(value: ColdArchiveArchivedLeaf): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ColdArchiveArchivedLeaf;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ColdArchiveArchivedLeaf;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ColdArchiveDeletedLeaf {
    constructor(attributes: { index: number; deletedKey: LedgerKey });

    index(value?: number): number;

    deletedKey(value?: LedgerKey): LedgerKey;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ColdArchiveDeletedLeaf;

    static write(value: ColdArchiveDeletedLeaf, io: Buffer): void;

    static isValid(value: ColdArchiveDeletedLeaf): boolean;

    static toXDR(value: ColdArchiveDeletedLeaf): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ColdArchiveDeletedLeaf;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ColdArchiveDeletedLeaf;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ColdArchiveBoundaryLeaf {
    constructor(attributes: { index: number; isLowerBound: boolean });

    index(value?: number): number;

    isLowerBound(value?: boolean): boolean;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ColdArchiveBoundaryLeaf;

    static write(value: ColdArchiveBoundaryLeaf, io: Buffer): void;

    static isValid(value: ColdArchiveBoundaryLeaf): boolean;

    static toXDR(value: ColdArchiveBoundaryLeaf): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ColdArchiveBoundaryLeaf;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ColdArchiveBoundaryLeaf;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ColdArchiveHashEntry {
    constructor(attributes: { index: number; level: number; hash: Buffer });

    index(value?: number): number;

    level(value?: number): number;

    hash(value?: Buffer): Buffer;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ColdArchiveHashEntry;

    static write(value: ColdArchiveHashEntry, io: Buffer): void;

    static isValid(value: ColdArchiveHashEntry): boolean;

    static toXDR(value: ColdArchiveHashEntry): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ColdArchiveHashEntry;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ColdArchiveHashEntry;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LedgerCloseValueSignature {
    constructor(attributes: { nodeId: NodeId; signature: Buffer });

    nodeId(value?: NodeId): NodeId;

    signature(value?: Buffer): Buffer;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LedgerCloseValueSignature;

    static write(value: LedgerCloseValueSignature, io: Buffer): void;

    static isValid(value: LedgerCloseValueSignature): boolean;

    static toXDR(value: LedgerCloseValueSignature): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): LedgerCloseValueSignature;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): LedgerCloseValueSignature;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class StellarValue {
    constructor(attributes: {
      txSetHash: Buffer;
      closeTime: TimePoint;
      upgrades: Buffer[];
      ext: StellarValueExt;
    });

    txSetHash(value?: Buffer): Buffer;

    closeTime(value?: TimePoint): TimePoint;

    upgrades(value?: Buffer[]): Buffer[];

    ext(value?: StellarValueExt): StellarValueExt;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): StellarValue;

    static write(value: StellarValue, io: Buffer): void;

    static isValid(value: StellarValue): boolean;

    static toXDR(value: StellarValue): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): StellarValue;

    static fromXDR(input: string, format: 'hex' | 'base64'): StellarValue;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LedgerHeaderExtensionV1 {
    constructor(attributes: { flags: number; ext: LedgerHeaderExtensionV1Ext });

    flags(value?: number): number;

    ext(value?: LedgerHeaderExtensionV1Ext): LedgerHeaderExtensionV1Ext;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LedgerHeaderExtensionV1;

    static write(value: LedgerHeaderExtensionV1, io: Buffer): void;

    static isValid(value: LedgerHeaderExtensionV1): boolean;

    static toXDR(value: LedgerHeaderExtensionV1): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): LedgerHeaderExtensionV1;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): LedgerHeaderExtensionV1;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LedgerHeader {
    constructor(attributes: {
      ledgerVersion: number;
      previousLedgerHash: Buffer;
      scpValue: StellarValue;
      txSetResultHash: Buffer;
      bucketListHash: Buffer;
      ledgerSeq: number;
      totalCoins: Int64;
      feePool: Int64;
      inflationSeq: number;
      idPool: Uint64;
      baseFee: number;
      baseReserve: number;
      maxTxSetSize: number;
      skipList: Buffer[];
      ext: LedgerHeaderExt;
    });

    ledgerVersion(value?: number): number;

    previousLedgerHash(value?: Buffer): Buffer;

    scpValue(value?: StellarValue): StellarValue;

    txSetResultHash(value?: Buffer): Buffer;

    bucketListHash(value?: Buffer): Buffer;

    ledgerSeq(value?: number): number;

    totalCoins(value?: Int64): Int64;

    feePool(value?: Int64): Int64;

    inflationSeq(value?: number): number;

    idPool(value?: Uint64): Uint64;

    baseFee(value?: number): number;

    baseReserve(value?: number): number;

    maxTxSetSize(value?: number): number;

    skipList(value?: Buffer[]): Buffer[];

    ext(value?: LedgerHeaderExt): LedgerHeaderExt;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LedgerHeader;

    static write(value: LedgerHeader, io: Buffer): void;

    static isValid(value: LedgerHeader): boolean;

    static toXDR(value: LedgerHeader): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): LedgerHeader;

    static fromXDR(input: string, format: 'hex' | 'base64'): LedgerHeader;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ConfigUpgradeSetKey {
    constructor(attributes: { contractId: Buffer; contentHash: Buffer });

    contractId(value?: Buffer): Buffer;

    contentHash(value?: Buffer): Buffer;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ConfigUpgradeSetKey;

    static write(value: ConfigUpgradeSetKey, io: Buffer): void;

    static isValid(value: ConfigUpgradeSetKey): boolean;

    static toXDR(value: ConfigUpgradeSetKey): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ConfigUpgradeSetKey;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ConfigUpgradeSetKey;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ConfigUpgradeSet {
    constructor(attributes: { updatedEntry: ConfigSettingEntry[] });

    updatedEntry(value?: ConfigSettingEntry[]): ConfigSettingEntry[];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ConfigUpgradeSet;

    static write(value: ConfigUpgradeSet, io: Buffer): void;

    static isValid(value: ConfigUpgradeSet): boolean;

    static toXDR(value: ConfigUpgradeSet): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ConfigUpgradeSet;

    static fromXDR(input: string, format: 'hex' | 'base64'): ConfigUpgradeSet;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ParallelTxsComponent {
    constructor(attributes: {
      baseFee: null | Int64;
      executionStages: TransactionEnvelope[][][];
    });

    baseFee(value?: null | Int64): null | Int64;

    executionStages(
      value?: TransactionEnvelope[][][],
    ): TransactionEnvelope[][][];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ParallelTxsComponent;

    static write(value: ParallelTxsComponent, io: Buffer): void;

    static isValid(value: ParallelTxsComponent): boolean;

    static toXDR(value: ParallelTxsComponent): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ParallelTxsComponent;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ParallelTxsComponent;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TxSetComponentTxsMaybeDiscountedFee {
    constructor(attributes: {
      baseFee: null | Int64;
      txes: TransactionEnvelope[];
    });

    baseFee(value?: null | Int64): null | Int64;

    txes(value?: TransactionEnvelope[]): TransactionEnvelope[];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TxSetComponentTxsMaybeDiscountedFee;

    static write(value: TxSetComponentTxsMaybeDiscountedFee, io: Buffer): void;

    static isValid(value: TxSetComponentTxsMaybeDiscountedFee): boolean;

    static toXDR(value: TxSetComponentTxsMaybeDiscountedFee): Buffer;

    static fromXDR(
      input: Buffer,
      format?: 'raw',
    ): TxSetComponentTxsMaybeDiscountedFee;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): TxSetComponentTxsMaybeDiscountedFee;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TransactionSet {
    constructor(attributes: {
      previousLedgerHash: Buffer;
      txes: TransactionEnvelope[];
    });

    previousLedgerHash(value?: Buffer): Buffer;

    txes(value?: TransactionEnvelope[]): TransactionEnvelope[];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TransactionSet;

    static write(value: TransactionSet, io: Buffer): void;

    static isValid(value: TransactionSet): boolean;

    static toXDR(value: TransactionSet): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): TransactionSet;

    static fromXDR(input: string, format: 'hex' | 'base64'): TransactionSet;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TransactionSetV1 {
    constructor(attributes: {
      previousLedgerHash: Buffer;
      phases: TransactionPhase[];
    });

    previousLedgerHash(value?: Buffer): Buffer;

    phases(value?: TransactionPhase[]): TransactionPhase[];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TransactionSetV1;

    static write(value: TransactionSetV1, io: Buffer): void;

    static isValid(value: TransactionSetV1): boolean;

    static toXDR(value: TransactionSetV1): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): TransactionSetV1;

    static fromXDR(input: string, format: 'hex' | 'base64'): TransactionSetV1;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TransactionResultPair {
    constructor(attributes: {
      transactionHash: Buffer;
      result: TransactionResult;
    });

    transactionHash(value?: Buffer): Buffer;

    result(value?: TransactionResult): TransactionResult;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TransactionResultPair;

    static write(value: TransactionResultPair, io: Buffer): void;

    static isValid(value: TransactionResultPair): boolean;

    static toXDR(value: TransactionResultPair): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): TransactionResultPair;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): TransactionResultPair;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TransactionResultSet {
    constructor(attributes: { results: TransactionResultPair[] });

    results(value?: TransactionResultPair[]): TransactionResultPair[];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TransactionResultSet;

    static write(value: TransactionResultSet, io: Buffer): void;

    static isValid(value: TransactionResultSet): boolean;

    static toXDR(value: TransactionResultSet): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): TransactionResultSet;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): TransactionResultSet;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TransactionHistoryEntry {
    constructor(attributes: {
      ledgerSeq: number;
      txSet: TransactionSet;
      ext: TransactionHistoryEntryExt;
    });

    ledgerSeq(value?: number): number;

    txSet(value?: TransactionSet): TransactionSet;

    ext(value?: TransactionHistoryEntryExt): TransactionHistoryEntryExt;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TransactionHistoryEntry;

    static write(value: TransactionHistoryEntry, io: Buffer): void;

    static isValid(value: TransactionHistoryEntry): boolean;

    static toXDR(value: TransactionHistoryEntry): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): TransactionHistoryEntry;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): TransactionHistoryEntry;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TransactionHistoryResultEntry {
    constructor(attributes: {
      ledgerSeq: number;
      txResultSet: TransactionResultSet;
      ext: TransactionHistoryResultEntryExt;
    });

    ledgerSeq(value?: number): number;

    txResultSet(value?: TransactionResultSet): TransactionResultSet;

    ext(
      value?: TransactionHistoryResultEntryExt,
    ): TransactionHistoryResultEntryExt;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TransactionHistoryResultEntry;

    static write(value: TransactionHistoryResultEntry, io: Buffer): void;

    static isValid(value: TransactionHistoryResultEntry): boolean;

    static toXDR(value: TransactionHistoryResultEntry): Buffer;

    static fromXDR(
      input: Buffer,
      format?: 'raw',
    ): TransactionHistoryResultEntry;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): TransactionHistoryResultEntry;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LedgerHeaderHistoryEntry {
    constructor(attributes: {
      hash: Buffer;
      header: LedgerHeader;
      ext: LedgerHeaderHistoryEntryExt;
    });

    hash(value?: Buffer): Buffer;

    header(value?: LedgerHeader): LedgerHeader;

    ext(value?: LedgerHeaderHistoryEntryExt): LedgerHeaderHistoryEntryExt;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LedgerHeaderHistoryEntry;

    static write(value: LedgerHeaderHistoryEntry, io: Buffer): void;

    static isValid(value: LedgerHeaderHistoryEntry): boolean;

    static toXDR(value: LedgerHeaderHistoryEntry): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): LedgerHeaderHistoryEntry;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): LedgerHeaderHistoryEntry;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LedgerScpMessages {
    constructor(attributes: { ledgerSeq: number; messages: ScpEnvelope[] });

    ledgerSeq(value?: number): number;

    messages(value?: ScpEnvelope[]): ScpEnvelope[];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LedgerScpMessages;

    static write(value: LedgerScpMessages, io: Buffer): void;

    static isValid(value: LedgerScpMessages): boolean;

    static toXDR(value: LedgerScpMessages): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): LedgerScpMessages;

    static fromXDR(input: string, format: 'hex' | 'base64'): LedgerScpMessages;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScpHistoryEntryV0 {
    constructor(attributes: {
      quorumSets: ScpQuorumSet[];
      ledgerMessages: LedgerScpMessages;
    });

    quorumSets(value?: ScpQuorumSet[]): ScpQuorumSet[];

    ledgerMessages(value?: LedgerScpMessages): LedgerScpMessages;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScpHistoryEntryV0;

    static write(value: ScpHistoryEntryV0, io: Buffer): void;

    static isValid(value: ScpHistoryEntryV0): boolean;

    static toXDR(value: ScpHistoryEntryV0): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScpHistoryEntryV0;

    static fromXDR(input: string, format: 'hex' | 'base64'): ScpHistoryEntryV0;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class OperationMeta {
    constructor(attributes: { changes: LedgerEntryChange[] });

    changes(value?: LedgerEntryChange[]): LedgerEntryChange[];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): OperationMeta;

    static write(value: OperationMeta, io: Buffer): void;

    static isValid(value: OperationMeta): boolean;

    static toXDR(value: OperationMeta): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): OperationMeta;

    static fromXDR(input: string, format: 'hex' | 'base64'): OperationMeta;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TransactionMetaV1 {
    constructor(attributes: {
      txChanges: LedgerEntryChange[];
      operations: OperationMeta[];
    });

    txChanges(value?: LedgerEntryChange[]): LedgerEntryChange[];

    operations(value?: OperationMeta[]): OperationMeta[];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TransactionMetaV1;

    static write(value: TransactionMetaV1, io: Buffer): void;

    static isValid(value: TransactionMetaV1): boolean;

    static toXDR(value: TransactionMetaV1): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): TransactionMetaV1;

    static fromXDR(input: string, format: 'hex' | 'base64'): TransactionMetaV1;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TransactionMetaV2 {
    constructor(attributes: {
      txChangesBefore: LedgerEntryChange[];
      operations: OperationMeta[];
      txChangesAfter: LedgerEntryChange[];
    });

    txChangesBefore(value?: LedgerEntryChange[]): LedgerEntryChange[];

    operations(value?: OperationMeta[]): OperationMeta[];

    txChangesAfter(value?: LedgerEntryChange[]): LedgerEntryChange[];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TransactionMetaV2;

    static write(value: TransactionMetaV2, io: Buffer): void;

    static isValid(value: TransactionMetaV2): boolean;

    static toXDR(value: TransactionMetaV2): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): TransactionMetaV2;

    static fromXDR(input: string, format: 'hex' | 'base64'): TransactionMetaV2;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ContractEventV0 {
    constructor(attributes: { topics: ScVal[]; data: ScVal });

    topics(value?: ScVal[]): ScVal[];

    data(value?: ScVal): ScVal;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ContractEventV0;

    static write(value: ContractEventV0, io: Buffer): void;

    static isValid(value: ContractEventV0): boolean;

    static toXDR(value: ContractEventV0): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ContractEventV0;

    static fromXDR(input: string, format: 'hex' | 'base64'): ContractEventV0;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ContractEvent {
    constructor(attributes: {
      ext: ExtensionPoint;
      contractId: null | Buffer;
      type: ContractEventType;
      body: ContractEventBody;
    });

    ext(value?: ExtensionPoint): ExtensionPoint;

    contractId(value?: null | Buffer): null | Buffer;

    type(value?: ContractEventType): ContractEventType;

    body(value?: ContractEventBody): ContractEventBody;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ContractEvent;

    static write(value: ContractEvent, io: Buffer): void;

    static isValid(value: ContractEvent): boolean;

    static toXDR(value: ContractEvent): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ContractEvent;

    static fromXDR(input: string, format: 'hex' | 'base64'): ContractEvent;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class DiagnosticEvent {
    constructor(attributes: {
      inSuccessfulContractCall: boolean;
      event: ContractEvent;
    });

    inSuccessfulContractCall(value?: boolean): boolean;

    event(value?: ContractEvent): ContractEvent;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): DiagnosticEvent;

    static write(value: DiagnosticEvent, io: Buffer): void;

    static isValid(value: DiagnosticEvent): boolean;

    static toXDR(value: DiagnosticEvent): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): DiagnosticEvent;

    static fromXDR(input: string, format: 'hex' | 'base64'): DiagnosticEvent;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class SorobanTransactionMetaExtV1 {
    constructor(attributes: {
      ext: ExtensionPoint;
      totalNonRefundableResourceFeeCharged: Int64;
      totalRefundableResourceFeeCharged: Int64;
      rentFeeCharged: Int64;
    });

    ext(value?: ExtensionPoint): ExtensionPoint;

    totalNonRefundableResourceFeeCharged(value?: Int64): Int64;

    totalRefundableResourceFeeCharged(value?: Int64): Int64;

    rentFeeCharged(value?: Int64): Int64;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): SorobanTransactionMetaExtV1;

    static write(value: SorobanTransactionMetaExtV1, io: Buffer): void;

    static isValid(value: SorobanTransactionMetaExtV1): boolean;

    static toXDR(value: SorobanTransactionMetaExtV1): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): SorobanTransactionMetaExtV1;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): SorobanTransactionMetaExtV1;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class SorobanTransactionMeta {
    constructor(attributes: {
      ext: SorobanTransactionMetaExt;
      events: ContractEvent[];
      returnValue: ScVal;
      diagnosticEvents: DiagnosticEvent[];
    });

    ext(value?: SorobanTransactionMetaExt): SorobanTransactionMetaExt;

    events(value?: ContractEvent[]): ContractEvent[];

    returnValue(value?: ScVal): ScVal;

    diagnosticEvents(value?: DiagnosticEvent[]): DiagnosticEvent[];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): SorobanTransactionMeta;

    static write(value: SorobanTransactionMeta, io: Buffer): void;

    static isValid(value: SorobanTransactionMeta): boolean;

    static toXDR(value: SorobanTransactionMeta): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): SorobanTransactionMeta;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): SorobanTransactionMeta;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TransactionMetaV3 {
    constructor(attributes: {
      ext: ExtensionPoint;
      txChangesBefore: LedgerEntryChange[];
      operations: OperationMeta[];
      txChangesAfter: LedgerEntryChange[];
      sorobanMeta: null | SorobanTransactionMeta;
    });

    ext(value?: ExtensionPoint): ExtensionPoint;

    txChangesBefore(value?: LedgerEntryChange[]): LedgerEntryChange[];

    operations(value?: OperationMeta[]): OperationMeta[];

    txChangesAfter(value?: LedgerEntryChange[]): LedgerEntryChange[];

    sorobanMeta(
      value?: null | SorobanTransactionMeta,
    ): null | SorobanTransactionMeta;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TransactionMetaV3;

    static write(value: TransactionMetaV3, io: Buffer): void;

    static isValid(value: TransactionMetaV3): boolean;

    static toXDR(value: TransactionMetaV3): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): TransactionMetaV3;

    static fromXDR(input: string, format: 'hex' | 'base64'): TransactionMetaV3;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class InvokeHostFunctionSuccessPreImage {
    constructor(attributes: { returnValue: ScVal; events: ContractEvent[] });

    returnValue(value?: ScVal): ScVal;

    events(value?: ContractEvent[]): ContractEvent[];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): InvokeHostFunctionSuccessPreImage;

    static write(value: InvokeHostFunctionSuccessPreImage, io: Buffer): void;

    static isValid(value: InvokeHostFunctionSuccessPreImage): boolean;

    static toXDR(value: InvokeHostFunctionSuccessPreImage): Buffer;

    static fromXDR(
      input: Buffer,
      format?: 'raw',
    ): InvokeHostFunctionSuccessPreImage;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): InvokeHostFunctionSuccessPreImage;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TransactionResultMeta {
    constructor(attributes: {
      result: TransactionResultPair;
      feeProcessing: LedgerEntryChange[];
      txApplyProcessing: TransactionMeta;
    });

    result(value?: TransactionResultPair): TransactionResultPair;

    feeProcessing(value?: LedgerEntryChange[]): LedgerEntryChange[];

    txApplyProcessing(value?: TransactionMeta): TransactionMeta;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TransactionResultMeta;

    static write(value: TransactionResultMeta, io: Buffer): void;

    static isValid(value: TransactionResultMeta): boolean;

    static toXDR(value: TransactionResultMeta): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): TransactionResultMeta;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): TransactionResultMeta;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class UpgradeEntryMeta {
    constructor(attributes: {
      upgrade: LedgerUpgrade;
      changes: LedgerEntryChange[];
    });

    upgrade(value?: LedgerUpgrade): LedgerUpgrade;

    changes(value?: LedgerEntryChange[]): LedgerEntryChange[];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): UpgradeEntryMeta;

    static write(value: UpgradeEntryMeta, io: Buffer): void;

    static isValid(value: UpgradeEntryMeta): boolean;

    static toXDR(value: UpgradeEntryMeta): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): UpgradeEntryMeta;

    static fromXDR(input: string, format: 'hex' | 'base64'): UpgradeEntryMeta;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LedgerCloseMetaV0 {
    constructor(attributes: {
      ledgerHeader: LedgerHeaderHistoryEntry;
      txSet: TransactionSet;
      txProcessing: TransactionResultMeta[];
      upgradesProcessing: UpgradeEntryMeta[];
      scpInfo: ScpHistoryEntry[];
    });

    ledgerHeader(value?: LedgerHeaderHistoryEntry): LedgerHeaderHistoryEntry;

    txSet(value?: TransactionSet): TransactionSet;

    txProcessing(value?: TransactionResultMeta[]): TransactionResultMeta[];

    upgradesProcessing(value?: UpgradeEntryMeta[]): UpgradeEntryMeta[];

    scpInfo(value?: ScpHistoryEntry[]): ScpHistoryEntry[];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LedgerCloseMetaV0;

    static write(value: LedgerCloseMetaV0, io: Buffer): void;

    static isValid(value: LedgerCloseMetaV0): boolean;

    static toXDR(value: LedgerCloseMetaV0): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): LedgerCloseMetaV0;

    static fromXDR(input: string, format: 'hex' | 'base64'): LedgerCloseMetaV0;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LedgerCloseMetaExtV1 {
    constructor(attributes: { ext: ExtensionPoint; sorobanFeeWrite1Kb: Int64 });

    ext(value?: ExtensionPoint): ExtensionPoint;

    sorobanFeeWrite1Kb(value?: Int64): Int64;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LedgerCloseMetaExtV1;

    static write(value: LedgerCloseMetaExtV1, io: Buffer): void;

    static isValid(value: LedgerCloseMetaExtV1): boolean;

    static toXDR(value: LedgerCloseMetaExtV1): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): LedgerCloseMetaExtV1;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): LedgerCloseMetaExtV1;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LedgerCloseMetaV1 {
    constructor(attributes: {
      ext: LedgerCloseMetaExt;
      ledgerHeader: LedgerHeaderHistoryEntry;
      txSet: GeneralizedTransactionSet;
      txProcessing: TransactionResultMeta[];
      upgradesProcessing: UpgradeEntryMeta[];
      scpInfo: ScpHistoryEntry[];
      totalByteSizeOfBucketList: Uint64;
      evictedTemporaryLedgerKeys: LedgerKey[];
      evictedPersistentLedgerEntries: LedgerEntry[];
    });

    ext(value?: LedgerCloseMetaExt): LedgerCloseMetaExt;

    ledgerHeader(value?: LedgerHeaderHistoryEntry): LedgerHeaderHistoryEntry;

    txSet(value?: GeneralizedTransactionSet): GeneralizedTransactionSet;

    txProcessing(value?: TransactionResultMeta[]): TransactionResultMeta[];

    upgradesProcessing(value?: UpgradeEntryMeta[]): UpgradeEntryMeta[];

    scpInfo(value?: ScpHistoryEntry[]): ScpHistoryEntry[];

    totalByteSizeOfBucketList(value?: Uint64): Uint64;

    evictedTemporaryLedgerKeys(value?: LedgerKey[]): LedgerKey[];

    evictedPersistentLedgerEntries(value?: LedgerEntry[]): LedgerEntry[];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LedgerCloseMetaV1;

    static write(value: LedgerCloseMetaV1, io: Buffer): void;

    static isValid(value: LedgerCloseMetaV1): boolean;

    static toXDR(value: LedgerCloseMetaV1): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): LedgerCloseMetaV1;

    static fromXDR(input: string, format: 'hex' | 'base64'): LedgerCloseMetaV1;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class Error {
    constructor(attributes: { code: ErrorCode; msg: string | Buffer });

    code(value?: ErrorCode): ErrorCode;

    msg(value?: string | Buffer): string | Buffer;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): Error;

    static write(value: Error, io: Buffer): void;

    static isValid(value: Error): boolean;

    static toXDR(value: Error): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): Error;

    static fromXDR(input: string, format: 'hex' | 'base64'): Error;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class SendMore {
    constructor(attributes: { numMessages: number });

    numMessages(value?: number): number;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): SendMore;

    static write(value: SendMore, io: Buffer): void;

    static isValid(value: SendMore): boolean;

    static toXDR(value: SendMore): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): SendMore;

    static fromXDR(input: string, format: 'hex' | 'base64'): SendMore;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class SendMoreExtended {
    constructor(attributes: { numMessages: number; numBytes: number });

    numMessages(value?: number): number;

    numBytes(value?: number): number;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): SendMoreExtended;

    static write(value: SendMoreExtended, io: Buffer): void;

    static isValid(value: SendMoreExtended): boolean;

    static toXDR(value: SendMoreExtended): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): SendMoreExtended;

    static fromXDR(input: string, format: 'hex' | 'base64'): SendMoreExtended;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class AuthCert {
    constructor(attributes: {
      pubkey: Curve25519Public;
      expiration: Uint64;
      sig: Buffer;
    });

    pubkey(value?: Curve25519Public): Curve25519Public;

    expiration(value?: Uint64): Uint64;

    sig(value?: Buffer): Buffer;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): AuthCert;

    static write(value: AuthCert, io: Buffer): void;

    static isValid(value: AuthCert): boolean;

    static toXDR(value: AuthCert): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): AuthCert;

    static fromXDR(input: string, format: 'hex' | 'base64'): AuthCert;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class Hello {
    constructor(attributes: {
      ledgerVersion: number;
      overlayVersion: number;
      overlayMinVersion: number;
      networkId: Buffer;
      versionStr: string | Buffer;
      listeningPort: number;
      peerId: NodeId;
      cert: AuthCert;
      nonce: Buffer;
    });

    ledgerVersion(value?: number): number;

    overlayVersion(value?: number): number;

    overlayMinVersion(value?: number): number;

    networkId(value?: Buffer): Buffer;

    versionStr(value?: string | Buffer): string | Buffer;

    listeningPort(value?: number): number;

    peerId(value?: NodeId): NodeId;

    cert(value?: AuthCert): AuthCert;

    nonce(value?: Buffer): Buffer;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): Hello;

    static write(value: Hello, io: Buffer): void;

    static isValid(value: Hello): boolean;

    static toXDR(value: Hello): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): Hello;

    static fromXDR(input: string, format: 'hex' | 'base64'): Hello;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class Auth {
    constructor(attributes: { flags: number });

    flags(value?: number): number;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): Auth;

    static write(value: Auth, io: Buffer): void;

    static isValid(value: Auth): boolean;

    static toXDR(value: Auth): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): Auth;

    static fromXDR(input: string, format: 'hex' | 'base64'): Auth;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class PeerAddress {
    constructor(attributes: {
      ip: PeerAddressIp;
      port: number;
      numFailures: number;
    });

    ip(value?: PeerAddressIp): PeerAddressIp;

    port(value?: number): number;

    numFailures(value?: number): number;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): PeerAddress;

    static write(value: PeerAddress, io: Buffer): void;

    static isValid(value: PeerAddress): boolean;

    static toXDR(value: PeerAddress): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): PeerAddress;

    static fromXDR(input: string, format: 'hex' | 'base64'): PeerAddress;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class DontHave {
    constructor(attributes: { type: MessageType; reqHash: Buffer });

    type(value?: MessageType): MessageType;

    reqHash(value?: Buffer): Buffer;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): DontHave;

    static write(value: DontHave, io: Buffer): void;

    static isValid(value: DontHave): boolean;

    static toXDR(value: DontHave): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): DontHave;

    static fromXDR(input: string, format: 'hex' | 'base64'): DontHave;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TimeSlicedSurveyStartCollectingMessage {
    constructor(attributes: {
      surveyorId: NodeId;
      nonce: number;
      ledgerNum: number;
    });

    surveyorId(value?: NodeId): NodeId;

    nonce(value?: number): number;

    ledgerNum(value?: number): number;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TimeSlicedSurveyStartCollectingMessage;

    static write(
      value: TimeSlicedSurveyStartCollectingMessage,
      io: Buffer,
    ): void;

    static isValid(value: TimeSlicedSurveyStartCollectingMessage): boolean;

    static toXDR(value: TimeSlicedSurveyStartCollectingMessage): Buffer;

    static fromXDR(
      input: Buffer,
      format?: 'raw',
    ): TimeSlicedSurveyStartCollectingMessage;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): TimeSlicedSurveyStartCollectingMessage;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class SignedTimeSlicedSurveyStartCollectingMessage {
    constructor(attributes: {
      signature: Buffer;
      startCollecting: TimeSlicedSurveyStartCollectingMessage;
    });

    signature(value?: Buffer): Buffer;

    startCollecting(
      value?: TimeSlicedSurveyStartCollectingMessage,
    ): TimeSlicedSurveyStartCollectingMessage;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): SignedTimeSlicedSurveyStartCollectingMessage;

    static write(
      value: SignedTimeSlicedSurveyStartCollectingMessage,
      io: Buffer,
    ): void;

    static isValid(
      value: SignedTimeSlicedSurveyStartCollectingMessage,
    ): boolean;

    static toXDR(value: SignedTimeSlicedSurveyStartCollectingMessage): Buffer;

    static fromXDR(
      input: Buffer,
      format?: 'raw',
    ): SignedTimeSlicedSurveyStartCollectingMessage;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): SignedTimeSlicedSurveyStartCollectingMessage;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TimeSlicedSurveyStopCollectingMessage {
    constructor(attributes: {
      surveyorId: NodeId;
      nonce: number;
      ledgerNum: number;
    });

    surveyorId(value?: NodeId): NodeId;

    nonce(value?: number): number;

    ledgerNum(value?: number): number;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TimeSlicedSurveyStopCollectingMessage;

    static write(
      value: TimeSlicedSurveyStopCollectingMessage,
      io: Buffer,
    ): void;

    static isValid(value: TimeSlicedSurveyStopCollectingMessage): boolean;

    static toXDR(value: TimeSlicedSurveyStopCollectingMessage): Buffer;

    static fromXDR(
      input: Buffer,
      format?: 'raw',
    ): TimeSlicedSurveyStopCollectingMessage;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): TimeSlicedSurveyStopCollectingMessage;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class SignedTimeSlicedSurveyStopCollectingMessage {
    constructor(attributes: {
      signature: Buffer;
      stopCollecting: TimeSlicedSurveyStopCollectingMessage;
    });

    signature(value?: Buffer): Buffer;

    stopCollecting(
      value?: TimeSlicedSurveyStopCollectingMessage,
    ): TimeSlicedSurveyStopCollectingMessage;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): SignedTimeSlicedSurveyStopCollectingMessage;

    static write(
      value: SignedTimeSlicedSurveyStopCollectingMessage,
      io: Buffer,
    ): void;

    static isValid(value: SignedTimeSlicedSurveyStopCollectingMessage): boolean;

    static toXDR(value: SignedTimeSlicedSurveyStopCollectingMessage): Buffer;

    static fromXDR(
      input: Buffer,
      format?: 'raw',
    ): SignedTimeSlicedSurveyStopCollectingMessage;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): SignedTimeSlicedSurveyStopCollectingMessage;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class SurveyRequestMessage {
    constructor(attributes: {
      surveyorPeerId: NodeId;
      surveyedPeerId: NodeId;
      ledgerNum: number;
      encryptionKey: Curve25519Public;
      commandType: SurveyMessageCommandType;
    });

    surveyorPeerId(value?: NodeId): NodeId;

    surveyedPeerId(value?: NodeId): NodeId;

    ledgerNum(value?: number): number;

    encryptionKey(value?: Curve25519Public): Curve25519Public;

    commandType(value?: SurveyMessageCommandType): SurveyMessageCommandType;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): SurveyRequestMessage;

    static write(value: SurveyRequestMessage, io: Buffer): void;

    static isValid(value: SurveyRequestMessage): boolean;

    static toXDR(value: SurveyRequestMessage): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): SurveyRequestMessage;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): SurveyRequestMessage;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TimeSlicedSurveyRequestMessage {
    constructor(attributes: {
      request: SurveyRequestMessage;
      nonce: number;
      inboundPeersIndex: number;
      outboundPeersIndex: number;
    });

    request(value?: SurveyRequestMessage): SurveyRequestMessage;

    nonce(value?: number): number;

    inboundPeersIndex(value?: number): number;

    outboundPeersIndex(value?: number): number;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TimeSlicedSurveyRequestMessage;

    static write(value: TimeSlicedSurveyRequestMessage, io: Buffer): void;

    static isValid(value: TimeSlicedSurveyRequestMessage): boolean;

    static toXDR(value: TimeSlicedSurveyRequestMessage): Buffer;

    static fromXDR(
      input: Buffer,
      format?: 'raw',
    ): TimeSlicedSurveyRequestMessage;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): TimeSlicedSurveyRequestMessage;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class SignedSurveyRequestMessage {
    constructor(attributes: {
      requestSignature: Buffer;
      request: SurveyRequestMessage;
    });

    requestSignature(value?: Buffer): Buffer;

    request(value?: SurveyRequestMessage): SurveyRequestMessage;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): SignedSurveyRequestMessage;

    static write(value: SignedSurveyRequestMessage, io: Buffer): void;

    static isValid(value: SignedSurveyRequestMessage): boolean;

    static toXDR(value: SignedSurveyRequestMessage): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): SignedSurveyRequestMessage;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): SignedSurveyRequestMessage;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class SignedTimeSlicedSurveyRequestMessage {
    constructor(attributes: {
      requestSignature: Buffer;
      request: TimeSlicedSurveyRequestMessage;
    });

    requestSignature(value?: Buffer): Buffer;

    request(
      value?: TimeSlicedSurveyRequestMessage,
    ): TimeSlicedSurveyRequestMessage;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): SignedTimeSlicedSurveyRequestMessage;

    static write(value: SignedTimeSlicedSurveyRequestMessage, io: Buffer): void;

    static isValid(value: SignedTimeSlicedSurveyRequestMessage): boolean;

    static toXDR(value: SignedTimeSlicedSurveyRequestMessage): Buffer;

    static fromXDR(
      input: Buffer,
      format?: 'raw',
    ): SignedTimeSlicedSurveyRequestMessage;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): SignedTimeSlicedSurveyRequestMessage;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class SurveyResponseMessage {
    constructor(attributes: {
      surveyorPeerId: NodeId;
      surveyedPeerId: NodeId;
      ledgerNum: number;
      commandType: SurveyMessageCommandType;
      encryptedBody: Buffer;
    });

    surveyorPeerId(value?: NodeId): NodeId;

    surveyedPeerId(value?: NodeId): NodeId;

    ledgerNum(value?: number): number;

    commandType(value?: SurveyMessageCommandType): SurveyMessageCommandType;

    encryptedBody(value?: Buffer): Buffer;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): SurveyResponseMessage;

    static write(value: SurveyResponseMessage, io: Buffer): void;

    static isValid(value: SurveyResponseMessage): boolean;

    static toXDR(value: SurveyResponseMessage): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): SurveyResponseMessage;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): SurveyResponseMessage;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TimeSlicedSurveyResponseMessage {
    constructor(attributes: { response: SurveyResponseMessage; nonce: number });

    response(value?: SurveyResponseMessage): SurveyResponseMessage;

    nonce(value?: number): number;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TimeSlicedSurveyResponseMessage;

    static write(value: TimeSlicedSurveyResponseMessage, io: Buffer): void;

    static isValid(value: TimeSlicedSurveyResponseMessage): boolean;

    static toXDR(value: TimeSlicedSurveyResponseMessage): Buffer;

    static fromXDR(
      input: Buffer,
      format?: 'raw',
    ): TimeSlicedSurveyResponseMessage;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): TimeSlicedSurveyResponseMessage;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class SignedSurveyResponseMessage {
    constructor(attributes: {
      responseSignature: Buffer;
      response: SurveyResponseMessage;
    });

    responseSignature(value?: Buffer): Buffer;

    response(value?: SurveyResponseMessage): SurveyResponseMessage;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): SignedSurveyResponseMessage;

    static write(value: SignedSurveyResponseMessage, io: Buffer): void;

    static isValid(value: SignedSurveyResponseMessage): boolean;

    static toXDR(value: SignedSurveyResponseMessage): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): SignedSurveyResponseMessage;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): SignedSurveyResponseMessage;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class SignedTimeSlicedSurveyResponseMessage {
    constructor(attributes: {
      responseSignature: Buffer;
      response: TimeSlicedSurveyResponseMessage;
    });

    responseSignature(value?: Buffer): Buffer;

    response(
      value?: TimeSlicedSurveyResponseMessage,
    ): TimeSlicedSurveyResponseMessage;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): SignedTimeSlicedSurveyResponseMessage;

    static write(
      value: SignedTimeSlicedSurveyResponseMessage,
      io: Buffer,
    ): void;

    static isValid(value: SignedTimeSlicedSurveyResponseMessage): boolean;

    static toXDR(value: SignedTimeSlicedSurveyResponseMessage): Buffer;

    static fromXDR(
      input: Buffer,
      format?: 'raw',
    ): SignedTimeSlicedSurveyResponseMessage;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): SignedTimeSlicedSurveyResponseMessage;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class PeerStats {
    constructor(attributes: {
      id: NodeId;
      versionStr: string | Buffer;
      messagesRead: Uint64;
      messagesWritten: Uint64;
      bytesRead: Uint64;
      bytesWritten: Uint64;
      secondsConnected: Uint64;
      uniqueFloodBytesRecv: Uint64;
      duplicateFloodBytesRecv: Uint64;
      uniqueFetchBytesRecv: Uint64;
      duplicateFetchBytesRecv: Uint64;
      uniqueFloodMessageRecv: Uint64;
      duplicateFloodMessageRecv: Uint64;
      uniqueFetchMessageRecv: Uint64;
      duplicateFetchMessageRecv: Uint64;
    });

    id(value?: NodeId): NodeId;

    versionStr(value?: string | Buffer): string | Buffer;

    messagesRead(value?: Uint64): Uint64;

    messagesWritten(value?: Uint64): Uint64;

    bytesRead(value?: Uint64): Uint64;

    bytesWritten(value?: Uint64): Uint64;

    secondsConnected(value?: Uint64): Uint64;

    uniqueFloodBytesRecv(value?: Uint64): Uint64;

    duplicateFloodBytesRecv(value?: Uint64): Uint64;

    uniqueFetchBytesRecv(value?: Uint64): Uint64;

    duplicateFetchBytesRecv(value?: Uint64): Uint64;

    uniqueFloodMessageRecv(value?: Uint64): Uint64;

    duplicateFloodMessageRecv(value?: Uint64): Uint64;

    uniqueFetchMessageRecv(value?: Uint64): Uint64;

    duplicateFetchMessageRecv(value?: Uint64): Uint64;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): PeerStats;

    static write(value: PeerStats, io: Buffer): void;

    static isValid(value: PeerStats): boolean;

    static toXDR(value: PeerStats): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): PeerStats;

    static fromXDR(input: string, format: 'hex' | 'base64'): PeerStats;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TimeSlicedNodeData {
    constructor(attributes: {
      addedAuthenticatedPeers: number;
      droppedAuthenticatedPeers: number;
      totalInboundPeerCount: number;
      totalOutboundPeerCount: number;
      p75ScpFirstToSelfLatencyMs: number;
      p75ScpSelfToOtherLatencyMs: number;
      lostSyncCount: number;
      isValidator: boolean;
      maxInboundPeerCount: number;
      maxOutboundPeerCount: number;
    });

    addedAuthenticatedPeers(value?: number): number;

    droppedAuthenticatedPeers(value?: number): number;

    totalInboundPeerCount(value?: number): number;

    totalOutboundPeerCount(value?: number): number;

    p75ScpFirstToSelfLatencyMs(value?: number): number;

    p75ScpSelfToOtherLatencyMs(value?: number): number;

    lostSyncCount(value?: number): number;

    isValidator(value?: boolean): boolean;

    maxInboundPeerCount(value?: number): number;

    maxOutboundPeerCount(value?: number): number;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TimeSlicedNodeData;

    static write(value: TimeSlicedNodeData, io: Buffer): void;

    static isValid(value: TimeSlicedNodeData): boolean;

    static toXDR(value: TimeSlicedNodeData): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): TimeSlicedNodeData;

    static fromXDR(input: string, format: 'hex' | 'base64'): TimeSlicedNodeData;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TimeSlicedPeerData {
    constructor(attributes: { peerStats: PeerStats; averageLatencyMs: number });

    peerStats(value?: PeerStats): PeerStats;

    averageLatencyMs(value?: number): number;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TimeSlicedPeerData;

    static write(value: TimeSlicedPeerData, io: Buffer): void;

    static isValid(value: TimeSlicedPeerData): boolean;

    static toXDR(value: TimeSlicedPeerData): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): TimeSlicedPeerData;

    static fromXDR(input: string, format: 'hex' | 'base64'): TimeSlicedPeerData;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TopologyResponseBodyV0 {
    constructor(attributes: {
      inboundPeers: PeerStats[];
      outboundPeers: PeerStats[];
      totalInboundPeerCount: number;
      totalOutboundPeerCount: number;
    });

    inboundPeers(value?: PeerStats[]): PeerStats[];

    outboundPeers(value?: PeerStats[]): PeerStats[];

    totalInboundPeerCount(value?: number): number;

    totalOutboundPeerCount(value?: number): number;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TopologyResponseBodyV0;

    static write(value: TopologyResponseBodyV0, io: Buffer): void;

    static isValid(value: TopologyResponseBodyV0): boolean;

    static toXDR(value: TopologyResponseBodyV0): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): TopologyResponseBodyV0;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): TopologyResponseBodyV0;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TopologyResponseBodyV1 {
    constructor(attributes: {
      inboundPeers: PeerStats[];
      outboundPeers: PeerStats[];
      totalInboundPeerCount: number;
      totalOutboundPeerCount: number;
      maxInboundPeerCount: number;
      maxOutboundPeerCount: number;
    });

    inboundPeers(value?: PeerStats[]): PeerStats[];

    outboundPeers(value?: PeerStats[]): PeerStats[];

    totalInboundPeerCount(value?: number): number;

    totalOutboundPeerCount(value?: number): number;

    maxInboundPeerCount(value?: number): number;

    maxOutboundPeerCount(value?: number): number;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TopologyResponseBodyV1;

    static write(value: TopologyResponseBodyV1, io: Buffer): void;

    static isValid(value: TopologyResponseBodyV1): boolean;

    static toXDR(value: TopologyResponseBodyV1): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): TopologyResponseBodyV1;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): TopologyResponseBodyV1;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TopologyResponseBodyV2 {
    constructor(attributes: {
      inboundPeers: TimeSlicedPeerData[];
      outboundPeers: TimeSlicedPeerData[];
      nodeData: TimeSlicedNodeData;
    });

    inboundPeers(value?: TimeSlicedPeerData[]): TimeSlicedPeerData[];

    outboundPeers(value?: TimeSlicedPeerData[]): TimeSlicedPeerData[];

    nodeData(value?: TimeSlicedNodeData): TimeSlicedNodeData;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TopologyResponseBodyV2;

    static write(value: TopologyResponseBodyV2, io: Buffer): void;

    static isValid(value: TopologyResponseBodyV2): boolean;

    static toXDR(value: TopologyResponseBodyV2): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): TopologyResponseBodyV2;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): TopologyResponseBodyV2;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class FloodAdvert {
    constructor(attributes: { txHashes: Hash[] });

    txHashes(value?: Hash[]): Hash[];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): FloodAdvert;

    static write(value: FloodAdvert, io: Buffer): void;

    static isValid(value: FloodAdvert): boolean;

    static toXDR(value: FloodAdvert): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): FloodAdvert;

    static fromXDR(input: string, format: 'hex' | 'base64'): FloodAdvert;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class FloodDemand {
    constructor(attributes: { txHashes: Hash[] });

    txHashes(value?: Hash[]): Hash[];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): FloodDemand;

    static write(value: FloodDemand, io: Buffer): void;

    static isValid(value: FloodDemand): boolean;

    static toXDR(value: FloodDemand): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): FloodDemand;

    static fromXDR(input: string, format: 'hex' | 'base64'): FloodDemand;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class AuthenticatedMessageV0 {
    constructor(attributes: {
      sequence: Uint64;
      message: StellarMessage;
      mac: HmacSha256Mac;
    });

    sequence(value?: Uint64): Uint64;

    message(value?: StellarMessage): StellarMessage;

    mac(value?: HmacSha256Mac): HmacSha256Mac;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): AuthenticatedMessageV0;

    static write(value: AuthenticatedMessageV0, io: Buffer): void;

    static isValid(value: AuthenticatedMessageV0): boolean;

    static toXDR(value: AuthenticatedMessageV0): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): AuthenticatedMessageV0;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): AuthenticatedMessageV0;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class MuxedAccountMed25519 {
    constructor(attributes: { id: Uint64; ed25519: Buffer });

    id(value?: Uint64): Uint64;

    ed25519(value?: Buffer): Buffer;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): MuxedAccountMed25519;

    static write(value: MuxedAccountMed25519, io: Buffer): void;

    static isValid(value: MuxedAccountMed25519): boolean;

    static toXDR(value: MuxedAccountMed25519): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): MuxedAccountMed25519;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): MuxedAccountMed25519;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class DecoratedSignature {
    constructor(attributes: { hint: Buffer; signature: Buffer });

    hint(value?: Buffer): Buffer;

    signature(value?: Buffer): Buffer;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): DecoratedSignature;

    static write(value: DecoratedSignature, io: Buffer): void;

    static isValid(value: DecoratedSignature): boolean;

    static toXDR(value: DecoratedSignature): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): DecoratedSignature;

    static fromXDR(input: string, format: 'hex' | 'base64'): DecoratedSignature;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class CreateAccountOp {
    constructor(attributes: { destination: AccountId; startingBalance: Int64 });

    destination(value?: AccountId): AccountId;

    startingBalance(value?: Int64): Int64;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): CreateAccountOp;

    static write(value: CreateAccountOp, io: Buffer): void;

    static isValid(value: CreateAccountOp): boolean;

    static toXDR(value: CreateAccountOp): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): CreateAccountOp;

    static fromXDR(input: string, format: 'hex' | 'base64'): CreateAccountOp;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class PaymentOp {
    constructor(attributes: {
      destination: MuxedAccount;
      asset: Asset;
      amount: Int64;
    });

    destination(value?: MuxedAccount): MuxedAccount;

    asset(value?: Asset): Asset;

    amount(value?: Int64): Int64;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): PaymentOp;

    static write(value: PaymentOp, io: Buffer): void;

    static isValid(value: PaymentOp): boolean;

    static toXDR(value: PaymentOp): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): PaymentOp;

    static fromXDR(input: string, format: 'hex' | 'base64'): PaymentOp;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class PathPaymentStrictReceiveOp {
    constructor(attributes: {
      sendAsset: Asset;
      sendMax: Int64;
      destination: MuxedAccount;
      destAsset: Asset;
      destAmount: Int64;
      path: Asset[];
    });

    sendAsset(value?: Asset): Asset;

    sendMax(value?: Int64): Int64;

    destination(value?: MuxedAccount): MuxedAccount;

    destAsset(value?: Asset): Asset;

    destAmount(value?: Int64): Int64;

    path(value?: Asset[]): Asset[];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): PathPaymentStrictReceiveOp;

    static write(value: PathPaymentStrictReceiveOp, io: Buffer): void;

    static isValid(value: PathPaymentStrictReceiveOp): boolean;

    static toXDR(value: PathPaymentStrictReceiveOp): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): PathPaymentStrictReceiveOp;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): PathPaymentStrictReceiveOp;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class PathPaymentStrictSendOp {
    constructor(attributes: {
      sendAsset: Asset;
      sendAmount: Int64;
      destination: MuxedAccount;
      destAsset: Asset;
      destMin: Int64;
      path: Asset[];
    });

    sendAsset(value?: Asset): Asset;

    sendAmount(value?: Int64): Int64;

    destination(value?: MuxedAccount): MuxedAccount;

    destAsset(value?: Asset): Asset;

    destMin(value?: Int64): Int64;

    path(value?: Asset[]): Asset[];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): PathPaymentStrictSendOp;

    static write(value: PathPaymentStrictSendOp, io: Buffer): void;

    static isValid(value: PathPaymentStrictSendOp): boolean;

    static toXDR(value: PathPaymentStrictSendOp): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): PathPaymentStrictSendOp;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): PathPaymentStrictSendOp;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ManageSellOfferOp {
    constructor(attributes: {
      selling: Asset;
      buying: Asset;
      amount: Int64;
      price: Price;
      offerId: Int64;
    });

    selling(value?: Asset): Asset;

    buying(value?: Asset): Asset;

    amount(value?: Int64): Int64;

    price(value?: Price): Price;

    offerId(value?: Int64): Int64;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ManageSellOfferOp;

    static write(value: ManageSellOfferOp, io: Buffer): void;

    static isValid(value: ManageSellOfferOp): boolean;

    static toXDR(value: ManageSellOfferOp): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ManageSellOfferOp;

    static fromXDR(input: string, format: 'hex' | 'base64'): ManageSellOfferOp;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ManageBuyOfferOp {
    constructor(attributes: {
      selling: Asset;
      buying: Asset;
      buyAmount: Int64;
      price: Price;
      offerId: Int64;
    });

    selling(value?: Asset): Asset;

    buying(value?: Asset): Asset;

    buyAmount(value?: Int64): Int64;

    price(value?: Price): Price;

    offerId(value?: Int64): Int64;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ManageBuyOfferOp;

    static write(value: ManageBuyOfferOp, io: Buffer): void;

    static isValid(value: ManageBuyOfferOp): boolean;

    static toXDR(value: ManageBuyOfferOp): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ManageBuyOfferOp;

    static fromXDR(input: string, format: 'hex' | 'base64'): ManageBuyOfferOp;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class CreatePassiveSellOfferOp {
    constructor(attributes: {
      selling: Asset;
      buying: Asset;
      amount: Int64;
      price: Price;
    });

    selling(value?: Asset): Asset;

    buying(value?: Asset): Asset;

    amount(value?: Int64): Int64;

    price(value?: Price): Price;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): CreatePassiveSellOfferOp;

    static write(value: CreatePassiveSellOfferOp, io: Buffer): void;

    static isValid(value: CreatePassiveSellOfferOp): boolean;

    static toXDR(value: CreatePassiveSellOfferOp): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): CreatePassiveSellOfferOp;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): CreatePassiveSellOfferOp;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class SetOptionsOp {
    constructor(attributes: {
      inflationDest: null | AccountId;
      clearFlags: null | number;
      setFlags: null | number;
      masterWeight: null | number;
      lowThreshold: null | number;
      medThreshold: null | number;
      highThreshold: null | number;
      homeDomain: null | string | Buffer;
      signer: null | Signer;
    });

    inflationDest(value?: null | AccountId): null | AccountId;

    clearFlags(value?: null | number): null | number;

    setFlags(value?: null | number): null | number;

    masterWeight(value?: null | number): null | number;

    lowThreshold(value?: null | number): null | number;

    medThreshold(value?: null | number): null | number;

    highThreshold(value?: null | number): null | number;

    homeDomain(value?: null | string | Buffer): null | string | Buffer;

    signer(value?: null | Signer): null | Signer;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): SetOptionsOp;

    static write(value: SetOptionsOp, io: Buffer): void;

    static isValid(value: SetOptionsOp): boolean;

    static toXDR(value: SetOptionsOp): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): SetOptionsOp;

    static fromXDR(input: string, format: 'hex' | 'base64'): SetOptionsOp;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ChangeTrustOp {
    constructor(attributes: { line: ChangeTrustAsset; limit: Int64 });

    line(value?: ChangeTrustAsset): ChangeTrustAsset;

    limit(value?: Int64): Int64;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ChangeTrustOp;

    static write(value: ChangeTrustOp, io: Buffer): void;

    static isValid(value: ChangeTrustOp): boolean;

    static toXDR(value: ChangeTrustOp): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ChangeTrustOp;

    static fromXDR(input: string, format: 'hex' | 'base64'): ChangeTrustOp;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class AllowTrustOp {
    constructor(attributes: {
      trustor: AccountId;
      asset: AssetCode;
      authorize: number;
    });

    trustor(value?: AccountId): AccountId;

    asset(value?: AssetCode): AssetCode;

    authorize(value?: number): number;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): AllowTrustOp;

    static write(value: AllowTrustOp, io: Buffer): void;

    static isValid(value: AllowTrustOp): boolean;

    static toXDR(value: AllowTrustOp): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): AllowTrustOp;

    static fromXDR(input: string, format: 'hex' | 'base64'): AllowTrustOp;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ManageDataOp {
    constructor(attributes: {
      dataName: string | Buffer;
      dataValue: null | Buffer;
    });

    dataName(value?: string | Buffer): string | Buffer;

    dataValue(value?: null | Buffer): null | Buffer;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ManageDataOp;

    static write(value: ManageDataOp, io: Buffer): void;

    static isValid(value: ManageDataOp): boolean;

    static toXDR(value: ManageDataOp): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ManageDataOp;

    static fromXDR(input: string, format: 'hex' | 'base64'): ManageDataOp;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class BumpSequenceOp {
    constructor(attributes: { bumpTo: SequenceNumber });

    bumpTo(value?: SequenceNumber): SequenceNumber;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): BumpSequenceOp;

    static write(value: BumpSequenceOp, io: Buffer): void;

    static isValid(value: BumpSequenceOp): boolean;

    static toXDR(value: BumpSequenceOp): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): BumpSequenceOp;

    static fromXDR(input: string, format: 'hex' | 'base64'): BumpSequenceOp;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class CreateClaimableBalanceOp {
    constructor(attributes: {
      asset: Asset;
      amount: Int64;
      claimants: Claimant[];
    });

    asset(value?: Asset): Asset;

    amount(value?: Int64): Int64;

    claimants(value?: Claimant[]): Claimant[];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): CreateClaimableBalanceOp;

    static write(value: CreateClaimableBalanceOp, io: Buffer): void;

    static isValid(value: CreateClaimableBalanceOp): boolean;

    static toXDR(value: CreateClaimableBalanceOp): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): CreateClaimableBalanceOp;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): CreateClaimableBalanceOp;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ClaimClaimableBalanceOp {
    constructor(attributes: { balanceId: ClaimableBalanceId });

    balanceId(value?: ClaimableBalanceId): ClaimableBalanceId;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ClaimClaimableBalanceOp;

    static write(value: ClaimClaimableBalanceOp, io: Buffer): void;

    static isValid(value: ClaimClaimableBalanceOp): boolean;

    static toXDR(value: ClaimClaimableBalanceOp): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ClaimClaimableBalanceOp;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ClaimClaimableBalanceOp;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class BeginSponsoringFutureReservesOp {
    constructor(attributes: { sponsoredId: AccountId });

    sponsoredId(value?: AccountId): AccountId;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): BeginSponsoringFutureReservesOp;

    static write(value: BeginSponsoringFutureReservesOp, io: Buffer): void;

    static isValid(value: BeginSponsoringFutureReservesOp): boolean;

    static toXDR(value: BeginSponsoringFutureReservesOp): Buffer;

    static fromXDR(
      input: Buffer,
      format?: 'raw',
    ): BeginSponsoringFutureReservesOp;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): BeginSponsoringFutureReservesOp;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class RevokeSponsorshipOpSigner {
    constructor(attributes: { accountId: AccountId; signerKey: SignerKey });

    accountId(value?: AccountId): AccountId;

    signerKey(value?: SignerKey): SignerKey;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): RevokeSponsorshipOpSigner;

    static write(value: RevokeSponsorshipOpSigner, io: Buffer): void;

    static isValid(value: RevokeSponsorshipOpSigner): boolean;

    static toXDR(value: RevokeSponsorshipOpSigner): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): RevokeSponsorshipOpSigner;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): RevokeSponsorshipOpSigner;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ClawbackOp {
    constructor(attributes: {
      asset: Asset;
      from: MuxedAccount;
      amount: Int64;
    });

    asset(value?: Asset): Asset;

    from(value?: MuxedAccount): MuxedAccount;

    amount(value?: Int64): Int64;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ClawbackOp;

    static write(value: ClawbackOp, io: Buffer): void;

    static isValid(value: ClawbackOp): boolean;

    static toXDR(value: ClawbackOp): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ClawbackOp;

    static fromXDR(input: string, format: 'hex' | 'base64'): ClawbackOp;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ClawbackClaimableBalanceOp {
    constructor(attributes: { balanceId: ClaimableBalanceId });

    balanceId(value?: ClaimableBalanceId): ClaimableBalanceId;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ClawbackClaimableBalanceOp;

    static write(value: ClawbackClaimableBalanceOp, io: Buffer): void;

    static isValid(value: ClawbackClaimableBalanceOp): boolean;

    static toXDR(value: ClawbackClaimableBalanceOp): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ClawbackClaimableBalanceOp;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ClawbackClaimableBalanceOp;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class SetTrustLineFlagsOp {
    constructor(attributes: {
      trustor: AccountId;
      asset: Asset;
      clearFlags: number;
      setFlags: number;
    });

    trustor(value?: AccountId): AccountId;

    asset(value?: Asset): Asset;

    clearFlags(value?: number): number;

    setFlags(value?: number): number;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): SetTrustLineFlagsOp;

    static write(value: SetTrustLineFlagsOp, io: Buffer): void;

    static isValid(value: SetTrustLineFlagsOp): boolean;

    static toXDR(value: SetTrustLineFlagsOp): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): SetTrustLineFlagsOp;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): SetTrustLineFlagsOp;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LiquidityPoolDepositOp {
    constructor(attributes: {
      liquidityPoolId: PoolId;
      maxAmountA: Int64;
      maxAmountB: Int64;
      minPrice: Price;
      maxPrice: Price;
    });

    liquidityPoolId(value?: PoolId): PoolId;

    maxAmountA(value?: Int64): Int64;

    maxAmountB(value?: Int64): Int64;

    minPrice(value?: Price): Price;

    maxPrice(value?: Price): Price;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LiquidityPoolDepositOp;

    static write(value: LiquidityPoolDepositOp, io: Buffer): void;

    static isValid(value: LiquidityPoolDepositOp): boolean;

    static toXDR(value: LiquidityPoolDepositOp): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): LiquidityPoolDepositOp;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): LiquidityPoolDepositOp;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LiquidityPoolWithdrawOp {
    constructor(attributes: {
      liquidityPoolId: PoolId;
      amount: Int64;
      minAmountA: Int64;
      minAmountB: Int64;
    });

    liquidityPoolId(value?: PoolId): PoolId;

    amount(value?: Int64): Int64;

    minAmountA(value?: Int64): Int64;

    minAmountB(value?: Int64): Int64;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LiquidityPoolWithdrawOp;

    static write(value: LiquidityPoolWithdrawOp, io: Buffer): void;

    static isValid(value: LiquidityPoolWithdrawOp): boolean;

    static toXDR(value: LiquidityPoolWithdrawOp): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): LiquidityPoolWithdrawOp;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): LiquidityPoolWithdrawOp;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ContractIdPreimageFromAddress {
    constructor(attributes: { address: ScAddress; salt: Buffer });

    address(value?: ScAddress): ScAddress;

    salt(value?: Buffer): Buffer;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ContractIdPreimageFromAddress;

    static write(value: ContractIdPreimageFromAddress, io: Buffer): void;

    static isValid(value: ContractIdPreimageFromAddress): boolean;

    static toXDR(value: ContractIdPreimageFromAddress): Buffer;

    static fromXDR(
      input: Buffer,
      format?: 'raw',
    ): ContractIdPreimageFromAddress;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ContractIdPreimageFromAddress;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class CreateContractArgs {
    constructor(attributes: {
      contractIdPreimage: ContractIdPreimage;
      executable: ContractExecutable;
    });

    contractIdPreimage(value?: ContractIdPreimage): ContractIdPreimage;

    executable(value?: ContractExecutable): ContractExecutable;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): CreateContractArgs;

    static write(value: CreateContractArgs, io: Buffer): void;

    static isValid(value: CreateContractArgs): boolean;

    static toXDR(value: CreateContractArgs): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): CreateContractArgs;

    static fromXDR(input: string, format: 'hex' | 'base64'): CreateContractArgs;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class CreateContractArgsV2 {
    constructor(attributes: {
      contractIdPreimage: ContractIdPreimage;
      executable: ContractExecutable;
      constructorArgs: ScVal[];
    });

    contractIdPreimage(value?: ContractIdPreimage): ContractIdPreimage;

    executable(value?: ContractExecutable): ContractExecutable;

    constructorArgs(value?: ScVal[]): ScVal[];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): CreateContractArgsV2;

    static write(value: CreateContractArgsV2, io: Buffer): void;

    static isValid(value: CreateContractArgsV2): boolean;

    static toXDR(value: CreateContractArgsV2): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): CreateContractArgsV2;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): CreateContractArgsV2;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class InvokeContractArgs {
    constructor(attributes: {
      contractAddress: ScAddress;
      functionName: string | Buffer;
      args: ScVal[];
    });

    contractAddress(value?: ScAddress): ScAddress;

    functionName(value?: string | Buffer): string | Buffer;

    args(value?: ScVal[]): ScVal[];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): InvokeContractArgs;

    static write(value: InvokeContractArgs, io: Buffer): void;

    static isValid(value: InvokeContractArgs): boolean;

    static toXDR(value: InvokeContractArgs): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): InvokeContractArgs;

    static fromXDR(input: string, format: 'hex' | 'base64'): InvokeContractArgs;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class SorobanAuthorizedInvocation {
    constructor(attributes: {
      function: SorobanAuthorizedFunction;
      subInvocations: SorobanAuthorizedInvocation[];
    });

    function(value?: SorobanAuthorizedFunction): SorobanAuthorizedFunction;

    subInvocations(
      value?: SorobanAuthorizedInvocation[],
    ): SorobanAuthorizedInvocation[];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): SorobanAuthorizedInvocation;

    static write(value: SorobanAuthorizedInvocation, io: Buffer): void;

    static isValid(value: SorobanAuthorizedInvocation): boolean;

    static toXDR(value: SorobanAuthorizedInvocation): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): SorobanAuthorizedInvocation;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): SorobanAuthorizedInvocation;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class SorobanAddressCredentials {
    constructor(attributes: {
      address: ScAddress;
      nonce: Int64;
      signatureExpirationLedger: number;
      signature: ScVal;
    });

    address(value?: ScAddress): ScAddress;

    nonce(value?: Int64): Int64;

    signatureExpirationLedger(value?: number): number;

    signature(value?: ScVal): ScVal;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): SorobanAddressCredentials;

    static write(value: SorobanAddressCredentials, io: Buffer): void;

    static isValid(value: SorobanAddressCredentials): boolean;

    static toXDR(value: SorobanAddressCredentials): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): SorobanAddressCredentials;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): SorobanAddressCredentials;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class SorobanAuthorizationEntry {
    constructor(attributes: {
      credentials: SorobanCredentials;
      rootInvocation: SorobanAuthorizedInvocation;
    });

    credentials(value?: SorobanCredentials): SorobanCredentials;

    rootInvocation(
      value?: SorobanAuthorizedInvocation,
    ): SorobanAuthorizedInvocation;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): SorobanAuthorizationEntry;

    static write(value: SorobanAuthorizationEntry, io: Buffer): void;

    static isValid(value: SorobanAuthorizationEntry): boolean;

    static toXDR(value: SorobanAuthorizationEntry): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): SorobanAuthorizationEntry;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): SorobanAuthorizationEntry;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class InvokeHostFunctionOp {
    constructor(attributes: {
      hostFunction: HostFunction;
      auth: SorobanAuthorizationEntry[];
    });

    hostFunction(value?: HostFunction): HostFunction;

    auth(value?: SorobanAuthorizationEntry[]): SorobanAuthorizationEntry[];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): InvokeHostFunctionOp;

    static write(value: InvokeHostFunctionOp, io: Buffer): void;

    static isValid(value: InvokeHostFunctionOp): boolean;

    static toXDR(value: InvokeHostFunctionOp): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): InvokeHostFunctionOp;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): InvokeHostFunctionOp;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ExtendFootprintTtlOp {
    constructor(attributes: { ext: ExtensionPoint; extendTo: number });

    ext(value?: ExtensionPoint): ExtensionPoint;

    extendTo(value?: number): number;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ExtendFootprintTtlOp;

    static write(value: ExtendFootprintTtlOp, io: Buffer): void;

    static isValid(value: ExtendFootprintTtlOp): boolean;

    static toXDR(value: ExtendFootprintTtlOp): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ExtendFootprintTtlOp;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ExtendFootprintTtlOp;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class RestoreFootprintOp {
    constructor(attributes: { ext: ExtensionPoint });

    ext(value?: ExtensionPoint): ExtensionPoint;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): RestoreFootprintOp;

    static write(value: RestoreFootprintOp, io: Buffer): void;

    static isValid(value: RestoreFootprintOp): boolean;

    static toXDR(value: RestoreFootprintOp): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): RestoreFootprintOp;

    static fromXDR(input: string, format: 'hex' | 'base64'): RestoreFootprintOp;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class Operation {
    constructor(attributes: {
      sourceAccount: null | MuxedAccount;
      body: OperationBody;
    });

    sourceAccount(value?: null | MuxedAccount): null | MuxedAccount;

    body(value?: OperationBody): OperationBody;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): Operation;

    static write(value: Operation, io: Buffer): void;

    static isValid(value: Operation): boolean;

    static toXDR(value: Operation): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): Operation;

    static fromXDR(input: string, format: 'hex' | 'base64'): Operation;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class HashIdPreimageOperationId {
    constructor(attributes: {
      sourceAccount: AccountId;
      seqNum: SequenceNumber;
      opNum: number;
    });

    sourceAccount(value?: AccountId): AccountId;

    seqNum(value?: SequenceNumber): SequenceNumber;

    opNum(value?: number): number;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): HashIdPreimageOperationId;

    static write(value: HashIdPreimageOperationId, io: Buffer): void;

    static isValid(value: HashIdPreimageOperationId): boolean;

    static toXDR(value: HashIdPreimageOperationId): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): HashIdPreimageOperationId;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): HashIdPreimageOperationId;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class HashIdPreimageRevokeId {
    constructor(attributes: {
      sourceAccount: AccountId;
      seqNum: SequenceNumber;
      opNum: number;
      liquidityPoolId: PoolId;
      asset: Asset;
    });

    sourceAccount(value?: AccountId): AccountId;

    seqNum(value?: SequenceNumber): SequenceNumber;

    opNum(value?: number): number;

    liquidityPoolId(value?: PoolId): PoolId;

    asset(value?: Asset): Asset;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): HashIdPreimageRevokeId;

    static write(value: HashIdPreimageRevokeId, io: Buffer): void;

    static isValid(value: HashIdPreimageRevokeId): boolean;

    static toXDR(value: HashIdPreimageRevokeId): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): HashIdPreimageRevokeId;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): HashIdPreimageRevokeId;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class HashIdPreimageContractId {
    constructor(attributes: {
      networkId: Buffer;
      contractIdPreimage: ContractIdPreimage;
    });

    networkId(value?: Buffer): Buffer;

    contractIdPreimage(value?: ContractIdPreimage): ContractIdPreimage;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): HashIdPreimageContractId;

    static write(value: HashIdPreimageContractId, io: Buffer): void;

    static isValid(value: HashIdPreimageContractId): boolean;

    static toXDR(value: HashIdPreimageContractId): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): HashIdPreimageContractId;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): HashIdPreimageContractId;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class HashIdPreimageSorobanAuthorization {
    constructor(attributes: {
      networkId: Buffer;
      nonce: Int64;
      signatureExpirationLedger: number;
      invocation: SorobanAuthorizedInvocation;
    });

    networkId(value?: Buffer): Buffer;

    nonce(value?: Int64): Int64;

    signatureExpirationLedger(value?: number): number;

    invocation(
      value?: SorobanAuthorizedInvocation,
    ): SorobanAuthorizedInvocation;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): HashIdPreimageSorobanAuthorization;

    static write(value: HashIdPreimageSorobanAuthorization, io: Buffer): void;

    static isValid(value: HashIdPreimageSorobanAuthorization): boolean;

    static toXDR(value: HashIdPreimageSorobanAuthorization): Buffer;

    static fromXDR(
      input: Buffer,
      format?: 'raw',
    ): HashIdPreimageSorobanAuthorization;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): HashIdPreimageSorobanAuthorization;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TimeBounds {
    constructor(attributes: { minTime: TimePoint; maxTime: TimePoint });

    minTime(value?: TimePoint): TimePoint;

    maxTime(value?: TimePoint): TimePoint;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TimeBounds;

    static write(value: TimeBounds, io: Buffer): void;

    static isValid(value: TimeBounds): boolean;

    static toXDR(value: TimeBounds): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): TimeBounds;

    static fromXDR(input: string, format: 'hex' | 'base64'): TimeBounds;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LedgerBounds {
    constructor(attributes: { minLedger: number; maxLedger: number });

    minLedger(value?: number): number;

    maxLedger(value?: number): number;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LedgerBounds;

    static write(value: LedgerBounds, io: Buffer): void;

    static isValid(value: LedgerBounds): boolean;

    static toXDR(value: LedgerBounds): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): LedgerBounds;

    static fromXDR(input: string, format: 'hex' | 'base64'): LedgerBounds;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class PreconditionsV2 {
    constructor(attributes: {
      timeBounds: null | TimeBounds;
      ledgerBounds: null | LedgerBounds;
      minSeqNum: null | SequenceNumber;
      minSeqAge: Duration;
      minSeqLedgerGap: number;
      extraSigners: SignerKey[];
    });

    timeBounds(value?: null | TimeBounds): null | TimeBounds;

    ledgerBounds(value?: null | LedgerBounds): null | LedgerBounds;

    minSeqNum(value?: null | SequenceNumber): null | SequenceNumber;

    minSeqAge(value?: Duration): Duration;

    minSeqLedgerGap(value?: number): number;

    extraSigners(value?: SignerKey[]): SignerKey[];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): PreconditionsV2;

    static write(value: PreconditionsV2, io: Buffer): void;

    static isValid(value: PreconditionsV2): boolean;

    static toXDR(value: PreconditionsV2): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): PreconditionsV2;

    static fromXDR(input: string, format: 'hex' | 'base64'): PreconditionsV2;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LedgerFootprint {
    constructor(attributes: { readOnly: LedgerKey[]; readWrite: LedgerKey[] });

    readOnly(value?: LedgerKey[]): LedgerKey[];

    readWrite(value?: LedgerKey[]): LedgerKey[];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LedgerFootprint;

    static write(value: LedgerFootprint, io: Buffer): void;

    static isValid(value: LedgerFootprint): boolean;

    static toXDR(value: LedgerFootprint): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): LedgerFootprint;

    static fromXDR(input: string, format: 'hex' | 'base64'): LedgerFootprint;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ArchivalProofNode {
    constructor(attributes: { index: number; hash: Buffer });

    index(value?: number): number;

    hash(value?: Buffer): Buffer;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ArchivalProofNode;

    static write(value: ArchivalProofNode, io: Buffer): void;

    static isValid(value: ArchivalProofNode): boolean;

    static toXDR(value: ArchivalProofNode): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ArchivalProofNode;

    static fromXDR(input: string, format: 'hex' | 'base64'): ArchivalProofNode;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class NonexistenceProofBody {
    constructor(attributes: {
      entriesToProve: ColdArchiveBucketEntry[];
      proofLevels: ArchivalProofNode[][];
    });

    entriesToProve(value?: ColdArchiveBucketEntry[]): ColdArchiveBucketEntry[];

    proofLevels(value?: ArchivalProofNode[][]): ArchivalProofNode[][];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): NonexistenceProofBody;

    static write(value: NonexistenceProofBody, io: Buffer): void;

    static isValid(value: NonexistenceProofBody): boolean;

    static toXDR(value: NonexistenceProofBody): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): NonexistenceProofBody;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): NonexistenceProofBody;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ExistenceProofBody {
    constructor(attributes: {
      keysToProve: LedgerKey[];
      lowBoundEntries: ColdArchiveBucketEntry[];
      highBoundEntries: ColdArchiveBucketEntry[];
      proofLevels: ArchivalProofNode[][];
    });

    keysToProve(value?: LedgerKey[]): LedgerKey[];

    lowBoundEntries(value?: ColdArchiveBucketEntry[]): ColdArchiveBucketEntry[];

    highBoundEntries(
      value?: ColdArchiveBucketEntry[],
    ): ColdArchiveBucketEntry[];

    proofLevels(value?: ArchivalProofNode[][]): ArchivalProofNode[][];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ExistenceProofBody;

    static write(value: ExistenceProofBody, io: Buffer): void;

    static isValid(value: ExistenceProofBody): boolean;

    static toXDR(value: ExistenceProofBody): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ExistenceProofBody;

    static fromXDR(input: string, format: 'hex' | 'base64'): ExistenceProofBody;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ArchivalProof {
    constructor(attributes: { epoch: number; body: ArchivalProofBody });

    epoch(value?: number): number;

    body(value?: ArchivalProofBody): ArchivalProofBody;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ArchivalProof;

    static write(value: ArchivalProof, io: Buffer): void;

    static isValid(value: ArchivalProof): boolean;

    static toXDR(value: ArchivalProof): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ArchivalProof;

    static fromXDR(input: string, format: 'hex' | 'base64'): ArchivalProof;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class SorobanResources {
    constructor(attributes: {
      footprint: LedgerFootprint;
      instructions: number;
      readBytes: number;
      writeBytes: number;
    });

    footprint(value?: LedgerFootprint): LedgerFootprint;

    instructions(value?: number): number;

    readBytes(value?: number): number;

    writeBytes(value?: number): number;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): SorobanResources;

    static write(value: SorobanResources, io: Buffer): void;

    static isValid(value: SorobanResources): boolean;

    static toXDR(value: SorobanResources): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): SorobanResources;

    static fromXDR(input: string, format: 'hex' | 'base64'): SorobanResources;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class SorobanTransactionData {
    constructor(attributes: {
      ext: SorobanTransactionDataExt;
      resources: SorobanResources;
      resourceFee: Int64;
    });

    ext(value?: SorobanTransactionDataExt): SorobanTransactionDataExt;

    resources(value?: SorobanResources): SorobanResources;

    resourceFee(value?: Int64): Int64;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): SorobanTransactionData;

    static write(value: SorobanTransactionData, io: Buffer): void;

    static isValid(value: SorobanTransactionData): boolean;

    static toXDR(value: SorobanTransactionData): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): SorobanTransactionData;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): SorobanTransactionData;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TransactionV0 {
    constructor(attributes: {
      sourceAccountEd25519: Buffer;
      fee: number;
      seqNum: SequenceNumber;
      timeBounds: null | TimeBounds;
      memo: Memo;
      operations: Operation[];
      ext: TransactionV0Ext;
    });

    sourceAccountEd25519(value?: Buffer): Buffer;

    fee(value?: number): number;

    seqNum(value?: SequenceNumber): SequenceNumber;

    timeBounds(value?: null | TimeBounds): null | TimeBounds;

    memo(value?: Memo): Memo;

    operations(value?: Operation[]): Operation[];

    ext(value?: TransactionV0Ext): TransactionV0Ext;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TransactionV0;

    static write(value: TransactionV0, io: Buffer): void;

    static isValid(value: TransactionV0): boolean;

    static toXDR(value: TransactionV0): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): TransactionV0;

    static fromXDR(input: string, format: 'hex' | 'base64'): TransactionV0;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TransactionV0Envelope {
    constructor(attributes: {
      tx: TransactionV0;
      signatures: DecoratedSignature[];
    });

    tx(value?: TransactionV0): TransactionV0;

    signatures(value?: DecoratedSignature[]): DecoratedSignature[];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TransactionV0Envelope;

    static write(value: TransactionV0Envelope, io: Buffer): void;

    static isValid(value: TransactionV0Envelope): boolean;

    static toXDR(value: TransactionV0Envelope): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): TransactionV0Envelope;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): TransactionV0Envelope;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class Transaction {
    constructor(attributes: {
      sourceAccount: MuxedAccount;
      fee: number;
      seqNum: SequenceNumber;
      cond: Preconditions;
      memo: Memo;
      operations: Operation[];
      ext: TransactionExt;
    });

    sourceAccount(value?: MuxedAccount): MuxedAccount;

    fee(value?: number): number;

    seqNum(value?: SequenceNumber): SequenceNumber;

    cond(value?: Preconditions): Preconditions;

    memo(value?: Memo): Memo;

    operations(value?: Operation[]): Operation[];

    ext(value?: TransactionExt): TransactionExt;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): Transaction;

    static write(value: Transaction, io: Buffer): void;

    static isValid(value: Transaction): boolean;

    static toXDR(value: Transaction): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): Transaction;

    static fromXDR(input: string, format: 'hex' | 'base64'): Transaction;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TransactionV1Envelope {
    constructor(attributes: {
      tx: Transaction;
      signatures: DecoratedSignature[];
    });

    tx(value?: Transaction): Transaction;

    signatures(value?: DecoratedSignature[]): DecoratedSignature[];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TransactionV1Envelope;

    static write(value: TransactionV1Envelope, io: Buffer): void;

    static isValid(value: TransactionV1Envelope): boolean;

    static toXDR(value: TransactionV1Envelope): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): TransactionV1Envelope;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): TransactionV1Envelope;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class FeeBumpTransaction {
    constructor(attributes: {
      feeSource: MuxedAccount;
      fee: Int64;
      innerTx: FeeBumpTransactionInnerTx;
      ext: FeeBumpTransactionExt;
    });

    feeSource(value?: MuxedAccount): MuxedAccount;

    fee(value?: Int64): Int64;

    innerTx(value?: FeeBumpTransactionInnerTx): FeeBumpTransactionInnerTx;

    ext(value?: FeeBumpTransactionExt): FeeBumpTransactionExt;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): FeeBumpTransaction;

    static write(value: FeeBumpTransaction, io: Buffer): void;

    static isValid(value: FeeBumpTransaction): boolean;

    static toXDR(value: FeeBumpTransaction): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): FeeBumpTransaction;

    static fromXDR(input: string, format: 'hex' | 'base64'): FeeBumpTransaction;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class FeeBumpTransactionEnvelope {
    constructor(attributes: {
      tx: FeeBumpTransaction;
      signatures: DecoratedSignature[];
    });

    tx(value?: FeeBumpTransaction): FeeBumpTransaction;

    signatures(value?: DecoratedSignature[]): DecoratedSignature[];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): FeeBumpTransactionEnvelope;

    static write(value: FeeBumpTransactionEnvelope, io: Buffer): void;

    static isValid(value: FeeBumpTransactionEnvelope): boolean;

    static toXDR(value: FeeBumpTransactionEnvelope): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): FeeBumpTransactionEnvelope;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): FeeBumpTransactionEnvelope;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TransactionSignaturePayload {
    constructor(attributes: {
      networkId: Buffer;
      taggedTransaction: TransactionSignaturePayloadTaggedTransaction;
    });

    networkId(value?: Buffer): Buffer;

    taggedTransaction(
      value?: TransactionSignaturePayloadTaggedTransaction,
    ): TransactionSignaturePayloadTaggedTransaction;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TransactionSignaturePayload;

    static write(value: TransactionSignaturePayload, io: Buffer): void;

    static isValid(value: TransactionSignaturePayload): boolean;

    static toXDR(value: TransactionSignaturePayload): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): TransactionSignaturePayload;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): TransactionSignaturePayload;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ClaimOfferAtomV0 {
    constructor(attributes: {
      sellerEd25519: Buffer;
      offerId: Int64;
      assetSold: Asset;
      amountSold: Int64;
      assetBought: Asset;
      amountBought: Int64;
    });

    sellerEd25519(value?: Buffer): Buffer;

    offerId(value?: Int64): Int64;

    assetSold(value?: Asset): Asset;

    amountSold(value?: Int64): Int64;

    assetBought(value?: Asset): Asset;

    amountBought(value?: Int64): Int64;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ClaimOfferAtomV0;

    static write(value: ClaimOfferAtomV0, io: Buffer): void;

    static isValid(value: ClaimOfferAtomV0): boolean;

    static toXDR(value: ClaimOfferAtomV0): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ClaimOfferAtomV0;

    static fromXDR(input: string, format: 'hex' | 'base64'): ClaimOfferAtomV0;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ClaimOfferAtom {
    constructor(attributes: {
      sellerId: AccountId;
      offerId: Int64;
      assetSold: Asset;
      amountSold: Int64;
      assetBought: Asset;
      amountBought: Int64;
    });

    sellerId(value?: AccountId): AccountId;

    offerId(value?: Int64): Int64;

    assetSold(value?: Asset): Asset;

    amountSold(value?: Int64): Int64;

    assetBought(value?: Asset): Asset;

    amountBought(value?: Int64): Int64;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ClaimOfferAtom;

    static write(value: ClaimOfferAtom, io: Buffer): void;

    static isValid(value: ClaimOfferAtom): boolean;

    static toXDR(value: ClaimOfferAtom): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ClaimOfferAtom;

    static fromXDR(input: string, format: 'hex' | 'base64'): ClaimOfferAtom;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ClaimLiquidityAtom {
    constructor(attributes: {
      liquidityPoolId: PoolId;
      assetSold: Asset;
      amountSold: Int64;
      assetBought: Asset;
      amountBought: Int64;
    });

    liquidityPoolId(value?: PoolId): PoolId;

    assetSold(value?: Asset): Asset;

    amountSold(value?: Int64): Int64;

    assetBought(value?: Asset): Asset;

    amountBought(value?: Int64): Int64;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ClaimLiquidityAtom;

    static write(value: ClaimLiquidityAtom, io: Buffer): void;

    static isValid(value: ClaimLiquidityAtom): boolean;

    static toXDR(value: ClaimLiquidityAtom): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ClaimLiquidityAtom;

    static fromXDR(input: string, format: 'hex' | 'base64'): ClaimLiquidityAtom;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class SimplePaymentResult {
    constructor(attributes: {
      destination: AccountId;
      asset: Asset;
      amount: Int64;
    });

    destination(value?: AccountId): AccountId;

    asset(value?: Asset): Asset;

    amount(value?: Int64): Int64;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): SimplePaymentResult;

    static write(value: SimplePaymentResult, io: Buffer): void;

    static isValid(value: SimplePaymentResult): boolean;

    static toXDR(value: SimplePaymentResult): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): SimplePaymentResult;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): SimplePaymentResult;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class PathPaymentStrictReceiveResultSuccess {
    constructor(attributes: { offers: ClaimAtom[]; last: SimplePaymentResult });

    offers(value?: ClaimAtom[]): ClaimAtom[];

    last(value?: SimplePaymentResult): SimplePaymentResult;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): PathPaymentStrictReceiveResultSuccess;

    static write(
      value: PathPaymentStrictReceiveResultSuccess,
      io: Buffer,
    ): void;

    static isValid(value: PathPaymentStrictReceiveResultSuccess): boolean;

    static toXDR(value: PathPaymentStrictReceiveResultSuccess): Buffer;

    static fromXDR(
      input: Buffer,
      format?: 'raw',
    ): PathPaymentStrictReceiveResultSuccess;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): PathPaymentStrictReceiveResultSuccess;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class PathPaymentStrictSendResultSuccess {
    constructor(attributes: { offers: ClaimAtom[]; last: SimplePaymentResult });

    offers(value?: ClaimAtom[]): ClaimAtom[];

    last(value?: SimplePaymentResult): SimplePaymentResult;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): PathPaymentStrictSendResultSuccess;

    static write(value: PathPaymentStrictSendResultSuccess, io: Buffer): void;

    static isValid(value: PathPaymentStrictSendResultSuccess): boolean;

    static toXDR(value: PathPaymentStrictSendResultSuccess): Buffer;

    static fromXDR(
      input: Buffer,
      format?: 'raw',
    ): PathPaymentStrictSendResultSuccess;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): PathPaymentStrictSendResultSuccess;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ManageOfferSuccessResult {
    constructor(attributes: {
      offersClaimed: ClaimAtom[];
      offer: ManageOfferSuccessResultOffer;
    });

    offersClaimed(value?: ClaimAtom[]): ClaimAtom[];

    offer(value?: ManageOfferSuccessResultOffer): ManageOfferSuccessResultOffer;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ManageOfferSuccessResult;

    static write(value: ManageOfferSuccessResult, io: Buffer): void;

    static isValid(value: ManageOfferSuccessResult): boolean;

    static toXDR(value: ManageOfferSuccessResult): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ManageOfferSuccessResult;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ManageOfferSuccessResult;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class InflationPayout {
    constructor(attributes: { destination: AccountId; amount: Int64 });

    destination(value?: AccountId): AccountId;

    amount(value?: Int64): Int64;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): InflationPayout;

    static write(value: InflationPayout, io: Buffer): void;

    static isValid(value: InflationPayout): boolean;

    static toXDR(value: InflationPayout): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): InflationPayout;

    static fromXDR(input: string, format: 'hex' | 'base64'): InflationPayout;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class InnerTransactionResult {
    constructor(attributes: {
      feeCharged: Int64;
      result: InnerTransactionResultResult;
      ext: InnerTransactionResultExt;
    });

    feeCharged(value?: Int64): Int64;

    result(value?: InnerTransactionResultResult): InnerTransactionResultResult;

    ext(value?: InnerTransactionResultExt): InnerTransactionResultExt;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): InnerTransactionResult;

    static write(value: InnerTransactionResult, io: Buffer): void;

    static isValid(value: InnerTransactionResult): boolean;

    static toXDR(value: InnerTransactionResult): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): InnerTransactionResult;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): InnerTransactionResult;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class InnerTransactionResultPair {
    constructor(attributes: {
      transactionHash: Buffer;
      result: InnerTransactionResult;
    });

    transactionHash(value?: Buffer): Buffer;

    result(value?: InnerTransactionResult): InnerTransactionResult;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): InnerTransactionResultPair;

    static write(value: InnerTransactionResultPair, io: Buffer): void;

    static isValid(value: InnerTransactionResultPair): boolean;

    static toXDR(value: InnerTransactionResultPair): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): InnerTransactionResultPair;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): InnerTransactionResultPair;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TransactionResult {
    constructor(attributes: {
      feeCharged: Int64;
      result: TransactionResultResult;
      ext: TransactionResultExt;
    });

    feeCharged(value?: Int64): Int64;

    result(value?: TransactionResultResult): TransactionResultResult;

    ext(value?: TransactionResultExt): TransactionResultExt;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TransactionResult;

    static write(value: TransactionResult, io: Buffer): void;

    static isValid(value: TransactionResult): boolean;

    static toXDR(value: TransactionResult): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): TransactionResult;

    static fromXDR(input: string, format: 'hex' | 'base64'): TransactionResult;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class SignerKeyEd25519SignedPayload {
    constructor(attributes: { ed25519: Buffer; payload: Buffer });

    ed25519(value?: Buffer): Buffer;

    payload(value?: Buffer): Buffer;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): SignerKeyEd25519SignedPayload;

    static write(value: SignerKeyEd25519SignedPayload, io: Buffer): void;

    static isValid(value: SignerKeyEd25519SignedPayload): boolean;

    static toXDR(value: SignerKeyEd25519SignedPayload): Buffer;

    static fromXDR(
      input: Buffer,
      format?: 'raw',
    ): SignerKeyEd25519SignedPayload;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): SignerKeyEd25519SignedPayload;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class Curve25519Secret {
    constructor(attributes: { key: Buffer });

    key(value?: Buffer): Buffer;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): Curve25519Secret;

    static write(value: Curve25519Secret, io: Buffer): void;

    static isValid(value: Curve25519Secret): boolean;

    static toXDR(value: Curve25519Secret): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): Curve25519Secret;

    static fromXDR(input: string, format: 'hex' | 'base64'): Curve25519Secret;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class Curve25519Public {
    constructor(attributes: { key: Buffer });

    key(value?: Buffer): Buffer;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): Curve25519Public;

    static write(value: Curve25519Public, io: Buffer): void;

    static isValid(value: Curve25519Public): boolean;

    static toXDR(value: Curve25519Public): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): Curve25519Public;

    static fromXDR(input: string, format: 'hex' | 'base64'): Curve25519Public;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class HmacSha256Key {
    constructor(attributes: { key: Buffer });

    key(value?: Buffer): Buffer;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): HmacSha256Key;

    static write(value: HmacSha256Key, io: Buffer): void;

    static isValid(value: HmacSha256Key): boolean;

    static toXDR(value: HmacSha256Key): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): HmacSha256Key;

    static fromXDR(input: string, format: 'hex' | 'base64'): HmacSha256Key;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class HmacSha256Mac {
    constructor(attributes: { mac: Buffer });

    mac(value?: Buffer): Buffer;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): HmacSha256Mac;

    static write(value: HmacSha256Mac, io: Buffer): void;

    static isValid(value: HmacSha256Mac): boolean;

    static toXDR(value: HmacSha256Mac): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): HmacSha256Mac;

    static fromXDR(input: string, format: 'hex' | 'base64'): HmacSha256Mac;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ShortHashSeed {
    constructor(attributes: { seed: Buffer });

    seed(value?: Buffer): Buffer;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ShortHashSeed;

    static write(value: ShortHashSeed, io: Buffer): void;

    static isValid(value: ShortHashSeed): boolean;

    static toXDR(value: ShortHashSeed): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ShortHashSeed;

    static fromXDR(input: string, format: 'hex' | 'base64'): ShortHashSeed;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class SerializedBinaryFuseFilter {
    constructor(attributes: {
      type: BinaryFuseFilterType;
      inputHashSeed: ShortHashSeed;
      filterSeed: ShortHashSeed;
      segmentLength: number;
      segementLengthMask: number;
      segmentCount: number;
      segmentCountLength: number;
      fingerprintLength: number;
      fingerprints: Buffer;
    });

    type(value?: BinaryFuseFilterType): BinaryFuseFilterType;

    inputHashSeed(value?: ShortHashSeed): ShortHashSeed;

    filterSeed(value?: ShortHashSeed): ShortHashSeed;

    segmentLength(value?: number): number;

    segementLengthMask(value?: number): number;

    segmentCount(value?: number): number;

    segmentCountLength(value?: number): number;

    fingerprintLength(value?: number): number;

    fingerprints(value?: Buffer): Buffer;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): SerializedBinaryFuseFilter;

    static write(value: SerializedBinaryFuseFilter, io: Buffer): void;

    static isValid(value: SerializedBinaryFuseFilter): boolean;

    static toXDR(value: SerializedBinaryFuseFilter): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): SerializedBinaryFuseFilter;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): SerializedBinaryFuseFilter;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class UInt128Parts {
    constructor(attributes: { hi: Uint64; lo: Uint64 });

    hi(value?: Uint64): Uint64;

    lo(value?: Uint64): Uint64;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): UInt128Parts;

    static write(value: UInt128Parts, io: Buffer): void;

    static isValid(value: UInt128Parts): boolean;

    static toXDR(value: UInt128Parts): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): UInt128Parts;

    static fromXDR(input: string, format: 'hex' | 'base64'): UInt128Parts;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class Int128Parts {
    constructor(attributes: { hi: Int64; lo: Uint64 });

    hi(value?: Int64): Int64;

    lo(value?: Uint64): Uint64;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): Int128Parts;

    static write(value: Int128Parts, io: Buffer): void;

    static isValid(value: Int128Parts): boolean;

    static toXDR(value: Int128Parts): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): Int128Parts;

    static fromXDR(input: string, format: 'hex' | 'base64'): Int128Parts;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class UInt256Parts {
    constructor(attributes: {
      hiHi: Uint64;
      hiLo: Uint64;
      loHi: Uint64;
      loLo: Uint64;
    });

    hiHi(value?: Uint64): Uint64;

    hiLo(value?: Uint64): Uint64;

    loHi(value?: Uint64): Uint64;

    loLo(value?: Uint64): Uint64;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): UInt256Parts;

    static write(value: UInt256Parts, io: Buffer): void;

    static isValid(value: UInt256Parts): boolean;

    static toXDR(value: UInt256Parts): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): UInt256Parts;

    static fromXDR(input: string, format: 'hex' | 'base64'): UInt256Parts;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class Int256Parts {
    constructor(attributes: {
      hiHi: Int64;
      hiLo: Uint64;
      loHi: Uint64;
      loLo: Uint64;
    });

    hiHi(value?: Int64): Int64;

    hiLo(value?: Uint64): Uint64;

    loHi(value?: Uint64): Uint64;

    loLo(value?: Uint64): Uint64;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): Int256Parts;

    static write(value: Int256Parts, io: Buffer): void;

    static isValid(value: Int256Parts): boolean;

    static toXDR(value: Int256Parts): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): Int256Parts;

    static fromXDR(input: string, format: 'hex' | 'base64'): Int256Parts;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScNonceKey {
    constructor(attributes: { nonce: Int64 });

    nonce(value?: Int64): Int64;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScNonceKey;

    static write(value: ScNonceKey, io: Buffer): void;

    static isValid(value: ScNonceKey): boolean;

    static toXDR(value: ScNonceKey): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScNonceKey;

    static fromXDR(input: string, format: 'hex' | 'base64'): ScNonceKey;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScContractInstance {
    constructor(attributes: {
      executable: ContractExecutable;
      storage: null | ScMapEntry[];
    });

    executable(value?: ContractExecutable): ContractExecutable;

    storage(value?: null | ScMapEntry[]): null | ScMapEntry[];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScContractInstance;

    static write(value: ScContractInstance, io: Buffer): void;

    static isValid(value: ScContractInstance): boolean;

    static toXDR(value: ScContractInstance): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScContractInstance;

    static fromXDR(input: string, format: 'hex' | 'base64'): ScContractInstance;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScMapEntry {
    constructor(attributes: { key: ScVal; val: ScVal });

    key(value?: ScVal): ScVal;

    val(value?: ScVal): ScVal;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScMapEntry;

    static write(value: ScMapEntry, io: Buffer): void;

    static isValid(value: ScMapEntry): boolean;

    static toXDR(value: ScMapEntry): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScMapEntry;

    static fromXDR(input: string, format: 'hex' | 'base64'): ScMapEntry;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScEnvMetaEntryInterfaceVersion {
    constructor(attributes: { protocol: number; preRelease: number });

    protocol(value?: number): number;

    preRelease(value?: number): number;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScEnvMetaEntryInterfaceVersion;

    static write(value: ScEnvMetaEntryInterfaceVersion, io: Buffer): void;

    static isValid(value: ScEnvMetaEntryInterfaceVersion): boolean;

    static toXDR(value: ScEnvMetaEntryInterfaceVersion): Buffer;

    static fromXDR(
      input: Buffer,
      format?: 'raw',
    ): ScEnvMetaEntryInterfaceVersion;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ScEnvMetaEntryInterfaceVersion;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScMetaV0 {
    constructor(attributes: { key: string | Buffer; val: string | Buffer });

    key(value?: string | Buffer): string | Buffer;

    val(value?: string | Buffer): string | Buffer;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScMetaV0;

    static write(value: ScMetaV0, io: Buffer): void;

    static isValid(value: ScMetaV0): boolean;

    static toXDR(value: ScMetaV0): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScMetaV0;

    static fromXDR(input: string, format: 'hex' | 'base64'): ScMetaV0;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScSpecTypeOption {
    constructor(attributes: { valueType: ScSpecTypeDef });

    valueType(value?: ScSpecTypeDef): ScSpecTypeDef;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScSpecTypeOption;

    static write(value: ScSpecTypeOption, io: Buffer): void;

    static isValid(value: ScSpecTypeOption): boolean;

    static toXDR(value: ScSpecTypeOption): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScSpecTypeOption;

    static fromXDR(input: string, format: 'hex' | 'base64'): ScSpecTypeOption;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScSpecTypeResult {
    constructor(attributes: {
      okType: ScSpecTypeDef;
      errorType: ScSpecTypeDef;
    });

    okType(value?: ScSpecTypeDef): ScSpecTypeDef;

    errorType(value?: ScSpecTypeDef): ScSpecTypeDef;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScSpecTypeResult;

    static write(value: ScSpecTypeResult, io: Buffer): void;

    static isValid(value: ScSpecTypeResult): boolean;

    static toXDR(value: ScSpecTypeResult): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScSpecTypeResult;

    static fromXDR(input: string, format: 'hex' | 'base64'): ScSpecTypeResult;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScSpecTypeVec {
    constructor(attributes: { elementType: ScSpecTypeDef });

    elementType(value?: ScSpecTypeDef): ScSpecTypeDef;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScSpecTypeVec;

    static write(value: ScSpecTypeVec, io: Buffer): void;

    static isValid(value: ScSpecTypeVec): boolean;

    static toXDR(value: ScSpecTypeVec): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScSpecTypeVec;

    static fromXDR(input: string, format: 'hex' | 'base64'): ScSpecTypeVec;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScSpecTypeMap {
    constructor(attributes: {
      keyType: ScSpecTypeDef;
      valueType: ScSpecTypeDef;
    });

    keyType(value?: ScSpecTypeDef): ScSpecTypeDef;

    valueType(value?: ScSpecTypeDef): ScSpecTypeDef;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScSpecTypeMap;

    static write(value: ScSpecTypeMap, io: Buffer): void;

    static isValid(value: ScSpecTypeMap): boolean;

    static toXDR(value: ScSpecTypeMap): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScSpecTypeMap;

    static fromXDR(input: string, format: 'hex' | 'base64'): ScSpecTypeMap;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScSpecTypeTuple {
    constructor(attributes: { valueTypes: ScSpecTypeDef[] });

    valueTypes(value?: ScSpecTypeDef[]): ScSpecTypeDef[];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScSpecTypeTuple;

    static write(value: ScSpecTypeTuple, io: Buffer): void;

    static isValid(value: ScSpecTypeTuple): boolean;

    static toXDR(value: ScSpecTypeTuple): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScSpecTypeTuple;

    static fromXDR(input: string, format: 'hex' | 'base64'): ScSpecTypeTuple;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScSpecTypeBytesN {
    constructor(attributes: { n: number });

    n(value?: number): number;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScSpecTypeBytesN;

    static write(value: ScSpecTypeBytesN, io: Buffer): void;

    static isValid(value: ScSpecTypeBytesN): boolean;

    static toXDR(value: ScSpecTypeBytesN): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScSpecTypeBytesN;

    static fromXDR(input: string, format: 'hex' | 'base64'): ScSpecTypeBytesN;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScSpecTypeUdt {
    constructor(attributes: { name: string | Buffer });

    name(value?: string | Buffer): string | Buffer;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScSpecTypeUdt;

    static write(value: ScSpecTypeUdt, io: Buffer): void;

    static isValid(value: ScSpecTypeUdt): boolean;

    static toXDR(value: ScSpecTypeUdt): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScSpecTypeUdt;

    static fromXDR(input: string, format: 'hex' | 'base64'): ScSpecTypeUdt;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScSpecUdtStructFieldV0 {
    constructor(attributes: {
      doc: string | Buffer;
      name: string | Buffer;
      type: ScSpecTypeDef;
    });

    doc(value?: string | Buffer): string | Buffer;

    name(value?: string | Buffer): string | Buffer;

    type(value?: ScSpecTypeDef): ScSpecTypeDef;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScSpecUdtStructFieldV0;

    static write(value: ScSpecUdtStructFieldV0, io: Buffer): void;

    static isValid(value: ScSpecUdtStructFieldV0): boolean;

    static toXDR(value: ScSpecUdtStructFieldV0): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScSpecUdtStructFieldV0;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ScSpecUdtStructFieldV0;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScSpecUdtStructV0 {
    constructor(attributes: {
      doc: string | Buffer;
      lib: string | Buffer;
      name: string | Buffer;
      fields: ScSpecUdtStructFieldV0[];
    });

    doc(value?: string | Buffer): string | Buffer;

    lib(value?: string | Buffer): string | Buffer;

    name(value?: string | Buffer): string | Buffer;

    fields(value?: ScSpecUdtStructFieldV0[]): ScSpecUdtStructFieldV0[];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScSpecUdtStructV0;

    static write(value: ScSpecUdtStructV0, io: Buffer): void;

    static isValid(value: ScSpecUdtStructV0): boolean;

    static toXDR(value: ScSpecUdtStructV0): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScSpecUdtStructV0;

    static fromXDR(input: string, format: 'hex' | 'base64'): ScSpecUdtStructV0;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScSpecUdtUnionCaseVoidV0 {
    constructor(attributes: { doc: string | Buffer; name: string | Buffer });

    doc(value?: string | Buffer): string | Buffer;

    name(value?: string | Buffer): string | Buffer;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScSpecUdtUnionCaseVoidV0;

    static write(value: ScSpecUdtUnionCaseVoidV0, io: Buffer): void;

    static isValid(value: ScSpecUdtUnionCaseVoidV0): boolean;

    static toXDR(value: ScSpecUdtUnionCaseVoidV0): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScSpecUdtUnionCaseVoidV0;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ScSpecUdtUnionCaseVoidV0;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScSpecUdtUnionCaseTupleV0 {
    constructor(attributes: {
      doc: string | Buffer;
      name: string | Buffer;
      type: ScSpecTypeDef[];
    });

    doc(value?: string | Buffer): string | Buffer;

    name(value?: string | Buffer): string | Buffer;

    type(value?: ScSpecTypeDef[]): ScSpecTypeDef[];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScSpecUdtUnionCaseTupleV0;

    static write(value: ScSpecUdtUnionCaseTupleV0, io: Buffer): void;

    static isValid(value: ScSpecUdtUnionCaseTupleV0): boolean;

    static toXDR(value: ScSpecUdtUnionCaseTupleV0): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScSpecUdtUnionCaseTupleV0;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ScSpecUdtUnionCaseTupleV0;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScSpecUdtUnionV0 {
    constructor(attributes: {
      doc: string | Buffer;
      lib: string | Buffer;
      name: string | Buffer;
      cases: ScSpecUdtUnionCaseV0[];
    });

    doc(value?: string | Buffer): string | Buffer;

    lib(value?: string | Buffer): string | Buffer;

    name(value?: string | Buffer): string | Buffer;

    cases(value?: ScSpecUdtUnionCaseV0[]): ScSpecUdtUnionCaseV0[];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScSpecUdtUnionV0;

    static write(value: ScSpecUdtUnionV0, io: Buffer): void;

    static isValid(value: ScSpecUdtUnionV0): boolean;

    static toXDR(value: ScSpecUdtUnionV0): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScSpecUdtUnionV0;

    static fromXDR(input: string, format: 'hex' | 'base64'): ScSpecUdtUnionV0;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScSpecUdtEnumCaseV0 {
    constructor(attributes: {
      doc: string | Buffer;
      name: string | Buffer;
      value: number;
    });

    doc(value?: string | Buffer): string | Buffer;

    name(value?: string | Buffer): string | Buffer;

    value(value?: number): number;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScSpecUdtEnumCaseV0;

    static write(value: ScSpecUdtEnumCaseV0, io: Buffer): void;

    static isValid(value: ScSpecUdtEnumCaseV0): boolean;

    static toXDR(value: ScSpecUdtEnumCaseV0): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScSpecUdtEnumCaseV0;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ScSpecUdtEnumCaseV0;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScSpecUdtEnumV0 {
    constructor(attributes: {
      doc: string | Buffer;
      lib: string | Buffer;
      name: string | Buffer;
      cases: ScSpecUdtEnumCaseV0[];
    });

    doc(value?: string | Buffer): string | Buffer;

    lib(value?: string | Buffer): string | Buffer;

    name(value?: string | Buffer): string | Buffer;

    cases(value?: ScSpecUdtEnumCaseV0[]): ScSpecUdtEnumCaseV0[];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScSpecUdtEnumV0;

    static write(value: ScSpecUdtEnumV0, io: Buffer): void;

    static isValid(value: ScSpecUdtEnumV0): boolean;

    static toXDR(value: ScSpecUdtEnumV0): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScSpecUdtEnumV0;

    static fromXDR(input: string, format: 'hex' | 'base64'): ScSpecUdtEnumV0;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScSpecUdtErrorEnumCaseV0 {
    constructor(attributes: {
      doc: string | Buffer;
      name: string | Buffer;
      value: number;
    });

    doc(value?: string | Buffer): string | Buffer;

    name(value?: string | Buffer): string | Buffer;

    value(value?: number): number;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScSpecUdtErrorEnumCaseV0;

    static write(value: ScSpecUdtErrorEnumCaseV0, io: Buffer): void;

    static isValid(value: ScSpecUdtErrorEnumCaseV0): boolean;

    static toXDR(value: ScSpecUdtErrorEnumCaseV0): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScSpecUdtErrorEnumCaseV0;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ScSpecUdtErrorEnumCaseV0;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScSpecUdtErrorEnumV0 {
    constructor(attributes: {
      doc: string | Buffer;
      lib: string | Buffer;
      name: string | Buffer;
      cases: ScSpecUdtErrorEnumCaseV0[];
    });

    doc(value?: string | Buffer): string | Buffer;

    lib(value?: string | Buffer): string | Buffer;

    name(value?: string | Buffer): string | Buffer;

    cases(value?: ScSpecUdtErrorEnumCaseV0[]): ScSpecUdtErrorEnumCaseV0[];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScSpecUdtErrorEnumV0;

    static write(value: ScSpecUdtErrorEnumV0, io: Buffer): void;

    static isValid(value: ScSpecUdtErrorEnumV0): boolean;

    static toXDR(value: ScSpecUdtErrorEnumV0): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScSpecUdtErrorEnumV0;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ScSpecUdtErrorEnumV0;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScSpecFunctionInputV0 {
    constructor(attributes: {
      doc: string | Buffer;
      name: string | Buffer;
      type: ScSpecTypeDef;
    });

    doc(value?: string | Buffer): string | Buffer;

    name(value?: string | Buffer): string | Buffer;

    type(value?: ScSpecTypeDef): ScSpecTypeDef;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScSpecFunctionInputV0;

    static write(value: ScSpecFunctionInputV0, io: Buffer): void;

    static isValid(value: ScSpecFunctionInputV0): boolean;

    static toXDR(value: ScSpecFunctionInputV0): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScSpecFunctionInputV0;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ScSpecFunctionInputV0;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScSpecFunctionV0 {
    constructor(attributes: {
      doc: string | Buffer;
      name: string | Buffer;
      inputs: ScSpecFunctionInputV0[];
      outputs: ScSpecTypeDef[];
    });

    doc(value?: string | Buffer): string | Buffer;

    name(value?: string | Buffer): string | Buffer;

    inputs(value?: ScSpecFunctionInputV0[]): ScSpecFunctionInputV0[];

    outputs(value?: ScSpecTypeDef[]): ScSpecTypeDef[];

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScSpecFunctionV0;

    static write(value: ScSpecFunctionV0, io: Buffer): void;

    static isValid(value: ScSpecFunctionV0): boolean;

    static toXDR(value: ScSpecFunctionV0): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScSpecFunctionV0;

    static fromXDR(input: string, format: 'hex' | 'base64'): ScSpecFunctionV0;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ConfigSettingContractExecutionLanesV0 {
    constructor(attributes: { ledgerMaxTxCount: number });

    ledgerMaxTxCount(value?: number): number;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ConfigSettingContractExecutionLanesV0;

    static write(
      value: ConfigSettingContractExecutionLanesV0,
      io: Buffer,
    ): void;

    static isValid(value: ConfigSettingContractExecutionLanesV0): boolean;

    static toXDR(value: ConfigSettingContractExecutionLanesV0): Buffer;

    static fromXDR(
      input: Buffer,
      format?: 'raw',
    ): ConfigSettingContractExecutionLanesV0;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ConfigSettingContractExecutionLanesV0;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ConfigSettingContractComputeV0 {
    constructor(attributes: {
      ledgerMaxInstructions: Int64;
      txMaxInstructions: Int64;
      feeRatePerInstructionsIncrement: Int64;
      txMemoryLimit: number;
    });

    ledgerMaxInstructions(value?: Int64): Int64;

    txMaxInstructions(value?: Int64): Int64;

    feeRatePerInstructionsIncrement(value?: Int64): Int64;

    txMemoryLimit(value?: number): number;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ConfigSettingContractComputeV0;

    static write(value: ConfigSettingContractComputeV0, io: Buffer): void;

    static isValid(value: ConfigSettingContractComputeV0): boolean;

    static toXDR(value: ConfigSettingContractComputeV0): Buffer;

    static fromXDR(
      input: Buffer,
      format?: 'raw',
    ): ConfigSettingContractComputeV0;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ConfigSettingContractComputeV0;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ConfigSettingContractParallelComputeV0 {
    constructor(attributes: { ledgerMaxParallelThreads: number });

    ledgerMaxParallelThreads(value?: number): number;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ConfigSettingContractParallelComputeV0;

    static write(
      value: ConfigSettingContractParallelComputeV0,
      io: Buffer,
    ): void;

    static isValid(value: ConfigSettingContractParallelComputeV0): boolean;

    static toXDR(value: ConfigSettingContractParallelComputeV0): Buffer;

    static fromXDR(
      input: Buffer,
      format?: 'raw',
    ): ConfigSettingContractParallelComputeV0;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ConfigSettingContractParallelComputeV0;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ConfigSettingContractLedgerCostV0 {
    constructor(attributes: {
      ledgerMaxReadLedgerEntries: number;
      ledgerMaxReadBytes: number;
      ledgerMaxWriteLedgerEntries: number;
      ledgerMaxWriteBytes: number;
      txMaxReadLedgerEntries: number;
      txMaxReadBytes: number;
      txMaxWriteLedgerEntries: number;
      txMaxWriteBytes: number;
      feeReadLedgerEntry: Int64;
      feeWriteLedgerEntry: Int64;
      feeRead1Kb: Int64;
      bucketListTargetSizeBytes: Int64;
      writeFee1KbBucketListLow: Int64;
      writeFee1KbBucketListHigh: Int64;
      bucketListWriteFeeGrowthFactor: number;
    });

    ledgerMaxReadLedgerEntries(value?: number): number;

    ledgerMaxReadBytes(value?: number): number;

    ledgerMaxWriteLedgerEntries(value?: number): number;

    ledgerMaxWriteBytes(value?: number): number;

    txMaxReadLedgerEntries(value?: number): number;

    txMaxReadBytes(value?: number): number;

    txMaxWriteLedgerEntries(value?: number): number;

    txMaxWriteBytes(value?: number): number;

    feeReadLedgerEntry(value?: Int64): Int64;

    feeWriteLedgerEntry(value?: Int64): Int64;

    feeRead1Kb(value?: Int64): Int64;

    bucketListTargetSizeBytes(value?: Int64): Int64;

    writeFee1KbBucketListLow(value?: Int64): Int64;

    writeFee1KbBucketListHigh(value?: Int64): Int64;

    bucketListWriteFeeGrowthFactor(value?: number): number;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ConfigSettingContractLedgerCostV0;

    static write(value: ConfigSettingContractLedgerCostV0, io: Buffer): void;

    static isValid(value: ConfigSettingContractLedgerCostV0): boolean;

    static toXDR(value: ConfigSettingContractLedgerCostV0): Buffer;

    static fromXDR(
      input: Buffer,
      format?: 'raw',
    ): ConfigSettingContractLedgerCostV0;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ConfigSettingContractLedgerCostV0;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ConfigSettingContractHistoricalDataV0 {
    constructor(attributes: { feeHistorical1Kb: Int64 });

    feeHistorical1Kb(value?: Int64): Int64;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ConfigSettingContractHistoricalDataV0;

    static write(
      value: ConfigSettingContractHistoricalDataV0,
      io: Buffer,
    ): void;

    static isValid(value: ConfigSettingContractHistoricalDataV0): boolean;

    static toXDR(value: ConfigSettingContractHistoricalDataV0): Buffer;

    static fromXDR(
      input: Buffer,
      format?: 'raw',
    ): ConfigSettingContractHistoricalDataV0;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ConfigSettingContractHistoricalDataV0;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ConfigSettingContractEventsV0 {
    constructor(attributes: {
      txMaxContractEventsSizeBytes: number;
      feeContractEvents1Kb: Int64;
    });

    txMaxContractEventsSizeBytes(value?: number): number;

    feeContractEvents1Kb(value?: Int64): Int64;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ConfigSettingContractEventsV0;

    static write(value: ConfigSettingContractEventsV0, io: Buffer): void;

    static isValid(value: ConfigSettingContractEventsV0): boolean;

    static toXDR(value: ConfigSettingContractEventsV0): Buffer;

    static fromXDR(
      input: Buffer,
      format?: 'raw',
    ): ConfigSettingContractEventsV0;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ConfigSettingContractEventsV0;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ConfigSettingContractBandwidthV0 {
    constructor(attributes: {
      ledgerMaxTxsSizeBytes: number;
      txMaxSizeBytes: number;
      feeTxSize1Kb: Int64;
    });

    ledgerMaxTxsSizeBytes(value?: number): number;

    txMaxSizeBytes(value?: number): number;

    feeTxSize1Kb(value?: Int64): Int64;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ConfigSettingContractBandwidthV0;

    static write(value: ConfigSettingContractBandwidthV0, io: Buffer): void;

    static isValid(value: ConfigSettingContractBandwidthV0): boolean;

    static toXDR(value: ConfigSettingContractBandwidthV0): Buffer;

    static fromXDR(
      input: Buffer,
      format?: 'raw',
    ): ConfigSettingContractBandwidthV0;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ConfigSettingContractBandwidthV0;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ContractCostParamEntry {
    constructor(attributes: {
      ext: ExtensionPoint;
      constTerm: Int64;
      linearTerm: Int64;
    });

    ext(value?: ExtensionPoint): ExtensionPoint;

    constTerm(value?: Int64): Int64;

    linearTerm(value?: Int64): Int64;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ContractCostParamEntry;

    static write(value: ContractCostParamEntry, io: Buffer): void;

    static isValid(value: ContractCostParamEntry): boolean;

    static toXDR(value: ContractCostParamEntry): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ContractCostParamEntry;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ContractCostParamEntry;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class StateArchivalSettings {
    constructor(attributes: {
      maxEntryTtl: number;
      minTemporaryTtl: number;
      minPersistentTtl: number;
      persistentRentRateDenominator: Int64;
      tempRentRateDenominator: Int64;
      maxEntriesToArchive: number;
      bucketListSizeWindowSampleSize: number;
      bucketListWindowSamplePeriod: number;
      evictionScanSize: number;
      startingEvictionScanLevel: number;
    });

    maxEntryTtl(value?: number): number;

    minTemporaryTtl(value?: number): number;

    minPersistentTtl(value?: number): number;

    persistentRentRateDenominator(value?: Int64): Int64;

    tempRentRateDenominator(value?: Int64): Int64;

    maxEntriesToArchive(value?: number): number;

    bucketListSizeWindowSampleSize(value?: number): number;

    bucketListWindowSamplePeriod(value?: number): number;

    evictionScanSize(value?: number): number;

    startingEvictionScanLevel(value?: number): number;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): StateArchivalSettings;

    static write(value: StateArchivalSettings, io: Buffer): void;

    static isValid(value: StateArchivalSettings): boolean;

    static toXDR(value: StateArchivalSettings): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): StateArchivalSettings;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): StateArchivalSettings;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class EvictionIterator {
    constructor(attributes: {
      bucketListLevel: number;
      isCurrBucket: boolean;
      bucketFileOffset: Uint64;
    });

    bucketListLevel(value?: number): number;

    isCurrBucket(value?: boolean): boolean;

    bucketFileOffset(value?: Uint64): Uint64;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): EvictionIterator;

    static write(value: EvictionIterator, io: Buffer): void;

    static isValid(value: EvictionIterator): boolean;

    static toXDR(value: EvictionIterator): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): EvictionIterator;

    static fromXDR(input: string, format: 'hex' | 'base64'): EvictionIterator;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScpStatementPledges {
    switch(): ScpStatementType;

    prepare(value?: ScpStatementPrepare): ScpStatementPrepare;

    confirm(value?: ScpStatementConfirm): ScpStatementConfirm;

    externalize(value?: ScpStatementExternalize): ScpStatementExternalize;

    nominate(value?: ScpNomination): ScpNomination;

    static scpStPrepare(value: ScpStatementPrepare): ScpStatementPledges;

    static scpStConfirm(value: ScpStatementConfirm): ScpStatementPledges;

    static scpStExternalize(
      value: ScpStatementExternalize,
    ): ScpStatementPledges;

    static scpStNominate(value: ScpNomination): ScpStatementPledges;

    value():
      | ScpStatementPrepare
      | ScpStatementConfirm
      | ScpStatementExternalize
      | ScpNomination;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScpStatementPledges;

    static write(value: ScpStatementPledges, io: Buffer): void;

    static isValid(value: ScpStatementPledges): boolean;

    static toXDR(value: ScpStatementPledges): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScpStatementPledges;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ScpStatementPledges;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class AssetCode {
    switch(): AssetType;

    assetCode4(value?: Buffer): Buffer;

    assetCode12(value?: Buffer): Buffer;

    static assetTypeCreditAlphanum4(value: Buffer): AssetCode;

    static assetTypeCreditAlphanum12(value: Buffer): AssetCode;

    value(): Buffer | Buffer;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): AssetCode;

    static write(value: AssetCode, io: Buffer): void;

    static isValid(value: AssetCode): boolean;

    static toXDR(value: AssetCode): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): AssetCode;

    static fromXDR(input: string, format: 'hex' | 'base64'): AssetCode;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class Asset {
    switch(): AssetType;

    alphaNum4(value?: AlphaNum4): AlphaNum4;

    alphaNum12(value?: AlphaNum12): AlphaNum12;

    static assetTypeNative(): Asset;

    static assetTypeCreditAlphanum4(value: AlphaNum4): Asset;

    static assetTypeCreditAlphanum12(value: AlphaNum12): Asset;

    value(): AlphaNum4 | AlphaNum12 | void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): Asset;

    static write(value: Asset, io: Buffer): void;

    static isValid(value: Asset): boolean;

    static toXDR(value: Asset): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): Asset;

    static fromXDR(input: string, format: 'hex' | 'base64'): Asset;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class AccountEntryExtensionV2Ext {
    switch(): number;

    v3(value?: AccountEntryExtensionV3): AccountEntryExtensionV3;

    static 0(): AccountEntryExtensionV2Ext;

    static 3(value: AccountEntryExtensionV3): AccountEntryExtensionV2Ext;

    value(): AccountEntryExtensionV3 | void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): AccountEntryExtensionV2Ext;

    static write(value: AccountEntryExtensionV2Ext, io: Buffer): void;

    static isValid(value: AccountEntryExtensionV2Ext): boolean;

    static toXDR(value: AccountEntryExtensionV2Ext): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): AccountEntryExtensionV2Ext;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): AccountEntryExtensionV2Ext;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class AccountEntryExtensionV1Ext {
    switch(): number;

    v2(value?: AccountEntryExtensionV2): AccountEntryExtensionV2;

    static 0(): AccountEntryExtensionV1Ext;

    static 2(value: AccountEntryExtensionV2): AccountEntryExtensionV1Ext;

    value(): AccountEntryExtensionV2 | void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): AccountEntryExtensionV1Ext;

    static write(value: AccountEntryExtensionV1Ext, io: Buffer): void;

    static isValid(value: AccountEntryExtensionV1Ext): boolean;

    static toXDR(value: AccountEntryExtensionV1Ext): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): AccountEntryExtensionV1Ext;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): AccountEntryExtensionV1Ext;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class AccountEntryExt {
    switch(): number;

    v1(value?: AccountEntryExtensionV1): AccountEntryExtensionV1;

    static 0(): AccountEntryExt;

    static 1(value: AccountEntryExtensionV1): AccountEntryExt;

    value(): AccountEntryExtensionV1 | void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): AccountEntryExt;

    static write(value: AccountEntryExt, io: Buffer): void;

    static isValid(value: AccountEntryExt): boolean;

    static toXDR(value: AccountEntryExt): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): AccountEntryExt;

    static fromXDR(input: string, format: 'hex' | 'base64'): AccountEntryExt;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TrustLineAsset {
    switch(): AssetType;

    alphaNum4(value?: AlphaNum4): AlphaNum4;

    alphaNum12(value?: AlphaNum12): AlphaNum12;

    liquidityPoolId(value?: PoolId): PoolId;

    static assetTypeNative(): TrustLineAsset;

    static assetTypeCreditAlphanum4(value: AlphaNum4): TrustLineAsset;

    static assetTypeCreditAlphanum12(value: AlphaNum12): TrustLineAsset;

    static assetTypePoolShare(value: PoolId): TrustLineAsset;

    value(): AlphaNum4 | AlphaNum12 | PoolId | void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TrustLineAsset;

    static write(value: TrustLineAsset, io: Buffer): void;

    static isValid(value: TrustLineAsset): boolean;

    static toXDR(value: TrustLineAsset): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): TrustLineAsset;

    static fromXDR(input: string, format: 'hex' | 'base64'): TrustLineAsset;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TrustLineEntryExtensionV2Ext {
    switch(): number;

    static 0(): TrustLineEntryExtensionV2Ext;

    value(): void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TrustLineEntryExtensionV2Ext;

    static write(value: TrustLineEntryExtensionV2Ext, io: Buffer): void;

    static isValid(value: TrustLineEntryExtensionV2Ext): boolean;

    static toXDR(value: TrustLineEntryExtensionV2Ext): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): TrustLineEntryExtensionV2Ext;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): TrustLineEntryExtensionV2Ext;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TrustLineEntryV1Ext {
    switch(): number;

    v2(value?: TrustLineEntryExtensionV2): TrustLineEntryExtensionV2;

    static 0(): TrustLineEntryV1Ext;

    static 2(value: TrustLineEntryExtensionV2): TrustLineEntryV1Ext;

    value(): TrustLineEntryExtensionV2 | void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TrustLineEntryV1Ext;

    static write(value: TrustLineEntryV1Ext, io: Buffer): void;

    static isValid(value: TrustLineEntryV1Ext): boolean;

    static toXDR(value: TrustLineEntryV1Ext): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): TrustLineEntryV1Ext;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): TrustLineEntryV1Ext;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TrustLineEntryExt {
    switch(): number;

    v1(value?: TrustLineEntryV1): TrustLineEntryV1;

    static 0(): TrustLineEntryExt;

    static 1(value: TrustLineEntryV1): TrustLineEntryExt;

    value(): TrustLineEntryV1 | void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TrustLineEntryExt;

    static write(value: TrustLineEntryExt, io: Buffer): void;

    static isValid(value: TrustLineEntryExt): boolean;

    static toXDR(value: TrustLineEntryExt): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): TrustLineEntryExt;

    static fromXDR(input: string, format: 'hex' | 'base64'): TrustLineEntryExt;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class OfferEntryExt {
    switch(): number;

    static 0(): OfferEntryExt;

    value(): void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): OfferEntryExt;

    static write(value: OfferEntryExt, io: Buffer): void;

    static isValid(value: OfferEntryExt): boolean;

    static toXDR(value: OfferEntryExt): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): OfferEntryExt;

    static fromXDR(input: string, format: 'hex' | 'base64'): OfferEntryExt;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class DataEntryExt {
    switch(): number;

    static 0(): DataEntryExt;

    value(): void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): DataEntryExt;

    static write(value: DataEntryExt, io: Buffer): void;

    static isValid(value: DataEntryExt): boolean;

    static toXDR(value: DataEntryExt): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): DataEntryExt;

    static fromXDR(input: string, format: 'hex' | 'base64'): DataEntryExt;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ClaimPredicate {
    switch(): ClaimPredicateType;

    andPredicates(value?: ClaimPredicate[]): ClaimPredicate[];

    orPredicates(value?: ClaimPredicate[]): ClaimPredicate[];

    notPredicate(value?: null | ClaimPredicate): null | ClaimPredicate;

    absBefore(value?: Int64): Int64;

    relBefore(value?: Int64): Int64;

    static claimPredicateUnconditional(): ClaimPredicate;

    static claimPredicateAnd(value: ClaimPredicate[]): ClaimPredicate;

    static claimPredicateOr(value: ClaimPredicate[]): ClaimPredicate;

    static claimPredicateNot(value: null | ClaimPredicate): ClaimPredicate;

    static claimPredicateBeforeAbsoluteTime(value: Int64): ClaimPredicate;

    static claimPredicateBeforeRelativeTime(value: Int64): ClaimPredicate;

    value():
      | ClaimPredicate[]
      | ClaimPredicate[]
      | null
      | ClaimPredicate
      | Int64
      | Int64
      | void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ClaimPredicate;

    static write(value: ClaimPredicate, io: Buffer): void;

    static isValid(value: ClaimPredicate): boolean;

    static toXDR(value: ClaimPredicate): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ClaimPredicate;

    static fromXDR(input: string, format: 'hex' | 'base64'): ClaimPredicate;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class Claimant {
    switch(): ClaimantType;

    v0(value?: ClaimantV0): ClaimantV0;

    static claimantTypeV0(value: ClaimantV0): Claimant;

    value(): ClaimantV0;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): Claimant;

    static write(value: Claimant, io: Buffer): void;

    static isValid(value: Claimant): boolean;

    static toXDR(value: Claimant): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): Claimant;

    static fromXDR(input: string, format: 'hex' | 'base64'): Claimant;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ClaimableBalanceId {
    switch(): ClaimableBalanceIdType;

    v0(value?: Buffer): Buffer;

    static claimableBalanceIdTypeV0(value: Buffer): ClaimableBalanceId;

    value(): Buffer;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ClaimableBalanceId;

    static write(value: ClaimableBalanceId, io: Buffer): void;

    static isValid(value: ClaimableBalanceId): boolean;

    static toXDR(value: ClaimableBalanceId): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ClaimableBalanceId;

    static fromXDR(input: string, format: 'hex' | 'base64'): ClaimableBalanceId;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ClaimableBalanceEntryExtensionV1Ext {
    switch(): number;

    static 0(): ClaimableBalanceEntryExtensionV1Ext;

    value(): void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ClaimableBalanceEntryExtensionV1Ext;

    static write(value: ClaimableBalanceEntryExtensionV1Ext, io: Buffer): void;

    static isValid(value: ClaimableBalanceEntryExtensionV1Ext): boolean;

    static toXDR(value: ClaimableBalanceEntryExtensionV1Ext): Buffer;

    static fromXDR(
      input: Buffer,
      format?: 'raw',
    ): ClaimableBalanceEntryExtensionV1Ext;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ClaimableBalanceEntryExtensionV1Ext;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ClaimableBalanceEntryExt {
    switch(): number;

    v1(
      value?: ClaimableBalanceEntryExtensionV1,
    ): ClaimableBalanceEntryExtensionV1;

    static 0(): ClaimableBalanceEntryExt;

    static 1(value: ClaimableBalanceEntryExtensionV1): ClaimableBalanceEntryExt;

    value(): ClaimableBalanceEntryExtensionV1 | void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ClaimableBalanceEntryExt;

    static write(value: ClaimableBalanceEntryExt, io: Buffer): void;

    static isValid(value: ClaimableBalanceEntryExt): boolean;

    static toXDR(value: ClaimableBalanceEntryExt): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ClaimableBalanceEntryExt;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ClaimableBalanceEntryExt;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LiquidityPoolEntryBody {
    switch(): LiquidityPoolType;

    constantProduct(
      value?: LiquidityPoolEntryConstantProduct,
    ): LiquidityPoolEntryConstantProduct;

    static liquidityPoolConstantProduct(
      value: LiquidityPoolEntryConstantProduct,
    ): LiquidityPoolEntryBody;

    value(): LiquidityPoolEntryConstantProduct;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LiquidityPoolEntryBody;

    static write(value: LiquidityPoolEntryBody, io: Buffer): void;

    static isValid(value: LiquidityPoolEntryBody): boolean;

    static toXDR(value: LiquidityPoolEntryBody): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): LiquidityPoolEntryBody;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): LiquidityPoolEntryBody;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ContractCodeEntryExt {
    switch(): number;

    v1(value?: ContractCodeEntryV1): ContractCodeEntryV1;

    static 0(): ContractCodeEntryExt;

    static 1(value: ContractCodeEntryV1): ContractCodeEntryExt;

    value(): ContractCodeEntryV1 | void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ContractCodeEntryExt;

    static write(value: ContractCodeEntryExt, io: Buffer): void;

    static isValid(value: ContractCodeEntryExt): boolean;

    static toXDR(value: ContractCodeEntryExt): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ContractCodeEntryExt;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ContractCodeEntryExt;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LedgerEntryExtensionV1Ext {
    switch(): number;

    static 0(): LedgerEntryExtensionV1Ext;

    value(): void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LedgerEntryExtensionV1Ext;

    static write(value: LedgerEntryExtensionV1Ext, io: Buffer): void;

    static isValid(value: LedgerEntryExtensionV1Ext): boolean;

    static toXDR(value: LedgerEntryExtensionV1Ext): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): LedgerEntryExtensionV1Ext;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): LedgerEntryExtensionV1Ext;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LedgerEntryData {
    switch(): LedgerEntryType;

    account(value?: AccountEntry): AccountEntry;

    trustLine(value?: TrustLineEntry): TrustLineEntry;

    offer(value?: OfferEntry): OfferEntry;

    data(value?: DataEntry): DataEntry;

    claimableBalance(value?: ClaimableBalanceEntry): ClaimableBalanceEntry;

    liquidityPool(value?: LiquidityPoolEntry): LiquidityPoolEntry;

    contractData(value?: ContractDataEntry): ContractDataEntry;

    contractCode(value?: ContractCodeEntry): ContractCodeEntry;

    configSetting(value?: ConfigSettingEntry): ConfigSettingEntry;

    ttl(value?: TtlEntry): TtlEntry;

    static account(value: AccountEntry): LedgerEntryData;

    static trustline(value: TrustLineEntry): LedgerEntryData;

    static offer(value: OfferEntry): LedgerEntryData;

    static data(value: DataEntry): LedgerEntryData;

    static claimableBalance(value: ClaimableBalanceEntry): LedgerEntryData;

    static liquidityPool(value: LiquidityPoolEntry): LedgerEntryData;

    static contractData(value: ContractDataEntry): LedgerEntryData;

    static contractCode(value: ContractCodeEntry): LedgerEntryData;

    static configSetting(value: ConfigSettingEntry): LedgerEntryData;

    static ttl(value: TtlEntry): LedgerEntryData;

    value():
      | AccountEntry
      | TrustLineEntry
      | OfferEntry
      | DataEntry
      | ClaimableBalanceEntry
      | LiquidityPoolEntry
      | ContractDataEntry
      | ContractCodeEntry
      | ConfigSettingEntry
      | TtlEntry;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LedgerEntryData;

    static write(value: LedgerEntryData, io: Buffer): void;

    static isValid(value: LedgerEntryData): boolean;

    static toXDR(value: LedgerEntryData): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): LedgerEntryData;

    static fromXDR(input: string, format: 'hex' | 'base64'): LedgerEntryData;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LedgerEntryExt {
    switch(): number;

    v1(value?: LedgerEntryExtensionV1): LedgerEntryExtensionV1;

    static 0(): LedgerEntryExt;

    static 1(value: LedgerEntryExtensionV1): LedgerEntryExt;

    value(): LedgerEntryExtensionV1 | void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LedgerEntryExt;

    static write(value: LedgerEntryExt, io: Buffer): void;

    static isValid(value: LedgerEntryExt): boolean;

    static toXDR(value: LedgerEntryExt): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): LedgerEntryExt;

    static fromXDR(input: string, format: 'hex' | 'base64'): LedgerEntryExt;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LedgerKey {
    switch(): LedgerEntryType;

    account(value?: LedgerKeyAccount): LedgerKeyAccount;

    trustLine(value?: LedgerKeyTrustLine): LedgerKeyTrustLine;

    offer(value?: LedgerKeyOffer): LedgerKeyOffer;

    data(value?: LedgerKeyData): LedgerKeyData;

    claimableBalance(
      value?: LedgerKeyClaimableBalance,
    ): LedgerKeyClaimableBalance;

    liquidityPool(value?: LedgerKeyLiquidityPool): LedgerKeyLiquidityPool;

    contractData(value?: LedgerKeyContractData): LedgerKeyContractData;

    contractCode(value?: LedgerKeyContractCode): LedgerKeyContractCode;

    configSetting(value?: LedgerKeyConfigSetting): LedgerKeyConfigSetting;

    ttl(value?: LedgerKeyTtl): LedgerKeyTtl;

    static account(value: LedgerKeyAccount): LedgerKey;

    static trustline(value: LedgerKeyTrustLine): LedgerKey;

    static offer(value: LedgerKeyOffer): LedgerKey;

    static data(value: LedgerKeyData): LedgerKey;

    static claimableBalance(value: LedgerKeyClaimableBalance): LedgerKey;

    static liquidityPool(value: LedgerKeyLiquidityPool): LedgerKey;

    static contractData(value: LedgerKeyContractData): LedgerKey;

    static contractCode(value: LedgerKeyContractCode): LedgerKey;

    static configSetting(value: LedgerKeyConfigSetting): LedgerKey;

    static ttl(value: LedgerKeyTtl): LedgerKey;

    value():
      | LedgerKeyAccount
      | LedgerKeyTrustLine
      | LedgerKeyOffer
      | LedgerKeyData
      | LedgerKeyClaimableBalance
      | LedgerKeyLiquidityPool
      | LedgerKeyContractData
      | LedgerKeyContractCode
      | LedgerKeyConfigSetting
      | LedgerKeyTtl;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LedgerKey;

    static write(value: LedgerKey, io: Buffer): void;

    static isValid(value: LedgerKey): boolean;

    static toXDR(value: LedgerKey): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): LedgerKey;

    static fromXDR(input: string, format: 'hex' | 'base64'): LedgerKey;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class BucketMetadataExt {
    switch(): number;

    bucketListType(value?: BucketListType): BucketListType;

    static 0(): BucketMetadataExt;

    static 1(value: BucketListType): BucketMetadataExt;

    value(): BucketListType | void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): BucketMetadataExt;

    static write(value: BucketMetadataExt, io: Buffer): void;

    static isValid(value: BucketMetadataExt): boolean;

    static toXDR(value: BucketMetadataExt): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): BucketMetadataExt;

    static fromXDR(input: string, format: 'hex' | 'base64'): BucketMetadataExt;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class BucketEntry {
    switch(): BucketEntryType;

    liveEntry(value?: LedgerEntry): LedgerEntry;

    deadEntry(value?: LedgerKey): LedgerKey;

    metaEntry(value?: BucketMetadata): BucketMetadata;

    static liveentry(value: LedgerEntry): BucketEntry;

    static initentry(value: LedgerEntry): BucketEntry;

    static deadentry(value: LedgerKey): BucketEntry;

    static metaentry(value: BucketMetadata): BucketEntry;

    value(): LedgerEntry | LedgerKey | BucketMetadata;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): BucketEntry;

    static write(value: BucketEntry, io: Buffer): void;

    static isValid(value: BucketEntry): boolean;

    static toXDR(value: BucketEntry): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): BucketEntry;

    static fromXDR(input: string, format: 'hex' | 'base64'): BucketEntry;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class HotArchiveBucketEntry {
    switch(): HotArchiveBucketEntryType;

    archivedEntry(value?: LedgerEntry): LedgerEntry;

    key(value?: LedgerKey): LedgerKey;

    metaEntry(value?: BucketMetadata): BucketMetadata;

    static hotArchiveArchived(value: LedgerEntry): HotArchiveBucketEntry;

    static hotArchiveLive(value: LedgerKey): HotArchiveBucketEntry;

    static hotArchiveDeleted(value: LedgerKey): HotArchiveBucketEntry;

    static hotArchiveMetaentry(value: BucketMetadata): HotArchiveBucketEntry;

    value(): LedgerEntry | LedgerKey | BucketMetadata;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): HotArchiveBucketEntry;

    static write(value: HotArchiveBucketEntry, io: Buffer): void;

    static isValid(value: HotArchiveBucketEntry): boolean;

    static toXDR(value: HotArchiveBucketEntry): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): HotArchiveBucketEntry;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): HotArchiveBucketEntry;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ColdArchiveBucketEntry {
    switch(): ColdArchiveBucketEntryType;

    metaEntry(value?: BucketMetadata): BucketMetadata;

    archivedLeaf(value?: ColdArchiveArchivedLeaf): ColdArchiveArchivedLeaf;

    deletedLeaf(value?: ColdArchiveDeletedLeaf): ColdArchiveDeletedLeaf;

    boundaryLeaf(value?: ColdArchiveBoundaryLeaf): ColdArchiveBoundaryLeaf;

    hashEntry(value?: ColdArchiveHashEntry): ColdArchiveHashEntry;

    static coldArchiveMetaentry(value: BucketMetadata): ColdArchiveBucketEntry;

    static coldArchiveArchivedLeaf(
      value: ColdArchiveArchivedLeaf,
    ): ColdArchiveBucketEntry;

    static coldArchiveDeletedLeaf(
      value: ColdArchiveDeletedLeaf,
    ): ColdArchiveBucketEntry;

    static coldArchiveBoundaryLeaf(
      value: ColdArchiveBoundaryLeaf,
    ): ColdArchiveBucketEntry;

    static coldArchiveHash(value: ColdArchiveHashEntry): ColdArchiveBucketEntry;

    value():
      | BucketMetadata
      | ColdArchiveArchivedLeaf
      | ColdArchiveDeletedLeaf
      | ColdArchiveBoundaryLeaf
      | ColdArchiveHashEntry;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ColdArchiveBucketEntry;

    static write(value: ColdArchiveBucketEntry, io: Buffer): void;

    static isValid(value: ColdArchiveBucketEntry): boolean;

    static toXDR(value: ColdArchiveBucketEntry): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ColdArchiveBucketEntry;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ColdArchiveBucketEntry;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class StellarValueExt {
    switch(): StellarValueType;

    lcValueSignature(
      value?: LedgerCloseValueSignature,
    ): LedgerCloseValueSignature;

    static stellarValueBasic(): StellarValueExt;

    static stellarValueSigned(
      value: LedgerCloseValueSignature,
    ): StellarValueExt;

    value(): LedgerCloseValueSignature | void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): StellarValueExt;

    static write(value: StellarValueExt, io: Buffer): void;

    static isValid(value: StellarValueExt): boolean;

    static toXDR(value: StellarValueExt): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): StellarValueExt;

    static fromXDR(input: string, format: 'hex' | 'base64'): StellarValueExt;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LedgerHeaderExtensionV1Ext {
    switch(): number;

    static 0(): LedgerHeaderExtensionV1Ext;

    value(): void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LedgerHeaderExtensionV1Ext;

    static write(value: LedgerHeaderExtensionV1Ext, io: Buffer): void;

    static isValid(value: LedgerHeaderExtensionV1Ext): boolean;

    static toXDR(value: LedgerHeaderExtensionV1Ext): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): LedgerHeaderExtensionV1Ext;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): LedgerHeaderExtensionV1Ext;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LedgerHeaderExt {
    switch(): number;

    v1(value?: LedgerHeaderExtensionV1): LedgerHeaderExtensionV1;

    static 0(): LedgerHeaderExt;

    static 1(value: LedgerHeaderExtensionV1): LedgerHeaderExt;

    value(): LedgerHeaderExtensionV1 | void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LedgerHeaderExt;

    static write(value: LedgerHeaderExt, io: Buffer): void;

    static isValid(value: LedgerHeaderExt): boolean;

    static toXDR(value: LedgerHeaderExt): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): LedgerHeaderExt;

    static fromXDR(input: string, format: 'hex' | 'base64'): LedgerHeaderExt;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LedgerUpgrade {
    switch(): LedgerUpgradeType;

    newLedgerVersion(value?: number): number;

    newBaseFee(value?: number): number;

    newMaxTxSetSize(value?: number): number;

    newBaseReserve(value?: number): number;

    newFlags(value?: number): number;

    newConfig(value?: ConfigUpgradeSetKey): ConfigUpgradeSetKey;

    newMaxSorobanTxSetSize(value?: number): number;

    static ledgerUpgradeVersion(value: number): LedgerUpgrade;

    static ledgerUpgradeBaseFee(value: number): LedgerUpgrade;

    static ledgerUpgradeMaxTxSetSize(value: number): LedgerUpgrade;

    static ledgerUpgradeBaseReserve(value: number): LedgerUpgrade;

    static ledgerUpgradeFlags(value: number): LedgerUpgrade;

    static ledgerUpgradeConfig(value: ConfigUpgradeSetKey): LedgerUpgrade;

    static ledgerUpgradeMaxSorobanTxSetSize(value: number): LedgerUpgrade;

    value():
      | number
      | number
      | number
      | number
      | number
      | ConfigUpgradeSetKey
      | number;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LedgerUpgrade;

    static write(value: LedgerUpgrade, io: Buffer): void;

    static isValid(value: LedgerUpgrade): boolean;

    static toXDR(value: LedgerUpgrade): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): LedgerUpgrade;

    static fromXDR(input: string, format: 'hex' | 'base64'): LedgerUpgrade;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TxSetComponent {
    switch(): TxSetComponentType;

    txsMaybeDiscountedFee(
      value?: TxSetComponentTxsMaybeDiscountedFee,
    ): TxSetComponentTxsMaybeDiscountedFee;

    static txsetCompTxsMaybeDiscountedFee(
      value: TxSetComponentTxsMaybeDiscountedFee,
    ): TxSetComponent;

    value(): TxSetComponentTxsMaybeDiscountedFee;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TxSetComponent;

    static write(value: TxSetComponent, io: Buffer): void;

    static isValid(value: TxSetComponent): boolean;

    static toXDR(value: TxSetComponent): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): TxSetComponent;

    static fromXDR(input: string, format: 'hex' | 'base64'): TxSetComponent;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TransactionPhase {
    switch(): number;

    v0Components(value?: TxSetComponent[]): TxSetComponent[];

    parallelTxsComponent(value?: ParallelTxsComponent): ParallelTxsComponent;

    static 0(value: TxSetComponent[]): TransactionPhase;

    static 1(value: ParallelTxsComponent): TransactionPhase;

    value(): TxSetComponent[] | ParallelTxsComponent;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TransactionPhase;

    static write(value: TransactionPhase, io: Buffer): void;

    static isValid(value: TransactionPhase): boolean;

    static toXDR(value: TransactionPhase): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): TransactionPhase;

    static fromXDR(input: string, format: 'hex' | 'base64'): TransactionPhase;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class GeneralizedTransactionSet {
    switch(): number;

    v1TxSet(value?: TransactionSetV1): TransactionSetV1;

    static 1(value: TransactionSetV1): GeneralizedTransactionSet;

    value(): TransactionSetV1;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): GeneralizedTransactionSet;

    static write(value: GeneralizedTransactionSet, io: Buffer): void;

    static isValid(value: GeneralizedTransactionSet): boolean;

    static toXDR(value: GeneralizedTransactionSet): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): GeneralizedTransactionSet;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): GeneralizedTransactionSet;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TransactionHistoryEntryExt {
    switch(): number;

    generalizedTxSet(
      value?: GeneralizedTransactionSet,
    ): GeneralizedTransactionSet;

    static 0(): TransactionHistoryEntryExt;

    static 1(value: GeneralizedTransactionSet): TransactionHistoryEntryExt;

    value(): GeneralizedTransactionSet | void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TransactionHistoryEntryExt;

    static write(value: TransactionHistoryEntryExt, io: Buffer): void;

    static isValid(value: TransactionHistoryEntryExt): boolean;

    static toXDR(value: TransactionHistoryEntryExt): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): TransactionHistoryEntryExt;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): TransactionHistoryEntryExt;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TransactionHistoryResultEntryExt {
    switch(): number;

    static 0(): TransactionHistoryResultEntryExt;

    value(): void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TransactionHistoryResultEntryExt;

    static write(value: TransactionHistoryResultEntryExt, io: Buffer): void;

    static isValid(value: TransactionHistoryResultEntryExt): boolean;

    static toXDR(value: TransactionHistoryResultEntryExt): Buffer;

    static fromXDR(
      input: Buffer,
      format?: 'raw',
    ): TransactionHistoryResultEntryExt;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): TransactionHistoryResultEntryExt;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LedgerHeaderHistoryEntryExt {
    switch(): number;

    static 0(): LedgerHeaderHistoryEntryExt;

    value(): void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LedgerHeaderHistoryEntryExt;

    static write(value: LedgerHeaderHistoryEntryExt, io: Buffer): void;

    static isValid(value: LedgerHeaderHistoryEntryExt): boolean;

    static toXDR(value: LedgerHeaderHistoryEntryExt): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): LedgerHeaderHistoryEntryExt;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): LedgerHeaderHistoryEntryExt;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScpHistoryEntry {
    switch(): number;

    v0(value?: ScpHistoryEntryV0): ScpHistoryEntryV0;

    static 0(value: ScpHistoryEntryV0): ScpHistoryEntry;

    value(): ScpHistoryEntryV0;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScpHistoryEntry;

    static write(value: ScpHistoryEntry, io: Buffer): void;

    static isValid(value: ScpHistoryEntry): boolean;

    static toXDR(value: ScpHistoryEntry): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScpHistoryEntry;

    static fromXDR(input: string, format: 'hex' | 'base64'): ScpHistoryEntry;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LedgerEntryChange {
    switch(): LedgerEntryChangeType;

    created(value?: LedgerEntry): LedgerEntry;

    updated(value?: LedgerEntry): LedgerEntry;

    removed(value?: LedgerKey): LedgerKey;

    state(value?: LedgerEntry): LedgerEntry;

    static ledgerEntryCreated(value: LedgerEntry): LedgerEntryChange;

    static ledgerEntryUpdated(value: LedgerEntry): LedgerEntryChange;

    static ledgerEntryRemoved(value: LedgerKey): LedgerEntryChange;

    static ledgerEntryState(value: LedgerEntry): LedgerEntryChange;

    value(): LedgerEntry | LedgerEntry | LedgerKey | LedgerEntry;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LedgerEntryChange;

    static write(value: LedgerEntryChange, io: Buffer): void;

    static isValid(value: LedgerEntryChange): boolean;

    static toXDR(value: LedgerEntryChange): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): LedgerEntryChange;

    static fromXDR(input: string, format: 'hex' | 'base64'): LedgerEntryChange;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ContractEventBody {
    switch(): number;

    v0(value?: ContractEventV0): ContractEventV0;

    static 0(value: ContractEventV0): ContractEventBody;

    value(): ContractEventV0;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ContractEventBody;

    static write(value: ContractEventBody, io: Buffer): void;

    static isValid(value: ContractEventBody): boolean;

    static toXDR(value: ContractEventBody): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ContractEventBody;

    static fromXDR(input: string, format: 'hex' | 'base64'): ContractEventBody;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class SorobanTransactionMetaExt {
    switch(): number;

    v1(value?: SorobanTransactionMetaExtV1): SorobanTransactionMetaExtV1;

    static 0(): SorobanTransactionMetaExt;

    static 1(value: SorobanTransactionMetaExtV1): SorobanTransactionMetaExt;

    value(): SorobanTransactionMetaExtV1 | void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): SorobanTransactionMetaExt;

    static write(value: SorobanTransactionMetaExt, io: Buffer): void;

    static isValid(value: SorobanTransactionMetaExt): boolean;

    static toXDR(value: SorobanTransactionMetaExt): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): SorobanTransactionMetaExt;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): SorobanTransactionMetaExt;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TransactionMeta {
    switch(): number;

    operations(value?: OperationMeta[]): OperationMeta[];

    v1(value?: TransactionMetaV1): TransactionMetaV1;

    v2(value?: TransactionMetaV2): TransactionMetaV2;

    v3(value?: TransactionMetaV3): TransactionMetaV3;

    static 0(value: OperationMeta[]): TransactionMeta;

    static 1(value: TransactionMetaV1): TransactionMeta;

    static 2(value: TransactionMetaV2): TransactionMeta;

    static 3(value: TransactionMetaV3): TransactionMeta;

    value():
      | OperationMeta[]
      | TransactionMetaV1
      | TransactionMetaV2
      | TransactionMetaV3;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TransactionMeta;

    static write(value: TransactionMeta, io: Buffer): void;

    static isValid(value: TransactionMeta): boolean;

    static toXDR(value: TransactionMeta): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): TransactionMeta;

    static fromXDR(input: string, format: 'hex' | 'base64'): TransactionMeta;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LedgerCloseMetaExt {
    switch(): number;

    v1(value?: LedgerCloseMetaExtV1): LedgerCloseMetaExtV1;

    static 0(): LedgerCloseMetaExt;

    static 1(value: LedgerCloseMetaExtV1): LedgerCloseMetaExt;

    value(): LedgerCloseMetaExtV1 | void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LedgerCloseMetaExt;

    static write(value: LedgerCloseMetaExt, io: Buffer): void;

    static isValid(value: LedgerCloseMetaExt): boolean;

    static toXDR(value: LedgerCloseMetaExt): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): LedgerCloseMetaExt;

    static fromXDR(input: string, format: 'hex' | 'base64'): LedgerCloseMetaExt;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LedgerCloseMeta {
    switch(): number;

    v0(value?: LedgerCloseMetaV0): LedgerCloseMetaV0;

    v1(value?: LedgerCloseMetaV1): LedgerCloseMetaV1;

    static 0(value: LedgerCloseMetaV0): LedgerCloseMeta;

    static 1(value: LedgerCloseMetaV1): LedgerCloseMeta;

    value(): LedgerCloseMetaV0 | LedgerCloseMetaV1;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LedgerCloseMeta;

    static write(value: LedgerCloseMeta, io: Buffer): void;

    static isValid(value: LedgerCloseMeta): boolean;

    static toXDR(value: LedgerCloseMeta): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): LedgerCloseMeta;

    static fromXDR(input: string, format: 'hex' | 'base64'): LedgerCloseMeta;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class PeerAddressIp {
    switch(): IpAddrType;

    ipv4(value?: Buffer): Buffer;

    ipv6(value?: Buffer): Buffer;

    static iPv4(value: Buffer): PeerAddressIp;

    static iPv6(value: Buffer): PeerAddressIp;

    value(): Buffer | Buffer;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): PeerAddressIp;

    static write(value: PeerAddressIp, io: Buffer): void;

    static isValid(value: PeerAddressIp): boolean;

    static toXDR(value: PeerAddressIp): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): PeerAddressIp;

    static fromXDR(input: string, format: 'hex' | 'base64'): PeerAddressIp;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class SurveyResponseBody {
    switch(): SurveyMessageResponseType;

    topologyResponseBodyV0(
      value?: TopologyResponseBodyV0,
    ): TopologyResponseBodyV0;

    topologyResponseBodyV1(
      value?: TopologyResponseBodyV1,
    ): TopologyResponseBodyV1;

    topologyResponseBodyV2(
      value?: TopologyResponseBodyV2,
    ): TopologyResponseBodyV2;

    static surveyTopologyResponseV0(
      value: TopologyResponseBodyV0,
    ): SurveyResponseBody;

    static surveyTopologyResponseV1(
      value: TopologyResponseBodyV1,
    ): SurveyResponseBody;

    static surveyTopologyResponseV2(
      value: TopologyResponseBodyV2,
    ): SurveyResponseBody;

    value():
      | TopologyResponseBodyV0
      | TopologyResponseBodyV1
      | TopologyResponseBodyV2;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): SurveyResponseBody;

    static write(value: SurveyResponseBody, io: Buffer): void;

    static isValid(value: SurveyResponseBody): boolean;

    static toXDR(value: SurveyResponseBody): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): SurveyResponseBody;

    static fromXDR(input: string, format: 'hex' | 'base64'): SurveyResponseBody;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class StellarMessage {
    switch(): MessageType;

    error(value?: Error): Error;

    hello(value?: Hello): Hello;

    auth(value?: Auth): Auth;

    dontHave(value?: DontHave): DontHave;

    peers(value?: PeerAddress[]): PeerAddress[];

    txSetHash(value?: Buffer): Buffer;

    txSet(value?: TransactionSet): TransactionSet;

    generalizedTxSet(
      value?: GeneralizedTransactionSet,
    ): GeneralizedTransactionSet;

    transaction(value?: TransactionEnvelope): TransactionEnvelope;

    signedSurveyRequestMessage(
      value?: SignedSurveyRequestMessage,
    ): SignedSurveyRequestMessage;

    signedSurveyResponseMessage(
      value?: SignedSurveyResponseMessage,
    ): SignedSurveyResponseMessage;

    signedTimeSlicedSurveyRequestMessage(
      value?: SignedTimeSlicedSurveyRequestMessage,
    ): SignedTimeSlicedSurveyRequestMessage;

    signedTimeSlicedSurveyResponseMessage(
      value?: SignedTimeSlicedSurveyResponseMessage,
    ): SignedTimeSlicedSurveyResponseMessage;

    signedTimeSlicedSurveyStartCollectingMessage(
      value?: SignedTimeSlicedSurveyStartCollectingMessage,
    ): SignedTimeSlicedSurveyStartCollectingMessage;

    signedTimeSlicedSurveyStopCollectingMessage(
      value?: SignedTimeSlicedSurveyStopCollectingMessage,
    ): SignedTimeSlicedSurveyStopCollectingMessage;

    qSetHash(value?: Buffer): Buffer;

    qSet(value?: ScpQuorumSet): ScpQuorumSet;

    envelope(value?: ScpEnvelope): ScpEnvelope;

    getScpLedgerSeq(value?: number): number;

    sendMoreMessage(value?: SendMore): SendMore;

    sendMoreExtendedMessage(value?: SendMoreExtended): SendMoreExtended;

    floodAdvert(value?: FloodAdvert): FloodAdvert;

    floodDemand(value?: FloodDemand): FloodDemand;

    static errorMsg(value: Error): StellarMessage;

    static hello(value: Hello): StellarMessage;

    static auth(value: Auth): StellarMessage;

    static dontHave(value: DontHave): StellarMessage;

    static getPeers(): StellarMessage;

    static peers(value: PeerAddress[]): StellarMessage;

    static getTxSet(value: Buffer): StellarMessage;

    static txSet(value: TransactionSet): StellarMessage;

    static generalizedTxSet(value: GeneralizedTransactionSet): StellarMessage;

    static transaction(value: TransactionEnvelope): StellarMessage;

    static surveyRequest(value: SignedSurveyRequestMessage): StellarMessage;

    static surveyResponse(value: SignedSurveyResponseMessage): StellarMessage;

    static timeSlicedSurveyRequest(
      value: SignedTimeSlicedSurveyRequestMessage,
    ): StellarMessage;

    static timeSlicedSurveyResponse(
      value: SignedTimeSlicedSurveyResponseMessage,
    ): StellarMessage;

    static timeSlicedSurveyStartCollecting(
      value: SignedTimeSlicedSurveyStartCollectingMessage,
    ): StellarMessage;

    static timeSlicedSurveyStopCollecting(
      value: SignedTimeSlicedSurveyStopCollectingMessage,
    ): StellarMessage;

    static getScpQuorumset(value: Buffer): StellarMessage;

    static scpQuorumset(value: ScpQuorumSet): StellarMessage;

    static scpMessage(value: ScpEnvelope): StellarMessage;

    static getScpState(value: number): StellarMessage;

    static sendMore(value: SendMore): StellarMessage;

    static sendMoreExtended(value: SendMoreExtended): StellarMessage;

    static floodAdvert(value: FloodAdvert): StellarMessage;

    static floodDemand(value: FloodDemand): StellarMessage;

    value():
      | Error
      | Hello
      | Auth
      | DontHave
      | PeerAddress[]
      | Buffer
      | TransactionSet
      | GeneralizedTransactionSet
      | TransactionEnvelope
      | SignedSurveyRequestMessage
      | SignedSurveyResponseMessage
      | SignedTimeSlicedSurveyRequestMessage
      | SignedTimeSlicedSurveyResponseMessage
      | SignedTimeSlicedSurveyStartCollectingMessage
      | SignedTimeSlicedSurveyStopCollectingMessage
      | Buffer
      | ScpQuorumSet
      | ScpEnvelope
      | number
      | SendMore
      | SendMoreExtended
      | FloodAdvert
      | FloodDemand
      | void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): StellarMessage;

    static write(value: StellarMessage, io: Buffer): void;

    static isValid(value: StellarMessage): boolean;

    static toXDR(value: StellarMessage): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): StellarMessage;

    static fromXDR(input: string, format: 'hex' | 'base64'): StellarMessage;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class AuthenticatedMessage {
    switch(): number;

    v0(value?: AuthenticatedMessageV0): AuthenticatedMessageV0;

    static 0(value: AuthenticatedMessageV0): AuthenticatedMessage;

    value(): AuthenticatedMessageV0;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): AuthenticatedMessage;

    static write(value: AuthenticatedMessage, io: Buffer): void;

    static isValid(value: AuthenticatedMessage): boolean;

    static toXDR(value: AuthenticatedMessage): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): AuthenticatedMessage;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): AuthenticatedMessage;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LiquidityPoolParameters {
    switch(): LiquidityPoolType;

    constantProduct(
      value?: LiquidityPoolConstantProductParameters,
    ): LiquidityPoolConstantProductParameters;

    static liquidityPoolConstantProduct(
      value: LiquidityPoolConstantProductParameters,
    ): LiquidityPoolParameters;

    value(): LiquidityPoolConstantProductParameters;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LiquidityPoolParameters;

    static write(value: LiquidityPoolParameters, io: Buffer): void;

    static isValid(value: LiquidityPoolParameters): boolean;

    static toXDR(value: LiquidityPoolParameters): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): LiquidityPoolParameters;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): LiquidityPoolParameters;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class MuxedAccount {
    switch(): CryptoKeyType;

    ed25519(value?: Buffer): Buffer;

    med25519(value?: MuxedAccountMed25519): MuxedAccountMed25519;

    static keyTypeEd25519(value: Buffer): MuxedAccount;

    static keyTypeMuxedEd25519(value: MuxedAccountMed25519): MuxedAccount;

    value(): Buffer | MuxedAccountMed25519;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): MuxedAccount;

    static write(value: MuxedAccount, io: Buffer): void;

    static isValid(value: MuxedAccount): boolean;

    static toXDR(value: MuxedAccount): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): MuxedAccount;

    static fromXDR(input: string, format: 'hex' | 'base64'): MuxedAccount;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ChangeTrustAsset {
    switch(): AssetType;

    alphaNum4(value?: AlphaNum4): AlphaNum4;

    alphaNum12(value?: AlphaNum12): AlphaNum12;

    liquidityPool(value?: LiquidityPoolParameters): LiquidityPoolParameters;

    static assetTypeNative(): ChangeTrustAsset;

    static assetTypeCreditAlphanum4(value: AlphaNum4): ChangeTrustAsset;

    static assetTypeCreditAlphanum12(value: AlphaNum12): ChangeTrustAsset;

    static assetTypePoolShare(value: LiquidityPoolParameters): ChangeTrustAsset;

    value(): AlphaNum4 | AlphaNum12 | LiquidityPoolParameters | void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ChangeTrustAsset;

    static write(value: ChangeTrustAsset, io: Buffer): void;

    static isValid(value: ChangeTrustAsset): boolean;

    static toXDR(value: ChangeTrustAsset): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ChangeTrustAsset;

    static fromXDR(input: string, format: 'hex' | 'base64'): ChangeTrustAsset;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class RevokeSponsorshipOp {
    switch(): RevokeSponsorshipType;

    ledgerKey(value?: LedgerKey): LedgerKey;

    signer(value?: RevokeSponsorshipOpSigner): RevokeSponsorshipOpSigner;

    static revokeSponsorshipLedgerEntry(value: LedgerKey): RevokeSponsorshipOp;

    static revokeSponsorshipSigner(
      value: RevokeSponsorshipOpSigner,
    ): RevokeSponsorshipOp;

    value(): LedgerKey | RevokeSponsorshipOpSigner;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): RevokeSponsorshipOp;

    static write(value: RevokeSponsorshipOp, io: Buffer): void;

    static isValid(value: RevokeSponsorshipOp): boolean;

    static toXDR(value: RevokeSponsorshipOp): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): RevokeSponsorshipOp;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): RevokeSponsorshipOp;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ContractIdPreimage {
    switch(): ContractIdPreimageType;

    fromAddress(
      value?: ContractIdPreimageFromAddress,
    ): ContractIdPreimageFromAddress;

    fromAsset(value?: Asset): Asset;

    static contractIdPreimageFromAddress(
      value: ContractIdPreimageFromAddress,
    ): ContractIdPreimage;

    static contractIdPreimageFromAsset(value: Asset): ContractIdPreimage;

    value(): ContractIdPreimageFromAddress | Asset;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ContractIdPreimage;

    static write(value: ContractIdPreimage, io: Buffer): void;

    static isValid(value: ContractIdPreimage): boolean;

    static toXDR(value: ContractIdPreimage): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ContractIdPreimage;

    static fromXDR(input: string, format: 'hex' | 'base64'): ContractIdPreimage;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class HostFunction {
    switch(): HostFunctionType;

    invokeContract(value?: InvokeContractArgs): InvokeContractArgs;

    createContract(value?: CreateContractArgs): CreateContractArgs;

    wasm(value?: Buffer): Buffer;

    createContractV2(value?: CreateContractArgsV2): CreateContractArgsV2;

    static hostFunctionTypeInvokeContract(
      value: InvokeContractArgs,
    ): HostFunction;

    static hostFunctionTypeCreateContract(
      value: CreateContractArgs,
    ): HostFunction;

    static hostFunctionTypeUploadContractWasm(value: Buffer): HostFunction;

    static hostFunctionTypeCreateContractV2(
      value: CreateContractArgsV2,
    ): HostFunction;

    value():
      | InvokeContractArgs
      | CreateContractArgs
      | Buffer
      | CreateContractArgsV2;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): HostFunction;

    static write(value: HostFunction, io: Buffer): void;

    static isValid(value: HostFunction): boolean;

    static toXDR(value: HostFunction): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): HostFunction;

    static fromXDR(input: string, format: 'hex' | 'base64'): HostFunction;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class SorobanAuthorizedFunction {
    switch(): SorobanAuthorizedFunctionType;

    contractFn(value?: InvokeContractArgs): InvokeContractArgs;

    createContractHostFn(value?: CreateContractArgs): CreateContractArgs;

    createContractV2HostFn(value?: CreateContractArgsV2): CreateContractArgsV2;

    static sorobanAuthorizedFunctionTypeContractFn(
      value: InvokeContractArgs,
    ): SorobanAuthorizedFunction;

    static sorobanAuthorizedFunctionTypeCreateContractHostFn(
      value: CreateContractArgs,
    ): SorobanAuthorizedFunction;

    static sorobanAuthorizedFunctionTypeCreateContractV2HostFn(
      value: CreateContractArgsV2,
    ): SorobanAuthorizedFunction;

    value(): InvokeContractArgs | CreateContractArgs | CreateContractArgsV2;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): SorobanAuthorizedFunction;

    static write(value: SorobanAuthorizedFunction, io: Buffer): void;

    static isValid(value: SorobanAuthorizedFunction): boolean;

    static toXDR(value: SorobanAuthorizedFunction): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): SorobanAuthorizedFunction;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): SorobanAuthorizedFunction;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class SorobanCredentials {
    switch(): SorobanCredentialsType;

    address(value?: SorobanAddressCredentials): SorobanAddressCredentials;

    static sorobanCredentialsSourceAccount(): SorobanCredentials;

    static sorobanCredentialsAddress(
      value: SorobanAddressCredentials,
    ): SorobanCredentials;

    value(): SorobanAddressCredentials | void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): SorobanCredentials;

    static write(value: SorobanCredentials, io: Buffer): void;

    static isValid(value: SorobanCredentials): boolean;

    static toXDR(value: SorobanCredentials): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): SorobanCredentials;

    static fromXDR(input: string, format: 'hex' | 'base64'): SorobanCredentials;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class OperationBody {
    switch(): OperationType;

    createAccountOp(value?: CreateAccountOp): CreateAccountOp;

    paymentOp(value?: PaymentOp): PaymentOp;

    pathPaymentStrictReceiveOp(
      value?: PathPaymentStrictReceiveOp,
    ): PathPaymentStrictReceiveOp;

    manageSellOfferOp(value?: ManageSellOfferOp): ManageSellOfferOp;

    createPassiveSellOfferOp(
      value?: CreatePassiveSellOfferOp,
    ): CreatePassiveSellOfferOp;

    setOptionsOp(value?: SetOptionsOp): SetOptionsOp;

    changeTrustOp(value?: ChangeTrustOp): ChangeTrustOp;

    allowTrustOp(value?: AllowTrustOp): AllowTrustOp;

    destination(value?: MuxedAccount): MuxedAccount;

    manageDataOp(value?: ManageDataOp): ManageDataOp;

    bumpSequenceOp(value?: BumpSequenceOp): BumpSequenceOp;

    manageBuyOfferOp(value?: ManageBuyOfferOp): ManageBuyOfferOp;

    pathPaymentStrictSendOp(
      value?: PathPaymentStrictSendOp,
    ): PathPaymentStrictSendOp;

    createClaimableBalanceOp(
      value?: CreateClaimableBalanceOp,
    ): CreateClaimableBalanceOp;

    claimClaimableBalanceOp(
      value?: ClaimClaimableBalanceOp,
    ): ClaimClaimableBalanceOp;

    beginSponsoringFutureReservesOp(
      value?: BeginSponsoringFutureReservesOp,
    ): BeginSponsoringFutureReservesOp;

    revokeSponsorshipOp(value?: RevokeSponsorshipOp): RevokeSponsorshipOp;

    clawbackOp(value?: ClawbackOp): ClawbackOp;

    clawbackClaimableBalanceOp(
      value?: ClawbackClaimableBalanceOp,
    ): ClawbackClaimableBalanceOp;

    setTrustLineFlagsOp(value?: SetTrustLineFlagsOp): SetTrustLineFlagsOp;

    liquidityPoolDepositOp(
      value?: LiquidityPoolDepositOp,
    ): LiquidityPoolDepositOp;

    liquidityPoolWithdrawOp(
      value?: LiquidityPoolWithdrawOp,
    ): LiquidityPoolWithdrawOp;

    invokeHostFunctionOp(value?: InvokeHostFunctionOp): InvokeHostFunctionOp;

    extendFootprintTtlOp(value?: ExtendFootprintTtlOp): ExtendFootprintTtlOp;

    restoreFootprintOp(value?: RestoreFootprintOp): RestoreFootprintOp;

    static createAccount(value: CreateAccountOp): OperationBody;

    static payment(value: PaymentOp): OperationBody;

    static pathPaymentStrictReceive(
      value: PathPaymentStrictReceiveOp,
    ): OperationBody;

    static manageSellOffer(value: ManageSellOfferOp): OperationBody;

    static createPassiveSellOffer(
      value: CreatePassiveSellOfferOp,
    ): OperationBody;

    static setOptions(value: SetOptionsOp): OperationBody;

    static changeTrust(value: ChangeTrustOp): OperationBody;

    static allowTrust(value: AllowTrustOp): OperationBody;

    static accountMerge(value: MuxedAccount): OperationBody;

    static inflation(): OperationBody;

    static manageData(value: ManageDataOp): OperationBody;

    static bumpSequence(value: BumpSequenceOp): OperationBody;

    static manageBuyOffer(value: ManageBuyOfferOp): OperationBody;

    static pathPaymentStrictSend(value: PathPaymentStrictSendOp): OperationBody;

    static createClaimableBalance(
      value: CreateClaimableBalanceOp,
    ): OperationBody;

    static claimClaimableBalance(value: ClaimClaimableBalanceOp): OperationBody;

    static beginSponsoringFutureReserves(
      value: BeginSponsoringFutureReservesOp,
    ): OperationBody;

    static endSponsoringFutureReserves(): OperationBody;

    static revokeSponsorship(value: RevokeSponsorshipOp): OperationBody;

    static clawback(value: ClawbackOp): OperationBody;

    static clawbackClaimableBalance(
      value: ClawbackClaimableBalanceOp,
    ): OperationBody;

    static setTrustLineFlags(value: SetTrustLineFlagsOp): OperationBody;

    static liquidityPoolDeposit(value: LiquidityPoolDepositOp): OperationBody;

    static liquidityPoolWithdraw(value: LiquidityPoolWithdrawOp): OperationBody;

    static invokeHostFunction(value: InvokeHostFunctionOp): OperationBody;

    static extendFootprintTtl(value: ExtendFootprintTtlOp): OperationBody;

    static restoreFootprint(value: RestoreFootprintOp): OperationBody;

    value():
      | CreateAccountOp
      | PaymentOp
      | PathPaymentStrictReceiveOp
      | ManageSellOfferOp
      | CreatePassiveSellOfferOp
      | SetOptionsOp
      | ChangeTrustOp
      | AllowTrustOp
      | MuxedAccount
      | ManageDataOp
      | BumpSequenceOp
      | ManageBuyOfferOp
      | PathPaymentStrictSendOp
      | CreateClaimableBalanceOp
      | ClaimClaimableBalanceOp
      | BeginSponsoringFutureReservesOp
      | RevokeSponsorshipOp
      | ClawbackOp
      | ClawbackClaimableBalanceOp
      | SetTrustLineFlagsOp
      | LiquidityPoolDepositOp
      | LiquidityPoolWithdrawOp
      | InvokeHostFunctionOp
      | ExtendFootprintTtlOp
      | RestoreFootprintOp
      | void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): OperationBody;

    static write(value: OperationBody, io: Buffer): void;

    static isValid(value: OperationBody): boolean;

    static toXDR(value: OperationBody): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): OperationBody;

    static fromXDR(input: string, format: 'hex' | 'base64'): OperationBody;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class HashIdPreimage {
    switch(): EnvelopeType;

    operationId(value?: HashIdPreimageOperationId): HashIdPreimageOperationId;

    revokeId(value?: HashIdPreimageRevokeId): HashIdPreimageRevokeId;

    contractId(value?: HashIdPreimageContractId): HashIdPreimageContractId;

    sorobanAuthorization(
      value?: HashIdPreimageSorobanAuthorization,
    ): HashIdPreimageSorobanAuthorization;

    static envelopeTypeOpId(value: HashIdPreimageOperationId): HashIdPreimage;

    static envelopeTypePoolRevokeOpId(
      value: HashIdPreimageRevokeId,
    ): HashIdPreimage;

    static envelopeTypeContractId(
      value: HashIdPreimageContractId,
    ): HashIdPreimage;

    static envelopeTypeSorobanAuthorization(
      value: HashIdPreimageSorobanAuthorization,
    ): HashIdPreimage;

    value():
      | HashIdPreimageOperationId
      | HashIdPreimageRevokeId
      | HashIdPreimageContractId
      | HashIdPreimageSorobanAuthorization;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): HashIdPreimage;

    static write(value: HashIdPreimage, io: Buffer): void;

    static isValid(value: HashIdPreimage): boolean;

    static toXDR(value: HashIdPreimage): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): HashIdPreimage;

    static fromXDR(input: string, format: 'hex' | 'base64'): HashIdPreimage;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class Memo {
    switch(): MemoType;

    text(value?: string | Buffer): string | Buffer;

    id(value?: Uint64): Uint64;

    hash(value?: Buffer): Buffer;

    retHash(value?: Buffer): Buffer;

    static memoNone(): Memo;

    static memoText(value: string | Buffer): Memo;

    static memoId(value: Uint64): Memo;

    static memoHash(value: Buffer): Memo;

    static memoReturn(value: Buffer): Memo;

    value(): string | Buffer | Uint64 | Buffer | Buffer | void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): Memo;

    static write(value: Memo, io: Buffer): void;

    static isValid(value: Memo): boolean;

    static toXDR(value: Memo): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): Memo;

    static fromXDR(input: string, format: 'hex' | 'base64'): Memo;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class Preconditions {
    switch(): PreconditionType;

    timeBounds(value?: TimeBounds): TimeBounds;

    v2(value?: PreconditionsV2): PreconditionsV2;

    static precondNone(): Preconditions;

    static precondTime(value: TimeBounds): Preconditions;

    static precondV2(value: PreconditionsV2): Preconditions;

    value(): TimeBounds | PreconditionsV2 | void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): Preconditions;

    static write(value: Preconditions, io: Buffer): void;

    static isValid(value: Preconditions): boolean;

    static toXDR(value: Preconditions): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): Preconditions;

    static fromXDR(input: string, format: 'hex' | 'base64'): Preconditions;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ArchivalProofBody {
    switch(): ArchivalProofType;

    nonexistenceProof(value?: NonexistenceProofBody): NonexistenceProofBody;

    existenceProof(value?: ExistenceProofBody): ExistenceProofBody;

    static existence(value: NonexistenceProofBody): ArchivalProofBody;

    static nonexistence(value: ExistenceProofBody): ArchivalProofBody;

    value(): NonexistenceProofBody | ExistenceProofBody;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ArchivalProofBody;

    static write(value: ArchivalProofBody, io: Buffer): void;

    static isValid(value: ArchivalProofBody): boolean;

    static toXDR(value: ArchivalProofBody): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ArchivalProofBody;

    static fromXDR(input: string, format: 'hex' | 'base64'): ArchivalProofBody;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class SorobanTransactionDataExt {
    switch(): number;

    proofs(value?: ArchivalProof[]): ArchivalProof[];

    static 0(): SorobanTransactionDataExt;

    static 1(value: ArchivalProof[]): SorobanTransactionDataExt;

    value(): ArchivalProof[] | void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): SorobanTransactionDataExt;

    static write(value: SorobanTransactionDataExt, io: Buffer): void;

    static isValid(value: SorobanTransactionDataExt): boolean;

    static toXDR(value: SorobanTransactionDataExt): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): SorobanTransactionDataExt;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): SorobanTransactionDataExt;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TransactionV0Ext {
    switch(): number;

    static 0(): TransactionV0Ext;

    value(): void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TransactionV0Ext;

    static write(value: TransactionV0Ext, io: Buffer): void;

    static isValid(value: TransactionV0Ext): boolean;

    static toXDR(value: TransactionV0Ext): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): TransactionV0Ext;

    static fromXDR(input: string, format: 'hex' | 'base64'): TransactionV0Ext;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TransactionExt {
    switch(): number;

    sorobanData(value?: SorobanTransactionData): SorobanTransactionData;

    static 0(): TransactionExt;

    static 1(value: SorobanTransactionData): TransactionExt;

    value(): SorobanTransactionData | void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TransactionExt;

    static write(value: TransactionExt, io: Buffer): void;

    static isValid(value: TransactionExt): boolean;

    static toXDR(value: TransactionExt): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): TransactionExt;

    static fromXDR(input: string, format: 'hex' | 'base64'): TransactionExt;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class FeeBumpTransactionInnerTx {
    switch(): EnvelopeType;

    v1(value?: TransactionV1Envelope): TransactionV1Envelope;

    static envelopeTypeTx(
      value: TransactionV1Envelope,
    ): FeeBumpTransactionInnerTx;

    value(): TransactionV1Envelope;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): FeeBumpTransactionInnerTx;

    static write(value: FeeBumpTransactionInnerTx, io: Buffer): void;

    static isValid(value: FeeBumpTransactionInnerTx): boolean;

    static toXDR(value: FeeBumpTransactionInnerTx): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): FeeBumpTransactionInnerTx;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): FeeBumpTransactionInnerTx;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class FeeBumpTransactionExt {
    switch(): number;

    static 0(): FeeBumpTransactionExt;

    value(): void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): FeeBumpTransactionExt;

    static write(value: FeeBumpTransactionExt, io: Buffer): void;

    static isValid(value: FeeBumpTransactionExt): boolean;

    static toXDR(value: FeeBumpTransactionExt): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): FeeBumpTransactionExt;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): FeeBumpTransactionExt;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TransactionEnvelope {
    switch(): EnvelopeType;

    v0(value?: TransactionV0Envelope): TransactionV0Envelope;

    v1(value?: TransactionV1Envelope): TransactionV1Envelope;

    feeBump(value?: FeeBumpTransactionEnvelope): FeeBumpTransactionEnvelope;

    static envelopeTypeTxV0(value: TransactionV0Envelope): TransactionEnvelope;

    static envelopeTypeTx(value: TransactionV1Envelope): TransactionEnvelope;

    static envelopeTypeTxFeeBump(
      value: FeeBumpTransactionEnvelope,
    ): TransactionEnvelope;

    value():
      | TransactionV0Envelope
      | TransactionV1Envelope
      | FeeBumpTransactionEnvelope;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TransactionEnvelope;

    static write(value: TransactionEnvelope, io: Buffer): void;

    static isValid(value: TransactionEnvelope): boolean;

    static toXDR(value: TransactionEnvelope): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): TransactionEnvelope;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): TransactionEnvelope;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TransactionSignaturePayloadTaggedTransaction {
    switch(): EnvelopeType;

    tx(value?: Transaction): Transaction;

    feeBump(value?: FeeBumpTransaction): FeeBumpTransaction;

    static envelopeTypeTx(
      value: Transaction,
    ): TransactionSignaturePayloadTaggedTransaction;

    static envelopeTypeTxFeeBump(
      value: FeeBumpTransaction,
    ): TransactionSignaturePayloadTaggedTransaction;

    value(): Transaction | FeeBumpTransaction;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TransactionSignaturePayloadTaggedTransaction;

    static write(
      value: TransactionSignaturePayloadTaggedTransaction,
      io: Buffer,
    ): void;

    static isValid(
      value: TransactionSignaturePayloadTaggedTransaction,
    ): boolean;

    static toXDR(value: TransactionSignaturePayloadTaggedTransaction): Buffer;

    static fromXDR(
      input: Buffer,
      format?: 'raw',
    ): TransactionSignaturePayloadTaggedTransaction;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): TransactionSignaturePayloadTaggedTransaction;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ClaimAtom {
    switch(): ClaimAtomType;

    v0(value?: ClaimOfferAtomV0): ClaimOfferAtomV0;

    orderBook(value?: ClaimOfferAtom): ClaimOfferAtom;

    liquidityPool(value?: ClaimLiquidityAtom): ClaimLiquidityAtom;

    static claimAtomTypeV0(value: ClaimOfferAtomV0): ClaimAtom;

    static claimAtomTypeOrderBook(value: ClaimOfferAtom): ClaimAtom;

    static claimAtomTypeLiquidityPool(value: ClaimLiquidityAtom): ClaimAtom;

    value(): ClaimOfferAtomV0 | ClaimOfferAtom | ClaimLiquidityAtom;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ClaimAtom;

    static write(value: ClaimAtom, io: Buffer): void;

    static isValid(value: ClaimAtom): boolean;

    static toXDR(value: ClaimAtom): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ClaimAtom;

    static fromXDR(input: string, format: 'hex' | 'base64'): ClaimAtom;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class CreateAccountResult {
    switch(): CreateAccountResultCode;

    static createAccountSuccess(): CreateAccountResult;

    static createAccountMalformed(): CreateAccountResult;

    static createAccountUnderfunded(): CreateAccountResult;

    static createAccountLowReserve(): CreateAccountResult;

    static createAccountAlreadyExist(): CreateAccountResult;

    value(): void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): CreateAccountResult;

    static write(value: CreateAccountResult, io: Buffer): void;

    static isValid(value: CreateAccountResult): boolean;

    static toXDR(value: CreateAccountResult): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): CreateAccountResult;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): CreateAccountResult;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class PaymentResult {
    switch(): PaymentResultCode;

    static paymentSuccess(): PaymentResult;

    static paymentMalformed(): PaymentResult;

    static paymentUnderfunded(): PaymentResult;

    static paymentSrcNoTrust(): PaymentResult;

    static paymentSrcNotAuthorized(): PaymentResult;

    static paymentNoDestination(): PaymentResult;

    static paymentNoTrust(): PaymentResult;

    static paymentNotAuthorized(): PaymentResult;

    static paymentLineFull(): PaymentResult;

    static paymentNoIssuer(): PaymentResult;

    value(): void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): PaymentResult;

    static write(value: PaymentResult, io: Buffer): void;

    static isValid(value: PaymentResult): boolean;

    static toXDR(value: PaymentResult): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): PaymentResult;

    static fromXDR(input: string, format: 'hex' | 'base64'): PaymentResult;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class PathPaymentStrictReceiveResult {
    switch(): PathPaymentStrictReceiveResultCode;

    success(
      value?: PathPaymentStrictReceiveResultSuccess,
    ): PathPaymentStrictReceiveResultSuccess;

    noIssuer(value?: Asset): Asset;

    static pathPaymentStrictReceiveSuccess(
      value: PathPaymentStrictReceiveResultSuccess,
    ): PathPaymentStrictReceiveResult;

    static pathPaymentStrictReceiveMalformed(): PathPaymentStrictReceiveResult;

    static pathPaymentStrictReceiveUnderfunded(): PathPaymentStrictReceiveResult;

    static pathPaymentStrictReceiveSrcNoTrust(): PathPaymentStrictReceiveResult;

    static pathPaymentStrictReceiveSrcNotAuthorized(): PathPaymentStrictReceiveResult;

    static pathPaymentStrictReceiveNoDestination(): PathPaymentStrictReceiveResult;

    static pathPaymentStrictReceiveNoTrust(): PathPaymentStrictReceiveResult;

    static pathPaymentStrictReceiveNotAuthorized(): PathPaymentStrictReceiveResult;

    static pathPaymentStrictReceiveLineFull(): PathPaymentStrictReceiveResult;

    static pathPaymentStrictReceiveNoIssuer(
      value: Asset,
    ): PathPaymentStrictReceiveResult;

    static pathPaymentStrictReceiveTooFewOffers(): PathPaymentStrictReceiveResult;

    static pathPaymentStrictReceiveOfferCrossSelf(): PathPaymentStrictReceiveResult;

    static pathPaymentStrictReceiveOverSendmax(): PathPaymentStrictReceiveResult;

    value(): PathPaymentStrictReceiveResultSuccess | Asset | void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): PathPaymentStrictReceiveResult;

    static write(value: PathPaymentStrictReceiveResult, io: Buffer): void;

    static isValid(value: PathPaymentStrictReceiveResult): boolean;

    static toXDR(value: PathPaymentStrictReceiveResult): Buffer;

    static fromXDR(
      input: Buffer,
      format?: 'raw',
    ): PathPaymentStrictReceiveResult;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): PathPaymentStrictReceiveResult;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class PathPaymentStrictSendResult {
    switch(): PathPaymentStrictSendResultCode;

    success(
      value?: PathPaymentStrictSendResultSuccess,
    ): PathPaymentStrictSendResultSuccess;

    noIssuer(value?: Asset): Asset;

    static pathPaymentStrictSendSuccess(
      value: PathPaymentStrictSendResultSuccess,
    ): PathPaymentStrictSendResult;

    static pathPaymentStrictSendMalformed(): PathPaymentStrictSendResult;

    static pathPaymentStrictSendUnderfunded(): PathPaymentStrictSendResult;

    static pathPaymentStrictSendSrcNoTrust(): PathPaymentStrictSendResult;

    static pathPaymentStrictSendSrcNotAuthorized(): PathPaymentStrictSendResult;

    static pathPaymentStrictSendNoDestination(): PathPaymentStrictSendResult;

    static pathPaymentStrictSendNoTrust(): PathPaymentStrictSendResult;

    static pathPaymentStrictSendNotAuthorized(): PathPaymentStrictSendResult;

    static pathPaymentStrictSendLineFull(): PathPaymentStrictSendResult;

    static pathPaymentStrictSendNoIssuer(
      value: Asset,
    ): PathPaymentStrictSendResult;

    static pathPaymentStrictSendTooFewOffers(): PathPaymentStrictSendResult;

    static pathPaymentStrictSendOfferCrossSelf(): PathPaymentStrictSendResult;

    static pathPaymentStrictSendUnderDestmin(): PathPaymentStrictSendResult;

    value(): PathPaymentStrictSendResultSuccess | Asset | void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): PathPaymentStrictSendResult;

    static write(value: PathPaymentStrictSendResult, io: Buffer): void;

    static isValid(value: PathPaymentStrictSendResult): boolean;

    static toXDR(value: PathPaymentStrictSendResult): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): PathPaymentStrictSendResult;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): PathPaymentStrictSendResult;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ManageOfferSuccessResultOffer {
    switch(): ManageOfferEffect;

    offer(value?: OfferEntry): OfferEntry;

    static manageOfferCreated(value: OfferEntry): ManageOfferSuccessResultOffer;

    static manageOfferUpdated(value: OfferEntry): ManageOfferSuccessResultOffer;

    static manageOfferDeleted(): ManageOfferSuccessResultOffer;

    value(): OfferEntry | void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ManageOfferSuccessResultOffer;

    static write(value: ManageOfferSuccessResultOffer, io: Buffer): void;

    static isValid(value: ManageOfferSuccessResultOffer): boolean;

    static toXDR(value: ManageOfferSuccessResultOffer): Buffer;

    static fromXDR(
      input: Buffer,
      format?: 'raw',
    ): ManageOfferSuccessResultOffer;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ManageOfferSuccessResultOffer;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ManageSellOfferResult {
    switch(): ManageSellOfferResultCode;

    success(value?: ManageOfferSuccessResult): ManageOfferSuccessResult;

    static manageSellOfferSuccess(
      value: ManageOfferSuccessResult,
    ): ManageSellOfferResult;

    static manageSellOfferMalformed(): ManageSellOfferResult;

    static manageSellOfferSellNoTrust(): ManageSellOfferResult;

    static manageSellOfferBuyNoTrust(): ManageSellOfferResult;

    static manageSellOfferSellNotAuthorized(): ManageSellOfferResult;

    static manageSellOfferBuyNotAuthorized(): ManageSellOfferResult;

    static manageSellOfferLineFull(): ManageSellOfferResult;

    static manageSellOfferUnderfunded(): ManageSellOfferResult;

    static manageSellOfferCrossSelf(): ManageSellOfferResult;

    static manageSellOfferSellNoIssuer(): ManageSellOfferResult;

    static manageSellOfferBuyNoIssuer(): ManageSellOfferResult;

    static manageSellOfferNotFound(): ManageSellOfferResult;

    static manageSellOfferLowReserve(): ManageSellOfferResult;

    value(): ManageOfferSuccessResult | void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ManageSellOfferResult;

    static write(value: ManageSellOfferResult, io: Buffer): void;

    static isValid(value: ManageSellOfferResult): boolean;

    static toXDR(value: ManageSellOfferResult): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ManageSellOfferResult;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ManageSellOfferResult;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ManageBuyOfferResult {
    switch(): ManageBuyOfferResultCode;

    success(value?: ManageOfferSuccessResult): ManageOfferSuccessResult;

    static manageBuyOfferSuccess(
      value: ManageOfferSuccessResult,
    ): ManageBuyOfferResult;

    static manageBuyOfferMalformed(): ManageBuyOfferResult;

    static manageBuyOfferSellNoTrust(): ManageBuyOfferResult;

    static manageBuyOfferBuyNoTrust(): ManageBuyOfferResult;

    static manageBuyOfferSellNotAuthorized(): ManageBuyOfferResult;

    static manageBuyOfferBuyNotAuthorized(): ManageBuyOfferResult;

    static manageBuyOfferLineFull(): ManageBuyOfferResult;

    static manageBuyOfferUnderfunded(): ManageBuyOfferResult;

    static manageBuyOfferCrossSelf(): ManageBuyOfferResult;

    static manageBuyOfferSellNoIssuer(): ManageBuyOfferResult;

    static manageBuyOfferBuyNoIssuer(): ManageBuyOfferResult;

    static manageBuyOfferNotFound(): ManageBuyOfferResult;

    static manageBuyOfferLowReserve(): ManageBuyOfferResult;

    value(): ManageOfferSuccessResult | void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ManageBuyOfferResult;

    static write(value: ManageBuyOfferResult, io: Buffer): void;

    static isValid(value: ManageBuyOfferResult): boolean;

    static toXDR(value: ManageBuyOfferResult): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ManageBuyOfferResult;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ManageBuyOfferResult;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class SetOptionsResult {
    switch(): SetOptionsResultCode;

    static setOptionsSuccess(): SetOptionsResult;

    static setOptionsLowReserve(): SetOptionsResult;

    static setOptionsTooManySigners(): SetOptionsResult;

    static setOptionsBadFlags(): SetOptionsResult;

    static setOptionsInvalidInflation(): SetOptionsResult;

    static setOptionsCantChange(): SetOptionsResult;

    static setOptionsUnknownFlag(): SetOptionsResult;

    static setOptionsThresholdOutOfRange(): SetOptionsResult;

    static setOptionsBadSigner(): SetOptionsResult;

    static setOptionsInvalidHomeDomain(): SetOptionsResult;

    static setOptionsAuthRevocableRequired(): SetOptionsResult;

    value(): void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): SetOptionsResult;

    static write(value: SetOptionsResult, io: Buffer): void;

    static isValid(value: SetOptionsResult): boolean;

    static toXDR(value: SetOptionsResult): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): SetOptionsResult;

    static fromXDR(input: string, format: 'hex' | 'base64'): SetOptionsResult;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ChangeTrustResult {
    switch(): ChangeTrustResultCode;

    static changeTrustSuccess(): ChangeTrustResult;

    static changeTrustMalformed(): ChangeTrustResult;

    static changeTrustNoIssuer(): ChangeTrustResult;

    static changeTrustInvalidLimit(): ChangeTrustResult;

    static changeTrustLowReserve(): ChangeTrustResult;

    static changeTrustSelfNotAllowed(): ChangeTrustResult;

    static changeTrustTrustLineMissing(): ChangeTrustResult;

    static changeTrustCannotDelete(): ChangeTrustResult;

    static changeTrustNotAuthMaintainLiabilities(): ChangeTrustResult;

    value(): void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ChangeTrustResult;

    static write(value: ChangeTrustResult, io: Buffer): void;

    static isValid(value: ChangeTrustResult): boolean;

    static toXDR(value: ChangeTrustResult): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ChangeTrustResult;

    static fromXDR(input: string, format: 'hex' | 'base64'): ChangeTrustResult;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class AllowTrustResult {
    switch(): AllowTrustResultCode;

    static allowTrustSuccess(): AllowTrustResult;

    static allowTrustMalformed(): AllowTrustResult;

    static allowTrustNoTrustLine(): AllowTrustResult;

    static allowTrustTrustNotRequired(): AllowTrustResult;

    static allowTrustCantRevoke(): AllowTrustResult;

    static allowTrustSelfNotAllowed(): AllowTrustResult;

    static allowTrustLowReserve(): AllowTrustResult;

    value(): void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): AllowTrustResult;

    static write(value: AllowTrustResult, io: Buffer): void;

    static isValid(value: AllowTrustResult): boolean;

    static toXDR(value: AllowTrustResult): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): AllowTrustResult;

    static fromXDR(input: string, format: 'hex' | 'base64'): AllowTrustResult;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class AccountMergeResult {
    switch(): AccountMergeResultCode;

    sourceAccountBalance(value?: Int64): Int64;

    static accountMergeSuccess(value: Int64): AccountMergeResult;

    static accountMergeMalformed(): AccountMergeResult;

    static accountMergeNoAccount(): AccountMergeResult;

    static accountMergeImmutableSet(): AccountMergeResult;

    static accountMergeHasSubEntries(): AccountMergeResult;

    static accountMergeSeqnumTooFar(): AccountMergeResult;

    static accountMergeDestFull(): AccountMergeResult;

    static accountMergeIsSponsor(): AccountMergeResult;

    value(): Int64 | void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): AccountMergeResult;

    static write(value: AccountMergeResult, io: Buffer): void;

    static isValid(value: AccountMergeResult): boolean;

    static toXDR(value: AccountMergeResult): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): AccountMergeResult;

    static fromXDR(input: string, format: 'hex' | 'base64'): AccountMergeResult;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class InflationResult {
    switch(): InflationResultCode;

    payouts(value?: InflationPayout[]): InflationPayout[];

    static inflationSuccess(value: InflationPayout[]): InflationResult;

    static inflationNotTime(): InflationResult;

    value(): InflationPayout[] | void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): InflationResult;

    static write(value: InflationResult, io: Buffer): void;

    static isValid(value: InflationResult): boolean;

    static toXDR(value: InflationResult): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): InflationResult;

    static fromXDR(input: string, format: 'hex' | 'base64'): InflationResult;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ManageDataResult {
    switch(): ManageDataResultCode;

    static manageDataSuccess(): ManageDataResult;

    static manageDataNotSupportedYet(): ManageDataResult;

    static manageDataNameNotFound(): ManageDataResult;

    static manageDataLowReserve(): ManageDataResult;

    static manageDataInvalidName(): ManageDataResult;

    value(): void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ManageDataResult;

    static write(value: ManageDataResult, io: Buffer): void;

    static isValid(value: ManageDataResult): boolean;

    static toXDR(value: ManageDataResult): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ManageDataResult;

    static fromXDR(input: string, format: 'hex' | 'base64'): ManageDataResult;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class BumpSequenceResult {
    switch(): BumpSequenceResultCode;

    static bumpSequenceSuccess(): BumpSequenceResult;

    static bumpSequenceBadSeq(): BumpSequenceResult;

    value(): void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): BumpSequenceResult;

    static write(value: BumpSequenceResult, io: Buffer): void;

    static isValid(value: BumpSequenceResult): boolean;

    static toXDR(value: BumpSequenceResult): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): BumpSequenceResult;

    static fromXDR(input: string, format: 'hex' | 'base64'): BumpSequenceResult;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class CreateClaimableBalanceResult {
    switch(): CreateClaimableBalanceResultCode;

    balanceId(value?: ClaimableBalanceId): ClaimableBalanceId;

    static createClaimableBalanceSuccess(
      value: ClaimableBalanceId,
    ): CreateClaimableBalanceResult;

    static createClaimableBalanceMalformed(): CreateClaimableBalanceResult;

    static createClaimableBalanceLowReserve(): CreateClaimableBalanceResult;

    static createClaimableBalanceNoTrust(): CreateClaimableBalanceResult;

    static createClaimableBalanceNotAuthorized(): CreateClaimableBalanceResult;

    static createClaimableBalanceUnderfunded(): CreateClaimableBalanceResult;

    value(): ClaimableBalanceId | void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): CreateClaimableBalanceResult;

    static write(value: CreateClaimableBalanceResult, io: Buffer): void;

    static isValid(value: CreateClaimableBalanceResult): boolean;

    static toXDR(value: CreateClaimableBalanceResult): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): CreateClaimableBalanceResult;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): CreateClaimableBalanceResult;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ClaimClaimableBalanceResult {
    switch(): ClaimClaimableBalanceResultCode;

    static claimClaimableBalanceSuccess(): ClaimClaimableBalanceResult;

    static claimClaimableBalanceDoesNotExist(): ClaimClaimableBalanceResult;

    static claimClaimableBalanceCannotClaim(): ClaimClaimableBalanceResult;

    static claimClaimableBalanceLineFull(): ClaimClaimableBalanceResult;

    static claimClaimableBalanceNoTrust(): ClaimClaimableBalanceResult;

    static claimClaimableBalanceNotAuthorized(): ClaimClaimableBalanceResult;

    value(): void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ClaimClaimableBalanceResult;

    static write(value: ClaimClaimableBalanceResult, io: Buffer): void;

    static isValid(value: ClaimClaimableBalanceResult): boolean;

    static toXDR(value: ClaimClaimableBalanceResult): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ClaimClaimableBalanceResult;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ClaimClaimableBalanceResult;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class BeginSponsoringFutureReservesResult {
    switch(): BeginSponsoringFutureReservesResultCode;

    static beginSponsoringFutureReservesSuccess(): BeginSponsoringFutureReservesResult;

    static beginSponsoringFutureReservesMalformed(): BeginSponsoringFutureReservesResult;

    static beginSponsoringFutureReservesAlreadySponsored(): BeginSponsoringFutureReservesResult;

    static beginSponsoringFutureReservesRecursive(): BeginSponsoringFutureReservesResult;

    value(): void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): BeginSponsoringFutureReservesResult;

    static write(value: BeginSponsoringFutureReservesResult, io: Buffer): void;

    static isValid(value: BeginSponsoringFutureReservesResult): boolean;

    static toXDR(value: BeginSponsoringFutureReservesResult): Buffer;

    static fromXDR(
      input: Buffer,
      format?: 'raw',
    ): BeginSponsoringFutureReservesResult;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): BeginSponsoringFutureReservesResult;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class EndSponsoringFutureReservesResult {
    switch(): EndSponsoringFutureReservesResultCode;

    static endSponsoringFutureReservesSuccess(): EndSponsoringFutureReservesResult;

    static endSponsoringFutureReservesNotSponsored(): EndSponsoringFutureReservesResult;

    value(): void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): EndSponsoringFutureReservesResult;

    static write(value: EndSponsoringFutureReservesResult, io: Buffer): void;

    static isValid(value: EndSponsoringFutureReservesResult): boolean;

    static toXDR(value: EndSponsoringFutureReservesResult): Buffer;

    static fromXDR(
      input: Buffer,
      format?: 'raw',
    ): EndSponsoringFutureReservesResult;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): EndSponsoringFutureReservesResult;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class RevokeSponsorshipResult {
    switch(): RevokeSponsorshipResultCode;

    static revokeSponsorshipSuccess(): RevokeSponsorshipResult;

    static revokeSponsorshipDoesNotExist(): RevokeSponsorshipResult;

    static revokeSponsorshipNotSponsor(): RevokeSponsorshipResult;

    static revokeSponsorshipLowReserve(): RevokeSponsorshipResult;

    static revokeSponsorshipOnlyTransferable(): RevokeSponsorshipResult;

    static revokeSponsorshipMalformed(): RevokeSponsorshipResult;

    value(): void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): RevokeSponsorshipResult;

    static write(value: RevokeSponsorshipResult, io: Buffer): void;

    static isValid(value: RevokeSponsorshipResult): boolean;

    static toXDR(value: RevokeSponsorshipResult): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): RevokeSponsorshipResult;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): RevokeSponsorshipResult;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ClawbackResult {
    switch(): ClawbackResultCode;

    static clawbackSuccess(): ClawbackResult;

    static clawbackMalformed(): ClawbackResult;

    static clawbackNotClawbackEnabled(): ClawbackResult;

    static clawbackNoTrust(): ClawbackResult;

    static clawbackUnderfunded(): ClawbackResult;

    value(): void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ClawbackResult;

    static write(value: ClawbackResult, io: Buffer): void;

    static isValid(value: ClawbackResult): boolean;

    static toXDR(value: ClawbackResult): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ClawbackResult;

    static fromXDR(input: string, format: 'hex' | 'base64'): ClawbackResult;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ClawbackClaimableBalanceResult {
    switch(): ClawbackClaimableBalanceResultCode;

    static clawbackClaimableBalanceSuccess(): ClawbackClaimableBalanceResult;

    static clawbackClaimableBalanceDoesNotExist(): ClawbackClaimableBalanceResult;

    static clawbackClaimableBalanceNotIssuer(): ClawbackClaimableBalanceResult;

    static clawbackClaimableBalanceNotClawbackEnabled(): ClawbackClaimableBalanceResult;

    value(): void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ClawbackClaimableBalanceResult;

    static write(value: ClawbackClaimableBalanceResult, io: Buffer): void;

    static isValid(value: ClawbackClaimableBalanceResult): boolean;

    static toXDR(value: ClawbackClaimableBalanceResult): Buffer;

    static fromXDR(
      input: Buffer,
      format?: 'raw',
    ): ClawbackClaimableBalanceResult;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ClawbackClaimableBalanceResult;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class SetTrustLineFlagsResult {
    switch(): SetTrustLineFlagsResultCode;

    static setTrustLineFlagsSuccess(): SetTrustLineFlagsResult;

    static setTrustLineFlagsMalformed(): SetTrustLineFlagsResult;

    static setTrustLineFlagsNoTrustLine(): SetTrustLineFlagsResult;

    static setTrustLineFlagsCantRevoke(): SetTrustLineFlagsResult;

    static setTrustLineFlagsInvalidState(): SetTrustLineFlagsResult;

    static setTrustLineFlagsLowReserve(): SetTrustLineFlagsResult;

    value(): void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): SetTrustLineFlagsResult;

    static write(value: SetTrustLineFlagsResult, io: Buffer): void;

    static isValid(value: SetTrustLineFlagsResult): boolean;

    static toXDR(value: SetTrustLineFlagsResult): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): SetTrustLineFlagsResult;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): SetTrustLineFlagsResult;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LiquidityPoolDepositResult {
    switch(): LiquidityPoolDepositResultCode;

    static liquidityPoolDepositSuccess(): LiquidityPoolDepositResult;

    static liquidityPoolDepositMalformed(): LiquidityPoolDepositResult;

    static liquidityPoolDepositNoTrust(): LiquidityPoolDepositResult;

    static liquidityPoolDepositNotAuthorized(): LiquidityPoolDepositResult;

    static liquidityPoolDepositUnderfunded(): LiquidityPoolDepositResult;

    static liquidityPoolDepositLineFull(): LiquidityPoolDepositResult;

    static liquidityPoolDepositBadPrice(): LiquidityPoolDepositResult;

    static liquidityPoolDepositPoolFull(): LiquidityPoolDepositResult;

    value(): void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LiquidityPoolDepositResult;

    static write(value: LiquidityPoolDepositResult, io: Buffer): void;

    static isValid(value: LiquidityPoolDepositResult): boolean;

    static toXDR(value: LiquidityPoolDepositResult): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): LiquidityPoolDepositResult;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): LiquidityPoolDepositResult;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class LiquidityPoolWithdrawResult {
    switch(): LiquidityPoolWithdrawResultCode;

    static liquidityPoolWithdrawSuccess(): LiquidityPoolWithdrawResult;

    static liquidityPoolWithdrawMalformed(): LiquidityPoolWithdrawResult;

    static liquidityPoolWithdrawNoTrust(): LiquidityPoolWithdrawResult;

    static liquidityPoolWithdrawUnderfunded(): LiquidityPoolWithdrawResult;

    static liquidityPoolWithdrawLineFull(): LiquidityPoolWithdrawResult;

    static liquidityPoolWithdrawUnderMinimum(): LiquidityPoolWithdrawResult;

    value(): void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): LiquidityPoolWithdrawResult;

    static write(value: LiquidityPoolWithdrawResult, io: Buffer): void;

    static isValid(value: LiquidityPoolWithdrawResult): boolean;

    static toXDR(value: LiquidityPoolWithdrawResult): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): LiquidityPoolWithdrawResult;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): LiquidityPoolWithdrawResult;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class InvokeHostFunctionResult {
    switch(): InvokeHostFunctionResultCode;

    success(value?: Buffer): Buffer;

    static invokeHostFunctionSuccess(value: Buffer): InvokeHostFunctionResult;

    static invokeHostFunctionMalformed(): InvokeHostFunctionResult;

    static invokeHostFunctionTrapped(): InvokeHostFunctionResult;

    static invokeHostFunctionResourceLimitExceeded(): InvokeHostFunctionResult;

    static invokeHostFunctionEntryArchived(): InvokeHostFunctionResult;

    static invokeHostFunctionInsufficientRefundableFee(): InvokeHostFunctionResult;

    value(): Buffer | void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): InvokeHostFunctionResult;

    static write(value: InvokeHostFunctionResult, io: Buffer): void;

    static isValid(value: InvokeHostFunctionResult): boolean;

    static toXDR(value: InvokeHostFunctionResult): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): InvokeHostFunctionResult;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): InvokeHostFunctionResult;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ExtendFootprintTtlResult {
    switch(): ExtendFootprintTtlResultCode;

    static extendFootprintTtlSuccess(): ExtendFootprintTtlResult;

    static extendFootprintTtlMalformed(): ExtendFootprintTtlResult;

    static extendFootprintTtlResourceLimitExceeded(): ExtendFootprintTtlResult;

    static extendFootprintTtlInsufficientRefundableFee(): ExtendFootprintTtlResult;

    value(): void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ExtendFootprintTtlResult;

    static write(value: ExtendFootprintTtlResult, io: Buffer): void;

    static isValid(value: ExtendFootprintTtlResult): boolean;

    static toXDR(value: ExtendFootprintTtlResult): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ExtendFootprintTtlResult;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ExtendFootprintTtlResult;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class RestoreFootprintResult {
    switch(): RestoreFootprintResultCode;

    static restoreFootprintSuccess(): RestoreFootprintResult;

    static restoreFootprintMalformed(): RestoreFootprintResult;

    static restoreFootprintResourceLimitExceeded(): RestoreFootprintResult;

    static restoreFootprintInsufficientRefundableFee(): RestoreFootprintResult;

    value(): void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): RestoreFootprintResult;

    static write(value: RestoreFootprintResult, io: Buffer): void;

    static isValid(value: RestoreFootprintResult): boolean;

    static toXDR(value: RestoreFootprintResult): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): RestoreFootprintResult;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): RestoreFootprintResult;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class OperationResultTr {
    switch(): OperationType;

    createAccountResult(value?: CreateAccountResult): CreateAccountResult;

    paymentResult(value?: PaymentResult): PaymentResult;

    pathPaymentStrictReceiveResult(
      value?: PathPaymentStrictReceiveResult,
    ): PathPaymentStrictReceiveResult;

    manageSellOfferResult(value?: ManageSellOfferResult): ManageSellOfferResult;

    createPassiveSellOfferResult(
      value?: ManageSellOfferResult,
    ): ManageSellOfferResult;

    setOptionsResult(value?: SetOptionsResult): SetOptionsResult;

    changeTrustResult(value?: ChangeTrustResult): ChangeTrustResult;

    allowTrustResult(value?: AllowTrustResult): AllowTrustResult;

    accountMergeResult(value?: AccountMergeResult): AccountMergeResult;

    inflationResult(value?: InflationResult): InflationResult;

    manageDataResult(value?: ManageDataResult): ManageDataResult;

    bumpSeqResult(value?: BumpSequenceResult): BumpSequenceResult;

    manageBuyOfferResult(value?: ManageBuyOfferResult): ManageBuyOfferResult;

    pathPaymentStrictSendResult(
      value?: PathPaymentStrictSendResult,
    ): PathPaymentStrictSendResult;

    createClaimableBalanceResult(
      value?: CreateClaimableBalanceResult,
    ): CreateClaimableBalanceResult;

    claimClaimableBalanceResult(
      value?: ClaimClaimableBalanceResult,
    ): ClaimClaimableBalanceResult;

    beginSponsoringFutureReservesResult(
      value?: BeginSponsoringFutureReservesResult,
    ): BeginSponsoringFutureReservesResult;

    endSponsoringFutureReservesResult(
      value?: EndSponsoringFutureReservesResult,
    ): EndSponsoringFutureReservesResult;

    revokeSponsorshipResult(
      value?: RevokeSponsorshipResult,
    ): RevokeSponsorshipResult;

    clawbackResult(value?: ClawbackResult): ClawbackResult;

    clawbackClaimableBalanceResult(
      value?: ClawbackClaimableBalanceResult,
    ): ClawbackClaimableBalanceResult;

    setTrustLineFlagsResult(
      value?: SetTrustLineFlagsResult,
    ): SetTrustLineFlagsResult;

    liquidityPoolDepositResult(
      value?: LiquidityPoolDepositResult,
    ): LiquidityPoolDepositResult;

    liquidityPoolWithdrawResult(
      value?: LiquidityPoolWithdrawResult,
    ): LiquidityPoolWithdrawResult;

    invokeHostFunctionResult(
      value?: InvokeHostFunctionResult,
    ): InvokeHostFunctionResult;

    extendFootprintTtlResult(
      value?: ExtendFootprintTtlResult,
    ): ExtendFootprintTtlResult;

    restoreFootprintResult(
      value?: RestoreFootprintResult,
    ): RestoreFootprintResult;

    static createAccount(value: CreateAccountResult): OperationResultTr;

    static payment(value: PaymentResult): OperationResultTr;

    static pathPaymentStrictReceive(
      value: PathPaymentStrictReceiveResult,
    ): OperationResultTr;

    static manageSellOffer(value: ManageSellOfferResult): OperationResultTr;

    static createPassiveSellOffer(
      value: ManageSellOfferResult,
    ): OperationResultTr;

    static setOptions(value: SetOptionsResult): OperationResultTr;

    static changeTrust(value: ChangeTrustResult): OperationResultTr;

    static allowTrust(value: AllowTrustResult): OperationResultTr;

    static accountMerge(value: AccountMergeResult): OperationResultTr;

    static inflation(value: InflationResult): OperationResultTr;

    static manageData(value: ManageDataResult): OperationResultTr;

    static bumpSequence(value: BumpSequenceResult): OperationResultTr;

    static manageBuyOffer(value: ManageBuyOfferResult): OperationResultTr;

    static pathPaymentStrictSend(
      value: PathPaymentStrictSendResult,
    ): OperationResultTr;

    static createClaimableBalance(
      value: CreateClaimableBalanceResult,
    ): OperationResultTr;

    static claimClaimableBalance(
      value: ClaimClaimableBalanceResult,
    ): OperationResultTr;

    static beginSponsoringFutureReserves(
      value: BeginSponsoringFutureReservesResult,
    ): OperationResultTr;

    static endSponsoringFutureReserves(
      value: EndSponsoringFutureReservesResult,
    ): OperationResultTr;

    static revokeSponsorship(value: RevokeSponsorshipResult): OperationResultTr;

    static clawback(value: ClawbackResult): OperationResultTr;

    static clawbackClaimableBalance(
      value: ClawbackClaimableBalanceResult,
    ): OperationResultTr;

    static setTrustLineFlags(value: SetTrustLineFlagsResult): OperationResultTr;

    static liquidityPoolDeposit(
      value: LiquidityPoolDepositResult,
    ): OperationResultTr;

    static liquidityPoolWithdraw(
      value: LiquidityPoolWithdrawResult,
    ): OperationResultTr;

    static invokeHostFunction(
      value: InvokeHostFunctionResult,
    ): OperationResultTr;

    static extendFootprintTtl(
      value: ExtendFootprintTtlResult,
    ): OperationResultTr;

    static restoreFootprint(value: RestoreFootprintResult): OperationResultTr;

    value():
      | CreateAccountResult
      | PaymentResult
      | PathPaymentStrictReceiveResult
      | ManageSellOfferResult
      | ManageSellOfferResult
      | SetOptionsResult
      | ChangeTrustResult
      | AllowTrustResult
      | AccountMergeResult
      | InflationResult
      | ManageDataResult
      | BumpSequenceResult
      | ManageBuyOfferResult
      | PathPaymentStrictSendResult
      | CreateClaimableBalanceResult
      | ClaimClaimableBalanceResult
      | BeginSponsoringFutureReservesResult
      | EndSponsoringFutureReservesResult
      | RevokeSponsorshipResult
      | ClawbackResult
      | ClawbackClaimableBalanceResult
      | SetTrustLineFlagsResult
      | LiquidityPoolDepositResult
      | LiquidityPoolWithdrawResult
      | InvokeHostFunctionResult
      | ExtendFootprintTtlResult
      | RestoreFootprintResult;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): OperationResultTr;

    static write(value: OperationResultTr, io: Buffer): void;

    static isValid(value: OperationResultTr): boolean;

    static toXDR(value: OperationResultTr): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): OperationResultTr;

    static fromXDR(input: string, format: 'hex' | 'base64'): OperationResultTr;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class OperationResult {
    switch(): OperationResultCode;

    tr(value?: OperationResultTr): OperationResultTr;

    static opInner(value: OperationResultTr): OperationResult;

    static opBadAuth(): OperationResult;

    static opNoAccount(): OperationResult;

    static opNotSupported(): OperationResult;

    static opTooManySubentries(): OperationResult;

    static opExceededWorkLimit(): OperationResult;

    static opTooManySponsoring(): OperationResult;

    value(): OperationResultTr | void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): OperationResult;

    static write(value: OperationResult, io: Buffer): void;

    static isValid(value: OperationResult): boolean;

    static toXDR(value: OperationResult): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): OperationResult;

    static fromXDR(input: string, format: 'hex' | 'base64'): OperationResult;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class InnerTransactionResultResult {
    switch(): TransactionResultCode;

    results(value?: OperationResult[]): OperationResult[];

    static txSuccess(value: OperationResult[]): InnerTransactionResultResult;

    static txFailed(value: OperationResult[]): InnerTransactionResultResult;

    static txTooEarly(): InnerTransactionResultResult;

    static txTooLate(): InnerTransactionResultResult;

    static txMissingOperation(): InnerTransactionResultResult;

    static txBadSeq(): InnerTransactionResultResult;

    static txBadAuth(): InnerTransactionResultResult;

    static txInsufficientBalance(): InnerTransactionResultResult;

    static txNoAccount(): InnerTransactionResultResult;

    static txInsufficientFee(): InnerTransactionResultResult;

    static txBadAuthExtra(): InnerTransactionResultResult;

    static txInternalError(): InnerTransactionResultResult;

    static txNotSupported(): InnerTransactionResultResult;

    static txBadSponsorship(): InnerTransactionResultResult;

    static txBadMinSeqAgeOrGap(): InnerTransactionResultResult;

    static txMalformed(): InnerTransactionResultResult;

    static txSorobanInvalid(): InnerTransactionResultResult;

    value(): OperationResult[] | void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): InnerTransactionResultResult;

    static write(value: InnerTransactionResultResult, io: Buffer): void;

    static isValid(value: InnerTransactionResultResult): boolean;

    static toXDR(value: InnerTransactionResultResult): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): InnerTransactionResultResult;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): InnerTransactionResultResult;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class InnerTransactionResultExt {
    switch(): number;

    static 0(): InnerTransactionResultExt;

    value(): void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): InnerTransactionResultExt;

    static write(value: InnerTransactionResultExt, io: Buffer): void;

    static isValid(value: InnerTransactionResultExt): boolean;

    static toXDR(value: InnerTransactionResultExt): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): InnerTransactionResultExt;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): InnerTransactionResultExt;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TransactionResultResult {
    switch(): TransactionResultCode;

    innerResultPair(
      value?: InnerTransactionResultPair,
    ): InnerTransactionResultPair;

    results(value?: OperationResult[]): OperationResult[];

    static txFeeBumpInnerSuccess(
      value: InnerTransactionResultPair,
    ): TransactionResultResult;

    static txFeeBumpInnerFailed(
      value: InnerTransactionResultPair,
    ): TransactionResultResult;

    static txSuccess(value: OperationResult[]): TransactionResultResult;

    static txFailed(value: OperationResult[]): TransactionResultResult;

    static txTooEarly(): TransactionResultResult;

    static txTooLate(): TransactionResultResult;

    static txMissingOperation(): TransactionResultResult;

    static txBadSeq(): TransactionResultResult;

    static txBadAuth(): TransactionResultResult;

    static txInsufficientBalance(): TransactionResultResult;

    static txNoAccount(): TransactionResultResult;

    static txInsufficientFee(): TransactionResultResult;

    static txBadAuthExtra(): TransactionResultResult;

    static txInternalError(): TransactionResultResult;

    static txNotSupported(): TransactionResultResult;

    static txBadSponsorship(): TransactionResultResult;

    static txBadMinSeqAgeOrGap(): TransactionResultResult;

    static txMalformed(): TransactionResultResult;

    static txSorobanInvalid(): TransactionResultResult;

    value(): InnerTransactionResultPair | OperationResult[] | void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TransactionResultResult;

    static write(value: TransactionResultResult, io: Buffer): void;

    static isValid(value: TransactionResultResult): boolean;

    static toXDR(value: TransactionResultResult): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): TransactionResultResult;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): TransactionResultResult;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class TransactionResultExt {
    switch(): number;

    static 0(): TransactionResultExt;

    value(): void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): TransactionResultExt;

    static write(value: TransactionResultExt, io: Buffer): void;

    static isValid(value: TransactionResultExt): boolean;

    static toXDR(value: TransactionResultExt): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): TransactionResultExt;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): TransactionResultExt;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ExtensionPoint {
    switch(): number;

    static 0(): ExtensionPoint;

    value(): void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ExtensionPoint;

    static write(value: ExtensionPoint, io: Buffer): void;

    static isValid(value: ExtensionPoint): boolean;

    static toXDR(value: ExtensionPoint): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ExtensionPoint;

    static fromXDR(input: string, format: 'hex' | 'base64'): ExtensionPoint;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class PublicKey {
    switch(): PublicKeyType;

    ed25519(value?: Buffer): Buffer;

    static publicKeyTypeEd25519(value: Buffer): PublicKey;

    value(): Buffer;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): PublicKey;

    static write(value: PublicKey, io: Buffer): void;

    static isValid(value: PublicKey): boolean;

    static toXDR(value: PublicKey): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): PublicKey;

    static fromXDR(input: string, format: 'hex' | 'base64'): PublicKey;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class SignerKey {
    switch(): SignerKeyType;

    ed25519(value?: Buffer): Buffer;

    preAuthTx(value?: Buffer): Buffer;

    hashX(value?: Buffer): Buffer;

    ed25519SignedPayload(
      value?: SignerKeyEd25519SignedPayload,
    ): SignerKeyEd25519SignedPayload;

    static signerKeyTypeEd25519(value: Buffer): SignerKey;

    static signerKeyTypePreAuthTx(value: Buffer): SignerKey;

    static signerKeyTypeHashX(value: Buffer): SignerKey;

    static signerKeyTypeEd25519SignedPayload(
      value: SignerKeyEd25519SignedPayload,
    ): SignerKey;

    value(): Buffer | Buffer | Buffer | SignerKeyEd25519SignedPayload;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): SignerKey;

    static write(value: SignerKey, io: Buffer): void;

    static isValid(value: SignerKey): boolean;

    static toXDR(value: SignerKey): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): SignerKey;

    static fromXDR(input: string, format: 'hex' | 'base64'): SignerKey;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScError {
    switch(): ScErrorType;

    contractCode(value?: number): number;

    code(value?: ScErrorCode): ScErrorCode;

    static sceContract(value: number): ScError;

    static sceWasmVm(value: ScErrorCode): ScError;

    static sceContext(value: ScErrorCode): ScError;

    static sceStorage(value: ScErrorCode): ScError;

    static sceObject(value: ScErrorCode): ScError;

    static sceCrypto(value: ScErrorCode): ScError;

    static sceEvents(value: ScErrorCode): ScError;

    static sceBudget(value: ScErrorCode): ScError;

    static sceValue(value: ScErrorCode): ScError;

    static sceAuth(value: ScErrorCode): ScError;

    value(): number | ScErrorCode;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScError;

    static write(value: ScError, io: Buffer): void;

    static isValid(value: ScError): boolean;

    static toXDR(value: ScError): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScError;

    static fromXDR(input: string, format: 'hex' | 'base64'): ScError;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ContractExecutable {
    switch(): ContractExecutableType;

    wasmHash(value?: Buffer): Buffer;

    static contractExecutableWasm(value: Buffer): ContractExecutable;

    static contractExecutableStellarAsset(): ContractExecutable;

    value(): Buffer | void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ContractExecutable;

    static write(value: ContractExecutable, io: Buffer): void;

    static isValid(value: ContractExecutable): boolean;

    static toXDR(value: ContractExecutable): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ContractExecutable;

    static fromXDR(input: string, format: 'hex' | 'base64'): ContractExecutable;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScAddress {
    switch(): ScAddressType;

    accountId(value?: AccountId): AccountId;

    contractId(value?: Buffer): Buffer;

    static scAddressTypeAccount(value: AccountId): ScAddress;

    static scAddressTypeContract(value: Buffer): ScAddress;

    value(): AccountId | Buffer;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScAddress;

    static write(value: ScAddress, io: Buffer): void;

    static isValid(value: ScAddress): boolean;

    static toXDR(value: ScAddress): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScAddress;

    static fromXDR(input: string, format: 'hex' | 'base64'): ScAddress;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScVal {
    switch(): ScValType;

    b(value?: boolean): boolean;

    error(value?: ScError): ScError;

    u32(value?: number): number;

    i32(value?: number): number;

    u64(value?: Uint64): Uint64;

    i64(value?: Int64): Int64;

    timepoint(value?: TimePoint): TimePoint;

    duration(value?: Duration): Duration;

    u128(value?: UInt128Parts): UInt128Parts;

    i128(value?: Int128Parts): Int128Parts;

    u256(value?: UInt256Parts): UInt256Parts;

    i256(value?: Int256Parts): Int256Parts;

    bytes(value?: Buffer): Buffer;

    str(value?: string | Buffer): string | Buffer;

    sym(value?: string | Buffer): string | Buffer;

    vec(value?: null | ScVal[]): null | ScVal[];

    map(value?: null | ScMapEntry[]): null | ScMapEntry[];

    address(value?: ScAddress): ScAddress;

    nonceKey(value?: ScNonceKey): ScNonceKey;

    instance(value?: ScContractInstance): ScContractInstance;

    static scvBool(value: boolean): ScVal;

    static scvVoid(): ScVal;

    static scvError(value: ScError): ScVal;

    static scvU32(value: number): ScVal;

    static scvI32(value: number): ScVal;

    static scvU64(value: Uint64): ScVal;

    static scvI64(value: Int64): ScVal;

    static scvTimepoint(value: TimePoint): ScVal;

    static scvDuration(value: Duration): ScVal;

    static scvU128(value: UInt128Parts): ScVal;

    static scvI128(value: Int128Parts): ScVal;

    static scvU256(value: UInt256Parts): ScVal;

    static scvI256(value: Int256Parts): ScVal;

    static scvBytes(value: Buffer): ScVal;

    static scvString(value: string | Buffer): ScVal;

    static scvSymbol(value: string | Buffer): ScVal;

    static scvVec(value: null | ScVal[]): ScVal;

    static scvMap(value: null | ScMapEntry[]): ScVal;

    static scvAddress(value: ScAddress): ScVal;

    static scvLedgerKeyContractInstance(): ScVal;

    static scvLedgerKeyNonce(value: ScNonceKey): ScVal;

    static scvContractInstance(value: ScContractInstance): ScVal;

    value():
      | boolean
      | ScError
      | number
      | number
      | Uint64
      | Int64
      | TimePoint
      | Duration
      | UInt128Parts
      | Int128Parts
      | UInt256Parts
      | Int256Parts
      | Buffer
      | string
      | Buffer
      | string
      | Buffer
      | null
      | ScVal[]
      | null
      | ScMapEntry[]
      | ScAddress
      | ScNonceKey
      | ScContractInstance
      | void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScVal;

    static write(value: ScVal, io: Buffer): void;

    static isValid(value: ScVal): boolean;

    static toXDR(value: ScVal): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScVal;

    static fromXDR(input: string, format: 'hex' | 'base64'): ScVal;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScEnvMetaEntry {
    switch(): ScEnvMetaKind;

    interfaceVersion(
      value?: ScEnvMetaEntryInterfaceVersion,
    ): ScEnvMetaEntryInterfaceVersion;

    static scEnvMetaKindInterfaceVersion(
      value: ScEnvMetaEntryInterfaceVersion,
    ): ScEnvMetaEntry;

    value(): ScEnvMetaEntryInterfaceVersion;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScEnvMetaEntry;

    static write(value: ScEnvMetaEntry, io: Buffer): void;

    static isValid(value: ScEnvMetaEntry): boolean;

    static toXDR(value: ScEnvMetaEntry): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScEnvMetaEntry;

    static fromXDR(input: string, format: 'hex' | 'base64'): ScEnvMetaEntry;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScMetaEntry {
    switch(): ScMetaKind;

    v0(value?: ScMetaV0): ScMetaV0;

    static scMetaV0(value: ScMetaV0): ScMetaEntry;

    value(): ScMetaV0;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScMetaEntry;

    static write(value: ScMetaEntry, io: Buffer): void;

    static isValid(value: ScMetaEntry): boolean;

    static toXDR(value: ScMetaEntry): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScMetaEntry;

    static fromXDR(input: string, format: 'hex' | 'base64'): ScMetaEntry;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScSpecTypeDef {
    switch(): ScSpecType;

    option(value?: ScSpecTypeOption): ScSpecTypeOption;

    result(value?: ScSpecTypeResult): ScSpecTypeResult;

    vec(value?: ScSpecTypeVec): ScSpecTypeVec;

    map(value?: ScSpecTypeMap): ScSpecTypeMap;

    tuple(value?: ScSpecTypeTuple): ScSpecTypeTuple;

    bytesN(value?: ScSpecTypeBytesN): ScSpecTypeBytesN;

    udt(value?: ScSpecTypeUdt): ScSpecTypeUdt;

    static scSpecTypeVal(): ScSpecTypeDef;

    static scSpecTypeBool(): ScSpecTypeDef;

    static scSpecTypeVoid(): ScSpecTypeDef;

    static scSpecTypeError(): ScSpecTypeDef;

    static scSpecTypeU32(): ScSpecTypeDef;

    static scSpecTypeI32(): ScSpecTypeDef;

    static scSpecTypeU64(): ScSpecTypeDef;

    static scSpecTypeI64(): ScSpecTypeDef;

    static scSpecTypeTimepoint(): ScSpecTypeDef;

    static scSpecTypeDuration(): ScSpecTypeDef;

    static scSpecTypeU128(): ScSpecTypeDef;

    static scSpecTypeI128(): ScSpecTypeDef;

    static scSpecTypeU256(): ScSpecTypeDef;

    static scSpecTypeI256(): ScSpecTypeDef;

    static scSpecTypeBytes(): ScSpecTypeDef;

    static scSpecTypeString(): ScSpecTypeDef;

    static scSpecTypeSymbol(): ScSpecTypeDef;

    static scSpecTypeAddress(): ScSpecTypeDef;

    static scSpecTypeOption(value: ScSpecTypeOption): ScSpecTypeDef;

    static scSpecTypeResult(value: ScSpecTypeResult): ScSpecTypeDef;

    static scSpecTypeVec(value: ScSpecTypeVec): ScSpecTypeDef;

    static scSpecTypeMap(value: ScSpecTypeMap): ScSpecTypeDef;

    static scSpecTypeTuple(value: ScSpecTypeTuple): ScSpecTypeDef;

    static scSpecTypeBytesN(value: ScSpecTypeBytesN): ScSpecTypeDef;

    static scSpecTypeUdt(value: ScSpecTypeUdt): ScSpecTypeDef;

    value():
      | ScSpecTypeOption
      | ScSpecTypeResult
      | ScSpecTypeVec
      | ScSpecTypeMap
      | ScSpecTypeTuple
      | ScSpecTypeBytesN
      | ScSpecTypeUdt
      | void;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScSpecTypeDef;

    static write(value: ScSpecTypeDef, io: Buffer): void;

    static isValid(value: ScSpecTypeDef): boolean;

    static toXDR(value: ScSpecTypeDef): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScSpecTypeDef;

    static fromXDR(input: string, format: 'hex' | 'base64'): ScSpecTypeDef;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScSpecUdtUnionCaseV0 {
    switch(): ScSpecUdtUnionCaseV0Kind;

    voidCase(value?: ScSpecUdtUnionCaseVoidV0): ScSpecUdtUnionCaseVoidV0;

    tupleCase(value?: ScSpecUdtUnionCaseTupleV0): ScSpecUdtUnionCaseTupleV0;

    static scSpecUdtUnionCaseVoidV0(
      value: ScSpecUdtUnionCaseVoidV0,
    ): ScSpecUdtUnionCaseV0;

    static scSpecUdtUnionCaseTupleV0(
      value: ScSpecUdtUnionCaseTupleV0,
    ): ScSpecUdtUnionCaseV0;

    value(): ScSpecUdtUnionCaseVoidV0 | ScSpecUdtUnionCaseTupleV0;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScSpecUdtUnionCaseV0;

    static write(value: ScSpecUdtUnionCaseV0, io: Buffer): void;

    static isValid(value: ScSpecUdtUnionCaseV0): boolean;

    static toXDR(value: ScSpecUdtUnionCaseV0): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScSpecUdtUnionCaseV0;

    static fromXDR(
      input: string,
      format: 'hex' | 'base64',
    ): ScSpecUdtUnionCaseV0;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ScSpecEntry {
    switch(): ScSpecEntryKind;

    functionV0(value?: ScSpecFunctionV0): ScSpecFunctionV0;

    udtStructV0(value?: ScSpecUdtStructV0): ScSpecUdtStructV0;

    udtUnionV0(value?: ScSpecUdtUnionV0): ScSpecUdtUnionV0;

    udtEnumV0(value?: ScSpecUdtEnumV0): ScSpecUdtEnumV0;

    udtErrorEnumV0(value?: ScSpecUdtErrorEnumV0): ScSpecUdtErrorEnumV0;

    static scSpecEntryFunctionV0(value: ScSpecFunctionV0): ScSpecEntry;

    static scSpecEntryUdtStructV0(value: ScSpecUdtStructV0): ScSpecEntry;

    static scSpecEntryUdtUnionV0(value: ScSpecUdtUnionV0): ScSpecEntry;

    static scSpecEntryUdtEnumV0(value: ScSpecUdtEnumV0): ScSpecEntry;

    static scSpecEntryUdtErrorEnumV0(value: ScSpecUdtErrorEnumV0): ScSpecEntry;

    value():
      | ScSpecFunctionV0
      | ScSpecUdtStructV0
      | ScSpecUdtUnionV0
      | ScSpecUdtEnumV0
      | ScSpecUdtErrorEnumV0;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ScSpecEntry;

    static write(value: ScSpecEntry, io: Buffer): void;

    static isValid(value: ScSpecEntry): boolean;

    static toXDR(value: ScSpecEntry): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ScSpecEntry;

    static fromXDR(input: string, format: 'hex' | 'base64'): ScSpecEntry;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }

  class ConfigSettingEntry {
    switch(): ConfigSettingId;

    contractMaxSizeBytes(value?: number): number;

    contractCompute(
      value?: ConfigSettingContractComputeV0,
    ): ConfigSettingContractComputeV0;

    contractLedgerCost(
      value?: ConfigSettingContractLedgerCostV0,
    ): ConfigSettingContractLedgerCostV0;

    contractHistoricalData(
      value?: ConfigSettingContractHistoricalDataV0,
    ): ConfigSettingContractHistoricalDataV0;

    contractEvents(
      value?: ConfigSettingContractEventsV0,
    ): ConfigSettingContractEventsV0;

    contractBandwidth(
      value?: ConfigSettingContractBandwidthV0,
    ): ConfigSettingContractBandwidthV0;

    contractCostParamsCpuInsns(
      value?: ContractCostParamEntry[],
    ): ContractCostParamEntry[];

    contractCostParamsMemBytes(
      value?: ContractCostParamEntry[],
    ): ContractCostParamEntry[];

    contractDataKeySizeBytes(value?: number): number;

    contractDataEntrySizeBytes(value?: number): number;

    stateArchivalSettings(value?: StateArchivalSettings): StateArchivalSettings;

    contractExecutionLanes(
      value?: ConfigSettingContractExecutionLanesV0,
    ): ConfigSettingContractExecutionLanesV0;

    bucketListSizeWindow(value?: Uint64[]): Uint64[];

    evictionIterator(value?: EvictionIterator): EvictionIterator;

    contractParallelCompute(
      value?: ConfigSettingContractParallelComputeV0,
    ): ConfigSettingContractParallelComputeV0;

    static configSettingContractMaxSizeBytes(value: number): ConfigSettingEntry;

    static configSettingContractComputeV0(
      value: ConfigSettingContractComputeV0,
    ): ConfigSettingEntry;

    static configSettingContractLedgerCostV0(
      value: ConfigSettingContractLedgerCostV0,
    ): ConfigSettingEntry;

    static configSettingContractHistoricalDataV0(
      value: ConfigSettingContractHistoricalDataV0,
    ): ConfigSettingEntry;

    static configSettingContractEventsV0(
      value: ConfigSettingContractEventsV0,
    ): ConfigSettingEntry;

    static configSettingContractBandwidthV0(
      value: ConfigSettingContractBandwidthV0,
    ): ConfigSettingEntry;

    static configSettingContractCostParamsCpuInstructions(
      value: ContractCostParamEntry[],
    ): ConfigSettingEntry;

    static configSettingContractCostParamsMemoryBytes(
      value: ContractCostParamEntry[],
    ): ConfigSettingEntry;

    static configSettingContractDataKeySizeBytes(
      value: number,
    ): ConfigSettingEntry;

    static configSettingContractDataEntrySizeBytes(
      value: number,
    ): ConfigSettingEntry;

    static configSettingStateArchival(
      value: StateArchivalSettings,
    ): ConfigSettingEntry;

    static configSettingContractExecutionLanes(
      value: ConfigSettingContractExecutionLanesV0,
    ): ConfigSettingEntry;

    static configSettingBucketlistSizeWindow(
      value: Uint64[],
    ): ConfigSettingEntry;

    static configSettingEvictionIterator(
      value: EvictionIterator,
    ): ConfigSettingEntry;

    static configSettingContractParallelComputeV0(
      value: ConfigSettingContractParallelComputeV0,
    ): ConfigSettingEntry;

    value():
      | number
      | ConfigSettingContractComputeV0
      | ConfigSettingContractLedgerCostV0
      | ConfigSettingContractHistoricalDataV0
      | ConfigSettingContractEventsV0
      | ConfigSettingContractBandwidthV0
      | ContractCostParamEntry[]
      | ContractCostParamEntry[]
      | number
      | number
      | StateArchivalSettings
      | ConfigSettingContractExecutionLanesV0
      | Uint64[]
      | EvictionIterator
      | ConfigSettingContractParallelComputeV0;

    toXDR(format?: 'raw'): Buffer;

    toXDR(format: 'hex' | 'base64'): string;

    static read(io: Buffer): ConfigSettingEntry;

    static write(value: ConfigSettingEntry, io: Buffer): void;

    static isValid(value: ConfigSettingEntry): boolean;

    static toXDR(value: ConfigSettingEntry): Buffer;

    static fromXDR(input: Buffer, format?: 'raw'): ConfigSettingEntry;

    static fromXDR(input: string, format: 'hex' | 'base64'): ConfigSettingEntry;

    static validateXDR(input: Buffer, format?: 'raw'): boolean;

    static validateXDR(input: string, format: 'hex' | 'base64'): boolean;
  }
}
