/**
 * This code was AUTOGENERATED using the codama library.
 * Please DO NOT EDIT THIS FILE, instead use visitors
 * to add features, then rerun codama to update it.
 *
 * @see https://github.com/codama-idl/codama
 */
import { type Address, type Codec, type Decoder, type Encoder, type IAccountMeta, type IAccountSignerMeta, type IInstruction, type IInstructionWithAccounts, type IInstructionWithData, type ReadonlyAccount, type ReadonlySignerAccount, type TransactionSigner, type WritableAccount } from '@solana/kit';
import { TOKEN_PROGRAM_ADDRESS } from '../programs';
export declare const MINT_TO_DISCRIMINATOR = 7;
export declare function getMintToDiscriminatorBytes(): import("@solana/kit").ReadonlyUint8Array;
export type MintToInstruction<TProgram extends string = typeof TOKEN_PROGRAM_ADDRESS, TAccountMint extends string | IAccountMeta<string> = string, TAccountToken extends string | IAccountMeta<string> = string, TAccountMintAuthority extends string | IAccountMeta<string> = string, TRemainingAccounts extends readonly IAccountMeta<string>[] = []> = IInstruction<TProgram> & IInstructionWithData<Uint8Array> & IInstructionWithAccounts<[
    TAccountMint extends string ? WritableAccount<TAccountMint> : TAccountMint,
    TAccountToken extends string ? WritableAccount<TAccountToken> : TAccountToken,
    TAccountMintAuthority extends string ? ReadonlyAccount<TAccountMintAuthority> : TAccountMintAuthority,
    ...TRemainingAccounts
]>;
export type MintToInstructionData = {
    discriminator: number;
    /** The amount of new tokens to mint. */
    amount: bigint;
};
export type MintToInstructionDataArgs = {
    /** The amount of new tokens to mint. */
    amount: number | bigint;
};
export declare function getMintToInstructionDataEncoder(): Encoder<MintToInstructionDataArgs>;
export declare function getMintToInstructionDataDecoder(): Decoder<MintToInstructionData>;
export declare function getMintToInstructionDataCodec(): Codec<MintToInstructionDataArgs, MintToInstructionData>;
export type MintToInput<TAccountMint extends string = string, TAccountToken extends string = string, TAccountMintAuthority extends string = string> = {
    /** The mint account. */
    mint: Address<TAccountMint>;
    /** The account to mint tokens to. */
    token: Address<TAccountToken>;
    /** The mint's minting authority or its multisignature account. */
    mintAuthority: Address<TAccountMintAuthority> | TransactionSigner<TAccountMintAuthority>;
    amount: MintToInstructionDataArgs['amount'];
    multiSigners?: Array<TransactionSigner>;
};
export declare function getMintToInstruction<TAccountMint extends string, TAccountToken extends string, TAccountMintAuthority extends string, TProgramAddress extends Address = typeof TOKEN_PROGRAM_ADDRESS>(input: MintToInput<TAccountMint, TAccountToken, TAccountMintAuthority>, config?: {
    programAddress?: TProgramAddress;
}): MintToInstruction<TProgramAddress, TAccountMint, TAccountToken, (typeof input)['mintAuthority'] extends TransactionSigner<TAccountMintAuthority> ? ReadonlySignerAccount<TAccountMintAuthority> & IAccountSignerMeta<TAccountMintAuthority> : TAccountMintAuthority>;
export type ParsedMintToInstruction<TProgram extends string = typeof TOKEN_PROGRAM_ADDRESS, TAccountMetas extends readonly IAccountMeta[] = readonly IAccountMeta[]> = {
    programAddress: Address<TProgram>;
    accounts: {
        /** The mint account. */
        mint: TAccountMetas[0];
        /** The account to mint tokens to. */
        token: TAccountMetas[1];
        /** The mint's minting authority or its multisignature account. */
        mintAuthority: TAccountMetas[2];
    };
    data: MintToInstructionData;
};
export declare function parseMintToInstruction<TProgram extends string, TAccountMetas extends readonly IAccountMeta[]>(instruction: IInstruction<TProgram> & IInstructionWithAccounts<TAccountMetas> & IInstructionWithData<Uint8Array>): ParsedMintToInstruction<TProgram, TAccountMetas>;
//# sourceMappingURL=mintTo.d.ts.map