/**
 * This code was AUTOGENERATED using the codama library.
 * Please DO NOT EDIT THIS FILE, instead use visitors
 * to add features, then rerun codama to update it.
 *
 * @see https://github.com/codama-idl/codama
 */
import { type Address, type Codec, type Decoder, type Encoder, type IAccountMeta, type IAccountSignerMeta, type IInstruction, type IInstructionWithAccounts, type IInstructionWithData, type ReadonlyAccount, type ReadonlySignerAccount, type TransactionSigner, type WritableAccount, type WritableSignerAccount } from '@solana/kit';
import { TOKEN_2022_PROGRAM_ADDRESS } from '../programs';
import { type ExtensionType, type ExtensionTypeArgs } from '../types';
export declare const REALLOCATE_DISCRIMINATOR = 29;
export declare function getReallocateDiscriminatorBytes(): import("@solana/kit").ReadonlyUint8Array;
export type ReallocateInstruction<TProgram extends string = typeof TOKEN_2022_PROGRAM_ADDRESS, TAccountToken extends string | IAccountMeta<string> = string, TAccountPayer extends string | IAccountMeta<string> = string, TAccountSystemProgram extends string | IAccountMeta<string> = '11111111111111111111111111111111', TAccountOwner extends string | IAccountMeta<string> = string, TRemainingAccounts extends readonly IAccountMeta<string>[] = []> = IInstruction<TProgram> & IInstructionWithData<Uint8Array> & IInstructionWithAccounts<[
    TAccountToken extends string ? WritableAccount<TAccountToken> : TAccountToken,
    TAccountPayer extends string ? WritableSignerAccount<TAccountPayer> & IAccountSignerMeta<TAccountPayer> : TAccountPayer,
    TAccountSystemProgram extends string ? ReadonlyAccount<TAccountSystemProgram> : TAccountSystemProgram,
    TAccountOwner extends string ? ReadonlyAccount<TAccountOwner> : TAccountOwner,
    ...TRemainingAccounts
]>;
export type ReallocateInstructionData = {
    discriminator: number;
    /** New extension types to include in the reallocated account. */
    newExtensionTypes: Array<ExtensionType>;
};
export type ReallocateInstructionDataArgs = {
    /** New extension types to include in the reallocated account. */
    newExtensionTypes: Array<ExtensionTypeArgs>;
};
export declare function getReallocateInstructionDataEncoder(): Encoder<ReallocateInstructionDataArgs>;
export declare function getReallocateInstructionDataDecoder(): Decoder<ReallocateInstructionData>;
export declare function getReallocateInstructionDataCodec(): Codec<ReallocateInstructionDataArgs, ReallocateInstructionData>;
export type ReallocateInput<TAccountToken extends string = string, TAccountPayer extends string = string, TAccountSystemProgram extends string = string, TAccountOwner extends string = string> = {
    /** The token account to reallocate. */
    token: Address<TAccountToken>;
    /** The payer account to fund reallocation. */
    payer: TransactionSigner<TAccountPayer>;
    /** System program for reallocation funding. */
    systemProgram?: Address<TAccountSystemProgram>;
    /** The account's owner or its multisignature account. */
    owner: Address<TAccountOwner> | TransactionSigner<TAccountOwner>;
    newExtensionTypes: ReallocateInstructionDataArgs['newExtensionTypes'];
    multiSigners?: Array<TransactionSigner>;
};
export declare function getReallocateInstruction<TAccountToken extends string, TAccountPayer extends string, TAccountSystemProgram extends string, TAccountOwner extends string, TProgramAddress extends Address = typeof TOKEN_2022_PROGRAM_ADDRESS>(input: ReallocateInput<TAccountToken, TAccountPayer, TAccountSystemProgram, TAccountOwner>, config?: {
    programAddress?: TProgramAddress;
}): ReallocateInstruction<TProgramAddress, TAccountToken, TAccountPayer, TAccountSystemProgram, (typeof input)['owner'] extends TransactionSigner<TAccountOwner> ? ReadonlySignerAccount<TAccountOwner> & IAccountSignerMeta<TAccountOwner> : TAccountOwner>;
export type ParsedReallocateInstruction<TProgram extends string = typeof TOKEN_2022_PROGRAM_ADDRESS, TAccountMetas extends readonly IAccountMeta[] = readonly IAccountMeta[]> = {
    programAddress: Address<TProgram>;
    accounts: {
        /** The token account to reallocate. */
        token: TAccountMetas[0];
        /** The payer account to fund reallocation. */
        payer: TAccountMetas[1];
        /** System program for reallocation funding. */
        systemProgram: TAccountMetas[2];
        /** The account's owner or its multisignature account. */
        owner: TAccountMetas[3];
    };
    data: ReallocateInstructionData;
};
export declare function parseReallocateInstruction<TProgram extends string, TAccountMetas extends readonly IAccountMeta[]>(instruction: IInstruction<TProgram> & IInstructionWithAccounts<TAccountMetas> & IInstructionWithData<Uint8Array>): ParsedReallocateInstruction<TProgram, TAccountMetas>;
//# sourceMappingURL=reallocate.d.ts.map