import { getEnumEncoder, getEnumDecoder, combineCodec, fixEncoderSize, getBytesEncoder, fixDecoderSize, getBytesDecoder, getDiscriminatedUnionEncoder, getUnitEncoder, addEncoderSizePrefix, getStructEncoder, getAddressEncoder, getU64Encoder, getU16Encoder, getOptionEncoder, getBooleanEncoder, getI16Encoder, getMapEncoder, getUtf8Encoder, getU32Encoder, getF64Encoder, getDiscriminatedUnionDecoder, getUnitDecoder, addDecoderSizePrefix, getStructDecoder, getAddressDecoder, getU64Decoder, getU16Decoder, getOptionDecoder, getBooleanDecoder, getI16Decoder, getMapDecoder, getUtf8Decoder, getU32Decoder, getF64Decoder, getTupleEncoder, getTupleDecoder, getU8Encoder, getHiddenPrefixEncoder, getArrayEncoder, getConstantEncoder, padLeftEncoder, getU8Decoder, getHiddenPrefixDecoder, getArrayDecoder, getConstantDecoder, decodeAccount, assertAccountExists, fetchEncodedAccount, assertAccountsExist, fetchEncodedAccounts, containsBytes, isProgramError, transformEncoder, AccountRole, getI8Encoder, getI8Decoder, getProgramDerivedAddress, none, getI64Encoder, getI64Decoder, unwrapOption, wrapNullable, isOption, isNone, upgradeRoleToSigner, isTransactionSigner as isTransactionSigner$1 } from '@solana/kit';
import { fetchSysvarClock } from '@solana/sysvars';

// src/generated/accounts/mint.ts
var AccountState = /* @__PURE__ */ ((AccountState2) => {
  AccountState2[AccountState2["Uninitialized"] = 0] = "Uninitialized";
  AccountState2[AccountState2["Initialized"] = 1] = "Initialized";
  AccountState2[AccountState2["Frozen"] = 2] = "Frozen";
  return AccountState2;
})(AccountState || {});
function getAccountStateEncoder() {
  return getEnumEncoder(AccountState);
}
function getAccountStateDecoder() {
  return getEnumDecoder(AccountState);
}
function getAccountStateCodec() {
  return combineCodec(getAccountStateEncoder(), getAccountStateDecoder());
}
var AuthorityType = /* @__PURE__ */ ((AuthorityType2) => {
  AuthorityType2[AuthorityType2["MintTokens"] = 0] = "MintTokens";
  AuthorityType2[AuthorityType2["FreezeAccount"] = 1] = "FreezeAccount";
  AuthorityType2[AuthorityType2["AccountOwner"] = 2] = "AccountOwner";
  AuthorityType2[AuthorityType2["CloseAccount"] = 3] = "CloseAccount";
  AuthorityType2[AuthorityType2["TransferFeeConfig"] = 4] = "TransferFeeConfig";
  AuthorityType2[AuthorityType2["WithheldWithdraw"] = 5] = "WithheldWithdraw";
  AuthorityType2[AuthorityType2["CloseMint"] = 6] = "CloseMint";
  AuthorityType2[AuthorityType2["InterestRate"] = 7] = "InterestRate";
  AuthorityType2[AuthorityType2["PermanentDelegate"] = 8] = "PermanentDelegate";
  AuthorityType2[AuthorityType2["ConfidentialTransferMint"] = 9] = "ConfidentialTransferMint";
  AuthorityType2[AuthorityType2["TransferHookProgramId"] = 10] = "TransferHookProgramId";
  AuthorityType2[AuthorityType2["ConfidentialTransferFeeConfig"] = 11] = "ConfidentialTransferFeeConfig";
  AuthorityType2[AuthorityType2["MetadataPointer"] = 12] = "MetadataPointer";
  AuthorityType2[AuthorityType2["GroupPointer"] = 13] = "GroupPointer";
  AuthorityType2[AuthorityType2["GroupMemberPointer"] = 14] = "GroupMemberPointer";
  AuthorityType2[AuthorityType2["ScaledUiAmount"] = 15] = "ScaledUiAmount";
  AuthorityType2[AuthorityType2["Pause"] = 16] = "Pause";
  return AuthorityType2;
})(AuthorityType || {});
function getAuthorityTypeEncoder() {
  return getEnumEncoder(AuthorityType);
}
function getAuthorityTypeDecoder() {
  return getEnumDecoder(AuthorityType);
}
function getAuthorityTypeCodec() {
  return combineCodec(getAuthorityTypeEncoder(), getAuthorityTypeDecoder());
}
function getDecryptableBalanceEncoder() {
  return fixEncoderSize(getBytesEncoder(), 36);
}
function getDecryptableBalanceDecoder() {
  return fixDecoderSize(getBytesDecoder(), 36);
}
function getDecryptableBalanceCodec() {
  return combineCodec(
    getDecryptableBalanceEncoder(),
    getDecryptableBalanceDecoder()
  );
}
function getEncryptedBalanceEncoder() {
  return fixEncoderSize(getBytesEncoder(), 64);
}
function getEncryptedBalanceDecoder() {
  return fixDecoderSize(getBytesDecoder(), 64);
}
function getEncryptedBalanceCodec() {
  return combineCodec(
    getEncryptedBalanceEncoder(),
    getEncryptedBalanceDecoder()
  );
}
function getExtensionEncoder() {
  return getDiscriminatedUnionEncoder(
    [
      ["Uninitialized", getUnitEncoder()],
      [
        "TransferFeeConfig",
        addEncoderSizePrefix(
          getStructEncoder([
            ["transferFeeConfigAuthority", getAddressEncoder()],
            ["withdrawWithheldAuthority", getAddressEncoder()],
            ["withheldAmount", getU64Encoder()],
            ["olderTransferFee", getTransferFeeEncoder()],
            ["newerTransferFee", getTransferFeeEncoder()]
          ]),
          getU16Encoder()
        )
      ],
      [
        "TransferFeeAmount",
        addEncoderSizePrefix(
          getStructEncoder([["withheldAmount", getU64Encoder()]]),
          getU16Encoder()
        )
      ],
      [
        "MintCloseAuthority",
        addEncoderSizePrefix(
          getStructEncoder([["closeAuthority", getAddressEncoder()]]),
          getU16Encoder()
        )
      ],
      [
        "ConfidentialTransferMint",
        addEncoderSizePrefix(
          getStructEncoder([
            [
              "authority",
              getOptionEncoder(getAddressEncoder(), {
                prefix: null,
                noneValue: "zeroes"
              })
            ],
            ["autoApproveNewAccounts", getBooleanEncoder()],
            [
              "auditorElgamalPubkey",
              getOptionEncoder(getAddressEncoder(), {
                prefix: null,
                noneValue: "zeroes"
              })
            ]
          ]),
          getU16Encoder()
        )
      ],
      [
        "ConfidentialTransferAccount",
        addEncoderSizePrefix(
          getStructEncoder([
            ["approved", getBooleanEncoder()],
            ["elgamalPubkey", getAddressEncoder()],
            ["pendingBalanceLow", getEncryptedBalanceEncoder()],
            ["pendingBalanceHigh", getEncryptedBalanceEncoder()],
            ["availableBalance", getEncryptedBalanceEncoder()],
            ["decryptableAvailableBalance", getDecryptableBalanceEncoder()],
            ["allowConfidentialCredits", getBooleanEncoder()],
            ["allowNonConfidentialCredits", getBooleanEncoder()],
            ["pendingBalanceCreditCounter", getU64Encoder()],
            ["maximumPendingBalanceCreditCounter", getU64Encoder()],
            ["expectedPendingBalanceCreditCounter", getU64Encoder()],
            ["actualPendingBalanceCreditCounter", getU64Encoder()]
          ]),
          getU16Encoder()
        )
      ],
      [
        "DefaultAccountState",
        addEncoderSizePrefix(
          getStructEncoder([["state", getAccountStateEncoder()]]),
          getU16Encoder()
        )
      ],
      [
        "ImmutableOwner",
        addEncoderSizePrefix(getStructEncoder([]), getU16Encoder())
      ],
      [
        "MemoTransfer",
        addEncoderSizePrefix(
          getStructEncoder([
            ["requireIncomingTransferMemos", getBooleanEncoder()]
          ]),
          getU16Encoder()
        )
      ],
      [
        "NonTransferable",
        addEncoderSizePrefix(getStructEncoder([]), getU16Encoder())
      ],
      [
        "InterestBearingConfig",
        addEncoderSizePrefix(
          getStructEncoder([
            ["rateAuthority", getAddressEncoder()],
            ["initializationTimestamp", getU64Encoder()],
            ["preUpdateAverageRate", getI16Encoder()],
            ["lastUpdateTimestamp", getU64Encoder()],
            ["currentRate", getI16Encoder()]
          ]),
          getU16Encoder()
        )
      ],
      [
        "CpiGuard",
        addEncoderSizePrefix(
          getStructEncoder([["lockCpi", getBooleanEncoder()]]),
          getU16Encoder()
        )
      ],
      [
        "PermanentDelegate",
        addEncoderSizePrefix(
          getStructEncoder([["delegate", getAddressEncoder()]]),
          getU16Encoder()
        )
      ],
      [
        "NonTransferableAccount",
        addEncoderSizePrefix(getStructEncoder([]), getU16Encoder())
      ],
      [
        "TransferHook",
        addEncoderSizePrefix(
          getStructEncoder([
            ["authority", getAddressEncoder()],
            ["programId", getAddressEncoder()]
          ]),
          getU16Encoder()
        )
      ],
      [
        "TransferHookAccount",
        addEncoderSizePrefix(
          getStructEncoder([["transferring", getBooleanEncoder()]]),
          getU16Encoder()
        )
      ],
      [
        "ConfidentialTransferFee",
        addEncoderSizePrefix(
          getStructEncoder([
            [
              "authority",
              getOptionEncoder(getAddressEncoder(), {
                prefix: null,
                noneValue: "zeroes"
              })
            ],
            ["elgamalPubkey", getAddressEncoder()],
            ["harvestToMintEnabled", getBooleanEncoder()],
            ["withheldAmount", getEncryptedBalanceEncoder()]
          ]),
          getU16Encoder()
        )
      ],
      [
        "ConfidentialTransferFeeAmount",
        addEncoderSizePrefix(
          getStructEncoder([["withheldAmount", getEncryptedBalanceEncoder()]]),
          getU16Encoder()
        )
      ],
      [
        "MetadataPointer",
        addEncoderSizePrefix(
          getStructEncoder([
            [
              "authority",
              getOptionEncoder(getAddressEncoder(), {
                prefix: null,
                noneValue: "zeroes"
              })
            ],
            [
              "metadataAddress",
              getOptionEncoder(getAddressEncoder(), {
                prefix: null,
                noneValue: "zeroes"
              })
            ]
          ]),
          getU16Encoder()
        )
      ],
      [
        "TokenMetadata",
        addEncoderSizePrefix(
          getStructEncoder([
            [
              "updateAuthority",
              getOptionEncoder(getAddressEncoder(), {
                prefix: null,
                noneValue: "zeroes"
              })
            ],
            ["mint", getAddressEncoder()],
            ["name", addEncoderSizePrefix(getUtf8Encoder(), getU32Encoder())],
            ["symbol", addEncoderSizePrefix(getUtf8Encoder(), getU32Encoder())],
            ["uri", addEncoderSizePrefix(getUtf8Encoder(), getU32Encoder())],
            [
              "additionalMetadata",
              getMapEncoder(
                addEncoderSizePrefix(getUtf8Encoder(), getU32Encoder()),
                addEncoderSizePrefix(getUtf8Encoder(), getU32Encoder())
              )
            ]
          ]),
          getU16Encoder()
        )
      ],
      [
        "GroupPointer",
        addEncoderSizePrefix(
          getStructEncoder([
            [
              "authority",
              getOptionEncoder(getAddressEncoder(), {
                prefix: null,
                noneValue: "zeroes"
              })
            ],
            [
              "groupAddress",
              getOptionEncoder(getAddressEncoder(), {
                prefix: null,
                noneValue: "zeroes"
              })
            ]
          ]),
          getU16Encoder()
        )
      ],
      [
        "TokenGroup",
        addEncoderSizePrefix(
          getStructEncoder([
            [
              "updateAuthority",
              getOptionEncoder(getAddressEncoder(), {
                prefix: null,
                noneValue: "zeroes"
              })
            ],
            ["mint", getAddressEncoder()],
            ["size", getU64Encoder()],
            ["maxSize", getU64Encoder()]
          ]),
          getU16Encoder()
        )
      ],
      [
        "GroupMemberPointer",
        addEncoderSizePrefix(
          getStructEncoder([
            [
              "authority",
              getOptionEncoder(getAddressEncoder(), {
                prefix: null,
                noneValue: "zeroes"
              })
            ],
            [
              "memberAddress",
              getOptionEncoder(getAddressEncoder(), {
                prefix: null,
                noneValue: "zeroes"
              })
            ]
          ]),
          getU16Encoder()
        )
      ],
      [
        "TokenGroupMember",
        addEncoderSizePrefix(
          getStructEncoder([
            ["mint", getAddressEncoder()],
            ["group", getAddressEncoder()],
            ["memberNumber", getU64Encoder()]
          ]),
          getU16Encoder()
        )
      ],
      ["ConfidentialMintBurn", getUnitEncoder()],
      [
        "ScaledUiAmountConfig",
        addEncoderSizePrefix(
          getStructEncoder([
            ["authority", getAddressEncoder()],
            ["multiplier", getF64Encoder()],
            ["newMultiplierEffectiveTimestamp", getU64Encoder()],
            ["newMultiplier", getF64Encoder()]
          ]),
          getU16Encoder()
        )
      ],
      [
        "PausableConfig",
        addEncoderSizePrefix(
          getStructEncoder([
            [
              "authority",
              getOptionEncoder(getAddressEncoder(), {
                prefix: null,
                noneValue: "zeroes"
              })
            ],
            ["paused", getBooleanEncoder()]
          ]),
          getU16Encoder()
        )
      ],
      ["PausableAccount", getUnitEncoder()]
    ],
    { size: getU16Encoder() }
  );
}
function getExtensionDecoder() {
  return getDiscriminatedUnionDecoder(
    [
      ["Uninitialized", getUnitDecoder()],
      [
        "TransferFeeConfig",
        addDecoderSizePrefix(
          getStructDecoder([
            ["transferFeeConfigAuthority", getAddressDecoder()],
            ["withdrawWithheldAuthority", getAddressDecoder()],
            ["withheldAmount", getU64Decoder()],
            ["olderTransferFee", getTransferFeeDecoder()],
            ["newerTransferFee", getTransferFeeDecoder()]
          ]),
          getU16Decoder()
        )
      ],
      [
        "TransferFeeAmount",
        addDecoderSizePrefix(
          getStructDecoder([["withheldAmount", getU64Decoder()]]),
          getU16Decoder()
        )
      ],
      [
        "MintCloseAuthority",
        addDecoderSizePrefix(
          getStructDecoder([["closeAuthority", getAddressDecoder()]]),
          getU16Decoder()
        )
      ],
      [
        "ConfidentialTransferMint",
        addDecoderSizePrefix(
          getStructDecoder([
            [
              "authority",
              getOptionDecoder(getAddressDecoder(), {
                prefix: null,
                noneValue: "zeroes"
              })
            ],
            ["autoApproveNewAccounts", getBooleanDecoder()],
            [
              "auditorElgamalPubkey",
              getOptionDecoder(getAddressDecoder(), {
                prefix: null,
                noneValue: "zeroes"
              })
            ]
          ]),
          getU16Decoder()
        )
      ],
      [
        "ConfidentialTransferAccount",
        addDecoderSizePrefix(
          getStructDecoder([
            ["approved", getBooleanDecoder()],
            ["elgamalPubkey", getAddressDecoder()],
            ["pendingBalanceLow", getEncryptedBalanceDecoder()],
            ["pendingBalanceHigh", getEncryptedBalanceDecoder()],
            ["availableBalance", getEncryptedBalanceDecoder()],
            ["decryptableAvailableBalance", getDecryptableBalanceDecoder()],
            ["allowConfidentialCredits", getBooleanDecoder()],
            ["allowNonConfidentialCredits", getBooleanDecoder()],
            ["pendingBalanceCreditCounter", getU64Decoder()],
            ["maximumPendingBalanceCreditCounter", getU64Decoder()],
            ["expectedPendingBalanceCreditCounter", getU64Decoder()],
            ["actualPendingBalanceCreditCounter", getU64Decoder()]
          ]),
          getU16Decoder()
        )
      ],
      [
        "DefaultAccountState",
        addDecoderSizePrefix(
          getStructDecoder([["state", getAccountStateDecoder()]]),
          getU16Decoder()
        )
      ],
      [
        "ImmutableOwner",
        addDecoderSizePrefix(getStructDecoder([]), getU16Decoder())
      ],
      [
        "MemoTransfer",
        addDecoderSizePrefix(
          getStructDecoder([
            ["requireIncomingTransferMemos", getBooleanDecoder()]
          ]),
          getU16Decoder()
        )
      ],
      [
        "NonTransferable",
        addDecoderSizePrefix(getStructDecoder([]), getU16Decoder())
      ],
      [
        "InterestBearingConfig",
        addDecoderSizePrefix(
          getStructDecoder([
            ["rateAuthority", getAddressDecoder()],
            ["initializationTimestamp", getU64Decoder()],
            ["preUpdateAverageRate", getI16Decoder()],
            ["lastUpdateTimestamp", getU64Decoder()],
            ["currentRate", getI16Decoder()]
          ]),
          getU16Decoder()
        )
      ],
      [
        "CpiGuard",
        addDecoderSizePrefix(
          getStructDecoder([["lockCpi", getBooleanDecoder()]]),
          getU16Decoder()
        )
      ],
      [
        "PermanentDelegate",
        addDecoderSizePrefix(
          getStructDecoder([["delegate", getAddressDecoder()]]),
          getU16Decoder()
        )
      ],
      [
        "NonTransferableAccount",
        addDecoderSizePrefix(getStructDecoder([]), getU16Decoder())
      ],
      [
        "TransferHook",
        addDecoderSizePrefix(
          getStructDecoder([
            ["authority", getAddressDecoder()],
            ["programId", getAddressDecoder()]
          ]),
          getU16Decoder()
        )
      ],
      [
        "TransferHookAccount",
        addDecoderSizePrefix(
          getStructDecoder([["transferring", getBooleanDecoder()]]),
          getU16Decoder()
        )
      ],
      [
        "ConfidentialTransferFee",
        addDecoderSizePrefix(
          getStructDecoder([
            [
              "authority",
              getOptionDecoder(getAddressDecoder(), {
                prefix: null,
                noneValue: "zeroes"
              })
            ],
            ["elgamalPubkey", getAddressDecoder()],
            ["harvestToMintEnabled", getBooleanDecoder()],
            ["withheldAmount", getEncryptedBalanceDecoder()]
          ]),
          getU16Decoder()
        )
      ],
      [
        "ConfidentialTransferFeeAmount",
        addDecoderSizePrefix(
          getStructDecoder([["withheldAmount", getEncryptedBalanceDecoder()]]),
          getU16Decoder()
        )
      ],
      [
        "MetadataPointer",
        addDecoderSizePrefix(
          getStructDecoder([
            [
              "authority",
              getOptionDecoder(getAddressDecoder(), {
                prefix: null,
                noneValue: "zeroes"
              })
            ],
            [
              "metadataAddress",
              getOptionDecoder(getAddressDecoder(), {
                prefix: null,
                noneValue: "zeroes"
              })
            ]
          ]),
          getU16Decoder()
        )
      ],
      [
        "TokenMetadata",
        addDecoderSizePrefix(
          getStructDecoder([
            [
              "updateAuthority",
              getOptionDecoder(getAddressDecoder(), {
                prefix: null,
                noneValue: "zeroes"
              })
            ],
            ["mint", getAddressDecoder()],
            ["name", addDecoderSizePrefix(getUtf8Decoder(), getU32Decoder())],
            ["symbol", addDecoderSizePrefix(getUtf8Decoder(), getU32Decoder())],
            ["uri", addDecoderSizePrefix(getUtf8Decoder(), getU32Decoder())],
            [
              "additionalMetadata",
              getMapDecoder(
                addDecoderSizePrefix(getUtf8Decoder(), getU32Decoder()),
                addDecoderSizePrefix(getUtf8Decoder(), getU32Decoder())
              )
            ]
          ]),
          getU16Decoder()
        )
      ],
      [
        "GroupPointer",
        addDecoderSizePrefix(
          getStructDecoder([
            [
              "authority",
              getOptionDecoder(getAddressDecoder(), {
                prefix: null,
                noneValue: "zeroes"
              })
            ],
            [
              "groupAddress",
              getOptionDecoder(getAddressDecoder(), {
                prefix: null,
                noneValue: "zeroes"
              })
            ]
          ]),
          getU16Decoder()
        )
      ],
      [
        "TokenGroup",
        addDecoderSizePrefix(
          getStructDecoder([
            [
              "updateAuthority",
              getOptionDecoder(getAddressDecoder(), {
                prefix: null,
                noneValue: "zeroes"
              })
            ],
            ["mint", getAddressDecoder()],
            ["size", getU64Decoder()],
            ["maxSize", getU64Decoder()]
          ]),
          getU16Decoder()
        )
      ],
      [
        "GroupMemberPointer",
        addDecoderSizePrefix(
          getStructDecoder([
            [
              "authority",
              getOptionDecoder(getAddressDecoder(), {
                prefix: null,
                noneValue: "zeroes"
              })
            ],
            [
              "memberAddress",
              getOptionDecoder(getAddressDecoder(), {
                prefix: null,
                noneValue: "zeroes"
              })
            ]
          ]),
          getU16Decoder()
        )
      ],
      [
        "TokenGroupMember",
        addDecoderSizePrefix(
          getStructDecoder([
            ["mint", getAddressDecoder()],
            ["group", getAddressDecoder()],
            ["memberNumber", getU64Decoder()]
          ]),
          getU16Decoder()
        )
      ],
      ["ConfidentialMintBurn", getUnitDecoder()],
      [
        "ScaledUiAmountConfig",
        addDecoderSizePrefix(
          getStructDecoder([
            ["authority", getAddressDecoder()],
            ["multiplier", getF64Decoder()],
            ["newMultiplierEffectiveTimestamp", getU64Decoder()],
            ["newMultiplier", getF64Decoder()]
          ]),
          getU16Decoder()
        )
      ],
      [
        "PausableConfig",
        addDecoderSizePrefix(
          getStructDecoder([
            [
              "authority",
              getOptionDecoder(getAddressDecoder(), {
                prefix: null,
                noneValue: "zeroes"
              })
            ],
            ["paused", getBooleanDecoder()]
          ]),
          getU16Decoder()
        )
      ],
      ["PausableAccount", getUnitDecoder()]
    ],
    { size: getU16Decoder() }
  );
}
function getExtensionCodec() {
  return combineCodec(getExtensionEncoder(), getExtensionDecoder());
}
function extension(kind, data) {
  return Array.isArray(data) ? { __kind: kind, fields: data } : { __kind: kind, ...data ?? {} };
}
function isExtension(kind, value) {
  return value.__kind === kind;
}
var ExtensionType = /* @__PURE__ */ ((ExtensionType2) => {
  ExtensionType2[ExtensionType2["Uninitialized"] = 0] = "Uninitialized";
  ExtensionType2[ExtensionType2["TransferFeeConfig"] = 1] = "TransferFeeConfig";
  ExtensionType2[ExtensionType2["TransferFeeAmount"] = 2] = "TransferFeeAmount";
  ExtensionType2[ExtensionType2["MintCloseAuthority"] = 3] = "MintCloseAuthority";
  ExtensionType2[ExtensionType2["ConfidentialTransferMint"] = 4] = "ConfidentialTransferMint";
  ExtensionType2[ExtensionType2["ConfidentialTransferAccount"] = 5] = "ConfidentialTransferAccount";
  ExtensionType2[ExtensionType2["DefaultAccountState"] = 6] = "DefaultAccountState";
  ExtensionType2[ExtensionType2["ImmutableOwner"] = 7] = "ImmutableOwner";
  ExtensionType2[ExtensionType2["MemoTransfer"] = 8] = "MemoTransfer";
  ExtensionType2[ExtensionType2["NonTransferable"] = 9] = "NonTransferable";
  ExtensionType2[ExtensionType2["InterestBearingConfig"] = 10] = "InterestBearingConfig";
  ExtensionType2[ExtensionType2["CpiGuard"] = 11] = "CpiGuard";
  ExtensionType2[ExtensionType2["PermanentDelegate"] = 12] = "PermanentDelegate";
  ExtensionType2[ExtensionType2["NonTransferableAccount"] = 13] = "NonTransferableAccount";
  ExtensionType2[ExtensionType2["TransferHook"] = 14] = "TransferHook";
  ExtensionType2[ExtensionType2["TransferHookAccount"] = 15] = "TransferHookAccount";
  ExtensionType2[ExtensionType2["ConfidentialTransferFee"] = 16] = "ConfidentialTransferFee";
  ExtensionType2[ExtensionType2["ConfidentialTransferFeeAmount"] = 17] = "ConfidentialTransferFeeAmount";
  ExtensionType2[ExtensionType2["ScaledUiAmountConfig"] = 18] = "ScaledUiAmountConfig";
  ExtensionType2[ExtensionType2["PausableConfig"] = 19] = "PausableConfig";
  ExtensionType2[ExtensionType2["PausableAccount"] = 20] = "PausableAccount";
  ExtensionType2[ExtensionType2["MetadataPointer"] = 21] = "MetadataPointer";
  ExtensionType2[ExtensionType2["TokenMetadata"] = 22] = "TokenMetadata";
  ExtensionType2[ExtensionType2["GroupPointer"] = 23] = "GroupPointer";
  ExtensionType2[ExtensionType2["TokenGroup"] = 24] = "TokenGroup";
  ExtensionType2[ExtensionType2["GroupMemberPointer"] = 25] = "GroupMemberPointer";
  ExtensionType2[ExtensionType2["TokenGroupMember"] = 26] = "TokenGroupMember";
  return ExtensionType2;
})(ExtensionType || {});
function getExtensionTypeEncoder() {
  return getEnumEncoder(ExtensionType, { size: getU16Encoder() });
}
function getExtensionTypeDecoder() {
  return getEnumDecoder(ExtensionType, { size: getU16Decoder() });
}
function getExtensionTypeCodec() {
  return combineCodec(getExtensionTypeEncoder(), getExtensionTypeDecoder());
}
function getTokenMetadataFieldEncoder() {
  return getDiscriminatedUnionEncoder([
    ["Name", getUnitEncoder()],
    ["Symbol", getUnitEncoder()],
    ["Uri", getUnitEncoder()],
    [
      "Key",
      getStructEncoder([
        [
          "fields",
          getTupleEncoder([
            addEncoderSizePrefix(getUtf8Encoder(), getU32Encoder())
          ])
        ]
      ])
    ]
  ]);
}
function getTokenMetadataFieldDecoder() {
  return getDiscriminatedUnionDecoder([
    ["Name", getUnitDecoder()],
    ["Symbol", getUnitDecoder()],
    ["Uri", getUnitDecoder()],
    [
      "Key",
      getStructDecoder([
        [
          "fields",
          getTupleDecoder([
            addDecoderSizePrefix(getUtf8Decoder(), getU32Decoder())
          ])
        ]
      ])
    ]
  ]);
}
function getTokenMetadataFieldCodec() {
  return combineCodec(
    getTokenMetadataFieldEncoder(),
    getTokenMetadataFieldDecoder()
  );
}
function tokenMetadataField(kind, data) {
  return Array.isArray(data) ? { __kind: kind, fields: data } : { __kind: kind, ...data ?? {} };
}
function isTokenMetadataField(kind, value) {
  return value.__kind === kind;
}
function getTransferFeeEncoder() {
  return getStructEncoder([
    ["epoch", getU64Encoder()],
    ["maximumFee", getU64Encoder()],
    ["transferFeeBasisPoints", getU16Encoder()]
  ]);
}
function getTransferFeeDecoder() {
  return getStructDecoder([
    ["epoch", getU64Decoder()],
    ["maximumFee", getU64Decoder()],
    ["transferFeeBasisPoints", getU16Decoder()]
  ]);
}
function getTransferFeeCodec() {
  return combineCodec(getTransferFeeEncoder(), getTransferFeeDecoder());
}

// src/generated/accounts/mint.ts
function getMintEncoder() {
  return getStructEncoder([
    [
      "mintAuthority",
      getOptionEncoder(getAddressEncoder(), {
        prefix: getU32Encoder(),
        noneValue: "zeroes"
      })
    ],
    ["supply", getU64Encoder()],
    ["decimals", getU8Encoder()],
    ["isInitialized", getBooleanEncoder()],
    [
      "freezeAuthority",
      getOptionEncoder(getAddressEncoder(), {
        prefix: getU32Encoder(),
        noneValue: "zeroes"
      })
    ],
    [
      "extensions",
      getOptionEncoder(
        getHiddenPrefixEncoder(
          getArrayEncoder(getExtensionEncoder(), { size: "remainder" }),
          [getConstantEncoder(padLeftEncoder(getU8Encoder(), 83).encode(1))]
        ),
        { prefix: null }
      )
    ]
  ]);
}
function getMintDecoder() {
  return getStructDecoder([
    [
      "mintAuthority",
      getOptionDecoder(getAddressDecoder(), {
        prefix: getU32Decoder(),
        noneValue: "zeroes"
      })
    ],
    ["supply", getU64Decoder()],
    ["decimals", getU8Decoder()],
    ["isInitialized", getBooleanDecoder()],
    [
      "freezeAuthority",
      getOptionDecoder(getAddressDecoder(), {
        prefix: getU32Decoder(),
        noneValue: "zeroes"
      })
    ],
    [
      "extensions",
      getOptionDecoder(
        getHiddenPrefixDecoder(
          getArrayDecoder(getExtensionDecoder(), { size: "remainder" }),
          [getConstantDecoder(padLeftEncoder(getU8Encoder(), 83).encode(1))]
        ),
        { prefix: null }
      )
    ]
  ]);
}
function getMintCodec() {
  return combineCodec(getMintEncoder(), getMintDecoder());
}
function decodeMint(encodedAccount) {
  return decodeAccount(
    encodedAccount,
    getMintDecoder()
  );
}
async function fetchMint(rpc, address, config) {
  const maybeAccount = await fetchMaybeMint(rpc, address, config);
  assertAccountExists(maybeAccount);
  return maybeAccount;
}
async function fetchMaybeMint(rpc, address, config) {
  const maybeAccount = await fetchEncodedAccount(rpc, address, config);
  return decodeMint(maybeAccount);
}
async function fetchAllMint(rpc, addresses, config) {
  const maybeAccounts = await fetchAllMaybeMint(rpc, addresses, config);
  assertAccountsExist(maybeAccounts);
  return maybeAccounts;
}
async function fetchAllMaybeMint(rpc, addresses, config) {
  const maybeAccounts = await fetchEncodedAccounts(rpc, addresses, config);
  return maybeAccounts.map((maybeAccount) => decodeMint(maybeAccount));
}
function getMultisigEncoder() {
  return getStructEncoder([
    ["m", getU8Encoder()],
    ["n", getU8Encoder()],
    ["isInitialized", getBooleanEncoder()],
    ["signers", getArrayEncoder(getAddressEncoder(), { size: 11 })]
  ]);
}
function getMultisigDecoder() {
  return getStructDecoder([
    ["m", getU8Decoder()],
    ["n", getU8Decoder()],
    ["isInitialized", getBooleanDecoder()],
    ["signers", getArrayDecoder(getAddressDecoder(), { size: 11 })]
  ]);
}
function getMultisigCodec() {
  return combineCodec(getMultisigEncoder(), getMultisigDecoder());
}
function decodeMultisig(encodedAccount) {
  return decodeAccount(
    encodedAccount,
    getMultisigDecoder()
  );
}
async function fetchMultisig(rpc, address, config) {
  const maybeAccount = await fetchMaybeMultisig(rpc, address, config);
  assertAccountExists(maybeAccount);
  return maybeAccount;
}
async function fetchMaybeMultisig(rpc, address, config) {
  const maybeAccount = await fetchEncodedAccount(rpc, address, config);
  return decodeMultisig(maybeAccount);
}
async function fetchAllMultisig(rpc, addresses, config) {
  const maybeAccounts = await fetchAllMaybeMultisig(rpc, addresses, config);
  assertAccountsExist(maybeAccounts);
  return maybeAccounts;
}
async function fetchAllMaybeMultisig(rpc, addresses, config) {
  const maybeAccounts = await fetchEncodedAccounts(rpc, addresses, config);
  return maybeAccounts.map((maybeAccount) => decodeMultisig(maybeAccount));
}
function getMultisigSize() {
  return 355;
}
function getTokenEncoder() {
  return getStructEncoder([
    ["mint", getAddressEncoder()],
    ["owner", getAddressEncoder()],
    ["amount", getU64Encoder()],
    [
      "delegate",
      getOptionEncoder(getAddressEncoder(), {
        prefix: getU32Encoder(),
        noneValue: "zeroes"
      })
    ],
    ["state", getAccountStateEncoder()],
    [
      "isNative",
      getOptionEncoder(getU64Encoder(), {
        prefix: getU32Encoder(),
        noneValue: "zeroes"
      })
    ],
    ["delegatedAmount", getU64Encoder()],
    [
      "closeAuthority",
      getOptionEncoder(getAddressEncoder(), {
        prefix: getU32Encoder(),
        noneValue: "zeroes"
      })
    ],
    [
      "extensions",
      getOptionEncoder(
        getHiddenPrefixEncoder(
          getArrayEncoder(getExtensionEncoder(), { size: "remainder" }),
          [getConstantEncoder(getU8Encoder().encode(2))]
        ),
        { prefix: null }
      )
    ]
  ]);
}
function getTokenDecoder() {
  return getStructDecoder([
    ["mint", getAddressDecoder()],
    ["owner", getAddressDecoder()],
    ["amount", getU64Decoder()],
    [
      "delegate",
      getOptionDecoder(getAddressDecoder(), {
        prefix: getU32Decoder(),
        noneValue: "zeroes"
      })
    ],
    ["state", getAccountStateDecoder()],
    [
      "isNative",
      getOptionDecoder(getU64Decoder(), {
        prefix: getU32Decoder(),
        noneValue: "zeroes"
      })
    ],
    ["delegatedAmount", getU64Decoder()],
    [
      "closeAuthority",
      getOptionDecoder(getAddressDecoder(), {
        prefix: getU32Decoder(),
        noneValue: "zeroes"
      })
    ],
    [
      "extensions",
      getOptionDecoder(
        getHiddenPrefixDecoder(
          getArrayDecoder(getExtensionDecoder(), { size: "remainder" }),
          [getConstantDecoder(getU8Encoder().encode(2))]
        ),
        { prefix: null }
      )
    ]
  ]);
}
function getTokenCodec() {
  return combineCodec(getTokenEncoder(), getTokenDecoder());
}
function decodeToken(encodedAccount) {
  return decodeAccount(
    encodedAccount,
    getTokenDecoder()
  );
}
async function fetchToken(rpc, address, config) {
  const maybeAccount = await fetchMaybeToken(rpc, address, config);
  assertAccountExists(maybeAccount);
  return maybeAccount;
}
async function fetchMaybeToken(rpc, address, config) {
  const maybeAccount = await fetchEncodedAccount(rpc, address, config);
  return decodeToken(maybeAccount);
}
async function fetchAllToken(rpc, addresses, config) {
  const maybeAccounts = await fetchAllMaybeToken(rpc, addresses, config);
  assertAccountsExist(maybeAccounts);
  return maybeAccounts;
}
async function fetchAllMaybeToken(rpc, addresses, config) {
  const maybeAccounts = await fetchEncodedAccounts(rpc, addresses, config);
  return maybeAccounts.map((maybeAccount) => decodeToken(maybeAccount));
}
var ASSOCIATED_TOKEN_PROGRAM_ADDRESS = "ATokenGPvbdGVxr1b2hvZbsiqW5xWH25efTNsLJA8knL";
var AssociatedTokenInstruction = /* @__PURE__ */ ((AssociatedTokenInstruction2) => {
  AssociatedTokenInstruction2[AssociatedTokenInstruction2["CreateAssociatedToken"] = 0] = "CreateAssociatedToken";
  AssociatedTokenInstruction2[AssociatedTokenInstruction2["CreateAssociatedTokenIdempotent"] = 1] = "CreateAssociatedTokenIdempotent";
  AssociatedTokenInstruction2[AssociatedTokenInstruction2["RecoverNestedAssociatedToken"] = 2] = "RecoverNestedAssociatedToken";
  return AssociatedTokenInstruction2;
})(AssociatedTokenInstruction || {});
function identifyAssociatedTokenInstruction(instruction) {
  const data = "data" in instruction ? instruction.data : instruction;
  if (containsBytes(data, getU8Encoder().encode(0), 0)) {
    return 0 /* CreateAssociatedToken */;
  }
  if (containsBytes(data, getU8Encoder().encode(1), 0)) {
    return 1 /* CreateAssociatedTokenIdempotent */;
  }
  if (containsBytes(data, getU8Encoder().encode(2), 0)) {
    return 2 /* RecoverNestedAssociatedToken */;
  }
  throw new Error(
    "The provided instruction could not be identified as a associatedToken instruction."
  );
}
var TOKEN_2022_PROGRAM_ADDRESS = "TokenzQdBNbLqP5VEhdkAS6EPFLC1PHnBqCXEpPxuEb";
var Token2022Account = /* @__PURE__ */ ((Token2022Account2) => {
  Token2022Account2[Token2022Account2["Mint"] = 0] = "Mint";
  Token2022Account2[Token2022Account2["Token"] = 1] = "Token";
  Token2022Account2[Token2022Account2["Multisig"] = 2] = "Multisig";
  return Token2022Account2;
})(Token2022Account || {});
function identifyToken2022Account(account) {
  const data = "data" in account ? account.data : account;
  if (data.length === 82) {
    return 0 /* Mint */;
  }
  if (data.length === 165) {
    return 1 /* Token */;
  }
  if (data.length === 355) {
    return 2 /* Multisig */;
  }
  throw new Error(
    "The provided account could not be identified as a token-2022 account."
  );
}
var Token2022Instruction = /* @__PURE__ */ ((Token2022Instruction2) => {
  Token2022Instruction2[Token2022Instruction2["InitializeMint"] = 0] = "InitializeMint";
  Token2022Instruction2[Token2022Instruction2["InitializeAccount"] = 1] = "InitializeAccount";
  Token2022Instruction2[Token2022Instruction2["InitializeMultisig"] = 2] = "InitializeMultisig";
  Token2022Instruction2[Token2022Instruction2["Transfer"] = 3] = "Transfer";
  Token2022Instruction2[Token2022Instruction2["Approve"] = 4] = "Approve";
  Token2022Instruction2[Token2022Instruction2["Revoke"] = 5] = "Revoke";
  Token2022Instruction2[Token2022Instruction2["SetAuthority"] = 6] = "SetAuthority";
  Token2022Instruction2[Token2022Instruction2["MintTo"] = 7] = "MintTo";
  Token2022Instruction2[Token2022Instruction2["Burn"] = 8] = "Burn";
  Token2022Instruction2[Token2022Instruction2["CloseAccount"] = 9] = "CloseAccount";
  Token2022Instruction2[Token2022Instruction2["FreezeAccount"] = 10] = "FreezeAccount";
  Token2022Instruction2[Token2022Instruction2["ThawAccount"] = 11] = "ThawAccount";
  Token2022Instruction2[Token2022Instruction2["TransferChecked"] = 12] = "TransferChecked";
  Token2022Instruction2[Token2022Instruction2["ApproveChecked"] = 13] = "ApproveChecked";
  Token2022Instruction2[Token2022Instruction2["MintToChecked"] = 14] = "MintToChecked";
  Token2022Instruction2[Token2022Instruction2["BurnChecked"] = 15] = "BurnChecked";
  Token2022Instruction2[Token2022Instruction2["InitializeAccount2"] = 16] = "InitializeAccount2";
  Token2022Instruction2[Token2022Instruction2["SyncNative"] = 17] = "SyncNative";
  Token2022Instruction2[Token2022Instruction2["InitializeAccount3"] = 18] = "InitializeAccount3";
  Token2022Instruction2[Token2022Instruction2["InitializeMultisig2"] = 19] = "InitializeMultisig2";
  Token2022Instruction2[Token2022Instruction2["InitializeMint2"] = 20] = "InitializeMint2";
  Token2022Instruction2[Token2022Instruction2["GetAccountDataSize"] = 21] = "GetAccountDataSize";
  Token2022Instruction2[Token2022Instruction2["InitializeImmutableOwner"] = 22] = "InitializeImmutableOwner";
  Token2022Instruction2[Token2022Instruction2["AmountToUiAmount"] = 23] = "AmountToUiAmount";
  Token2022Instruction2[Token2022Instruction2["UiAmountToAmount"] = 24] = "UiAmountToAmount";
  Token2022Instruction2[Token2022Instruction2["InitializeMintCloseAuthority"] = 25] = "InitializeMintCloseAuthority";
  Token2022Instruction2[Token2022Instruction2["InitializeTransferFeeConfig"] = 26] = "InitializeTransferFeeConfig";
  Token2022Instruction2[Token2022Instruction2["TransferCheckedWithFee"] = 27] = "TransferCheckedWithFee";
  Token2022Instruction2[Token2022Instruction2["WithdrawWithheldTokensFromMint"] = 28] = "WithdrawWithheldTokensFromMint";
  Token2022Instruction2[Token2022Instruction2["WithdrawWithheldTokensFromAccounts"] = 29] = "WithdrawWithheldTokensFromAccounts";
  Token2022Instruction2[Token2022Instruction2["HarvestWithheldTokensToMint"] = 30] = "HarvestWithheldTokensToMint";
  Token2022Instruction2[Token2022Instruction2["SetTransferFee"] = 31] = "SetTransferFee";
  Token2022Instruction2[Token2022Instruction2["InitializeConfidentialTransferMint"] = 32] = "InitializeConfidentialTransferMint";
  Token2022Instruction2[Token2022Instruction2["UpdateConfidentialTransferMint"] = 33] = "UpdateConfidentialTransferMint";
  Token2022Instruction2[Token2022Instruction2["ConfigureConfidentialTransferAccount"] = 34] = "ConfigureConfidentialTransferAccount";
  Token2022Instruction2[Token2022Instruction2["ApproveConfidentialTransferAccount"] = 35] = "ApproveConfidentialTransferAccount";
  Token2022Instruction2[Token2022Instruction2["EmptyConfidentialTransferAccount"] = 36] = "EmptyConfidentialTransferAccount";
  Token2022Instruction2[Token2022Instruction2["ConfidentialDeposit"] = 37] = "ConfidentialDeposit";
  Token2022Instruction2[Token2022Instruction2["ConfidentialWithdraw"] = 38] = "ConfidentialWithdraw";
  Token2022Instruction2[Token2022Instruction2["ConfidentialTransfer"] = 39] = "ConfidentialTransfer";
  Token2022Instruction2[Token2022Instruction2["ApplyConfidentialPendingBalance"] = 40] = "ApplyConfidentialPendingBalance";
  Token2022Instruction2[Token2022Instruction2["EnableConfidentialCredits"] = 41] = "EnableConfidentialCredits";
  Token2022Instruction2[Token2022Instruction2["DisableConfidentialCredits"] = 42] = "DisableConfidentialCredits";
  Token2022Instruction2[Token2022Instruction2["EnableNonConfidentialCredits"] = 43] = "EnableNonConfidentialCredits";
  Token2022Instruction2[Token2022Instruction2["DisableNonConfidentialCredits"] = 44] = "DisableNonConfidentialCredits";
  Token2022Instruction2[Token2022Instruction2["ConfidentialTransferWithFee"] = 45] = "ConfidentialTransferWithFee";
  Token2022Instruction2[Token2022Instruction2["InitializeDefaultAccountState"] = 46] = "InitializeDefaultAccountState";
  Token2022Instruction2[Token2022Instruction2["UpdateDefaultAccountState"] = 47] = "UpdateDefaultAccountState";
  Token2022Instruction2[Token2022Instruction2["Reallocate"] = 48] = "Reallocate";
  Token2022Instruction2[Token2022Instruction2["EnableMemoTransfers"] = 49] = "EnableMemoTransfers";
  Token2022Instruction2[Token2022Instruction2["DisableMemoTransfers"] = 50] = "DisableMemoTransfers";
  Token2022Instruction2[Token2022Instruction2["CreateNativeMint"] = 51] = "CreateNativeMint";
  Token2022Instruction2[Token2022Instruction2["InitializeNonTransferableMint"] = 52] = "InitializeNonTransferableMint";
  Token2022Instruction2[Token2022Instruction2["InitializeInterestBearingMint"] = 53] = "InitializeInterestBearingMint";
  Token2022Instruction2[Token2022Instruction2["UpdateRateInterestBearingMint"] = 54] = "UpdateRateInterestBearingMint";
  Token2022Instruction2[Token2022Instruction2["EnableCpiGuard"] = 55] = "EnableCpiGuard";
  Token2022Instruction2[Token2022Instruction2["DisableCpiGuard"] = 56] = "DisableCpiGuard";
  Token2022Instruction2[Token2022Instruction2["InitializePermanentDelegate"] = 57] = "InitializePermanentDelegate";
  Token2022Instruction2[Token2022Instruction2["InitializeTransferHook"] = 58] = "InitializeTransferHook";
  Token2022Instruction2[Token2022Instruction2["UpdateTransferHook"] = 59] = "UpdateTransferHook";
  Token2022Instruction2[Token2022Instruction2["InitializeConfidentialTransferFee"] = 60] = "InitializeConfidentialTransferFee";
  Token2022Instruction2[Token2022Instruction2["WithdrawWithheldTokensFromMintForConfidentialTransferFee"] = 61] = "WithdrawWithheldTokensFromMintForConfidentialTransferFee";
  Token2022Instruction2[Token2022Instruction2["WithdrawWithheldTokensFromAccountsForConfidentialTransferFee"] = 62] = "WithdrawWithheldTokensFromAccountsForConfidentialTransferFee";
  Token2022Instruction2[Token2022Instruction2["HarvestWithheldTokensToMintForConfidentialTransferFee"] = 63] = "HarvestWithheldTokensToMintForConfidentialTransferFee";
  Token2022Instruction2[Token2022Instruction2["EnableHarvestToMint"] = 64] = "EnableHarvestToMint";
  Token2022Instruction2[Token2022Instruction2["DisableHarvestToMint"] = 65] = "DisableHarvestToMint";
  Token2022Instruction2[Token2022Instruction2["WithdrawExcessLamports"] = 66] = "WithdrawExcessLamports";
  Token2022Instruction2[Token2022Instruction2["InitializeMetadataPointer"] = 67] = "InitializeMetadataPointer";
  Token2022Instruction2[Token2022Instruction2["UpdateMetadataPointer"] = 68] = "UpdateMetadataPointer";
  Token2022Instruction2[Token2022Instruction2["InitializeGroupPointer"] = 69] = "InitializeGroupPointer";
  Token2022Instruction2[Token2022Instruction2["UpdateGroupPointer"] = 70] = "UpdateGroupPointer";
  Token2022Instruction2[Token2022Instruction2["InitializeGroupMemberPointer"] = 71] = "InitializeGroupMemberPointer";
  Token2022Instruction2[Token2022Instruction2["UpdateGroupMemberPointer"] = 72] = "UpdateGroupMemberPointer";
  Token2022Instruction2[Token2022Instruction2["InitializeScaledUiAmountMint"] = 73] = "InitializeScaledUiAmountMint";
  Token2022Instruction2[Token2022Instruction2["UpdateMultiplierScaledUiMint"] = 74] = "UpdateMultiplierScaledUiMint";
  Token2022Instruction2[Token2022Instruction2["InitializePausableConfig"] = 75] = "InitializePausableConfig";
  Token2022Instruction2[Token2022Instruction2["Pause"] = 76] = "Pause";
  Token2022Instruction2[Token2022Instruction2["Resume"] = 77] = "Resume";
  Token2022Instruction2[Token2022Instruction2["InitializeTokenMetadata"] = 78] = "InitializeTokenMetadata";
  Token2022Instruction2[Token2022Instruction2["UpdateTokenMetadataField"] = 79] = "UpdateTokenMetadataField";
  Token2022Instruction2[Token2022Instruction2["RemoveTokenMetadataKey"] = 80] = "RemoveTokenMetadataKey";
  Token2022Instruction2[Token2022Instruction2["UpdateTokenMetadataUpdateAuthority"] = 81] = "UpdateTokenMetadataUpdateAuthority";
  Token2022Instruction2[Token2022Instruction2["EmitTokenMetadata"] = 82] = "EmitTokenMetadata";
  Token2022Instruction2[Token2022Instruction2["InitializeTokenGroup"] = 83] = "InitializeTokenGroup";
  Token2022Instruction2[Token2022Instruction2["UpdateTokenGroupMaxSize"] = 84] = "UpdateTokenGroupMaxSize";
  Token2022Instruction2[Token2022Instruction2["UpdateTokenGroupUpdateAuthority"] = 85] = "UpdateTokenGroupUpdateAuthority";
  Token2022Instruction2[Token2022Instruction2["InitializeTokenGroupMember"] = 86] = "InitializeTokenGroupMember";
  return Token2022Instruction2;
})(Token2022Instruction || {});
function identifyToken2022Instruction(instruction) {
  const data = "data" in instruction ? instruction.data : instruction;
  if (containsBytes(data, getU8Encoder().encode(0), 0)) {
    return 0 /* InitializeMint */;
  }
  if (containsBytes(data, getU8Encoder().encode(1), 0)) {
    return 1 /* InitializeAccount */;
  }
  if (containsBytes(data, getU8Encoder().encode(2), 0)) {
    return 2 /* InitializeMultisig */;
  }
  if (containsBytes(data, getU8Encoder().encode(3), 0)) {
    return 3 /* Transfer */;
  }
  if (containsBytes(data, getU8Encoder().encode(4), 0)) {
    return 4 /* Approve */;
  }
  if (containsBytes(data, getU8Encoder().encode(5), 0)) {
    return 5 /* Revoke */;
  }
  if (containsBytes(data, getU8Encoder().encode(6), 0)) {
    return 6 /* SetAuthority */;
  }
  if (containsBytes(data, getU8Encoder().encode(7), 0)) {
    return 7 /* MintTo */;
  }
  if (containsBytes(data, getU8Encoder().encode(8), 0)) {
    return 8 /* Burn */;
  }
  if (containsBytes(data, getU8Encoder().encode(9), 0)) {
    return 9 /* CloseAccount */;
  }
  if (containsBytes(data, getU8Encoder().encode(10), 0)) {
    return 10 /* FreezeAccount */;
  }
  if (containsBytes(data, getU8Encoder().encode(11), 0)) {
    return 11 /* ThawAccount */;
  }
  if (containsBytes(data, getU8Encoder().encode(12), 0)) {
    return 12 /* TransferChecked */;
  }
  if (containsBytes(data, getU8Encoder().encode(13), 0)) {
    return 13 /* ApproveChecked */;
  }
  if (containsBytes(data, getU8Encoder().encode(14), 0)) {
    return 14 /* MintToChecked */;
  }
  if (containsBytes(data, getU8Encoder().encode(15), 0)) {
    return 15 /* BurnChecked */;
  }
  if (containsBytes(data, getU8Encoder().encode(16), 0)) {
    return 16 /* InitializeAccount2 */;
  }
  if (containsBytes(data, getU8Encoder().encode(17), 0)) {
    return 17 /* SyncNative */;
  }
  if (containsBytes(data, getU8Encoder().encode(18), 0)) {
    return 18 /* InitializeAccount3 */;
  }
  if (containsBytes(data, getU8Encoder().encode(19), 0)) {
    return 19 /* InitializeMultisig2 */;
  }
  if (containsBytes(data, getU8Encoder().encode(20), 0)) {
    return 20 /* InitializeMint2 */;
  }
  if (containsBytes(data, getU8Encoder().encode(21), 0)) {
    return 21 /* GetAccountDataSize */;
  }
  if (containsBytes(data, getU8Encoder().encode(22), 0)) {
    return 22 /* InitializeImmutableOwner */;
  }
  if (containsBytes(data, getU8Encoder().encode(23), 0)) {
    return 23 /* AmountToUiAmount */;
  }
  if (containsBytes(data, getU8Encoder().encode(24), 0)) {
    return 24 /* UiAmountToAmount */;
  }
  if (containsBytes(data, getU8Encoder().encode(25), 0)) {
    return 25 /* InitializeMintCloseAuthority */;
  }
  if (containsBytes(data, getU8Encoder().encode(26), 0) && containsBytes(data, getU8Encoder().encode(0), 1)) {
    return 26 /* InitializeTransferFeeConfig */;
  }
  if (containsBytes(data, getU8Encoder().encode(26), 0) && containsBytes(data, getU8Encoder().encode(1), 1)) {
    return 27 /* TransferCheckedWithFee */;
  }
  if (containsBytes(data, getU8Encoder().encode(26), 0) && containsBytes(data, getU8Encoder().encode(2), 1)) {
    return 28 /* WithdrawWithheldTokensFromMint */;
  }
  if (containsBytes(data, getU8Encoder().encode(26), 0) && containsBytes(data, getU8Encoder().encode(3), 1)) {
    return 29 /* WithdrawWithheldTokensFromAccounts */;
  }
  if (containsBytes(data, getU8Encoder().encode(26), 0) && containsBytes(data, getU8Encoder().encode(4), 1)) {
    return 30 /* HarvestWithheldTokensToMint */;
  }
  if (containsBytes(data, getU8Encoder().encode(26), 0) && containsBytes(data, getU8Encoder().encode(5), 1)) {
    return 31 /* SetTransferFee */;
  }
  if (containsBytes(data, getU8Encoder().encode(27), 0) && containsBytes(data, getU8Encoder().encode(0), 1)) {
    return 32 /* InitializeConfidentialTransferMint */;
  }
  if (containsBytes(data, getU8Encoder().encode(27), 0) && containsBytes(data, getU8Encoder().encode(1), 1)) {
    return 33 /* UpdateConfidentialTransferMint */;
  }
  if (containsBytes(data, getU8Encoder().encode(27), 0) && containsBytes(data, getU8Encoder().encode(2), 1)) {
    return 34 /* ConfigureConfidentialTransferAccount */;
  }
  if (containsBytes(data, getU8Encoder().encode(27), 0) && containsBytes(data, getU8Encoder().encode(3), 1)) {
    return 35 /* ApproveConfidentialTransferAccount */;
  }
  if (containsBytes(data, getU8Encoder().encode(27), 0) && containsBytes(data, getU8Encoder().encode(4), 1)) {
    return 36 /* EmptyConfidentialTransferAccount */;
  }
  if (containsBytes(data, getU8Encoder().encode(27), 0) && containsBytes(data, getU8Encoder().encode(5), 1)) {
    return 37 /* ConfidentialDeposit */;
  }
  if (containsBytes(data, getU8Encoder().encode(27), 0) && containsBytes(data, getU8Encoder().encode(6), 1)) {
    return 38 /* ConfidentialWithdraw */;
  }
  if (containsBytes(data, getU8Encoder().encode(27), 0) && containsBytes(data, getU8Encoder().encode(7), 1)) {
    return 39 /* ConfidentialTransfer */;
  }
  if (containsBytes(data, getU8Encoder().encode(27), 0) && containsBytes(data, getU8Encoder().encode(8), 1)) {
    return 40 /* ApplyConfidentialPendingBalance */;
  }
  if (containsBytes(data, getU8Encoder().encode(27), 0) && containsBytes(data, getU8Encoder().encode(9), 1)) {
    return 41 /* EnableConfidentialCredits */;
  }
  if (containsBytes(data, getU8Encoder().encode(27), 0) && containsBytes(data, getU8Encoder().encode(10), 1)) {
    return 42 /* DisableConfidentialCredits */;
  }
  if (containsBytes(data, getU8Encoder().encode(27), 0) && containsBytes(data, getU8Encoder().encode(11), 1)) {
    return 43 /* EnableNonConfidentialCredits */;
  }
  if (containsBytes(data, getU8Encoder().encode(27), 0) && containsBytes(data, getU8Encoder().encode(12), 1)) {
    return 44 /* DisableNonConfidentialCredits */;
  }
  if (containsBytes(data, getU8Encoder().encode(27), 0) && containsBytes(data, getU8Encoder().encode(13), 1)) {
    return 45 /* ConfidentialTransferWithFee */;
  }
  if (containsBytes(data, getU8Encoder().encode(28), 0) && containsBytes(data, getU8Encoder().encode(0), 1)) {
    return 46 /* InitializeDefaultAccountState */;
  }
  if (containsBytes(data, getU8Encoder().encode(28), 0) && containsBytes(data, getU8Encoder().encode(1), 1)) {
    return 47 /* UpdateDefaultAccountState */;
  }
  if (containsBytes(data, getU8Encoder().encode(29), 0)) {
    return 48 /* Reallocate */;
  }
  if (containsBytes(data, getU8Encoder().encode(30), 0) && containsBytes(data, getU8Encoder().encode(0), 1)) {
    return 49 /* EnableMemoTransfers */;
  }
  if (containsBytes(data, getU8Encoder().encode(30), 0) && containsBytes(data, getU8Encoder().encode(1), 1)) {
    return 50 /* DisableMemoTransfers */;
  }
  if (containsBytes(data, getU8Encoder().encode(31), 0)) {
    return 51 /* CreateNativeMint */;
  }
  if (containsBytes(data, getU8Encoder().encode(32), 0)) {
    return 52 /* InitializeNonTransferableMint */;
  }
  if (containsBytes(data, getU8Encoder().encode(33), 0) && containsBytes(data, getU8Encoder().encode(0), 1)) {
    return 53 /* InitializeInterestBearingMint */;
  }
  if (containsBytes(data, getU8Encoder().encode(33), 0) && containsBytes(data, getU8Encoder().encode(1), 1)) {
    return 54 /* UpdateRateInterestBearingMint */;
  }
  if (containsBytes(data, getU8Encoder().encode(34), 0) && containsBytes(data, getU8Encoder().encode(0), 1)) {
    return 55 /* EnableCpiGuard */;
  }
  if (containsBytes(data, getU8Encoder().encode(34), 0) && containsBytes(data, getU8Encoder().encode(1), 1)) {
    return 56 /* DisableCpiGuard */;
  }
  if (containsBytes(data, getU8Encoder().encode(35), 0)) {
    return 57 /* InitializePermanentDelegate */;
  }
  if (containsBytes(data, getU8Encoder().encode(36), 0) && containsBytes(data, getU8Encoder().encode(0), 1)) {
    return 58 /* InitializeTransferHook */;
  }
  if (containsBytes(data, getU8Encoder().encode(36), 0) && containsBytes(data, getU8Encoder().encode(1), 1)) {
    return 59 /* UpdateTransferHook */;
  }
  if (containsBytes(data, getU8Encoder().encode(37), 0) && containsBytes(data, getU8Encoder().encode(0), 1)) {
    return 60 /* InitializeConfidentialTransferFee */;
  }
  if (containsBytes(data, getU8Encoder().encode(37), 0) && containsBytes(data, getU8Encoder().encode(1), 1)) {
    return 61 /* WithdrawWithheldTokensFromMintForConfidentialTransferFee */;
  }
  if (containsBytes(data, getU8Encoder().encode(37), 0) && containsBytes(data, getU8Encoder().encode(2), 1)) {
    return 62 /* WithdrawWithheldTokensFromAccountsForConfidentialTransferFee */;
  }
  if (containsBytes(data, getU8Encoder().encode(37), 0) && containsBytes(data, getU8Encoder().encode(3), 1)) {
    return 63 /* HarvestWithheldTokensToMintForConfidentialTransferFee */;
  }
  if (containsBytes(data, getU8Encoder().encode(37), 0) && containsBytes(data, getU8Encoder().encode(4), 1)) {
    return 64 /* EnableHarvestToMint */;
  }
  if (containsBytes(data, getU8Encoder().encode(37), 0) && containsBytes(data, getU8Encoder().encode(5), 1)) {
    return 65 /* DisableHarvestToMint */;
  }
  if (containsBytes(data, getU8Encoder().encode(38), 0)) {
    return 66 /* WithdrawExcessLamports */;
  }
  if (containsBytes(data, getU8Encoder().encode(39), 0) && containsBytes(data, getU8Encoder().encode(0), 1)) {
    return 67 /* InitializeMetadataPointer */;
  }
  if (containsBytes(data, getU8Encoder().encode(39), 0) && containsBytes(data, getU8Encoder().encode(1), 1)) {
    return 68 /* UpdateMetadataPointer */;
  }
  if (containsBytes(data, getU8Encoder().encode(40), 0) && containsBytes(data, getU8Encoder().encode(0), 1)) {
    return 69 /* InitializeGroupPointer */;
  }
  if (containsBytes(data, getU8Encoder().encode(40), 0) && containsBytes(data, getU8Encoder().encode(1), 1)) {
    return 70 /* UpdateGroupPointer */;
  }
  if (containsBytes(data, getU8Encoder().encode(41), 0) && containsBytes(data, getU8Encoder().encode(0), 1)) {
    return 71 /* InitializeGroupMemberPointer */;
  }
  if (containsBytes(data, getU8Encoder().encode(41), 0) && containsBytes(data, getU8Encoder().encode(1), 1)) {
    return 72 /* UpdateGroupMemberPointer */;
  }
  if (containsBytes(data, getU8Encoder().encode(43), 0) && containsBytes(data, getU8Encoder().encode(0), 1)) {
    return 73 /* InitializeScaledUiAmountMint */;
  }
  if (containsBytes(data, getU8Encoder().encode(43), 0) && containsBytes(data, getU8Encoder().encode(1), 1)) {
    return 74 /* UpdateMultiplierScaledUiMint */;
  }
  if (containsBytes(data, getU8Encoder().encode(44), 0) && containsBytes(data, getU8Encoder().encode(0), 1)) {
    return 75 /* InitializePausableConfig */;
  }
  if (containsBytes(data, getU8Encoder().encode(44), 0) && containsBytes(data, getU8Encoder().encode(1), 1)) {
    return 76 /* Pause */;
  }
  if (containsBytes(data, getU8Encoder().encode(44), 0) && containsBytes(data, getU8Encoder().encode(2), 1)) {
    return 77 /* Resume */;
  }
  if (containsBytes(
    data,
    new Uint8Array([210, 225, 30, 162, 88, 184, 77, 141]),
    0
  )) {
    return 78 /* InitializeTokenMetadata */;
  }
  if (containsBytes(
    data,
    new Uint8Array([221, 233, 49, 45, 181, 202, 220, 200]),
    0
  )) {
    return 79 /* UpdateTokenMetadataField */;
  }
  if (containsBytes(data, new Uint8Array([234, 18, 32, 56, 89, 141, 37, 181]), 0)) {
    return 80 /* RemoveTokenMetadataKey */;
  }
  if (containsBytes(
    data,
    new Uint8Array([215, 228, 166, 228, 84, 100, 86, 123]),
    0
  )) {
    return 81 /* UpdateTokenMetadataUpdateAuthority */;
  }
  if (containsBytes(
    data,
    new Uint8Array([250, 166, 180, 250, 13, 12, 184, 70]),
    0
  )) {
    return 82 /* EmitTokenMetadata */;
  }
  if (containsBytes(data, new Uint8Array([121, 113, 108, 39, 54, 51, 0, 4]), 0)) {
    return 83 /* InitializeTokenGroup */;
  }
  if (containsBytes(
    data,
    new Uint8Array([108, 37, 171, 143, 248, 30, 18, 110]),
    0
  )) {
    return 84 /* UpdateTokenGroupMaxSize */;
  }
  if (containsBytes(
    data,
    new Uint8Array([161, 105, 88, 1, 237, 221, 216, 203]),
    0
  )) {
    return 85 /* UpdateTokenGroupUpdateAuthority */;
  }
  if (containsBytes(
    data,
    new Uint8Array([152, 32, 222, 176, 223, 237, 116, 134]),
    0
  )) {
    return 86 /* InitializeTokenGroupMember */;
  }
  throw new Error(
    "The provided instruction could not be identified as a token-2022 instruction."
  );
}

// src/generated/errors/associatedToken.ts
var ASSOCIATED_TOKEN_ERROR__INVALID_OWNER = 0;
var associatedTokenErrorMessages;
if (process.env.NODE_ENV !== "production") {
  associatedTokenErrorMessages = {
    [ASSOCIATED_TOKEN_ERROR__INVALID_OWNER]: `Associated token account owner does not match address derivation`
  };
}
function getAssociatedTokenErrorMessage(code) {
  if (process.env.NODE_ENV !== "production") {
    return associatedTokenErrorMessages[code];
  }
  return "Error message not available in production bundles.";
}
function isAssociatedTokenError(error, transactionMessage, code) {
  return isProgramError(
    error,
    transactionMessage,
    ASSOCIATED_TOKEN_PROGRAM_ADDRESS,
    code
  );
}
var TOKEN_2022_ERROR__NOT_RENT_EXEMPT = 0;
var TOKEN_2022_ERROR__INSUFFICIENT_FUNDS = 1;
var TOKEN_2022_ERROR__INVALID_MINT = 2;
var TOKEN_2022_ERROR__MINT_MISMATCH = 3;
var TOKEN_2022_ERROR__OWNER_MISMATCH = 4;
var TOKEN_2022_ERROR__FIXED_SUPPLY = 5;
var TOKEN_2022_ERROR__ALREADY_IN_USE = 6;
var TOKEN_2022_ERROR__INVALID_NUMBER_OF_PROVIDED_SIGNERS = 7;
var TOKEN_2022_ERROR__INVALID_NUMBER_OF_REQUIRED_SIGNERS = 8;
var TOKEN_2022_ERROR__UNINITIALIZED_STATE = 9;
var TOKEN_2022_ERROR__NATIVE_NOT_SUPPORTED = 10;
var TOKEN_2022_ERROR__NON_NATIVE_HAS_BALANCE = 11;
var TOKEN_2022_ERROR__INVALID_INSTRUCTION = 12;
var TOKEN_2022_ERROR__INVALID_STATE = 13;
var TOKEN_2022_ERROR__OVERFLOW = 14;
var TOKEN_2022_ERROR__AUTHORITY_TYPE_NOT_SUPPORTED = 15;
var TOKEN_2022_ERROR__MINT_CANNOT_FREEZE = 16;
var TOKEN_2022_ERROR__ACCOUNT_FROZEN = 17;
var TOKEN_2022_ERROR__MINT_DECIMALS_MISMATCH = 18;
var TOKEN_2022_ERROR__NON_NATIVE_NOT_SUPPORTED = 19;
var token2022ErrorMessages;
if (process.env.NODE_ENV !== "production") {
  token2022ErrorMessages = {
    [TOKEN_2022_ERROR__ACCOUNT_FROZEN]: `Account is frozen`,
    [TOKEN_2022_ERROR__ALREADY_IN_USE]: `Already in use`,
    [TOKEN_2022_ERROR__AUTHORITY_TYPE_NOT_SUPPORTED]: `Account does not support specified authority type`,
    [TOKEN_2022_ERROR__FIXED_SUPPLY]: `Fixed supply`,
    [TOKEN_2022_ERROR__INSUFFICIENT_FUNDS]: `Insufficient funds`,
    [TOKEN_2022_ERROR__INVALID_INSTRUCTION]: `Invalid instruction`,
    [TOKEN_2022_ERROR__INVALID_MINT]: `Invalid Mint`,
    [TOKEN_2022_ERROR__INVALID_NUMBER_OF_PROVIDED_SIGNERS]: `Invalid number of provided signers`,
    [TOKEN_2022_ERROR__INVALID_NUMBER_OF_REQUIRED_SIGNERS]: `Invalid number of required signers`,
    [TOKEN_2022_ERROR__INVALID_STATE]: `State is invalid for requested operation`,
    [TOKEN_2022_ERROR__MINT_CANNOT_FREEZE]: `This token mint cannot freeze accounts`,
    [TOKEN_2022_ERROR__MINT_DECIMALS_MISMATCH]: `The provided decimals value different from the Mint decimals`,
    [TOKEN_2022_ERROR__MINT_MISMATCH]: `Account not associated with this Mint`,
    [TOKEN_2022_ERROR__NATIVE_NOT_SUPPORTED]: `Instruction does not support native tokens`,
    [TOKEN_2022_ERROR__NON_NATIVE_HAS_BALANCE]: `Non-native account can only be closed if its balance is zero`,
    [TOKEN_2022_ERROR__NON_NATIVE_NOT_SUPPORTED]: `Instruction does not support non-native tokens`,
    [TOKEN_2022_ERROR__NOT_RENT_EXEMPT]: `Lamport balance below rent-exempt threshold`,
    [TOKEN_2022_ERROR__OVERFLOW]: `Operation overflowed`,
    [TOKEN_2022_ERROR__OWNER_MISMATCH]: `Owner does not match`,
    [TOKEN_2022_ERROR__UNINITIALIZED_STATE]: `State is unititialized`
  };
}
function getToken2022ErrorMessage(code) {
  if (process.env.NODE_ENV !== "production") {
    return token2022ErrorMessages[code];
  }
  return "Error message not available in production bundles.";
}
function isToken2022Error(error, transactionMessage, code) {
  return isProgramError(
    error,
    transactionMessage,
    TOKEN_2022_PROGRAM_ADDRESS,
    code
  );
}
function expectAddress(value) {
  if (!value) {
    throw new Error("Expected a Address.");
  }
  if (typeof value === "object" && "address" in value) {
    return value.address;
  }
  if (Array.isArray(value)) {
    return value[0];
  }
  return value;
}
function getAccountMetaFactory(programAddress, optionalAccountStrategy) {
  return (account) => {
    if (!account.value) {
      return Object.freeze({
        address: programAddress,
        role: AccountRole.READONLY
      });
    }
    const writableRole = account.isWritable ? AccountRole.WRITABLE : AccountRole.READONLY;
    return Object.freeze({
      address: expectAddress(account.value),
      role: isTransactionSigner(account.value) ? upgradeRoleToSigner(writableRole) : writableRole,
      ...isTransactionSigner(account.value) ? { signer: account.value } : {}
    });
  };
}
function isTransactionSigner(value) {
  return !!value && typeof value === "object" && "address" in value && isTransactionSigner$1(value);
}

// src/generated/instructions/amountToUiAmount.ts
var AMOUNT_TO_UI_AMOUNT_DISCRIMINATOR = 23;
function getAmountToUiAmountDiscriminatorBytes() {
  return getU8Encoder().encode(AMOUNT_TO_UI_AMOUNT_DISCRIMINATOR);
}
function getAmountToUiAmountInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["amount", getU64Encoder()]
    ]),
    (value) => ({ ...value, discriminator: AMOUNT_TO_UI_AMOUNT_DISCRIMINATOR })
  );
}
function getAmountToUiAmountInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["amount", getU64Decoder()]
  ]);
}
function getAmountToUiAmountInstructionDataCodec() {
  return combineCodec(
    getAmountToUiAmountInstructionDataEncoder(),
    getAmountToUiAmountInstructionDataDecoder()
  );
}
function getAmountToUiAmountInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    mint: { value: input.mint ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [getAccountMeta(accounts.mint)],
    programAddress,
    data: getAmountToUiAmountInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseAmountToUiAmountInstruction(instruction) {
  if (instruction.accounts.length < 1) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      mint: getNextAccount()
    },
    data: getAmountToUiAmountInstructionDataDecoder().decode(instruction.data)
  };
}
var APPLY_CONFIDENTIAL_PENDING_BALANCE_DISCRIMINATOR = 27;
function getApplyConfidentialPendingBalanceDiscriminatorBytes() {
  return getU8Encoder().encode(
    APPLY_CONFIDENTIAL_PENDING_BALANCE_DISCRIMINATOR
  );
}
var APPLY_CONFIDENTIAL_PENDING_BALANCE_CONFIDENTIAL_TRANSFER_DISCRIMINATOR = 8;
function getApplyConfidentialPendingBalanceConfidentialTransferDiscriminatorBytes() {
  return getU8Encoder().encode(
    APPLY_CONFIDENTIAL_PENDING_BALANCE_CONFIDENTIAL_TRANSFER_DISCRIMINATOR
  );
}
function getApplyConfidentialPendingBalanceInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["confidentialTransferDiscriminator", getU8Encoder()],
      ["expectedPendingBalanceCreditCounter", getU64Encoder()],
      ["newDecryptableAvailableBalance", getDecryptableBalanceEncoder()]
    ]),
    (value) => ({
      ...value,
      discriminator: APPLY_CONFIDENTIAL_PENDING_BALANCE_DISCRIMINATOR,
      confidentialTransferDiscriminator: APPLY_CONFIDENTIAL_PENDING_BALANCE_CONFIDENTIAL_TRANSFER_DISCRIMINATOR
    })
  );
}
function getApplyConfidentialPendingBalanceInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["confidentialTransferDiscriminator", getU8Decoder()],
    ["expectedPendingBalanceCreditCounter", getU64Decoder()],
    ["newDecryptableAvailableBalance", getDecryptableBalanceDecoder()]
  ]);
}
function getApplyConfidentialPendingBalanceInstructionDataCodec() {
  return combineCodec(
    getApplyConfidentialPendingBalanceInstructionDataEncoder(),
    getApplyConfidentialPendingBalanceInstructionDataDecoder()
  );
}
function getApplyConfidentialPendingBalanceInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    token: { value: input.token ?? null, isWritable: true },
    authority: { value: input.authority ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.token),
      getAccountMeta(accounts.authority),
      ...remainingAccounts
    ],
    programAddress,
    data: getApplyConfidentialPendingBalanceInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseApplyConfidentialPendingBalanceInstruction(instruction) {
  if (instruction.accounts.length < 2) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      token: getNextAccount(),
      authority: getNextAccount()
    },
    data: getApplyConfidentialPendingBalanceInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var APPROVE_DISCRIMINATOR = 4;
function getApproveDiscriminatorBytes() {
  return getU8Encoder().encode(APPROVE_DISCRIMINATOR);
}
function getApproveInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["amount", getU64Encoder()]
    ]),
    (value) => ({ ...value, discriminator: APPROVE_DISCRIMINATOR })
  );
}
function getApproveInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["amount", getU64Decoder()]
  ]);
}
function getApproveInstructionDataCodec() {
  return combineCodec(
    getApproveInstructionDataEncoder(),
    getApproveInstructionDataDecoder()
  );
}
function getApproveInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    source: { value: input.source ?? null, isWritable: true },
    delegate: { value: input.delegate ?? null, isWritable: false },
    owner: { value: input.owner ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.source),
      getAccountMeta(accounts.delegate),
      getAccountMeta(accounts.owner),
      ...remainingAccounts
    ],
    programAddress,
    data: getApproveInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseApproveInstruction(instruction) {
  if (instruction.accounts.length < 3) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      source: getNextAccount(),
      delegate: getNextAccount(),
      owner: getNextAccount()
    },
    data: getApproveInstructionDataDecoder().decode(instruction.data)
  };
}
var APPROVE_CHECKED_DISCRIMINATOR = 13;
function getApproveCheckedDiscriminatorBytes() {
  return getU8Encoder().encode(APPROVE_CHECKED_DISCRIMINATOR);
}
function getApproveCheckedInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["amount", getU64Encoder()],
      ["decimals", getU8Encoder()]
    ]),
    (value) => ({ ...value, discriminator: APPROVE_CHECKED_DISCRIMINATOR })
  );
}
function getApproveCheckedInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["amount", getU64Decoder()],
    ["decimals", getU8Decoder()]
  ]);
}
function getApproveCheckedInstructionDataCodec() {
  return combineCodec(
    getApproveCheckedInstructionDataEncoder(),
    getApproveCheckedInstructionDataDecoder()
  );
}
function getApproveCheckedInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    source: { value: input.source ?? null, isWritable: true },
    mint: { value: input.mint ?? null, isWritable: false },
    delegate: { value: input.delegate ?? null, isWritable: false },
    owner: { value: input.owner ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.source),
      getAccountMeta(accounts.mint),
      getAccountMeta(accounts.delegate),
      getAccountMeta(accounts.owner),
      ...remainingAccounts
    ],
    programAddress,
    data: getApproveCheckedInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseApproveCheckedInstruction(instruction) {
  if (instruction.accounts.length < 4) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      source: getNextAccount(),
      mint: getNextAccount(),
      delegate: getNextAccount(),
      owner: getNextAccount()
    },
    data: getApproveCheckedInstructionDataDecoder().decode(instruction.data)
  };
}
var APPROVE_CONFIDENTIAL_TRANSFER_ACCOUNT_DISCRIMINATOR = 27;
function getApproveConfidentialTransferAccountDiscriminatorBytes() {
  return getU8Encoder().encode(
    APPROVE_CONFIDENTIAL_TRANSFER_ACCOUNT_DISCRIMINATOR
  );
}
var APPROVE_CONFIDENTIAL_TRANSFER_ACCOUNT_CONFIDENTIAL_TRANSFER_DISCRIMINATOR = 3;
function getApproveConfidentialTransferAccountConfidentialTransferDiscriminatorBytes() {
  return getU8Encoder().encode(
    APPROVE_CONFIDENTIAL_TRANSFER_ACCOUNT_CONFIDENTIAL_TRANSFER_DISCRIMINATOR
  );
}
function getApproveConfidentialTransferAccountInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["confidentialTransferDiscriminator", getU8Encoder()]
    ]),
    (value) => ({
      ...value,
      discriminator: APPROVE_CONFIDENTIAL_TRANSFER_ACCOUNT_DISCRIMINATOR,
      confidentialTransferDiscriminator: APPROVE_CONFIDENTIAL_TRANSFER_ACCOUNT_CONFIDENTIAL_TRANSFER_DISCRIMINATOR
    })
  );
}
function getApproveConfidentialTransferAccountInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["confidentialTransferDiscriminator", getU8Decoder()]
  ]);
}
function getApproveConfidentialTransferAccountInstructionDataCodec() {
  return combineCodec(
    getApproveConfidentialTransferAccountInstructionDataEncoder(),
    getApproveConfidentialTransferAccountInstructionDataDecoder()
  );
}
function getApproveConfidentialTransferAccountInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    token: { value: input.token ?? null, isWritable: true },
    mint: { value: input.mint ?? null, isWritable: false },
    authority: { value: input.authority ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.token),
      getAccountMeta(accounts.mint),
      getAccountMeta(accounts.authority)
    ],
    programAddress,
    data: getApproveConfidentialTransferAccountInstructionDataEncoder().encode(
      {}
    )
  };
  return instruction;
}
function parseApproveConfidentialTransferAccountInstruction(instruction) {
  if (instruction.accounts.length < 3) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      token: getNextAccount(),
      mint: getNextAccount(),
      authority: getNextAccount()
    },
    data: getApproveConfidentialTransferAccountInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var BURN_DISCRIMINATOR = 8;
function getBurnDiscriminatorBytes() {
  return getU8Encoder().encode(BURN_DISCRIMINATOR);
}
function getBurnInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["amount", getU64Encoder()]
    ]),
    (value) => ({ ...value, discriminator: BURN_DISCRIMINATOR })
  );
}
function getBurnInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["amount", getU64Decoder()]
  ]);
}
function getBurnInstructionDataCodec() {
  return combineCodec(
    getBurnInstructionDataEncoder(),
    getBurnInstructionDataDecoder()
  );
}
function getBurnInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    account: { value: input.account ?? null, isWritable: true },
    mint: { value: input.mint ?? null, isWritable: true },
    authority: { value: input.authority ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.account),
      getAccountMeta(accounts.mint),
      getAccountMeta(accounts.authority),
      ...remainingAccounts
    ],
    programAddress,
    data: getBurnInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseBurnInstruction(instruction) {
  if (instruction.accounts.length < 3) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      account: getNextAccount(),
      mint: getNextAccount(),
      authority: getNextAccount()
    },
    data: getBurnInstructionDataDecoder().decode(instruction.data)
  };
}
var BURN_CHECKED_DISCRIMINATOR = 15;
function getBurnCheckedDiscriminatorBytes() {
  return getU8Encoder().encode(BURN_CHECKED_DISCRIMINATOR);
}
function getBurnCheckedInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["amount", getU64Encoder()],
      ["decimals", getU8Encoder()]
    ]),
    (value) => ({ ...value, discriminator: BURN_CHECKED_DISCRIMINATOR })
  );
}
function getBurnCheckedInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["amount", getU64Decoder()],
    ["decimals", getU8Decoder()]
  ]);
}
function getBurnCheckedInstructionDataCodec() {
  return combineCodec(
    getBurnCheckedInstructionDataEncoder(),
    getBurnCheckedInstructionDataDecoder()
  );
}
function getBurnCheckedInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    account: { value: input.account ?? null, isWritable: true },
    mint: { value: input.mint ?? null, isWritable: true },
    authority: { value: input.authority ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.account),
      getAccountMeta(accounts.mint),
      getAccountMeta(accounts.authority),
      ...remainingAccounts
    ],
    programAddress,
    data: getBurnCheckedInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseBurnCheckedInstruction(instruction) {
  if (instruction.accounts.length < 3) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      account: getNextAccount(),
      mint: getNextAccount(),
      authority: getNextAccount()
    },
    data: getBurnCheckedInstructionDataDecoder().decode(instruction.data)
  };
}
var CLOSE_ACCOUNT_DISCRIMINATOR = 9;
function getCloseAccountDiscriminatorBytes() {
  return getU8Encoder().encode(CLOSE_ACCOUNT_DISCRIMINATOR);
}
function getCloseAccountInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([["discriminator", getU8Encoder()]]),
    (value) => ({ ...value, discriminator: CLOSE_ACCOUNT_DISCRIMINATOR })
  );
}
function getCloseAccountInstructionDataDecoder() {
  return getStructDecoder([["discriminator", getU8Decoder()]]);
}
function getCloseAccountInstructionDataCodec() {
  return combineCodec(
    getCloseAccountInstructionDataEncoder(),
    getCloseAccountInstructionDataDecoder()
  );
}
function getCloseAccountInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    account: { value: input.account ?? null, isWritable: true },
    destination: { value: input.destination ?? null, isWritable: true },
    owner: { value: input.owner ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.account),
      getAccountMeta(accounts.destination),
      getAccountMeta(accounts.owner),
      ...remainingAccounts
    ],
    programAddress,
    data: getCloseAccountInstructionDataEncoder().encode({})
  };
  return instruction;
}
function parseCloseAccountInstruction(instruction) {
  if (instruction.accounts.length < 3) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      account: getNextAccount(),
      destination: getNextAccount(),
      owner: getNextAccount()
    },
    data: getCloseAccountInstructionDataDecoder().decode(instruction.data)
  };
}
var CONFIDENTIAL_DEPOSIT_DISCRIMINATOR = 27;
function getConfidentialDepositDiscriminatorBytes() {
  return getU8Encoder().encode(CONFIDENTIAL_DEPOSIT_DISCRIMINATOR);
}
var CONFIDENTIAL_DEPOSIT_CONFIDENTIAL_TRANSFER_DISCRIMINATOR = 5;
function getConfidentialDepositConfidentialTransferDiscriminatorBytes() {
  return getU8Encoder().encode(
    CONFIDENTIAL_DEPOSIT_CONFIDENTIAL_TRANSFER_DISCRIMINATOR
  );
}
function getConfidentialDepositInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["confidentialTransferDiscriminator", getU8Encoder()],
      ["amount", getU64Encoder()],
      ["decimals", getU8Encoder()]
    ]),
    (value) => ({
      ...value,
      discriminator: CONFIDENTIAL_DEPOSIT_DISCRIMINATOR,
      confidentialTransferDiscriminator: CONFIDENTIAL_DEPOSIT_CONFIDENTIAL_TRANSFER_DISCRIMINATOR
    })
  );
}
function getConfidentialDepositInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["confidentialTransferDiscriminator", getU8Decoder()],
    ["amount", getU64Decoder()],
    ["decimals", getU8Decoder()]
  ]);
}
function getConfidentialDepositInstructionDataCodec() {
  return combineCodec(
    getConfidentialDepositInstructionDataEncoder(),
    getConfidentialDepositInstructionDataDecoder()
  );
}
function getConfidentialDepositInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    token: { value: input.token ?? null, isWritable: true },
    mint: { value: input.mint ?? null, isWritable: false },
    authority: { value: input.authority ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.token),
      getAccountMeta(accounts.mint),
      getAccountMeta(accounts.authority),
      ...remainingAccounts
    ],
    programAddress,
    data: getConfidentialDepositInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseConfidentialDepositInstruction(instruction) {
  if (instruction.accounts.length < 3) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      token: getNextAccount(),
      mint: getNextAccount(),
      authority: getNextAccount()
    },
    data: getConfidentialDepositInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var CONFIDENTIAL_TRANSFER_DISCRIMINATOR = 27;
function getConfidentialTransferDiscriminatorBytes() {
  return getU8Encoder().encode(CONFIDENTIAL_TRANSFER_DISCRIMINATOR);
}
var CONFIDENTIAL_TRANSFER_CONFIDENTIAL_TRANSFER_DISCRIMINATOR = 7;
function getConfidentialTransferConfidentialTransferDiscriminatorBytes() {
  return getU8Encoder().encode(
    CONFIDENTIAL_TRANSFER_CONFIDENTIAL_TRANSFER_DISCRIMINATOR
  );
}
function getConfidentialTransferInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["confidentialTransferDiscriminator", getU8Encoder()],
      ["newSourceDecryptableAvailableBalance", getDecryptableBalanceEncoder()],
      ["equalityProofInstructionOffset", getI8Encoder()],
      ["ciphertextValidityProofInstructionOffset", getI8Encoder()],
      ["rangeProofInstructionOffset", getI8Encoder()]
    ]),
    (value) => ({
      ...value,
      discriminator: CONFIDENTIAL_TRANSFER_DISCRIMINATOR,
      confidentialTransferDiscriminator: CONFIDENTIAL_TRANSFER_CONFIDENTIAL_TRANSFER_DISCRIMINATOR
    })
  );
}
function getConfidentialTransferInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["confidentialTransferDiscriminator", getU8Decoder()],
    ["newSourceDecryptableAvailableBalance", getDecryptableBalanceDecoder()],
    ["equalityProofInstructionOffset", getI8Decoder()],
    ["ciphertextValidityProofInstructionOffset", getI8Decoder()],
    ["rangeProofInstructionOffset", getI8Decoder()]
  ]);
}
function getConfidentialTransferInstructionDataCodec() {
  return combineCodec(
    getConfidentialTransferInstructionDataEncoder(),
    getConfidentialTransferInstructionDataDecoder()
  );
}
function getConfidentialTransferInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    sourceToken: { value: input.sourceToken ?? null, isWritable: true },
    mint: { value: input.mint ?? null, isWritable: false },
    destinationToken: {
      value: input.destinationToken ?? null,
      isWritable: true
    },
    instructionsSysvar: {
      value: input.instructionsSysvar ?? null,
      isWritable: false
    },
    equalityRecord: { value: input.equalityRecord ?? null, isWritable: false },
    ciphertextValidityRecord: {
      value: input.ciphertextValidityRecord ?? null,
      isWritable: false
    },
    rangeRecord: { value: input.rangeRecord ?? null, isWritable: false },
    authority: { value: input.authority ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.sourceToken),
      getAccountMeta(accounts.mint),
      getAccountMeta(accounts.destinationToken),
      getAccountMeta(accounts.instructionsSysvar),
      getAccountMeta(accounts.equalityRecord),
      getAccountMeta(accounts.ciphertextValidityRecord),
      getAccountMeta(accounts.rangeRecord),
      getAccountMeta(accounts.authority),
      ...remainingAccounts
    ],
    programAddress,
    data: getConfidentialTransferInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseConfidentialTransferInstruction(instruction) {
  if (instruction.accounts.length < 8) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  const getNextOptionalAccount = () => {
    const accountMeta = getNextAccount();
    return accountMeta.address === TOKEN_2022_PROGRAM_ADDRESS ? void 0 : accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      sourceToken: getNextAccount(),
      mint: getNextAccount(),
      destinationToken: getNextAccount(),
      instructionsSysvar: getNextOptionalAccount(),
      equalityRecord: getNextOptionalAccount(),
      ciphertextValidityRecord: getNextOptionalAccount(),
      rangeRecord: getNextOptionalAccount(),
      authority: getNextAccount()
    },
    data: getConfidentialTransferInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var CONFIDENTIAL_TRANSFER_WITH_FEE_DISCRIMINATOR = 27;
function getConfidentialTransferWithFeeDiscriminatorBytes() {
  return getU8Encoder().encode(CONFIDENTIAL_TRANSFER_WITH_FEE_DISCRIMINATOR);
}
var CONFIDENTIAL_TRANSFER_WITH_FEE_CONFIDENTIAL_TRANSFER_DISCRIMINATOR = 13;
function getConfidentialTransferWithFeeConfidentialTransferDiscriminatorBytes() {
  return getU8Encoder().encode(
    CONFIDENTIAL_TRANSFER_WITH_FEE_CONFIDENTIAL_TRANSFER_DISCRIMINATOR
  );
}
function getConfidentialTransferWithFeeInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["confidentialTransferDiscriminator", getU8Encoder()],
      ["newSourceDecryptableAvailableBalance", getDecryptableBalanceEncoder()],
      ["equalityProofInstructionOffset", getI8Encoder()],
      [
        "transferAmountCiphertextValidityProofInstructionOffset",
        getI8Encoder()
      ],
      ["feeSigmaProofInstructionOffset", getI8Encoder()],
      ["feeCiphertextValidityProofInstructionOffset", getI8Encoder()],
      ["rangeProofInstructionOffset", getI8Encoder()]
    ]),
    (value) => ({
      ...value,
      discriminator: CONFIDENTIAL_TRANSFER_WITH_FEE_DISCRIMINATOR,
      confidentialTransferDiscriminator: CONFIDENTIAL_TRANSFER_WITH_FEE_CONFIDENTIAL_TRANSFER_DISCRIMINATOR
    })
  );
}
function getConfidentialTransferWithFeeInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["confidentialTransferDiscriminator", getU8Decoder()],
    ["newSourceDecryptableAvailableBalance", getDecryptableBalanceDecoder()],
    ["equalityProofInstructionOffset", getI8Decoder()],
    ["transferAmountCiphertextValidityProofInstructionOffset", getI8Decoder()],
    ["feeSigmaProofInstructionOffset", getI8Decoder()],
    ["feeCiphertextValidityProofInstructionOffset", getI8Decoder()],
    ["rangeProofInstructionOffset", getI8Decoder()]
  ]);
}
function getConfidentialTransferWithFeeInstructionDataCodec() {
  return combineCodec(
    getConfidentialTransferWithFeeInstructionDataEncoder(),
    getConfidentialTransferWithFeeInstructionDataDecoder()
  );
}
function getConfidentialTransferWithFeeInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    sourceToken: { value: input.sourceToken ?? null, isWritable: true },
    mint: { value: input.mint ?? null, isWritable: false },
    destinationToken: {
      value: input.destinationToken ?? null,
      isWritable: true
    },
    instructionsSysvar: {
      value: input.instructionsSysvar ?? null,
      isWritable: false
    },
    equalityRecord: { value: input.equalityRecord ?? null, isWritable: false },
    transferAmountCiphertextValidityRecord: {
      value: input.transferAmountCiphertextValidityRecord ?? null,
      isWritable: false
    },
    feeSigmaRecord: { value: input.feeSigmaRecord ?? null, isWritable: false },
    feeCiphertextValidityRecord: {
      value: input.feeCiphertextValidityRecord ?? null,
      isWritable: false
    },
    rangeRecord: { value: input.rangeRecord ?? null, isWritable: false },
    authority: { value: input.authority ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.sourceToken),
      getAccountMeta(accounts.mint),
      getAccountMeta(accounts.destinationToken),
      getAccountMeta(accounts.instructionsSysvar),
      getAccountMeta(accounts.equalityRecord),
      getAccountMeta(accounts.transferAmountCiphertextValidityRecord),
      getAccountMeta(accounts.feeSigmaRecord),
      getAccountMeta(accounts.feeCiphertextValidityRecord),
      getAccountMeta(accounts.rangeRecord),
      getAccountMeta(accounts.authority),
      ...remainingAccounts
    ],
    programAddress,
    data: getConfidentialTransferWithFeeInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseConfidentialTransferWithFeeInstruction(instruction) {
  if (instruction.accounts.length < 10) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  const getNextOptionalAccount = () => {
    const accountMeta = getNextAccount();
    return accountMeta.address === TOKEN_2022_PROGRAM_ADDRESS ? void 0 : accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      sourceToken: getNextAccount(),
      mint: getNextAccount(),
      destinationToken: getNextAccount(),
      instructionsSysvar: getNextOptionalAccount(),
      equalityRecord: getNextOptionalAccount(),
      transferAmountCiphertextValidityRecord: getNextOptionalAccount(),
      feeSigmaRecord: getNextOptionalAccount(),
      feeCiphertextValidityRecord: getNextOptionalAccount(),
      rangeRecord: getNextOptionalAccount(),
      authority: getNextAccount()
    },
    data: getConfidentialTransferWithFeeInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var CONFIDENTIAL_WITHDRAW_DISCRIMINATOR = 27;
function getConfidentialWithdrawDiscriminatorBytes() {
  return getU8Encoder().encode(CONFIDENTIAL_WITHDRAW_DISCRIMINATOR);
}
var CONFIDENTIAL_WITHDRAW_CONFIDENTIAL_TRANSFER_DISCRIMINATOR = 6;
function getConfidentialWithdrawConfidentialTransferDiscriminatorBytes() {
  return getU8Encoder().encode(
    CONFIDENTIAL_WITHDRAW_CONFIDENTIAL_TRANSFER_DISCRIMINATOR
  );
}
function getConfidentialWithdrawInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["confidentialTransferDiscriminator", getU8Encoder()],
      ["amount", getU64Encoder()],
      ["decimals", getU8Encoder()],
      ["newDecryptableAvailableBalance", getDecryptableBalanceEncoder()],
      ["equalityProofInstructionOffset", getI8Encoder()],
      ["rangeProofInstructionOffset", getI8Encoder()]
    ]),
    (value) => ({
      ...value,
      discriminator: CONFIDENTIAL_WITHDRAW_DISCRIMINATOR,
      confidentialTransferDiscriminator: CONFIDENTIAL_WITHDRAW_CONFIDENTIAL_TRANSFER_DISCRIMINATOR
    })
  );
}
function getConfidentialWithdrawInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["confidentialTransferDiscriminator", getU8Decoder()],
    ["amount", getU64Decoder()],
    ["decimals", getU8Decoder()],
    ["newDecryptableAvailableBalance", getDecryptableBalanceDecoder()],
    ["equalityProofInstructionOffset", getI8Decoder()],
    ["rangeProofInstructionOffset", getI8Decoder()]
  ]);
}
function getConfidentialWithdrawInstructionDataCodec() {
  return combineCodec(
    getConfidentialWithdrawInstructionDataEncoder(),
    getConfidentialWithdrawInstructionDataDecoder()
  );
}
function getConfidentialWithdrawInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    token: { value: input.token ?? null, isWritable: true },
    mint: { value: input.mint ?? null, isWritable: false },
    instructionsSysvar: {
      value: input.instructionsSysvar ?? null,
      isWritable: false
    },
    equalityRecord: { value: input.equalityRecord ?? null, isWritable: false },
    rangeRecord: { value: input.rangeRecord ?? null, isWritable: false },
    authority: { value: input.authority ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.token),
      getAccountMeta(accounts.mint),
      getAccountMeta(accounts.instructionsSysvar),
      getAccountMeta(accounts.equalityRecord),
      getAccountMeta(accounts.rangeRecord),
      getAccountMeta(accounts.authority),
      ...remainingAccounts
    ],
    programAddress,
    data: getConfidentialWithdrawInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseConfidentialWithdrawInstruction(instruction) {
  if (instruction.accounts.length < 6) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  const getNextOptionalAccount = () => {
    const accountMeta = getNextAccount();
    return accountMeta.address === TOKEN_2022_PROGRAM_ADDRESS ? void 0 : accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      token: getNextAccount(),
      mint: getNextAccount(),
      instructionsSysvar: getNextOptionalAccount(),
      equalityRecord: getNextOptionalAccount(),
      rangeRecord: getNextOptionalAccount(),
      authority: getNextAccount()
    },
    data: getConfidentialWithdrawInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var CONFIGURE_CONFIDENTIAL_TRANSFER_ACCOUNT_DISCRIMINATOR = 27;
function getConfigureConfidentialTransferAccountDiscriminatorBytes() {
  return getU8Encoder().encode(
    CONFIGURE_CONFIDENTIAL_TRANSFER_ACCOUNT_DISCRIMINATOR
  );
}
var CONFIGURE_CONFIDENTIAL_TRANSFER_ACCOUNT_CONFIDENTIAL_TRANSFER_DISCRIMINATOR = 2;
function getConfigureConfidentialTransferAccountConfidentialTransferDiscriminatorBytes() {
  return getU8Encoder().encode(
    CONFIGURE_CONFIDENTIAL_TRANSFER_ACCOUNT_CONFIDENTIAL_TRANSFER_DISCRIMINATOR
  );
}
function getConfigureConfidentialTransferAccountInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["confidentialTransferDiscriminator", getU8Encoder()],
      ["decryptableZeroBalance", getDecryptableBalanceEncoder()],
      ["maximumPendingBalanceCreditCounter", getU64Encoder()],
      ["proofInstructionOffset", getI8Encoder()]
    ]),
    (value) => ({
      ...value,
      discriminator: CONFIGURE_CONFIDENTIAL_TRANSFER_ACCOUNT_DISCRIMINATOR,
      confidentialTransferDiscriminator: CONFIGURE_CONFIDENTIAL_TRANSFER_ACCOUNT_CONFIDENTIAL_TRANSFER_DISCRIMINATOR
    })
  );
}
function getConfigureConfidentialTransferAccountInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["confidentialTransferDiscriminator", getU8Decoder()],
    ["decryptableZeroBalance", getDecryptableBalanceDecoder()],
    ["maximumPendingBalanceCreditCounter", getU64Decoder()],
    ["proofInstructionOffset", getI8Decoder()]
  ]);
}
function getConfigureConfidentialTransferAccountInstructionDataCodec() {
  return combineCodec(
    getConfigureConfidentialTransferAccountInstructionDataEncoder(),
    getConfigureConfidentialTransferAccountInstructionDataDecoder()
  );
}
function getConfigureConfidentialTransferAccountInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    token: { value: input.token ?? null, isWritable: true },
    mint: { value: input.mint ?? null, isWritable: false },
    instructionsSysvarOrContextState: {
      value: input.instructionsSysvarOrContextState ?? null,
      isWritable: false
    },
    record: { value: input.record ?? null, isWritable: false },
    authority: { value: input.authority ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  if (!accounts.instructionsSysvarOrContextState.value) {
    accounts.instructionsSysvarOrContextState.value = "Sysvar1nstructions1111111111111111111111111";
  }
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.token),
      getAccountMeta(accounts.mint),
      getAccountMeta(accounts.instructionsSysvarOrContextState),
      getAccountMeta(accounts.record),
      getAccountMeta(accounts.authority),
      ...remainingAccounts
    ],
    programAddress,
    data: getConfigureConfidentialTransferAccountInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseConfigureConfidentialTransferAccountInstruction(instruction) {
  if (instruction.accounts.length < 5) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  const getNextOptionalAccount = () => {
    const accountMeta = getNextAccount();
    return accountMeta.address === TOKEN_2022_PROGRAM_ADDRESS ? void 0 : accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      token: getNextAccount(),
      mint: getNextAccount(),
      instructionsSysvarOrContextState: getNextAccount(),
      record: getNextOptionalAccount(),
      authority: getNextAccount()
    },
    data: getConfigureConfidentialTransferAccountInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
async function findAssociatedTokenPda(seeds, config = {}) {
  const {
    programAddress = "ATokenGPvbdGVxr1b2hvZbsiqW5xWH25efTNsLJA8knL"
  } = config;
  return await getProgramDerivedAddress({
    programAddress,
    seeds: [
      getAddressEncoder().encode(seeds.owner),
      getAddressEncoder().encode(seeds.tokenProgram),
      getAddressEncoder().encode(seeds.mint)
    ]
  });
}

// src/generated/instructions/createAssociatedToken.ts
var CREATE_ASSOCIATED_TOKEN_DISCRIMINATOR = 0;
function getCreateAssociatedTokenDiscriminatorBytes() {
  return getU8Encoder().encode(CREATE_ASSOCIATED_TOKEN_DISCRIMINATOR);
}
function getCreateAssociatedTokenInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([["discriminator", getU8Encoder()]]),
    (value) => ({
      ...value,
      discriminator: CREATE_ASSOCIATED_TOKEN_DISCRIMINATOR
    })
  );
}
function getCreateAssociatedTokenInstructionDataDecoder() {
  return getStructDecoder([["discriminator", getU8Decoder()]]);
}
function getCreateAssociatedTokenInstructionDataCodec() {
  return combineCodec(
    getCreateAssociatedTokenInstructionDataEncoder(),
    getCreateAssociatedTokenInstructionDataDecoder()
  );
}
async function getCreateAssociatedTokenInstructionAsync(input, config) {
  const programAddress = config?.programAddress ?? ASSOCIATED_TOKEN_PROGRAM_ADDRESS;
  const originalAccounts = {
    payer: { value: input.payer ?? null, isWritable: true },
    ata: { value: input.ata ?? null, isWritable: true },
    owner: { value: input.owner ?? null, isWritable: false },
    mint: { value: input.mint ?? null, isWritable: false },
    systemProgram: { value: input.systemProgram ?? null, isWritable: false },
    tokenProgram: { value: input.tokenProgram ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  if (!accounts.tokenProgram.value) {
    accounts.tokenProgram.value = "TokenzQdBNbLqP5VEhdkAS6EPFLC1PHnBqCXEpPxuEb";
  }
  if (!accounts.ata.value) {
    accounts.ata.value = await findAssociatedTokenPda({
      owner: expectAddress(accounts.owner.value),
      tokenProgram: expectAddress(accounts.tokenProgram.value),
      mint: expectAddress(accounts.mint.value)
    });
  }
  if (!accounts.systemProgram.value) {
    accounts.systemProgram.value = "11111111111111111111111111111111";
  }
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.payer),
      getAccountMeta(accounts.ata),
      getAccountMeta(accounts.owner),
      getAccountMeta(accounts.mint),
      getAccountMeta(accounts.systemProgram),
      getAccountMeta(accounts.tokenProgram)
    ],
    programAddress,
    data: getCreateAssociatedTokenInstructionDataEncoder().encode({})
  };
  return instruction;
}
function getCreateAssociatedTokenInstruction(input, config) {
  const programAddress = config?.programAddress ?? ASSOCIATED_TOKEN_PROGRAM_ADDRESS;
  const originalAccounts = {
    payer: { value: input.payer ?? null, isWritable: true },
    ata: { value: input.ata ?? null, isWritable: true },
    owner: { value: input.owner ?? null, isWritable: false },
    mint: { value: input.mint ?? null, isWritable: false },
    systemProgram: { value: input.systemProgram ?? null, isWritable: false },
    tokenProgram: { value: input.tokenProgram ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  if (!accounts.tokenProgram.value) {
    accounts.tokenProgram.value = "TokenzQdBNbLqP5VEhdkAS6EPFLC1PHnBqCXEpPxuEb";
  }
  if (!accounts.systemProgram.value) {
    accounts.systemProgram.value = "11111111111111111111111111111111";
  }
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.payer),
      getAccountMeta(accounts.ata),
      getAccountMeta(accounts.owner),
      getAccountMeta(accounts.mint),
      getAccountMeta(accounts.systemProgram),
      getAccountMeta(accounts.tokenProgram)
    ],
    programAddress,
    data: getCreateAssociatedTokenInstructionDataEncoder().encode({})
  };
  return instruction;
}
function parseCreateAssociatedTokenInstruction(instruction) {
  if (instruction.accounts.length < 6) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      payer: getNextAccount(),
      ata: getNextAccount(),
      owner: getNextAccount(),
      mint: getNextAccount(),
      systemProgram: getNextAccount(),
      tokenProgram: getNextAccount()
    },
    data: getCreateAssociatedTokenInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var CREATE_ASSOCIATED_TOKEN_IDEMPOTENT_DISCRIMINATOR = 1;
function getCreateAssociatedTokenIdempotentDiscriminatorBytes() {
  return getU8Encoder().encode(
    CREATE_ASSOCIATED_TOKEN_IDEMPOTENT_DISCRIMINATOR
  );
}
function getCreateAssociatedTokenIdempotentInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([["discriminator", getU8Encoder()]]),
    (value) => ({
      ...value,
      discriminator: CREATE_ASSOCIATED_TOKEN_IDEMPOTENT_DISCRIMINATOR
    })
  );
}
function getCreateAssociatedTokenIdempotentInstructionDataDecoder() {
  return getStructDecoder([["discriminator", getU8Decoder()]]);
}
function getCreateAssociatedTokenIdempotentInstructionDataCodec() {
  return combineCodec(
    getCreateAssociatedTokenIdempotentInstructionDataEncoder(),
    getCreateAssociatedTokenIdempotentInstructionDataDecoder()
  );
}
async function getCreateAssociatedTokenIdempotentInstructionAsync(input, config) {
  const programAddress = config?.programAddress ?? ASSOCIATED_TOKEN_PROGRAM_ADDRESS;
  const originalAccounts = {
    payer: { value: input.payer ?? null, isWritable: true },
    ata: { value: input.ata ?? null, isWritable: true },
    owner: { value: input.owner ?? null, isWritable: false },
    mint: { value: input.mint ?? null, isWritable: false },
    systemProgram: { value: input.systemProgram ?? null, isWritable: false },
    tokenProgram: { value: input.tokenProgram ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  if (!accounts.tokenProgram.value) {
    accounts.tokenProgram.value = "TokenzQdBNbLqP5VEhdkAS6EPFLC1PHnBqCXEpPxuEb";
  }
  if (!accounts.ata.value) {
    accounts.ata.value = await findAssociatedTokenPda({
      owner: expectAddress(accounts.owner.value),
      tokenProgram: expectAddress(accounts.tokenProgram.value),
      mint: expectAddress(accounts.mint.value)
    });
  }
  if (!accounts.systemProgram.value) {
    accounts.systemProgram.value = "11111111111111111111111111111111";
  }
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.payer),
      getAccountMeta(accounts.ata),
      getAccountMeta(accounts.owner),
      getAccountMeta(accounts.mint),
      getAccountMeta(accounts.systemProgram),
      getAccountMeta(accounts.tokenProgram)
    ],
    programAddress,
    data: getCreateAssociatedTokenIdempotentInstructionDataEncoder().encode({})
  };
  return instruction;
}
function getCreateAssociatedTokenIdempotentInstruction(input, config) {
  const programAddress = config?.programAddress ?? ASSOCIATED_TOKEN_PROGRAM_ADDRESS;
  const originalAccounts = {
    payer: { value: input.payer ?? null, isWritable: true },
    ata: { value: input.ata ?? null, isWritable: true },
    owner: { value: input.owner ?? null, isWritable: false },
    mint: { value: input.mint ?? null, isWritable: false },
    systemProgram: { value: input.systemProgram ?? null, isWritable: false },
    tokenProgram: { value: input.tokenProgram ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  if (!accounts.tokenProgram.value) {
    accounts.tokenProgram.value = "TokenzQdBNbLqP5VEhdkAS6EPFLC1PHnBqCXEpPxuEb";
  }
  if (!accounts.systemProgram.value) {
    accounts.systemProgram.value = "11111111111111111111111111111111";
  }
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.payer),
      getAccountMeta(accounts.ata),
      getAccountMeta(accounts.owner),
      getAccountMeta(accounts.mint),
      getAccountMeta(accounts.systemProgram),
      getAccountMeta(accounts.tokenProgram)
    ],
    programAddress,
    data: getCreateAssociatedTokenIdempotentInstructionDataEncoder().encode({})
  };
  return instruction;
}
function parseCreateAssociatedTokenIdempotentInstruction(instruction) {
  if (instruction.accounts.length < 6) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      payer: getNextAccount(),
      ata: getNextAccount(),
      owner: getNextAccount(),
      mint: getNextAccount(),
      systemProgram: getNextAccount(),
      tokenProgram: getNextAccount()
    },
    data: getCreateAssociatedTokenIdempotentInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var CREATE_NATIVE_MINT_DISCRIMINATOR = 31;
function getCreateNativeMintDiscriminatorBytes() {
  return getU8Encoder().encode(CREATE_NATIVE_MINT_DISCRIMINATOR);
}
function getCreateNativeMintInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([["discriminator", getU8Encoder()]]),
    (value) => ({ ...value, discriminator: CREATE_NATIVE_MINT_DISCRIMINATOR })
  );
}
function getCreateNativeMintInstructionDataDecoder() {
  return getStructDecoder([["discriminator", getU8Decoder()]]);
}
function getCreateNativeMintInstructionDataCodec() {
  return combineCodec(
    getCreateNativeMintInstructionDataEncoder(),
    getCreateNativeMintInstructionDataDecoder()
  );
}
function getCreateNativeMintInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    payer: { value: input.payer ?? null, isWritable: true },
    nativeMint: { value: input.nativeMint ?? null, isWritable: true },
    systemProgram: { value: input.systemProgram ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  if (!accounts.systemProgram.value) {
    accounts.systemProgram.value = "11111111111111111111111111111111";
  }
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.payer),
      getAccountMeta(accounts.nativeMint),
      getAccountMeta(accounts.systemProgram)
    ],
    programAddress,
    data: getCreateNativeMintInstructionDataEncoder().encode({})
  };
  return instruction;
}
function parseCreateNativeMintInstruction(instruction) {
  if (instruction.accounts.length < 3) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      payer: getNextAccount(),
      nativeMint: getNextAccount(),
      systemProgram: getNextAccount()
    },
    data: getCreateNativeMintInstructionDataDecoder().decode(instruction.data)
  };
}
var DISABLE_CONFIDENTIAL_CREDITS_DISCRIMINATOR = 27;
function getDisableConfidentialCreditsDiscriminatorBytes() {
  return getU8Encoder().encode(DISABLE_CONFIDENTIAL_CREDITS_DISCRIMINATOR);
}
var DISABLE_CONFIDENTIAL_CREDITS_CONFIDENTIAL_TRANSFER_DISCRIMINATOR = 10;
function getDisableConfidentialCreditsConfidentialTransferDiscriminatorBytes() {
  return getU8Encoder().encode(
    DISABLE_CONFIDENTIAL_CREDITS_CONFIDENTIAL_TRANSFER_DISCRIMINATOR
  );
}
function getDisableConfidentialCreditsInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["confidentialTransferDiscriminator", getU8Encoder()]
    ]),
    (value) => ({
      ...value,
      discriminator: DISABLE_CONFIDENTIAL_CREDITS_DISCRIMINATOR,
      confidentialTransferDiscriminator: DISABLE_CONFIDENTIAL_CREDITS_CONFIDENTIAL_TRANSFER_DISCRIMINATOR
    })
  );
}
function getDisableConfidentialCreditsInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["confidentialTransferDiscriminator", getU8Decoder()]
  ]);
}
function getDisableConfidentialCreditsInstructionDataCodec() {
  return combineCodec(
    getDisableConfidentialCreditsInstructionDataEncoder(),
    getDisableConfidentialCreditsInstructionDataDecoder()
  );
}
function getDisableConfidentialCreditsInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    token: { value: input.token ?? null, isWritable: true },
    authority: { value: input.authority ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.token),
      getAccountMeta(accounts.authority),
      ...remainingAccounts
    ],
    programAddress,
    data: getDisableConfidentialCreditsInstructionDataEncoder().encode({})
  };
  return instruction;
}
function parseDisableConfidentialCreditsInstruction(instruction) {
  if (instruction.accounts.length < 2) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      token: getNextAccount(),
      authority: getNextAccount()
    },
    data: getDisableConfidentialCreditsInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var DISABLE_CPI_GUARD_DISCRIMINATOR = 34;
function getDisableCpiGuardDiscriminatorBytes() {
  return getU8Encoder().encode(DISABLE_CPI_GUARD_DISCRIMINATOR);
}
var DISABLE_CPI_GUARD_CPI_GUARD_DISCRIMINATOR = 1;
function getDisableCpiGuardCpiGuardDiscriminatorBytes() {
  return getU8Encoder().encode(DISABLE_CPI_GUARD_CPI_GUARD_DISCRIMINATOR);
}
function getDisableCpiGuardInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["cpiGuardDiscriminator", getU8Encoder()]
    ]),
    (value) => ({
      ...value,
      discriminator: DISABLE_CPI_GUARD_DISCRIMINATOR,
      cpiGuardDiscriminator: DISABLE_CPI_GUARD_CPI_GUARD_DISCRIMINATOR
    })
  );
}
function getDisableCpiGuardInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["cpiGuardDiscriminator", getU8Decoder()]
  ]);
}
function getDisableCpiGuardInstructionDataCodec() {
  return combineCodec(
    getDisableCpiGuardInstructionDataEncoder(),
    getDisableCpiGuardInstructionDataDecoder()
  );
}
function getDisableCpiGuardInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    token: { value: input.token ?? null, isWritable: true },
    owner: { value: input.owner ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.token),
      getAccountMeta(accounts.owner),
      ...remainingAccounts
    ],
    programAddress,
    data: getDisableCpiGuardInstructionDataEncoder().encode({})
  };
  return instruction;
}
function parseDisableCpiGuardInstruction(instruction) {
  if (instruction.accounts.length < 2) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      token: getNextAccount(),
      owner: getNextAccount()
    },
    data: getDisableCpiGuardInstructionDataDecoder().decode(instruction.data)
  };
}
var DISABLE_HARVEST_TO_MINT_DISCRIMINATOR = 37;
function getDisableHarvestToMintDiscriminatorBytes() {
  return getU8Encoder().encode(DISABLE_HARVEST_TO_MINT_DISCRIMINATOR);
}
var DISABLE_HARVEST_TO_MINT_CONFIDENTIAL_TRANSFER_FEE_DISCRIMINATOR = 5;
function getDisableHarvestToMintConfidentialTransferFeeDiscriminatorBytes() {
  return getU8Encoder().encode(
    DISABLE_HARVEST_TO_MINT_CONFIDENTIAL_TRANSFER_FEE_DISCRIMINATOR
  );
}
function getDisableHarvestToMintInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["confidentialTransferFeeDiscriminator", getU8Encoder()]
    ]),
    (value) => ({
      ...value,
      discriminator: DISABLE_HARVEST_TO_MINT_DISCRIMINATOR,
      confidentialTransferFeeDiscriminator: DISABLE_HARVEST_TO_MINT_CONFIDENTIAL_TRANSFER_FEE_DISCRIMINATOR
    })
  );
}
function getDisableHarvestToMintInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["confidentialTransferFeeDiscriminator", getU8Decoder()]
  ]);
}
function getDisableHarvestToMintInstructionDataCodec() {
  return combineCodec(
    getDisableHarvestToMintInstructionDataEncoder(),
    getDisableHarvestToMintInstructionDataDecoder()
  );
}
function getDisableHarvestToMintInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    mint: { value: input.mint ?? null, isWritable: true },
    authority: { value: input.authority ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.mint),
      getAccountMeta(accounts.authority),
      ...remainingAccounts
    ],
    programAddress,
    data: getDisableHarvestToMintInstructionDataEncoder().encode({})
  };
  return instruction;
}
function parseDisableHarvestToMintInstruction(instruction) {
  if (instruction.accounts.length < 2) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      mint: getNextAccount(),
      authority: getNextAccount()
    },
    data: getDisableHarvestToMintInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var DISABLE_MEMO_TRANSFERS_DISCRIMINATOR = 30;
function getDisableMemoTransfersDiscriminatorBytes() {
  return getU8Encoder().encode(DISABLE_MEMO_TRANSFERS_DISCRIMINATOR);
}
var DISABLE_MEMO_TRANSFERS_MEMO_TRANSFERS_DISCRIMINATOR = 1;
function getDisableMemoTransfersMemoTransfersDiscriminatorBytes() {
  return getU8Encoder().encode(
    DISABLE_MEMO_TRANSFERS_MEMO_TRANSFERS_DISCRIMINATOR
  );
}
function getDisableMemoTransfersInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["memoTransfersDiscriminator", getU8Encoder()]
    ]),
    (value) => ({
      ...value,
      discriminator: DISABLE_MEMO_TRANSFERS_DISCRIMINATOR,
      memoTransfersDiscriminator: DISABLE_MEMO_TRANSFERS_MEMO_TRANSFERS_DISCRIMINATOR
    })
  );
}
function getDisableMemoTransfersInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["memoTransfersDiscriminator", getU8Decoder()]
  ]);
}
function getDisableMemoTransfersInstructionDataCodec() {
  return combineCodec(
    getDisableMemoTransfersInstructionDataEncoder(),
    getDisableMemoTransfersInstructionDataDecoder()
  );
}
function getDisableMemoTransfersInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    token: { value: input.token ?? null, isWritable: true },
    owner: { value: input.owner ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.token),
      getAccountMeta(accounts.owner),
      ...remainingAccounts
    ],
    programAddress,
    data: getDisableMemoTransfersInstructionDataEncoder().encode({})
  };
  return instruction;
}
function parseDisableMemoTransfersInstruction(instruction) {
  if (instruction.accounts.length < 2) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      token: getNextAccount(),
      owner: getNextAccount()
    },
    data: getDisableMemoTransfersInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var DISABLE_NON_CONFIDENTIAL_CREDITS_DISCRIMINATOR = 27;
function getDisableNonConfidentialCreditsDiscriminatorBytes() {
  return getU8Encoder().encode(DISABLE_NON_CONFIDENTIAL_CREDITS_DISCRIMINATOR);
}
var DISABLE_NON_CONFIDENTIAL_CREDITS_CONFIDENTIAL_TRANSFER_DISCRIMINATOR = 12;
function getDisableNonConfidentialCreditsConfidentialTransferDiscriminatorBytes() {
  return getU8Encoder().encode(
    DISABLE_NON_CONFIDENTIAL_CREDITS_CONFIDENTIAL_TRANSFER_DISCRIMINATOR
  );
}
function getDisableNonConfidentialCreditsInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["confidentialTransferDiscriminator", getU8Encoder()]
    ]),
    (value) => ({
      ...value,
      discriminator: DISABLE_NON_CONFIDENTIAL_CREDITS_DISCRIMINATOR,
      confidentialTransferDiscriminator: DISABLE_NON_CONFIDENTIAL_CREDITS_CONFIDENTIAL_TRANSFER_DISCRIMINATOR
    })
  );
}
function getDisableNonConfidentialCreditsInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["confidentialTransferDiscriminator", getU8Decoder()]
  ]);
}
function getDisableNonConfidentialCreditsInstructionDataCodec() {
  return combineCodec(
    getDisableNonConfidentialCreditsInstructionDataEncoder(),
    getDisableNonConfidentialCreditsInstructionDataDecoder()
  );
}
function getDisableNonConfidentialCreditsInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    token: { value: input.token ?? null, isWritable: true },
    authority: { value: input.authority ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.token),
      getAccountMeta(accounts.authority),
      ...remainingAccounts
    ],
    programAddress,
    data: getDisableNonConfidentialCreditsInstructionDataEncoder().encode({})
  };
  return instruction;
}
function parseDisableNonConfidentialCreditsInstruction(instruction) {
  if (instruction.accounts.length < 2) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      token: getNextAccount(),
      authority: getNextAccount()
    },
    data: getDisableNonConfidentialCreditsInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var EMIT_TOKEN_METADATA_DISCRIMINATOR = new Uint8Array([
  250,
  166,
  180,
  250,
  13,
  12,
  184,
  70
]);
function getEmitTokenMetadataDiscriminatorBytes() {
  return getBytesEncoder().encode(EMIT_TOKEN_METADATA_DISCRIMINATOR);
}
function getEmitTokenMetadataInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getBytesEncoder()],
      ["start", getOptionEncoder(getU64Encoder())],
      ["end", getOptionEncoder(getU64Encoder())]
    ]),
    (value) => ({
      ...value,
      discriminator: EMIT_TOKEN_METADATA_DISCRIMINATOR,
      start: value.start ?? none(),
      end: value.end ?? none()
    })
  );
}
function getEmitTokenMetadataInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getBytesDecoder()],
    ["start", getOptionDecoder(getU64Decoder())],
    ["end", getOptionDecoder(getU64Decoder())]
  ]);
}
function getEmitTokenMetadataInstructionDataCodec() {
  return combineCodec(
    getEmitTokenMetadataInstructionDataEncoder(),
    getEmitTokenMetadataInstructionDataDecoder()
  );
}
function getEmitTokenMetadataInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    metadata: { value: input.metadata ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [getAccountMeta(accounts.metadata)],
    programAddress,
    data: getEmitTokenMetadataInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseEmitTokenMetadataInstruction(instruction) {
  if (instruction.accounts.length < 1) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      metadata: getNextAccount()
    },
    data: getEmitTokenMetadataInstructionDataDecoder().decode(instruction.data)
  };
}
var EMPTY_CONFIDENTIAL_TRANSFER_ACCOUNT_DISCRIMINATOR = 27;
function getEmptyConfidentialTransferAccountDiscriminatorBytes() {
  return getU8Encoder().encode(
    EMPTY_CONFIDENTIAL_TRANSFER_ACCOUNT_DISCRIMINATOR
  );
}
var EMPTY_CONFIDENTIAL_TRANSFER_ACCOUNT_CONFIDENTIAL_TRANSFER_DISCRIMINATOR = 4;
function getEmptyConfidentialTransferAccountConfidentialTransferDiscriminatorBytes() {
  return getU8Encoder().encode(
    EMPTY_CONFIDENTIAL_TRANSFER_ACCOUNT_CONFIDENTIAL_TRANSFER_DISCRIMINATOR
  );
}
function getEmptyConfidentialTransferAccountInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["confidentialTransferDiscriminator", getU8Encoder()],
      ["proofInstructionOffset", getI8Encoder()]
    ]),
    (value) => ({
      ...value,
      discriminator: EMPTY_CONFIDENTIAL_TRANSFER_ACCOUNT_DISCRIMINATOR,
      confidentialTransferDiscriminator: EMPTY_CONFIDENTIAL_TRANSFER_ACCOUNT_CONFIDENTIAL_TRANSFER_DISCRIMINATOR
    })
  );
}
function getEmptyConfidentialTransferAccountInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["confidentialTransferDiscriminator", getU8Decoder()],
    ["proofInstructionOffset", getI8Decoder()]
  ]);
}
function getEmptyConfidentialTransferAccountInstructionDataCodec() {
  return combineCodec(
    getEmptyConfidentialTransferAccountInstructionDataEncoder(),
    getEmptyConfidentialTransferAccountInstructionDataDecoder()
  );
}
function getEmptyConfidentialTransferAccountInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    token: { value: input.token ?? null, isWritable: true },
    instructionsSysvarOrContextState: {
      value: input.instructionsSysvarOrContextState ?? null,
      isWritable: false
    },
    record: { value: input.record ?? null, isWritable: false },
    authority: { value: input.authority ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  if (!accounts.instructionsSysvarOrContextState.value) {
    accounts.instructionsSysvarOrContextState.value = "Sysvar1nstructions1111111111111111111111111";
  }
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.token),
      getAccountMeta(accounts.instructionsSysvarOrContextState),
      getAccountMeta(accounts.record),
      getAccountMeta(accounts.authority),
      ...remainingAccounts
    ],
    programAddress,
    data: getEmptyConfidentialTransferAccountInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseEmptyConfidentialTransferAccountInstruction(instruction) {
  if (instruction.accounts.length < 4) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  const getNextOptionalAccount = () => {
    const accountMeta = getNextAccount();
    return accountMeta.address === TOKEN_2022_PROGRAM_ADDRESS ? void 0 : accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      token: getNextAccount(),
      instructionsSysvarOrContextState: getNextAccount(),
      record: getNextOptionalAccount(),
      authority: getNextAccount()
    },
    data: getEmptyConfidentialTransferAccountInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var ENABLE_CONFIDENTIAL_CREDITS_DISCRIMINATOR = 27;
function getEnableConfidentialCreditsDiscriminatorBytes() {
  return getU8Encoder().encode(ENABLE_CONFIDENTIAL_CREDITS_DISCRIMINATOR);
}
var ENABLE_CONFIDENTIAL_CREDITS_CONFIDENTIAL_TRANSFER_DISCRIMINATOR = 9;
function getEnableConfidentialCreditsConfidentialTransferDiscriminatorBytes() {
  return getU8Encoder().encode(
    ENABLE_CONFIDENTIAL_CREDITS_CONFIDENTIAL_TRANSFER_DISCRIMINATOR
  );
}
function getEnableConfidentialCreditsInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["confidentialTransferDiscriminator", getU8Encoder()]
    ]),
    (value) => ({
      ...value,
      discriminator: ENABLE_CONFIDENTIAL_CREDITS_DISCRIMINATOR,
      confidentialTransferDiscriminator: ENABLE_CONFIDENTIAL_CREDITS_CONFIDENTIAL_TRANSFER_DISCRIMINATOR
    })
  );
}
function getEnableConfidentialCreditsInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["confidentialTransferDiscriminator", getU8Decoder()]
  ]);
}
function getEnableConfidentialCreditsInstructionDataCodec() {
  return combineCodec(
    getEnableConfidentialCreditsInstructionDataEncoder(),
    getEnableConfidentialCreditsInstructionDataDecoder()
  );
}
function getEnableConfidentialCreditsInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    token: { value: input.token ?? null, isWritable: true },
    authority: { value: input.authority ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.token),
      getAccountMeta(accounts.authority),
      ...remainingAccounts
    ],
    programAddress,
    data: getEnableConfidentialCreditsInstructionDataEncoder().encode({})
  };
  return instruction;
}
function parseEnableConfidentialCreditsInstruction(instruction) {
  if (instruction.accounts.length < 2) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      token: getNextAccount(),
      authority: getNextAccount()
    },
    data: getEnableConfidentialCreditsInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var ENABLE_CPI_GUARD_DISCRIMINATOR = 34;
function getEnableCpiGuardDiscriminatorBytes() {
  return getU8Encoder().encode(ENABLE_CPI_GUARD_DISCRIMINATOR);
}
var ENABLE_CPI_GUARD_CPI_GUARD_DISCRIMINATOR = 0;
function getEnableCpiGuardCpiGuardDiscriminatorBytes() {
  return getU8Encoder().encode(ENABLE_CPI_GUARD_CPI_GUARD_DISCRIMINATOR);
}
function getEnableCpiGuardInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["cpiGuardDiscriminator", getU8Encoder()]
    ]),
    (value) => ({
      ...value,
      discriminator: ENABLE_CPI_GUARD_DISCRIMINATOR,
      cpiGuardDiscriminator: ENABLE_CPI_GUARD_CPI_GUARD_DISCRIMINATOR
    })
  );
}
function getEnableCpiGuardInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["cpiGuardDiscriminator", getU8Decoder()]
  ]);
}
function getEnableCpiGuardInstructionDataCodec() {
  return combineCodec(
    getEnableCpiGuardInstructionDataEncoder(),
    getEnableCpiGuardInstructionDataDecoder()
  );
}
function getEnableCpiGuardInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    token: { value: input.token ?? null, isWritable: true },
    owner: { value: input.owner ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.token),
      getAccountMeta(accounts.owner),
      ...remainingAccounts
    ],
    programAddress,
    data: getEnableCpiGuardInstructionDataEncoder().encode({})
  };
  return instruction;
}
function parseEnableCpiGuardInstruction(instruction) {
  if (instruction.accounts.length < 2) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      token: getNextAccount(),
      owner: getNextAccount()
    },
    data: getEnableCpiGuardInstructionDataDecoder().decode(instruction.data)
  };
}
var ENABLE_HARVEST_TO_MINT_DISCRIMINATOR = 37;
function getEnableHarvestToMintDiscriminatorBytes() {
  return getU8Encoder().encode(ENABLE_HARVEST_TO_MINT_DISCRIMINATOR);
}
var ENABLE_HARVEST_TO_MINT_CONFIDENTIAL_TRANSFER_FEE_DISCRIMINATOR = 4;
function getEnableHarvestToMintConfidentialTransferFeeDiscriminatorBytes() {
  return getU8Encoder().encode(
    ENABLE_HARVEST_TO_MINT_CONFIDENTIAL_TRANSFER_FEE_DISCRIMINATOR
  );
}
function getEnableHarvestToMintInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["confidentialTransferFeeDiscriminator", getU8Encoder()]
    ]),
    (value) => ({
      ...value,
      discriminator: ENABLE_HARVEST_TO_MINT_DISCRIMINATOR,
      confidentialTransferFeeDiscriminator: ENABLE_HARVEST_TO_MINT_CONFIDENTIAL_TRANSFER_FEE_DISCRIMINATOR
    })
  );
}
function getEnableHarvestToMintInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["confidentialTransferFeeDiscriminator", getU8Decoder()]
  ]);
}
function getEnableHarvestToMintInstructionDataCodec() {
  return combineCodec(
    getEnableHarvestToMintInstructionDataEncoder(),
    getEnableHarvestToMintInstructionDataDecoder()
  );
}
function getEnableHarvestToMintInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    mint: { value: input.mint ?? null, isWritable: true },
    authority: { value: input.authority ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.mint),
      getAccountMeta(accounts.authority),
      ...remainingAccounts
    ],
    programAddress,
    data: getEnableHarvestToMintInstructionDataEncoder().encode({})
  };
  return instruction;
}
function parseEnableHarvestToMintInstruction(instruction) {
  if (instruction.accounts.length < 2) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      mint: getNextAccount(),
      authority: getNextAccount()
    },
    data: getEnableHarvestToMintInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var ENABLE_MEMO_TRANSFERS_DISCRIMINATOR = 30;
function getEnableMemoTransfersDiscriminatorBytes() {
  return getU8Encoder().encode(ENABLE_MEMO_TRANSFERS_DISCRIMINATOR);
}
var ENABLE_MEMO_TRANSFERS_MEMO_TRANSFERS_DISCRIMINATOR = 0;
function getEnableMemoTransfersMemoTransfersDiscriminatorBytes() {
  return getU8Encoder().encode(
    ENABLE_MEMO_TRANSFERS_MEMO_TRANSFERS_DISCRIMINATOR
  );
}
function getEnableMemoTransfersInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["memoTransfersDiscriminator", getU8Encoder()]
    ]),
    (value) => ({
      ...value,
      discriminator: ENABLE_MEMO_TRANSFERS_DISCRIMINATOR,
      memoTransfersDiscriminator: ENABLE_MEMO_TRANSFERS_MEMO_TRANSFERS_DISCRIMINATOR
    })
  );
}
function getEnableMemoTransfersInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["memoTransfersDiscriminator", getU8Decoder()]
  ]);
}
function getEnableMemoTransfersInstructionDataCodec() {
  return combineCodec(
    getEnableMemoTransfersInstructionDataEncoder(),
    getEnableMemoTransfersInstructionDataDecoder()
  );
}
function getEnableMemoTransfersInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    token: { value: input.token ?? null, isWritable: true },
    owner: { value: input.owner ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.token),
      getAccountMeta(accounts.owner),
      ...remainingAccounts
    ],
    programAddress,
    data: getEnableMemoTransfersInstructionDataEncoder().encode({})
  };
  return instruction;
}
function parseEnableMemoTransfersInstruction(instruction) {
  if (instruction.accounts.length < 2) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      token: getNextAccount(),
      owner: getNextAccount()
    },
    data: getEnableMemoTransfersInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var ENABLE_NON_CONFIDENTIAL_CREDITS_DISCRIMINATOR = 27;
function getEnableNonConfidentialCreditsDiscriminatorBytes() {
  return getU8Encoder().encode(ENABLE_NON_CONFIDENTIAL_CREDITS_DISCRIMINATOR);
}
var ENABLE_NON_CONFIDENTIAL_CREDITS_CONFIDENTIAL_TRANSFER_DISCRIMINATOR = 11;
function getEnableNonConfidentialCreditsConfidentialTransferDiscriminatorBytes() {
  return getU8Encoder().encode(
    ENABLE_NON_CONFIDENTIAL_CREDITS_CONFIDENTIAL_TRANSFER_DISCRIMINATOR
  );
}
function getEnableNonConfidentialCreditsInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["confidentialTransferDiscriminator", getU8Encoder()]
    ]),
    (value) => ({
      ...value,
      discriminator: ENABLE_NON_CONFIDENTIAL_CREDITS_DISCRIMINATOR,
      confidentialTransferDiscriminator: ENABLE_NON_CONFIDENTIAL_CREDITS_CONFIDENTIAL_TRANSFER_DISCRIMINATOR
    })
  );
}
function getEnableNonConfidentialCreditsInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["confidentialTransferDiscriminator", getU8Decoder()]
  ]);
}
function getEnableNonConfidentialCreditsInstructionDataCodec() {
  return combineCodec(
    getEnableNonConfidentialCreditsInstructionDataEncoder(),
    getEnableNonConfidentialCreditsInstructionDataDecoder()
  );
}
function getEnableNonConfidentialCreditsInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    token: { value: input.token ?? null, isWritable: true },
    authority: { value: input.authority ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.token),
      getAccountMeta(accounts.authority),
      ...remainingAccounts
    ],
    programAddress,
    data: getEnableNonConfidentialCreditsInstructionDataEncoder().encode({})
  };
  return instruction;
}
function parseEnableNonConfidentialCreditsInstruction(instruction) {
  if (instruction.accounts.length < 2) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      token: getNextAccount(),
      authority: getNextAccount()
    },
    data: getEnableNonConfidentialCreditsInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var FREEZE_ACCOUNT_DISCRIMINATOR = 10;
function getFreezeAccountDiscriminatorBytes() {
  return getU8Encoder().encode(FREEZE_ACCOUNT_DISCRIMINATOR);
}
function getFreezeAccountInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([["discriminator", getU8Encoder()]]),
    (value) => ({ ...value, discriminator: FREEZE_ACCOUNT_DISCRIMINATOR })
  );
}
function getFreezeAccountInstructionDataDecoder() {
  return getStructDecoder([["discriminator", getU8Decoder()]]);
}
function getFreezeAccountInstructionDataCodec() {
  return combineCodec(
    getFreezeAccountInstructionDataEncoder(),
    getFreezeAccountInstructionDataDecoder()
  );
}
function getFreezeAccountInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    account: { value: input.account ?? null, isWritable: true },
    mint: { value: input.mint ?? null, isWritable: false },
    owner: { value: input.owner ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.account),
      getAccountMeta(accounts.mint),
      getAccountMeta(accounts.owner),
      ...remainingAccounts
    ],
    programAddress,
    data: getFreezeAccountInstructionDataEncoder().encode({})
  };
  return instruction;
}
function parseFreezeAccountInstruction(instruction) {
  if (instruction.accounts.length < 3) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      account: getNextAccount(),
      mint: getNextAccount(),
      owner: getNextAccount()
    },
    data: getFreezeAccountInstructionDataDecoder().decode(instruction.data)
  };
}
var GET_ACCOUNT_DATA_SIZE_DISCRIMINATOR = 21;
function getGetAccountDataSizeDiscriminatorBytes() {
  return getU8Encoder().encode(GET_ACCOUNT_DATA_SIZE_DISCRIMINATOR);
}
function getGetAccountDataSizeInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([["discriminator", getU8Encoder()]]),
    (value) => ({
      ...value,
      discriminator: GET_ACCOUNT_DATA_SIZE_DISCRIMINATOR
    })
  );
}
function getGetAccountDataSizeInstructionDataDecoder() {
  return getStructDecoder([["discriminator", getU8Decoder()]]);
}
function getGetAccountDataSizeInstructionDataCodec() {
  return combineCodec(
    getGetAccountDataSizeInstructionDataEncoder(),
    getGetAccountDataSizeInstructionDataDecoder()
  );
}
function getGetAccountDataSizeInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    mint: { value: input.mint ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [getAccountMeta(accounts.mint)],
    programAddress,
    data: getGetAccountDataSizeInstructionDataEncoder().encode({})
  };
  return instruction;
}
function parseGetAccountDataSizeInstruction(instruction) {
  if (instruction.accounts.length < 1) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      mint: getNextAccount()
    },
    data: getGetAccountDataSizeInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var HARVEST_WITHHELD_TOKENS_TO_MINT_DISCRIMINATOR = 26;
function getHarvestWithheldTokensToMintDiscriminatorBytes() {
  return getU8Encoder().encode(HARVEST_WITHHELD_TOKENS_TO_MINT_DISCRIMINATOR);
}
var HARVEST_WITHHELD_TOKENS_TO_MINT_TRANSFER_FEE_DISCRIMINATOR = 4;
function getHarvestWithheldTokensToMintTransferFeeDiscriminatorBytes() {
  return getU8Encoder().encode(
    HARVEST_WITHHELD_TOKENS_TO_MINT_TRANSFER_FEE_DISCRIMINATOR
  );
}
function getHarvestWithheldTokensToMintInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["transferFeeDiscriminator", getU8Encoder()]
    ]),
    (value) => ({
      ...value,
      discriminator: HARVEST_WITHHELD_TOKENS_TO_MINT_DISCRIMINATOR,
      transferFeeDiscriminator: HARVEST_WITHHELD_TOKENS_TO_MINT_TRANSFER_FEE_DISCRIMINATOR
    })
  );
}
function getHarvestWithheldTokensToMintInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["transferFeeDiscriminator", getU8Decoder()]
  ]);
}
function getHarvestWithheldTokensToMintInstructionDataCodec() {
  return combineCodec(
    getHarvestWithheldTokensToMintInstructionDataEncoder(),
    getHarvestWithheldTokensToMintInstructionDataDecoder()
  );
}
function getHarvestWithheldTokensToMintInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    mint: { value: input.mint ?? null, isWritable: true }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = args.sources.map((address) => ({
    address,
    role: AccountRole.WRITABLE
  }));
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [getAccountMeta(accounts.mint), ...remainingAccounts],
    programAddress,
    data: getHarvestWithheldTokensToMintInstructionDataEncoder().encode({})
  };
  return instruction;
}
function parseHarvestWithheldTokensToMintInstruction(instruction) {
  if (instruction.accounts.length < 1) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      mint: getNextAccount()
    },
    data: getHarvestWithheldTokensToMintInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var HARVEST_WITHHELD_TOKENS_TO_MINT_FOR_CONFIDENTIAL_TRANSFER_FEE_DISCRIMINATOR = 37;
function getHarvestWithheldTokensToMintForConfidentialTransferFeeDiscriminatorBytes() {
  return getU8Encoder().encode(
    HARVEST_WITHHELD_TOKENS_TO_MINT_FOR_CONFIDENTIAL_TRANSFER_FEE_DISCRIMINATOR
  );
}
var HARVEST_WITHHELD_TOKENS_TO_MINT_FOR_CONFIDENTIAL_TRANSFER_FEE_CONFIDENTIAL_TRANSFER_FEE_DISCRIMINATOR = 3;
function getHarvestWithheldTokensToMintForConfidentialTransferFeeConfidentialTransferFeeDiscriminatorBytes() {
  return getU8Encoder().encode(
    HARVEST_WITHHELD_TOKENS_TO_MINT_FOR_CONFIDENTIAL_TRANSFER_FEE_CONFIDENTIAL_TRANSFER_FEE_DISCRIMINATOR
  );
}
function getHarvestWithheldTokensToMintForConfidentialTransferFeeInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["confidentialTransferFeeDiscriminator", getU8Encoder()]
    ]),
    (value) => ({
      ...value,
      discriminator: HARVEST_WITHHELD_TOKENS_TO_MINT_FOR_CONFIDENTIAL_TRANSFER_FEE_DISCRIMINATOR,
      confidentialTransferFeeDiscriminator: HARVEST_WITHHELD_TOKENS_TO_MINT_FOR_CONFIDENTIAL_TRANSFER_FEE_CONFIDENTIAL_TRANSFER_FEE_DISCRIMINATOR
    })
  );
}
function getHarvestWithheldTokensToMintForConfidentialTransferFeeInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["confidentialTransferFeeDiscriminator", getU8Decoder()]
  ]);
}
function getHarvestWithheldTokensToMintForConfidentialTransferFeeInstructionDataCodec() {
  return combineCodec(
    getHarvestWithheldTokensToMintForConfidentialTransferFeeInstructionDataEncoder(),
    getHarvestWithheldTokensToMintForConfidentialTransferFeeInstructionDataDecoder()
  );
}
function getHarvestWithheldTokensToMintForConfidentialTransferFeeInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    mint: { value: input.mint ?? null, isWritable: true }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.sources ?? []).map(
    (address) => ({ address, role: AccountRole.WRITABLE })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [getAccountMeta(accounts.mint), ...remainingAccounts],
    programAddress,
    data: getHarvestWithheldTokensToMintForConfidentialTransferFeeInstructionDataEncoder().encode(
      {}
    )
  };
  return instruction;
}
function parseHarvestWithheldTokensToMintForConfidentialTransferFeeInstruction(instruction) {
  if (instruction.accounts.length < 1) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      mint: getNextAccount()
    },
    data: getHarvestWithheldTokensToMintForConfidentialTransferFeeInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var INITIALIZE_ACCOUNT_DISCRIMINATOR = 1;
function getInitializeAccountDiscriminatorBytes() {
  return getU8Encoder().encode(INITIALIZE_ACCOUNT_DISCRIMINATOR);
}
function getInitializeAccountInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([["discriminator", getU8Encoder()]]),
    (value) => ({ ...value, discriminator: INITIALIZE_ACCOUNT_DISCRIMINATOR })
  );
}
function getInitializeAccountInstructionDataDecoder() {
  return getStructDecoder([["discriminator", getU8Decoder()]]);
}
function getInitializeAccountInstructionDataCodec() {
  return combineCodec(
    getInitializeAccountInstructionDataEncoder(),
    getInitializeAccountInstructionDataDecoder()
  );
}
function getInitializeAccountInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    account: { value: input.account ?? null, isWritable: true },
    mint: { value: input.mint ?? null, isWritable: false },
    owner: { value: input.owner ?? null, isWritable: false },
    rent: { value: input.rent ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  if (!accounts.rent.value) {
    accounts.rent.value = "SysvarRent111111111111111111111111111111111";
  }
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.account),
      getAccountMeta(accounts.mint),
      getAccountMeta(accounts.owner),
      getAccountMeta(accounts.rent)
    ],
    programAddress,
    data: getInitializeAccountInstructionDataEncoder().encode({})
  };
  return instruction;
}
function parseInitializeAccountInstruction(instruction) {
  if (instruction.accounts.length < 4) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      account: getNextAccount(),
      mint: getNextAccount(),
      owner: getNextAccount(),
      rent: getNextAccount()
    },
    data: getInitializeAccountInstructionDataDecoder().decode(instruction.data)
  };
}
var INITIALIZE_ACCOUNT2_DISCRIMINATOR = 16;
function getInitializeAccount2DiscriminatorBytes() {
  return getU8Encoder().encode(INITIALIZE_ACCOUNT2_DISCRIMINATOR);
}
function getInitializeAccount2InstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["owner", getAddressEncoder()]
    ]),
    (value) => ({ ...value, discriminator: INITIALIZE_ACCOUNT2_DISCRIMINATOR })
  );
}
function getInitializeAccount2InstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["owner", getAddressDecoder()]
  ]);
}
function getInitializeAccount2InstructionDataCodec() {
  return combineCodec(
    getInitializeAccount2InstructionDataEncoder(),
    getInitializeAccount2InstructionDataDecoder()
  );
}
function getInitializeAccount2Instruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    account: { value: input.account ?? null, isWritable: true },
    mint: { value: input.mint ?? null, isWritable: false },
    rent: { value: input.rent ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  if (!accounts.rent.value) {
    accounts.rent.value = "SysvarRent111111111111111111111111111111111";
  }
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.account),
      getAccountMeta(accounts.mint),
      getAccountMeta(accounts.rent)
    ],
    programAddress,
    data: getInitializeAccount2InstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseInitializeAccount2Instruction(instruction) {
  if (instruction.accounts.length < 3) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      account: getNextAccount(),
      mint: getNextAccount(),
      rent: getNextAccount()
    },
    data: getInitializeAccount2InstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var INITIALIZE_ACCOUNT3_DISCRIMINATOR = 18;
function getInitializeAccount3DiscriminatorBytes() {
  return getU8Encoder().encode(INITIALIZE_ACCOUNT3_DISCRIMINATOR);
}
function getInitializeAccount3InstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["owner", getAddressEncoder()]
    ]),
    (value) => ({ ...value, discriminator: INITIALIZE_ACCOUNT3_DISCRIMINATOR })
  );
}
function getInitializeAccount3InstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["owner", getAddressDecoder()]
  ]);
}
function getInitializeAccount3InstructionDataCodec() {
  return combineCodec(
    getInitializeAccount3InstructionDataEncoder(),
    getInitializeAccount3InstructionDataDecoder()
  );
}
function getInitializeAccount3Instruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    account: { value: input.account ?? null, isWritable: true },
    mint: { value: input.mint ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [getAccountMeta(accounts.account), getAccountMeta(accounts.mint)],
    programAddress,
    data: getInitializeAccount3InstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseInitializeAccount3Instruction(instruction) {
  if (instruction.accounts.length < 2) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      account: getNextAccount(),
      mint: getNextAccount()
    },
    data: getInitializeAccount3InstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var INITIALIZE_CONFIDENTIAL_TRANSFER_FEE_DISCRIMINATOR = 37;
function getInitializeConfidentialTransferFeeDiscriminatorBytes() {
  return getU8Encoder().encode(
    INITIALIZE_CONFIDENTIAL_TRANSFER_FEE_DISCRIMINATOR
  );
}
var INITIALIZE_CONFIDENTIAL_TRANSFER_FEE_CONFIDENTIAL_TRANSFER_FEE_DISCRIMINATOR = 0;
function getInitializeConfidentialTransferFeeConfidentialTransferFeeDiscriminatorBytes() {
  return getU8Encoder().encode(
    INITIALIZE_CONFIDENTIAL_TRANSFER_FEE_CONFIDENTIAL_TRANSFER_FEE_DISCRIMINATOR
  );
}
function getInitializeConfidentialTransferFeeInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["confidentialTransferFeeDiscriminator", getU8Encoder()],
      [
        "authority",
        getOptionEncoder(getAddressEncoder(), {
          prefix: null,
          noneValue: "zeroes"
        })
      ],
      [
        "withdrawWithheldAuthorityElGamalPubkey",
        getOptionEncoder(getAddressEncoder(), {
          prefix: null,
          noneValue: "zeroes"
        })
      ]
    ]),
    (value) => ({
      ...value,
      discriminator: INITIALIZE_CONFIDENTIAL_TRANSFER_FEE_DISCRIMINATOR,
      confidentialTransferFeeDiscriminator: INITIALIZE_CONFIDENTIAL_TRANSFER_FEE_CONFIDENTIAL_TRANSFER_FEE_DISCRIMINATOR
    })
  );
}
function getInitializeConfidentialTransferFeeInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["confidentialTransferFeeDiscriminator", getU8Decoder()],
    [
      "authority",
      getOptionDecoder(getAddressDecoder(), {
        prefix: null,
        noneValue: "zeroes"
      })
    ],
    [
      "withdrawWithheldAuthorityElGamalPubkey",
      getOptionDecoder(getAddressDecoder(), {
        prefix: null,
        noneValue: "zeroes"
      })
    ]
  ]);
}
function getInitializeConfidentialTransferFeeInstructionDataCodec() {
  return combineCodec(
    getInitializeConfidentialTransferFeeInstructionDataEncoder(),
    getInitializeConfidentialTransferFeeInstructionDataDecoder()
  );
}
function getInitializeConfidentialTransferFeeInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    mint: { value: input.mint ?? null, isWritable: true }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [getAccountMeta(accounts.mint)],
    programAddress,
    data: getInitializeConfidentialTransferFeeInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseInitializeConfidentialTransferFeeInstruction(instruction) {
  if (instruction.accounts.length < 1) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      mint: getNextAccount()
    },
    data: getInitializeConfidentialTransferFeeInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var INITIALIZE_CONFIDENTIAL_TRANSFER_MINT_DISCRIMINATOR = 27;
function getInitializeConfidentialTransferMintDiscriminatorBytes() {
  return getU8Encoder().encode(
    INITIALIZE_CONFIDENTIAL_TRANSFER_MINT_DISCRIMINATOR
  );
}
var INITIALIZE_CONFIDENTIAL_TRANSFER_MINT_CONFIDENTIAL_TRANSFER_DISCRIMINATOR = 0;
function getInitializeConfidentialTransferMintConfidentialTransferDiscriminatorBytes() {
  return getU8Encoder().encode(
    INITIALIZE_CONFIDENTIAL_TRANSFER_MINT_CONFIDENTIAL_TRANSFER_DISCRIMINATOR
  );
}
function getInitializeConfidentialTransferMintInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["confidentialTransferDiscriminator", getU8Encoder()],
      [
        "authority",
        getOptionEncoder(getAddressEncoder(), {
          prefix: null,
          noneValue: "zeroes"
        })
      ],
      ["autoApproveNewAccounts", getBooleanEncoder()],
      [
        "auditorElgamalPubkey",
        getOptionEncoder(getAddressEncoder(), {
          prefix: null,
          noneValue: "zeroes"
        })
      ]
    ]),
    (value) => ({
      ...value,
      discriminator: INITIALIZE_CONFIDENTIAL_TRANSFER_MINT_DISCRIMINATOR,
      confidentialTransferDiscriminator: INITIALIZE_CONFIDENTIAL_TRANSFER_MINT_CONFIDENTIAL_TRANSFER_DISCRIMINATOR
    })
  );
}
function getInitializeConfidentialTransferMintInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["confidentialTransferDiscriminator", getU8Decoder()],
    [
      "authority",
      getOptionDecoder(getAddressDecoder(), {
        prefix: null,
        noneValue: "zeroes"
      })
    ],
    ["autoApproveNewAccounts", getBooleanDecoder()],
    [
      "auditorElgamalPubkey",
      getOptionDecoder(getAddressDecoder(), {
        prefix: null,
        noneValue: "zeroes"
      })
    ]
  ]);
}
function getInitializeConfidentialTransferMintInstructionDataCodec() {
  return combineCodec(
    getInitializeConfidentialTransferMintInstructionDataEncoder(),
    getInitializeConfidentialTransferMintInstructionDataDecoder()
  );
}
function getInitializeConfidentialTransferMintInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    mint: { value: input.mint ?? null, isWritable: true }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [getAccountMeta(accounts.mint)],
    programAddress,
    data: getInitializeConfidentialTransferMintInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseInitializeConfidentialTransferMintInstruction(instruction) {
  if (instruction.accounts.length < 1) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      mint: getNextAccount()
    },
    data: getInitializeConfidentialTransferMintInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var INITIALIZE_DEFAULT_ACCOUNT_STATE_DISCRIMINATOR = 28;
function getInitializeDefaultAccountStateDiscriminatorBytes() {
  return getU8Encoder().encode(INITIALIZE_DEFAULT_ACCOUNT_STATE_DISCRIMINATOR);
}
var INITIALIZE_DEFAULT_ACCOUNT_STATE_DEFAULT_ACCOUNT_STATE_DISCRIMINATOR = 0;
function getInitializeDefaultAccountStateDefaultAccountStateDiscriminatorBytes() {
  return getU8Encoder().encode(
    INITIALIZE_DEFAULT_ACCOUNT_STATE_DEFAULT_ACCOUNT_STATE_DISCRIMINATOR
  );
}
function getInitializeDefaultAccountStateInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["defaultAccountStateDiscriminator", getU8Encoder()],
      ["state", getAccountStateEncoder()]
    ]),
    (value) => ({
      ...value,
      discriminator: INITIALIZE_DEFAULT_ACCOUNT_STATE_DISCRIMINATOR,
      defaultAccountStateDiscriminator: INITIALIZE_DEFAULT_ACCOUNT_STATE_DEFAULT_ACCOUNT_STATE_DISCRIMINATOR
    })
  );
}
function getInitializeDefaultAccountStateInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["defaultAccountStateDiscriminator", getU8Decoder()],
    ["state", getAccountStateDecoder()]
  ]);
}
function getInitializeDefaultAccountStateInstructionDataCodec() {
  return combineCodec(
    getInitializeDefaultAccountStateInstructionDataEncoder(),
    getInitializeDefaultAccountStateInstructionDataDecoder()
  );
}
function getInitializeDefaultAccountStateInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    mint: { value: input.mint ?? null, isWritable: true }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [getAccountMeta(accounts.mint)],
    programAddress,
    data: getInitializeDefaultAccountStateInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseInitializeDefaultAccountStateInstruction(instruction) {
  if (instruction.accounts.length < 1) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      mint: getNextAccount()
    },
    data: getInitializeDefaultAccountStateInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var INITIALIZE_GROUP_MEMBER_POINTER_DISCRIMINATOR = 41;
function getInitializeGroupMemberPointerDiscriminatorBytes() {
  return getU8Encoder().encode(INITIALIZE_GROUP_MEMBER_POINTER_DISCRIMINATOR);
}
var INITIALIZE_GROUP_MEMBER_POINTER_GROUP_MEMBER_POINTER_DISCRIMINATOR = 0;
function getInitializeGroupMemberPointerGroupMemberPointerDiscriminatorBytes() {
  return getU8Encoder().encode(
    INITIALIZE_GROUP_MEMBER_POINTER_GROUP_MEMBER_POINTER_DISCRIMINATOR
  );
}
function getInitializeGroupMemberPointerInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["groupMemberPointerDiscriminator", getU8Encoder()],
      [
        "authority",
        getOptionEncoder(getAddressEncoder(), {
          prefix: null,
          noneValue: "zeroes"
        })
      ],
      [
        "memberAddress",
        getOptionEncoder(getAddressEncoder(), {
          prefix: null,
          noneValue: "zeroes"
        })
      ]
    ]),
    (value) => ({
      ...value,
      discriminator: INITIALIZE_GROUP_MEMBER_POINTER_DISCRIMINATOR,
      groupMemberPointerDiscriminator: INITIALIZE_GROUP_MEMBER_POINTER_GROUP_MEMBER_POINTER_DISCRIMINATOR
    })
  );
}
function getInitializeGroupMemberPointerInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["groupMemberPointerDiscriminator", getU8Decoder()],
    [
      "authority",
      getOptionDecoder(getAddressDecoder(), {
        prefix: null,
        noneValue: "zeroes"
      })
    ],
    [
      "memberAddress",
      getOptionDecoder(getAddressDecoder(), {
        prefix: null,
        noneValue: "zeroes"
      })
    ]
  ]);
}
function getInitializeGroupMemberPointerInstructionDataCodec() {
  return combineCodec(
    getInitializeGroupMemberPointerInstructionDataEncoder(),
    getInitializeGroupMemberPointerInstructionDataDecoder()
  );
}
function getInitializeGroupMemberPointerInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    mint: { value: input.mint ?? null, isWritable: true }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [getAccountMeta(accounts.mint)],
    programAddress,
    data: getInitializeGroupMemberPointerInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseInitializeGroupMemberPointerInstruction(instruction) {
  if (instruction.accounts.length < 1) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      mint: getNextAccount()
    },
    data: getInitializeGroupMemberPointerInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var INITIALIZE_GROUP_POINTER_DISCRIMINATOR = 40;
function getInitializeGroupPointerDiscriminatorBytes() {
  return getU8Encoder().encode(INITIALIZE_GROUP_POINTER_DISCRIMINATOR);
}
var INITIALIZE_GROUP_POINTER_GROUP_POINTER_DISCRIMINATOR = 0;
function getInitializeGroupPointerGroupPointerDiscriminatorBytes() {
  return getU8Encoder().encode(
    INITIALIZE_GROUP_POINTER_GROUP_POINTER_DISCRIMINATOR
  );
}
function getInitializeGroupPointerInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["groupPointerDiscriminator", getU8Encoder()],
      [
        "authority",
        getOptionEncoder(getAddressEncoder(), {
          prefix: null,
          noneValue: "zeroes"
        })
      ],
      [
        "groupAddress",
        getOptionEncoder(getAddressEncoder(), {
          prefix: null,
          noneValue: "zeroes"
        })
      ]
    ]),
    (value) => ({
      ...value,
      discriminator: INITIALIZE_GROUP_POINTER_DISCRIMINATOR,
      groupPointerDiscriminator: INITIALIZE_GROUP_POINTER_GROUP_POINTER_DISCRIMINATOR
    })
  );
}
function getInitializeGroupPointerInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["groupPointerDiscriminator", getU8Decoder()],
    [
      "authority",
      getOptionDecoder(getAddressDecoder(), {
        prefix: null,
        noneValue: "zeroes"
      })
    ],
    [
      "groupAddress",
      getOptionDecoder(getAddressDecoder(), {
        prefix: null,
        noneValue: "zeroes"
      })
    ]
  ]);
}
function getInitializeGroupPointerInstructionDataCodec() {
  return combineCodec(
    getInitializeGroupPointerInstructionDataEncoder(),
    getInitializeGroupPointerInstructionDataDecoder()
  );
}
function getInitializeGroupPointerInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    mint: { value: input.mint ?? null, isWritable: true }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [getAccountMeta(accounts.mint)],
    programAddress,
    data: getInitializeGroupPointerInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseInitializeGroupPointerInstruction(instruction) {
  if (instruction.accounts.length < 1) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      mint: getNextAccount()
    },
    data: getInitializeGroupPointerInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var INITIALIZE_IMMUTABLE_OWNER_DISCRIMINATOR = 22;
function getInitializeImmutableOwnerDiscriminatorBytes() {
  return getU8Encoder().encode(INITIALIZE_IMMUTABLE_OWNER_DISCRIMINATOR);
}
function getInitializeImmutableOwnerInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([["discriminator", getU8Encoder()]]),
    (value) => ({
      ...value,
      discriminator: INITIALIZE_IMMUTABLE_OWNER_DISCRIMINATOR
    })
  );
}
function getInitializeImmutableOwnerInstructionDataDecoder() {
  return getStructDecoder([["discriminator", getU8Decoder()]]);
}
function getInitializeImmutableOwnerInstructionDataCodec() {
  return combineCodec(
    getInitializeImmutableOwnerInstructionDataEncoder(),
    getInitializeImmutableOwnerInstructionDataDecoder()
  );
}
function getInitializeImmutableOwnerInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    account: { value: input.account ?? null, isWritable: true }
  };
  const accounts = originalAccounts;
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [getAccountMeta(accounts.account)],
    programAddress,
    data: getInitializeImmutableOwnerInstructionDataEncoder().encode({})
  };
  return instruction;
}
function parseInitializeImmutableOwnerInstruction(instruction) {
  if (instruction.accounts.length < 1) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      account: getNextAccount()
    },
    data: getInitializeImmutableOwnerInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var INITIALIZE_INTEREST_BEARING_MINT_DISCRIMINATOR = 33;
function getInitializeInterestBearingMintDiscriminatorBytes() {
  return getU8Encoder().encode(INITIALIZE_INTEREST_BEARING_MINT_DISCRIMINATOR);
}
var INITIALIZE_INTEREST_BEARING_MINT_INTEREST_BEARING_MINT_DISCRIMINATOR = 0;
function getInitializeInterestBearingMintInterestBearingMintDiscriminatorBytes() {
  return getU8Encoder().encode(
    INITIALIZE_INTEREST_BEARING_MINT_INTEREST_BEARING_MINT_DISCRIMINATOR
  );
}
function getInitializeInterestBearingMintInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["interestBearingMintDiscriminator", getU8Encoder()],
      [
        "rateAuthority",
        getOptionEncoder(getAddressEncoder(), {
          prefix: null,
          noneValue: "zeroes"
        })
      ],
      ["rate", getI16Encoder()]
    ]),
    (value) => ({
      ...value,
      discriminator: INITIALIZE_INTEREST_BEARING_MINT_DISCRIMINATOR,
      interestBearingMintDiscriminator: INITIALIZE_INTEREST_BEARING_MINT_INTEREST_BEARING_MINT_DISCRIMINATOR
    })
  );
}
function getInitializeInterestBearingMintInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["interestBearingMintDiscriminator", getU8Decoder()],
    [
      "rateAuthority",
      getOptionDecoder(getAddressDecoder(), {
        prefix: null,
        noneValue: "zeroes"
      })
    ],
    ["rate", getI16Decoder()]
  ]);
}
function getInitializeInterestBearingMintInstructionDataCodec() {
  return combineCodec(
    getInitializeInterestBearingMintInstructionDataEncoder(),
    getInitializeInterestBearingMintInstructionDataDecoder()
  );
}
function getInitializeInterestBearingMintInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    mint: { value: input.mint ?? null, isWritable: true }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [getAccountMeta(accounts.mint)],
    programAddress,
    data: getInitializeInterestBearingMintInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseInitializeInterestBearingMintInstruction(instruction) {
  if (instruction.accounts.length < 1) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      mint: getNextAccount()
    },
    data: getInitializeInterestBearingMintInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var INITIALIZE_METADATA_POINTER_DISCRIMINATOR = 39;
function getInitializeMetadataPointerDiscriminatorBytes() {
  return getU8Encoder().encode(INITIALIZE_METADATA_POINTER_DISCRIMINATOR);
}
var INITIALIZE_METADATA_POINTER_METADATA_POINTER_DISCRIMINATOR = 0;
function getInitializeMetadataPointerMetadataPointerDiscriminatorBytes() {
  return getU8Encoder().encode(
    INITIALIZE_METADATA_POINTER_METADATA_POINTER_DISCRIMINATOR
  );
}
function getInitializeMetadataPointerInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["metadataPointerDiscriminator", getU8Encoder()],
      [
        "authority",
        getOptionEncoder(getAddressEncoder(), {
          prefix: null,
          noneValue: "zeroes"
        })
      ],
      [
        "metadataAddress",
        getOptionEncoder(getAddressEncoder(), {
          prefix: null,
          noneValue: "zeroes"
        })
      ]
    ]),
    (value) => ({
      ...value,
      discriminator: INITIALIZE_METADATA_POINTER_DISCRIMINATOR,
      metadataPointerDiscriminator: INITIALIZE_METADATA_POINTER_METADATA_POINTER_DISCRIMINATOR
    })
  );
}
function getInitializeMetadataPointerInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["metadataPointerDiscriminator", getU8Decoder()],
    [
      "authority",
      getOptionDecoder(getAddressDecoder(), {
        prefix: null,
        noneValue: "zeroes"
      })
    ],
    [
      "metadataAddress",
      getOptionDecoder(getAddressDecoder(), {
        prefix: null,
        noneValue: "zeroes"
      })
    ]
  ]);
}
function getInitializeMetadataPointerInstructionDataCodec() {
  return combineCodec(
    getInitializeMetadataPointerInstructionDataEncoder(),
    getInitializeMetadataPointerInstructionDataDecoder()
  );
}
function getInitializeMetadataPointerInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    mint: { value: input.mint ?? null, isWritable: true }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [getAccountMeta(accounts.mint)],
    programAddress,
    data: getInitializeMetadataPointerInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseInitializeMetadataPointerInstruction(instruction) {
  if (instruction.accounts.length < 1) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      mint: getNextAccount()
    },
    data: getInitializeMetadataPointerInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var INITIALIZE_MINT_DISCRIMINATOR = 0;
function getInitializeMintDiscriminatorBytes() {
  return getU8Encoder().encode(INITIALIZE_MINT_DISCRIMINATOR);
}
function getInitializeMintInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["decimals", getU8Encoder()],
      ["mintAuthority", getAddressEncoder()],
      ["freezeAuthority", getOptionEncoder(getAddressEncoder())]
    ]),
    (value) => ({
      ...value,
      discriminator: INITIALIZE_MINT_DISCRIMINATOR,
      freezeAuthority: value.freezeAuthority ?? none()
    })
  );
}
function getInitializeMintInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["decimals", getU8Decoder()],
    ["mintAuthority", getAddressDecoder()],
    ["freezeAuthority", getOptionDecoder(getAddressDecoder())]
  ]);
}
function getInitializeMintInstructionDataCodec() {
  return combineCodec(
    getInitializeMintInstructionDataEncoder(),
    getInitializeMintInstructionDataDecoder()
  );
}
function getInitializeMintInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    mint: { value: input.mint ?? null, isWritable: true },
    rent: { value: input.rent ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  if (!accounts.rent.value) {
    accounts.rent.value = "SysvarRent111111111111111111111111111111111";
  }
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [getAccountMeta(accounts.mint), getAccountMeta(accounts.rent)],
    programAddress,
    data: getInitializeMintInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseInitializeMintInstruction(instruction) {
  if (instruction.accounts.length < 2) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      mint: getNextAccount(),
      rent: getNextAccount()
    },
    data: getInitializeMintInstructionDataDecoder().decode(instruction.data)
  };
}
var INITIALIZE_MINT2_DISCRIMINATOR = 20;
function getInitializeMint2DiscriminatorBytes() {
  return getU8Encoder().encode(INITIALIZE_MINT2_DISCRIMINATOR);
}
function getInitializeMint2InstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["decimals", getU8Encoder()],
      ["mintAuthority", getAddressEncoder()],
      ["freezeAuthority", getOptionEncoder(getAddressEncoder())]
    ]),
    (value) => ({
      ...value,
      discriminator: INITIALIZE_MINT2_DISCRIMINATOR,
      freezeAuthority: value.freezeAuthority ?? none()
    })
  );
}
function getInitializeMint2InstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["decimals", getU8Decoder()],
    ["mintAuthority", getAddressDecoder()],
    ["freezeAuthority", getOptionDecoder(getAddressDecoder())]
  ]);
}
function getInitializeMint2InstructionDataCodec() {
  return combineCodec(
    getInitializeMint2InstructionDataEncoder(),
    getInitializeMint2InstructionDataDecoder()
  );
}
function getInitializeMint2Instruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    mint: { value: input.mint ?? null, isWritable: true }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [getAccountMeta(accounts.mint)],
    programAddress,
    data: getInitializeMint2InstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseInitializeMint2Instruction(instruction) {
  if (instruction.accounts.length < 1) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      mint: getNextAccount()
    },
    data: getInitializeMint2InstructionDataDecoder().decode(instruction.data)
  };
}
var INITIALIZE_MINT_CLOSE_AUTHORITY_DISCRIMINATOR = 25;
function getInitializeMintCloseAuthorityDiscriminatorBytes() {
  return getU8Encoder().encode(INITIALIZE_MINT_CLOSE_AUTHORITY_DISCRIMINATOR);
}
function getInitializeMintCloseAuthorityInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["closeAuthority", getOptionEncoder(getAddressEncoder())]
    ]),
    (value) => ({
      ...value,
      discriminator: INITIALIZE_MINT_CLOSE_AUTHORITY_DISCRIMINATOR
    })
  );
}
function getInitializeMintCloseAuthorityInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["closeAuthority", getOptionDecoder(getAddressDecoder())]
  ]);
}
function getInitializeMintCloseAuthorityInstructionDataCodec() {
  return combineCodec(
    getInitializeMintCloseAuthorityInstructionDataEncoder(),
    getInitializeMintCloseAuthorityInstructionDataDecoder()
  );
}
function getInitializeMintCloseAuthorityInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    mint: { value: input.mint ?? null, isWritable: true }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [getAccountMeta(accounts.mint)],
    programAddress,
    data: getInitializeMintCloseAuthorityInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseInitializeMintCloseAuthorityInstruction(instruction) {
  if (instruction.accounts.length < 1) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      mint: getNextAccount()
    },
    data: getInitializeMintCloseAuthorityInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var INITIALIZE_MULTISIG_DISCRIMINATOR = 2;
function getInitializeMultisigDiscriminatorBytes() {
  return getU8Encoder().encode(INITIALIZE_MULTISIG_DISCRIMINATOR);
}
function getInitializeMultisigInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["m", getU8Encoder()]
    ]),
    (value) => ({ ...value, discriminator: INITIALIZE_MULTISIG_DISCRIMINATOR })
  );
}
function getInitializeMultisigInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["m", getU8Decoder()]
  ]);
}
function getInitializeMultisigInstructionDataCodec() {
  return combineCodec(
    getInitializeMultisigInstructionDataEncoder(),
    getInitializeMultisigInstructionDataDecoder()
  );
}
function getInitializeMultisigInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    multisig: { value: input.multisig ?? null, isWritable: true },
    rent: { value: input.rent ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  if (!accounts.rent.value) {
    accounts.rent.value = "SysvarRent111111111111111111111111111111111";
  }
  const remainingAccounts = args.signers.map((address) => ({
    address,
    role: AccountRole.READONLY
  }));
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.multisig),
      getAccountMeta(accounts.rent),
      ...remainingAccounts
    ],
    programAddress,
    data: getInitializeMultisigInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseInitializeMultisigInstruction(instruction) {
  if (instruction.accounts.length < 2) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      multisig: getNextAccount(),
      rent: getNextAccount()
    },
    data: getInitializeMultisigInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var INITIALIZE_MULTISIG2_DISCRIMINATOR = 19;
function getInitializeMultisig2DiscriminatorBytes() {
  return getU8Encoder().encode(INITIALIZE_MULTISIG2_DISCRIMINATOR);
}
function getInitializeMultisig2InstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["m", getU8Encoder()]
    ]),
    (value) => ({ ...value, discriminator: INITIALIZE_MULTISIG2_DISCRIMINATOR })
  );
}
function getInitializeMultisig2InstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["m", getU8Decoder()]
  ]);
}
function getInitializeMultisig2InstructionDataCodec() {
  return combineCodec(
    getInitializeMultisig2InstructionDataEncoder(),
    getInitializeMultisig2InstructionDataDecoder()
  );
}
function getInitializeMultisig2Instruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    multisig: { value: input.multisig ?? null, isWritable: true }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = args.signers.map((address) => ({
    address,
    role: AccountRole.READONLY
  }));
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [getAccountMeta(accounts.multisig), ...remainingAccounts],
    programAddress,
    data: getInitializeMultisig2InstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseInitializeMultisig2Instruction(instruction) {
  if (instruction.accounts.length < 1) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      multisig: getNextAccount()
    },
    data: getInitializeMultisig2InstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var INITIALIZE_NON_TRANSFERABLE_MINT_DISCRIMINATOR = 32;
function getInitializeNonTransferableMintDiscriminatorBytes() {
  return getU8Encoder().encode(INITIALIZE_NON_TRANSFERABLE_MINT_DISCRIMINATOR);
}
function getInitializeNonTransferableMintInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([["discriminator", getU8Encoder()]]),
    (value) => ({
      ...value,
      discriminator: INITIALIZE_NON_TRANSFERABLE_MINT_DISCRIMINATOR
    })
  );
}
function getInitializeNonTransferableMintInstructionDataDecoder() {
  return getStructDecoder([["discriminator", getU8Decoder()]]);
}
function getInitializeNonTransferableMintInstructionDataCodec() {
  return combineCodec(
    getInitializeNonTransferableMintInstructionDataEncoder(),
    getInitializeNonTransferableMintInstructionDataDecoder()
  );
}
function getInitializeNonTransferableMintInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    mint: { value: input.mint ?? null, isWritable: true }
  };
  const accounts = originalAccounts;
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [getAccountMeta(accounts.mint)],
    programAddress,
    data: getInitializeNonTransferableMintInstructionDataEncoder().encode({})
  };
  return instruction;
}
function parseInitializeNonTransferableMintInstruction(instruction) {
  if (instruction.accounts.length < 1) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      mint: getNextAccount()
    },
    data: getInitializeNonTransferableMintInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var INITIALIZE_PAUSABLE_CONFIG_DISCRIMINATOR = 44;
function getInitializePausableConfigDiscriminatorBytes() {
  return getU8Encoder().encode(INITIALIZE_PAUSABLE_CONFIG_DISCRIMINATOR);
}
var INITIALIZE_PAUSABLE_CONFIG_PAUSABLE_DISCRIMINATOR = 0;
function getInitializePausableConfigPausableDiscriminatorBytes() {
  return getU8Encoder().encode(
    INITIALIZE_PAUSABLE_CONFIG_PAUSABLE_DISCRIMINATOR
  );
}
function getInitializePausableConfigInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["pausableDiscriminator", getU8Encoder()],
      [
        "authority",
        getOptionEncoder(getAddressEncoder(), {
          prefix: null,
          noneValue: "zeroes"
        })
      ]
    ]),
    (value) => ({
      ...value,
      discriminator: INITIALIZE_PAUSABLE_CONFIG_DISCRIMINATOR,
      pausableDiscriminator: INITIALIZE_PAUSABLE_CONFIG_PAUSABLE_DISCRIMINATOR
    })
  );
}
function getInitializePausableConfigInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["pausableDiscriminator", getU8Decoder()],
    [
      "authority",
      getOptionDecoder(getAddressDecoder(), {
        prefix: null,
        noneValue: "zeroes"
      })
    ]
  ]);
}
function getInitializePausableConfigInstructionDataCodec() {
  return combineCodec(
    getInitializePausableConfigInstructionDataEncoder(),
    getInitializePausableConfigInstructionDataDecoder()
  );
}
function getInitializePausableConfigInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    mint: { value: input.mint ?? null, isWritable: true }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [getAccountMeta(accounts.mint)],
    programAddress,
    data: getInitializePausableConfigInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseInitializePausableConfigInstruction(instruction) {
  if (instruction.accounts.length < 1) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      mint: getNextAccount()
    },
    data: getInitializePausableConfigInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var INITIALIZE_PERMANENT_DELEGATE_DISCRIMINATOR = 35;
function getInitializePermanentDelegateDiscriminatorBytes() {
  return getU8Encoder().encode(INITIALIZE_PERMANENT_DELEGATE_DISCRIMINATOR);
}
function getInitializePermanentDelegateInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["delegate", getAddressEncoder()]
    ]),
    (value) => ({
      ...value,
      discriminator: INITIALIZE_PERMANENT_DELEGATE_DISCRIMINATOR
    })
  );
}
function getInitializePermanentDelegateInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["delegate", getAddressDecoder()]
  ]);
}
function getInitializePermanentDelegateInstructionDataCodec() {
  return combineCodec(
    getInitializePermanentDelegateInstructionDataEncoder(),
    getInitializePermanentDelegateInstructionDataDecoder()
  );
}
function getInitializePermanentDelegateInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    mint: { value: input.mint ?? null, isWritable: true }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [getAccountMeta(accounts.mint)],
    programAddress,
    data: getInitializePermanentDelegateInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseInitializePermanentDelegateInstruction(instruction) {
  if (instruction.accounts.length < 1) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      mint: getNextAccount()
    },
    data: getInitializePermanentDelegateInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var INITIALIZE_SCALED_UI_AMOUNT_MINT_DISCRIMINATOR = 43;
function getInitializeScaledUiAmountMintDiscriminatorBytes() {
  return getU8Encoder().encode(INITIALIZE_SCALED_UI_AMOUNT_MINT_DISCRIMINATOR);
}
var INITIALIZE_SCALED_UI_AMOUNT_MINT_SCALED_UI_AMOUNT_MINT_DISCRIMINATOR = 0;
function getInitializeScaledUiAmountMintScaledUiAmountMintDiscriminatorBytes() {
  return getU8Encoder().encode(
    INITIALIZE_SCALED_UI_AMOUNT_MINT_SCALED_UI_AMOUNT_MINT_DISCRIMINATOR
  );
}
function getInitializeScaledUiAmountMintInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["scaledUiAmountMintDiscriminator", getU8Encoder()],
      [
        "authority",
        getOptionEncoder(getAddressEncoder(), {
          prefix: null,
          noneValue: "zeroes"
        })
      ],
      ["multiplier", getF64Encoder()]
    ]),
    (value) => ({
      ...value,
      discriminator: INITIALIZE_SCALED_UI_AMOUNT_MINT_DISCRIMINATOR,
      scaledUiAmountMintDiscriminator: INITIALIZE_SCALED_UI_AMOUNT_MINT_SCALED_UI_AMOUNT_MINT_DISCRIMINATOR
    })
  );
}
function getInitializeScaledUiAmountMintInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["scaledUiAmountMintDiscriminator", getU8Decoder()],
    [
      "authority",
      getOptionDecoder(getAddressDecoder(), {
        prefix: null,
        noneValue: "zeroes"
      })
    ],
    ["multiplier", getF64Decoder()]
  ]);
}
function getInitializeScaledUiAmountMintInstructionDataCodec() {
  return combineCodec(
    getInitializeScaledUiAmountMintInstructionDataEncoder(),
    getInitializeScaledUiAmountMintInstructionDataDecoder()
  );
}
function getInitializeScaledUiAmountMintInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    mint: { value: input.mint ?? null, isWritable: true }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [getAccountMeta(accounts.mint)],
    programAddress,
    data: getInitializeScaledUiAmountMintInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseInitializeScaledUiAmountMintInstruction(instruction) {
  if (instruction.accounts.length < 1) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      mint: getNextAccount()
    },
    data: getInitializeScaledUiAmountMintInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var INITIALIZE_TOKEN_GROUP_DISCRIMINATOR = new Uint8Array([
  121,
  113,
  108,
  39,
  54,
  51,
  0,
  4
]);
function getInitializeTokenGroupDiscriminatorBytes() {
  return getBytesEncoder().encode(INITIALIZE_TOKEN_GROUP_DISCRIMINATOR);
}
function getInitializeTokenGroupInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getBytesEncoder()],
      [
        "updateAuthority",
        getOptionEncoder(getAddressEncoder(), {
          prefix: null,
          noneValue: "zeroes"
        })
      ],
      ["maxSize", getU64Encoder()]
    ]),
    (value) => ({
      ...value,
      discriminator: INITIALIZE_TOKEN_GROUP_DISCRIMINATOR
    })
  );
}
function getInitializeTokenGroupInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getBytesDecoder()],
    [
      "updateAuthority",
      getOptionDecoder(getAddressDecoder(), {
        prefix: null,
        noneValue: "zeroes"
      })
    ],
    ["maxSize", getU64Decoder()]
  ]);
}
function getInitializeTokenGroupInstructionDataCodec() {
  return combineCodec(
    getInitializeTokenGroupInstructionDataEncoder(),
    getInitializeTokenGroupInstructionDataDecoder()
  );
}
function getInitializeTokenGroupInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    group: { value: input.group ?? null, isWritable: true },
    mint: { value: input.mint ?? null, isWritable: false },
    mintAuthority: { value: input.mintAuthority ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.group),
      getAccountMeta(accounts.mint),
      getAccountMeta(accounts.mintAuthority)
    ],
    programAddress,
    data: getInitializeTokenGroupInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseInitializeTokenGroupInstruction(instruction) {
  if (instruction.accounts.length < 3) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      group: getNextAccount(),
      mint: getNextAccount(),
      mintAuthority: getNextAccount()
    },
    data: getInitializeTokenGroupInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var INITIALIZE_TOKEN_GROUP_MEMBER_DISCRIMINATOR = new Uint8Array([
  152,
  32,
  222,
  176,
  223,
  237,
  116,
  134
]);
function getInitializeTokenGroupMemberDiscriminatorBytes() {
  return getBytesEncoder().encode(INITIALIZE_TOKEN_GROUP_MEMBER_DISCRIMINATOR);
}
function getInitializeTokenGroupMemberInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([["discriminator", getBytesEncoder()]]),
    (value) => ({
      ...value,
      discriminator: INITIALIZE_TOKEN_GROUP_MEMBER_DISCRIMINATOR
    })
  );
}
function getInitializeTokenGroupMemberInstructionDataDecoder() {
  return getStructDecoder([["discriminator", getBytesDecoder()]]);
}
function getInitializeTokenGroupMemberInstructionDataCodec() {
  return combineCodec(
    getInitializeTokenGroupMemberInstructionDataEncoder(),
    getInitializeTokenGroupMemberInstructionDataDecoder()
  );
}
function getInitializeTokenGroupMemberInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    member: { value: input.member ?? null, isWritable: true },
    memberMint: { value: input.memberMint ?? null, isWritable: false },
    memberMintAuthority: {
      value: input.memberMintAuthority ?? null,
      isWritable: false
    },
    group: { value: input.group ?? null, isWritable: true },
    groupUpdateAuthority: {
      value: input.groupUpdateAuthority ?? null,
      isWritable: false
    }
  };
  const accounts = originalAccounts;
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.member),
      getAccountMeta(accounts.memberMint),
      getAccountMeta(accounts.memberMintAuthority),
      getAccountMeta(accounts.group),
      getAccountMeta(accounts.groupUpdateAuthority)
    ],
    programAddress,
    data: getInitializeTokenGroupMemberInstructionDataEncoder().encode({})
  };
  return instruction;
}
function parseInitializeTokenGroupMemberInstruction(instruction) {
  if (instruction.accounts.length < 5) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      member: getNextAccount(),
      memberMint: getNextAccount(),
      memberMintAuthority: getNextAccount(),
      group: getNextAccount(),
      groupUpdateAuthority: getNextAccount()
    },
    data: getInitializeTokenGroupMemberInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var INITIALIZE_TOKEN_METADATA_DISCRIMINATOR = new Uint8Array([
  210,
  225,
  30,
  162,
  88,
  184,
  77,
  141
]);
function getInitializeTokenMetadataDiscriminatorBytes() {
  return getBytesEncoder().encode(INITIALIZE_TOKEN_METADATA_DISCRIMINATOR);
}
function getInitializeTokenMetadataInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getBytesEncoder()],
      ["name", addEncoderSizePrefix(getUtf8Encoder(), getU32Encoder())],
      ["symbol", addEncoderSizePrefix(getUtf8Encoder(), getU32Encoder())],
      ["uri", addEncoderSizePrefix(getUtf8Encoder(), getU32Encoder())]
    ]),
    (value) => ({
      ...value,
      discriminator: INITIALIZE_TOKEN_METADATA_DISCRIMINATOR
    })
  );
}
function getInitializeTokenMetadataInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getBytesDecoder()],
    ["name", addDecoderSizePrefix(getUtf8Decoder(), getU32Decoder())],
    ["symbol", addDecoderSizePrefix(getUtf8Decoder(), getU32Decoder())],
    ["uri", addDecoderSizePrefix(getUtf8Decoder(), getU32Decoder())]
  ]);
}
function getInitializeTokenMetadataInstructionDataCodec() {
  return combineCodec(
    getInitializeTokenMetadataInstructionDataEncoder(),
    getInitializeTokenMetadataInstructionDataDecoder()
  );
}
function getInitializeTokenMetadataInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    metadata: { value: input.metadata ?? null, isWritable: true },
    updateAuthority: {
      value: input.updateAuthority ?? null,
      isWritable: false
    },
    mint: { value: input.mint ?? null, isWritable: false },
    mintAuthority: { value: input.mintAuthority ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.metadata),
      getAccountMeta(accounts.updateAuthority),
      getAccountMeta(accounts.mint),
      getAccountMeta(accounts.mintAuthority)
    ],
    programAddress,
    data: getInitializeTokenMetadataInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseInitializeTokenMetadataInstruction(instruction) {
  if (instruction.accounts.length < 4) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      metadata: getNextAccount(),
      updateAuthority: getNextAccount(),
      mint: getNextAccount(),
      mintAuthority: getNextAccount()
    },
    data: getInitializeTokenMetadataInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var INITIALIZE_TRANSFER_FEE_CONFIG_DISCRIMINATOR = 26;
function getInitializeTransferFeeConfigDiscriminatorBytes() {
  return getU8Encoder().encode(INITIALIZE_TRANSFER_FEE_CONFIG_DISCRIMINATOR);
}
var INITIALIZE_TRANSFER_FEE_CONFIG_TRANSFER_FEE_DISCRIMINATOR = 0;
function getInitializeTransferFeeConfigTransferFeeDiscriminatorBytes() {
  return getU8Encoder().encode(
    INITIALIZE_TRANSFER_FEE_CONFIG_TRANSFER_FEE_DISCRIMINATOR
  );
}
function getInitializeTransferFeeConfigInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["transferFeeDiscriminator", getU8Encoder()],
      ["transferFeeConfigAuthority", getOptionEncoder(getAddressEncoder())],
      ["withdrawWithheldAuthority", getOptionEncoder(getAddressEncoder())],
      ["transferFeeBasisPoints", getU16Encoder()],
      ["maximumFee", getU64Encoder()]
    ]),
    (value) => ({
      ...value,
      discriminator: INITIALIZE_TRANSFER_FEE_CONFIG_DISCRIMINATOR,
      transferFeeDiscriminator: INITIALIZE_TRANSFER_FEE_CONFIG_TRANSFER_FEE_DISCRIMINATOR
    })
  );
}
function getInitializeTransferFeeConfigInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["transferFeeDiscriminator", getU8Decoder()],
    ["transferFeeConfigAuthority", getOptionDecoder(getAddressDecoder())],
    ["withdrawWithheldAuthority", getOptionDecoder(getAddressDecoder())],
    ["transferFeeBasisPoints", getU16Decoder()],
    ["maximumFee", getU64Decoder()]
  ]);
}
function getInitializeTransferFeeConfigInstructionDataCodec() {
  return combineCodec(
    getInitializeTransferFeeConfigInstructionDataEncoder(),
    getInitializeTransferFeeConfigInstructionDataDecoder()
  );
}
function getInitializeTransferFeeConfigInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    mint: { value: input.mint ?? null, isWritable: true }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [getAccountMeta(accounts.mint)],
    programAddress,
    data: getInitializeTransferFeeConfigInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseInitializeTransferFeeConfigInstruction(instruction) {
  if (instruction.accounts.length < 1) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      mint: getNextAccount()
    },
    data: getInitializeTransferFeeConfigInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var INITIALIZE_TRANSFER_HOOK_DISCRIMINATOR = 36;
function getInitializeTransferHookDiscriminatorBytes() {
  return getU8Encoder().encode(INITIALIZE_TRANSFER_HOOK_DISCRIMINATOR);
}
var INITIALIZE_TRANSFER_HOOK_TRANSFER_HOOK_DISCRIMINATOR = 0;
function getInitializeTransferHookTransferHookDiscriminatorBytes() {
  return getU8Encoder().encode(
    INITIALIZE_TRANSFER_HOOK_TRANSFER_HOOK_DISCRIMINATOR
  );
}
function getInitializeTransferHookInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["transferHookDiscriminator", getU8Encoder()],
      [
        "authority",
        getOptionEncoder(getAddressEncoder(), {
          prefix: null,
          noneValue: "zeroes"
        })
      ],
      [
        "programId",
        getOptionEncoder(getAddressEncoder(), {
          prefix: null,
          noneValue: "zeroes"
        })
      ]
    ]),
    (value) => ({
      ...value,
      discriminator: INITIALIZE_TRANSFER_HOOK_DISCRIMINATOR,
      transferHookDiscriminator: INITIALIZE_TRANSFER_HOOK_TRANSFER_HOOK_DISCRIMINATOR
    })
  );
}
function getInitializeTransferHookInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["transferHookDiscriminator", getU8Decoder()],
    [
      "authority",
      getOptionDecoder(getAddressDecoder(), {
        prefix: null,
        noneValue: "zeroes"
      })
    ],
    [
      "programId",
      getOptionDecoder(getAddressDecoder(), {
        prefix: null,
        noneValue: "zeroes"
      })
    ]
  ]);
}
function getInitializeTransferHookInstructionDataCodec() {
  return combineCodec(
    getInitializeTransferHookInstructionDataEncoder(),
    getInitializeTransferHookInstructionDataDecoder()
  );
}
function getInitializeTransferHookInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    mint: { value: input.mint ?? null, isWritable: true }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [getAccountMeta(accounts.mint)],
    programAddress,
    data: getInitializeTransferHookInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseInitializeTransferHookInstruction(instruction) {
  if (instruction.accounts.length < 1) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      mint: getNextAccount()
    },
    data: getInitializeTransferHookInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var MINT_TO_DISCRIMINATOR = 7;
function getMintToDiscriminatorBytes() {
  return getU8Encoder().encode(MINT_TO_DISCRIMINATOR);
}
function getMintToInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["amount", getU64Encoder()]
    ]),
    (value) => ({ ...value, discriminator: MINT_TO_DISCRIMINATOR })
  );
}
function getMintToInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["amount", getU64Decoder()]
  ]);
}
function getMintToInstructionDataCodec() {
  return combineCodec(
    getMintToInstructionDataEncoder(),
    getMintToInstructionDataDecoder()
  );
}
function getMintToInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    mint: { value: input.mint ?? null, isWritable: true },
    token: { value: input.token ?? null, isWritable: true },
    mintAuthority: { value: input.mintAuthority ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.mint),
      getAccountMeta(accounts.token),
      getAccountMeta(accounts.mintAuthority),
      ...remainingAccounts
    ],
    programAddress,
    data: getMintToInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseMintToInstruction(instruction) {
  if (instruction.accounts.length < 3) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      mint: getNextAccount(),
      token: getNextAccount(),
      mintAuthority: getNextAccount()
    },
    data: getMintToInstructionDataDecoder().decode(instruction.data)
  };
}
var MINT_TO_CHECKED_DISCRIMINATOR = 14;
function getMintToCheckedDiscriminatorBytes() {
  return getU8Encoder().encode(MINT_TO_CHECKED_DISCRIMINATOR);
}
function getMintToCheckedInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["amount", getU64Encoder()],
      ["decimals", getU8Encoder()]
    ]),
    (value) => ({ ...value, discriminator: MINT_TO_CHECKED_DISCRIMINATOR })
  );
}
function getMintToCheckedInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["amount", getU64Decoder()],
    ["decimals", getU8Decoder()]
  ]);
}
function getMintToCheckedInstructionDataCodec() {
  return combineCodec(
    getMintToCheckedInstructionDataEncoder(),
    getMintToCheckedInstructionDataDecoder()
  );
}
function getMintToCheckedInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    mint: { value: input.mint ?? null, isWritable: true },
    token: { value: input.token ?? null, isWritable: true },
    mintAuthority: { value: input.mintAuthority ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.mint),
      getAccountMeta(accounts.token),
      getAccountMeta(accounts.mintAuthority),
      ...remainingAccounts
    ],
    programAddress,
    data: getMintToCheckedInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseMintToCheckedInstruction(instruction) {
  if (instruction.accounts.length < 3) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      mint: getNextAccount(),
      token: getNextAccount(),
      mintAuthority: getNextAccount()
    },
    data: getMintToCheckedInstructionDataDecoder().decode(instruction.data)
  };
}
var PAUSE_DISCRIMINATOR = 44;
function getPauseDiscriminatorBytes() {
  return getU8Encoder().encode(PAUSE_DISCRIMINATOR);
}
var PAUSE_PAUSABLE_DISCRIMINATOR = 1;
function getPausePausableDiscriminatorBytes() {
  return getU8Encoder().encode(PAUSE_PAUSABLE_DISCRIMINATOR);
}
function getPauseInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["pausableDiscriminator", getU8Encoder()]
    ]),
    (value) => ({
      ...value,
      discriminator: PAUSE_DISCRIMINATOR,
      pausableDiscriminator: PAUSE_PAUSABLE_DISCRIMINATOR
    })
  );
}
function getPauseInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["pausableDiscriminator", getU8Decoder()]
  ]);
}
function getPauseInstructionDataCodec() {
  return combineCodec(
    getPauseInstructionDataEncoder(),
    getPauseInstructionDataDecoder()
  );
}
function getPauseInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    mint: { value: input.mint ?? null, isWritable: true },
    authority: { value: input.authority ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.mint),
      getAccountMeta(accounts.authority)
    ],
    programAddress,
    data: getPauseInstructionDataEncoder().encode({})
  };
  return instruction;
}
function parsePauseInstruction(instruction) {
  if (instruction.accounts.length < 2) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      mint: getNextAccount(),
      authority: getNextAccount()
    },
    data: getPauseInstructionDataDecoder().decode(instruction.data)
  };
}
var REALLOCATE_DISCRIMINATOR = 29;
function getReallocateDiscriminatorBytes() {
  return getU8Encoder().encode(REALLOCATE_DISCRIMINATOR);
}
function getReallocateInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      [
        "newExtensionTypes",
        getArrayEncoder(getExtensionTypeEncoder(), { size: "remainder" })
      ]
    ]),
    (value) => ({ ...value, discriminator: REALLOCATE_DISCRIMINATOR })
  );
}
function getReallocateInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    [
      "newExtensionTypes",
      getArrayDecoder(getExtensionTypeDecoder(), { size: "remainder" })
    ]
  ]);
}
function getReallocateInstructionDataCodec() {
  return combineCodec(
    getReallocateInstructionDataEncoder(),
    getReallocateInstructionDataDecoder()
  );
}
function getReallocateInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    token: { value: input.token ?? null, isWritable: true },
    payer: { value: input.payer ?? null, isWritable: true },
    systemProgram: { value: input.systemProgram ?? null, isWritable: false },
    owner: { value: input.owner ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  if (!accounts.systemProgram.value) {
    accounts.systemProgram.value = "11111111111111111111111111111111";
  }
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.token),
      getAccountMeta(accounts.payer),
      getAccountMeta(accounts.systemProgram),
      getAccountMeta(accounts.owner),
      ...remainingAccounts
    ],
    programAddress,
    data: getReallocateInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseReallocateInstruction(instruction) {
  if (instruction.accounts.length < 4) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      token: getNextAccount(),
      payer: getNextAccount(),
      systemProgram: getNextAccount(),
      owner: getNextAccount()
    },
    data: getReallocateInstructionDataDecoder().decode(instruction.data)
  };
}
var RECOVER_NESTED_ASSOCIATED_TOKEN_DISCRIMINATOR = 2;
function getRecoverNestedAssociatedTokenDiscriminatorBytes() {
  return getU8Encoder().encode(RECOVER_NESTED_ASSOCIATED_TOKEN_DISCRIMINATOR);
}
function getRecoverNestedAssociatedTokenInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([["discriminator", getU8Encoder()]]),
    (value) => ({
      ...value,
      discriminator: RECOVER_NESTED_ASSOCIATED_TOKEN_DISCRIMINATOR
    })
  );
}
function getRecoverNestedAssociatedTokenInstructionDataDecoder() {
  return getStructDecoder([["discriminator", getU8Decoder()]]);
}
function getRecoverNestedAssociatedTokenInstructionDataCodec() {
  return combineCodec(
    getRecoverNestedAssociatedTokenInstructionDataEncoder(),
    getRecoverNestedAssociatedTokenInstructionDataDecoder()
  );
}
async function getRecoverNestedAssociatedTokenInstructionAsync(input, config) {
  const programAddress = config?.programAddress ?? ASSOCIATED_TOKEN_PROGRAM_ADDRESS;
  const originalAccounts = {
    nestedAssociatedAccountAddress: {
      value: input.nestedAssociatedAccountAddress ?? null,
      isWritable: true
    },
    nestedTokenMintAddress: {
      value: input.nestedTokenMintAddress ?? null,
      isWritable: false
    },
    destinationAssociatedAccountAddress: {
      value: input.destinationAssociatedAccountAddress ?? null,
      isWritable: true
    },
    ownerAssociatedAccountAddress: {
      value: input.ownerAssociatedAccountAddress ?? null,
      isWritable: false
    },
    ownerTokenMintAddress: {
      value: input.ownerTokenMintAddress ?? null,
      isWritable: false
    },
    walletAddress: { value: input.walletAddress ?? null, isWritable: true },
    tokenProgram: { value: input.tokenProgram ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  if (!accounts.tokenProgram.value) {
    accounts.tokenProgram.value = "TokenzQdBNbLqP5VEhdkAS6EPFLC1PHnBqCXEpPxuEb";
  }
  if (!accounts.ownerAssociatedAccountAddress.value) {
    accounts.ownerAssociatedAccountAddress.value = await findAssociatedTokenPda(
      {
        owner: expectAddress(accounts.walletAddress.value),
        tokenProgram: expectAddress(accounts.tokenProgram.value),
        mint: expectAddress(accounts.ownerTokenMintAddress.value)
      }
    );
  }
  if (!accounts.nestedAssociatedAccountAddress.value) {
    accounts.nestedAssociatedAccountAddress.value = await findAssociatedTokenPda({
      owner: expectAddress(accounts.ownerAssociatedAccountAddress.value),
      tokenProgram: expectAddress(accounts.tokenProgram.value),
      mint: expectAddress(accounts.nestedTokenMintAddress.value)
    });
  }
  if (!accounts.destinationAssociatedAccountAddress.value) {
    accounts.destinationAssociatedAccountAddress.value = await findAssociatedTokenPda({
      owner: expectAddress(accounts.walletAddress.value),
      tokenProgram: expectAddress(accounts.tokenProgram.value),
      mint: expectAddress(accounts.nestedTokenMintAddress.value)
    });
  }
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.nestedAssociatedAccountAddress),
      getAccountMeta(accounts.nestedTokenMintAddress),
      getAccountMeta(accounts.destinationAssociatedAccountAddress),
      getAccountMeta(accounts.ownerAssociatedAccountAddress),
      getAccountMeta(accounts.ownerTokenMintAddress),
      getAccountMeta(accounts.walletAddress),
      getAccountMeta(accounts.tokenProgram)
    ],
    programAddress,
    data: getRecoverNestedAssociatedTokenInstructionDataEncoder().encode({})
  };
  return instruction;
}
function getRecoverNestedAssociatedTokenInstruction(input, config) {
  const programAddress = config?.programAddress ?? ASSOCIATED_TOKEN_PROGRAM_ADDRESS;
  const originalAccounts = {
    nestedAssociatedAccountAddress: {
      value: input.nestedAssociatedAccountAddress ?? null,
      isWritable: true
    },
    nestedTokenMintAddress: {
      value: input.nestedTokenMintAddress ?? null,
      isWritable: false
    },
    destinationAssociatedAccountAddress: {
      value: input.destinationAssociatedAccountAddress ?? null,
      isWritable: true
    },
    ownerAssociatedAccountAddress: {
      value: input.ownerAssociatedAccountAddress ?? null,
      isWritable: false
    },
    ownerTokenMintAddress: {
      value: input.ownerTokenMintAddress ?? null,
      isWritable: false
    },
    walletAddress: { value: input.walletAddress ?? null, isWritable: true },
    tokenProgram: { value: input.tokenProgram ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  if (!accounts.tokenProgram.value) {
    accounts.tokenProgram.value = "TokenzQdBNbLqP5VEhdkAS6EPFLC1PHnBqCXEpPxuEb";
  }
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.nestedAssociatedAccountAddress),
      getAccountMeta(accounts.nestedTokenMintAddress),
      getAccountMeta(accounts.destinationAssociatedAccountAddress),
      getAccountMeta(accounts.ownerAssociatedAccountAddress),
      getAccountMeta(accounts.ownerTokenMintAddress),
      getAccountMeta(accounts.walletAddress),
      getAccountMeta(accounts.tokenProgram)
    ],
    programAddress,
    data: getRecoverNestedAssociatedTokenInstructionDataEncoder().encode({})
  };
  return instruction;
}
function parseRecoverNestedAssociatedTokenInstruction(instruction) {
  if (instruction.accounts.length < 7) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      nestedAssociatedAccountAddress: getNextAccount(),
      nestedTokenMintAddress: getNextAccount(),
      destinationAssociatedAccountAddress: getNextAccount(),
      ownerAssociatedAccountAddress: getNextAccount(),
      ownerTokenMintAddress: getNextAccount(),
      walletAddress: getNextAccount(),
      tokenProgram: getNextAccount()
    },
    data: getRecoverNestedAssociatedTokenInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var REMOVE_TOKEN_METADATA_KEY_DISCRIMINATOR = new Uint8Array([
  234,
  18,
  32,
  56,
  89,
  141,
  37,
  181
]);
function getRemoveTokenMetadataKeyDiscriminatorBytes() {
  return getBytesEncoder().encode(REMOVE_TOKEN_METADATA_KEY_DISCRIMINATOR);
}
function getRemoveTokenMetadataKeyInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getBytesEncoder()],
      ["idempotent", getBooleanEncoder()],
      ["key", addEncoderSizePrefix(getUtf8Encoder(), getU32Encoder())]
    ]),
    (value) => ({
      ...value,
      discriminator: REMOVE_TOKEN_METADATA_KEY_DISCRIMINATOR,
      idempotent: value.idempotent ?? false
    })
  );
}
function getRemoveTokenMetadataKeyInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getBytesDecoder()],
    ["idempotent", getBooleanDecoder()],
    ["key", addDecoderSizePrefix(getUtf8Decoder(), getU32Decoder())]
  ]);
}
function getRemoveTokenMetadataKeyInstructionDataCodec() {
  return combineCodec(
    getRemoveTokenMetadataKeyInstructionDataEncoder(),
    getRemoveTokenMetadataKeyInstructionDataDecoder()
  );
}
function getRemoveTokenMetadataKeyInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    metadata: { value: input.metadata ?? null, isWritable: true },
    updateAuthority: {
      value: input.updateAuthority ?? null,
      isWritable: false
    }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.metadata),
      getAccountMeta(accounts.updateAuthority)
    ],
    programAddress,
    data: getRemoveTokenMetadataKeyInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseRemoveTokenMetadataKeyInstruction(instruction) {
  if (instruction.accounts.length < 2) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      metadata: getNextAccount(),
      updateAuthority: getNextAccount()
    },
    data: getRemoveTokenMetadataKeyInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var RESUME_DISCRIMINATOR = 44;
function getResumeDiscriminatorBytes() {
  return getU8Encoder().encode(RESUME_DISCRIMINATOR);
}
var RESUME_PAUSABLE_DISCRIMINATOR = 2;
function getResumePausableDiscriminatorBytes() {
  return getU8Encoder().encode(RESUME_PAUSABLE_DISCRIMINATOR);
}
function getResumeInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["pausableDiscriminator", getU8Encoder()]
    ]),
    (value) => ({
      ...value,
      discriminator: RESUME_DISCRIMINATOR,
      pausableDiscriminator: RESUME_PAUSABLE_DISCRIMINATOR
    })
  );
}
function getResumeInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["pausableDiscriminator", getU8Decoder()]
  ]);
}
function getResumeInstructionDataCodec() {
  return combineCodec(
    getResumeInstructionDataEncoder(),
    getResumeInstructionDataDecoder()
  );
}
function getResumeInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    mint: { value: input.mint ?? null, isWritable: true },
    authority: { value: input.authority ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.mint),
      getAccountMeta(accounts.authority)
    ],
    programAddress,
    data: getResumeInstructionDataEncoder().encode({})
  };
  return instruction;
}
function parseResumeInstruction(instruction) {
  if (instruction.accounts.length < 2) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      mint: getNextAccount(),
      authority: getNextAccount()
    },
    data: getResumeInstructionDataDecoder().decode(instruction.data)
  };
}
var REVOKE_DISCRIMINATOR = 5;
function getRevokeDiscriminatorBytes() {
  return getU8Encoder().encode(REVOKE_DISCRIMINATOR);
}
function getRevokeInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([["discriminator", getU8Encoder()]]),
    (value) => ({ ...value, discriminator: REVOKE_DISCRIMINATOR })
  );
}
function getRevokeInstructionDataDecoder() {
  return getStructDecoder([["discriminator", getU8Decoder()]]);
}
function getRevokeInstructionDataCodec() {
  return combineCodec(
    getRevokeInstructionDataEncoder(),
    getRevokeInstructionDataDecoder()
  );
}
function getRevokeInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    source: { value: input.source ?? null, isWritable: true },
    owner: { value: input.owner ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.source),
      getAccountMeta(accounts.owner),
      ...remainingAccounts
    ],
    programAddress,
    data: getRevokeInstructionDataEncoder().encode({})
  };
  return instruction;
}
function parseRevokeInstruction(instruction) {
  if (instruction.accounts.length < 2) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      source: getNextAccount(),
      owner: getNextAccount()
    },
    data: getRevokeInstructionDataDecoder().decode(instruction.data)
  };
}
var SET_AUTHORITY_DISCRIMINATOR = 6;
function getSetAuthorityDiscriminatorBytes() {
  return getU8Encoder().encode(SET_AUTHORITY_DISCRIMINATOR);
}
function getSetAuthorityInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["authorityType", getAuthorityTypeEncoder()],
      ["newAuthority", getOptionEncoder(getAddressEncoder())]
    ]),
    (value) => ({ ...value, discriminator: SET_AUTHORITY_DISCRIMINATOR })
  );
}
function getSetAuthorityInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["authorityType", getAuthorityTypeDecoder()],
    ["newAuthority", getOptionDecoder(getAddressDecoder())]
  ]);
}
function getSetAuthorityInstructionDataCodec() {
  return combineCodec(
    getSetAuthorityInstructionDataEncoder(),
    getSetAuthorityInstructionDataDecoder()
  );
}
function getSetAuthorityInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    owned: { value: input.owned ?? null, isWritable: true },
    owner: { value: input.owner ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.owned),
      getAccountMeta(accounts.owner),
      ...remainingAccounts
    ],
    programAddress,
    data: getSetAuthorityInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseSetAuthorityInstruction(instruction) {
  if (instruction.accounts.length < 2) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      owned: getNextAccount(),
      owner: getNextAccount()
    },
    data: getSetAuthorityInstructionDataDecoder().decode(instruction.data)
  };
}
var SET_TRANSFER_FEE_DISCRIMINATOR = 26;
function getSetTransferFeeDiscriminatorBytes() {
  return getU8Encoder().encode(SET_TRANSFER_FEE_DISCRIMINATOR);
}
var SET_TRANSFER_FEE_TRANSFER_FEE_DISCRIMINATOR = 5;
function getSetTransferFeeTransferFeeDiscriminatorBytes() {
  return getU8Encoder().encode(SET_TRANSFER_FEE_TRANSFER_FEE_DISCRIMINATOR);
}
function getSetTransferFeeInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["transferFeeDiscriminator", getU8Encoder()],
      ["transferFeeBasisPoints", getU16Encoder()],
      ["maximumFee", getU64Encoder()]
    ]),
    (value) => ({
      ...value,
      discriminator: SET_TRANSFER_FEE_DISCRIMINATOR,
      transferFeeDiscriminator: SET_TRANSFER_FEE_TRANSFER_FEE_DISCRIMINATOR
    })
  );
}
function getSetTransferFeeInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["transferFeeDiscriminator", getU8Decoder()],
    ["transferFeeBasisPoints", getU16Decoder()],
    ["maximumFee", getU64Decoder()]
  ]);
}
function getSetTransferFeeInstructionDataCodec() {
  return combineCodec(
    getSetTransferFeeInstructionDataEncoder(),
    getSetTransferFeeInstructionDataDecoder()
  );
}
function getSetTransferFeeInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    mint: { value: input.mint ?? null, isWritable: true },
    transferFeeConfigAuthority: {
      value: input.transferFeeConfigAuthority ?? null,
      isWritable: false
    }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.mint),
      getAccountMeta(accounts.transferFeeConfigAuthority),
      ...remainingAccounts
    ],
    programAddress,
    data: getSetTransferFeeInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseSetTransferFeeInstruction(instruction) {
  if (instruction.accounts.length < 2) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      mint: getNextAccount(),
      transferFeeConfigAuthority: getNextAccount()
    },
    data: getSetTransferFeeInstructionDataDecoder().decode(instruction.data)
  };
}
var SYNC_NATIVE_DISCRIMINATOR = 17;
function getSyncNativeDiscriminatorBytes() {
  return getU8Encoder().encode(SYNC_NATIVE_DISCRIMINATOR);
}
function getSyncNativeInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([["discriminator", getU8Encoder()]]),
    (value) => ({ ...value, discriminator: SYNC_NATIVE_DISCRIMINATOR })
  );
}
function getSyncNativeInstructionDataDecoder() {
  return getStructDecoder([["discriminator", getU8Decoder()]]);
}
function getSyncNativeInstructionDataCodec() {
  return combineCodec(
    getSyncNativeInstructionDataEncoder(),
    getSyncNativeInstructionDataDecoder()
  );
}
function getSyncNativeInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    account: { value: input.account ?? null, isWritable: true }
  };
  const accounts = originalAccounts;
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [getAccountMeta(accounts.account)],
    programAddress,
    data: getSyncNativeInstructionDataEncoder().encode({})
  };
  return instruction;
}
function parseSyncNativeInstruction(instruction) {
  if (instruction.accounts.length < 1) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      account: getNextAccount()
    },
    data: getSyncNativeInstructionDataDecoder().decode(instruction.data)
  };
}
var THAW_ACCOUNT_DISCRIMINATOR = 11;
function getThawAccountDiscriminatorBytes() {
  return getU8Encoder().encode(THAW_ACCOUNT_DISCRIMINATOR);
}
function getThawAccountInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([["discriminator", getU8Encoder()]]),
    (value) => ({ ...value, discriminator: THAW_ACCOUNT_DISCRIMINATOR })
  );
}
function getThawAccountInstructionDataDecoder() {
  return getStructDecoder([["discriminator", getU8Decoder()]]);
}
function getThawAccountInstructionDataCodec() {
  return combineCodec(
    getThawAccountInstructionDataEncoder(),
    getThawAccountInstructionDataDecoder()
  );
}
function getThawAccountInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    account: { value: input.account ?? null, isWritable: true },
    mint: { value: input.mint ?? null, isWritable: false },
    owner: { value: input.owner ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.account),
      getAccountMeta(accounts.mint),
      getAccountMeta(accounts.owner),
      ...remainingAccounts
    ],
    programAddress,
    data: getThawAccountInstructionDataEncoder().encode({})
  };
  return instruction;
}
function parseThawAccountInstruction(instruction) {
  if (instruction.accounts.length < 3) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      account: getNextAccount(),
      mint: getNextAccount(),
      owner: getNextAccount()
    },
    data: getThawAccountInstructionDataDecoder().decode(instruction.data)
  };
}
var TRANSFER_DISCRIMINATOR = 3;
function getTransferDiscriminatorBytes() {
  return getU8Encoder().encode(TRANSFER_DISCRIMINATOR);
}
function getTransferInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["amount", getU64Encoder()]
    ]),
    (value) => ({ ...value, discriminator: TRANSFER_DISCRIMINATOR })
  );
}
function getTransferInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["amount", getU64Decoder()]
  ]);
}
function getTransferInstructionDataCodec() {
  return combineCodec(
    getTransferInstructionDataEncoder(),
    getTransferInstructionDataDecoder()
  );
}
function getTransferInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    source: { value: input.source ?? null, isWritable: true },
    destination: { value: input.destination ?? null, isWritable: true },
    authority: { value: input.authority ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.source),
      getAccountMeta(accounts.destination),
      getAccountMeta(accounts.authority),
      ...remainingAccounts
    ],
    programAddress,
    data: getTransferInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseTransferInstruction(instruction) {
  if (instruction.accounts.length < 3) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      source: getNextAccount(),
      destination: getNextAccount(),
      authority: getNextAccount()
    },
    data: getTransferInstructionDataDecoder().decode(instruction.data)
  };
}
var TRANSFER_CHECKED_DISCRIMINATOR = 12;
function getTransferCheckedDiscriminatorBytes() {
  return getU8Encoder().encode(TRANSFER_CHECKED_DISCRIMINATOR);
}
function getTransferCheckedInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["amount", getU64Encoder()],
      ["decimals", getU8Encoder()]
    ]),
    (value) => ({ ...value, discriminator: TRANSFER_CHECKED_DISCRIMINATOR })
  );
}
function getTransferCheckedInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["amount", getU64Decoder()],
    ["decimals", getU8Decoder()]
  ]);
}
function getTransferCheckedInstructionDataCodec() {
  return combineCodec(
    getTransferCheckedInstructionDataEncoder(),
    getTransferCheckedInstructionDataDecoder()
  );
}
function getTransferCheckedInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    source: { value: input.source ?? null, isWritable: true },
    mint: { value: input.mint ?? null, isWritable: false },
    destination: { value: input.destination ?? null, isWritable: true },
    authority: { value: input.authority ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.source),
      getAccountMeta(accounts.mint),
      getAccountMeta(accounts.destination),
      getAccountMeta(accounts.authority),
      ...remainingAccounts
    ],
    programAddress,
    data: getTransferCheckedInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseTransferCheckedInstruction(instruction) {
  if (instruction.accounts.length < 4) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      source: getNextAccount(),
      mint: getNextAccount(),
      destination: getNextAccount(),
      authority: getNextAccount()
    },
    data: getTransferCheckedInstructionDataDecoder().decode(instruction.data)
  };
}
var TRANSFER_CHECKED_WITH_FEE_DISCRIMINATOR = 26;
function getTransferCheckedWithFeeDiscriminatorBytes() {
  return getU8Encoder().encode(TRANSFER_CHECKED_WITH_FEE_DISCRIMINATOR);
}
var TRANSFER_CHECKED_WITH_FEE_TRANSFER_FEE_DISCRIMINATOR = 1;
function getTransferCheckedWithFeeTransferFeeDiscriminatorBytes() {
  return getU8Encoder().encode(
    TRANSFER_CHECKED_WITH_FEE_TRANSFER_FEE_DISCRIMINATOR
  );
}
function getTransferCheckedWithFeeInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["transferFeeDiscriminator", getU8Encoder()],
      ["amount", getU64Encoder()],
      ["decimals", getU8Encoder()],
      ["fee", getU64Encoder()]
    ]),
    (value) => ({
      ...value,
      discriminator: TRANSFER_CHECKED_WITH_FEE_DISCRIMINATOR,
      transferFeeDiscriminator: TRANSFER_CHECKED_WITH_FEE_TRANSFER_FEE_DISCRIMINATOR
    })
  );
}
function getTransferCheckedWithFeeInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["transferFeeDiscriminator", getU8Decoder()],
    ["amount", getU64Decoder()],
    ["decimals", getU8Decoder()],
    ["fee", getU64Decoder()]
  ]);
}
function getTransferCheckedWithFeeInstructionDataCodec() {
  return combineCodec(
    getTransferCheckedWithFeeInstructionDataEncoder(),
    getTransferCheckedWithFeeInstructionDataDecoder()
  );
}
function getTransferCheckedWithFeeInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    source: { value: input.source ?? null, isWritable: true },
    mint: { value: input.mint ?? null, isWritable: false },
    destination: { value: input.destination ?? null, isWritable: true },
    authority: { value: input.authority ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.source),
      getAccountMeta(accounts.mint),
      getAccountMeta(accounts.destination),
      getAccountMeta(accounts.authority),
      ...remainingAccounts
    ],
    programAddress,
    data: getTransferCheckedWithFeeInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseTransferCheckedWithFeeInstruction(instruction) {
  if (instruction.accounts.length < 4) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      source: getNextAccount(),
      mint: getNextAccount(),
      destination: getNextAccount(),
      authority: getNextAccount()
    },
    data: getTransferCheckedWithFeeInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var UI_AMOUNT_TO_AMOUNT_DISCRIMINATOR = 24;
function getUiAmountToAmountDiscriminatorBytes() {
  return getU8Encoder().encode(UI_AMOUNT_TO_AMOUNT_DISCRIMINATOR);
}
function getUiAmountToAmountInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["uiAmount", getUtf8Encoder()]
    ]),
    (value) => ({ ...value, discriminator: UI_AMOUNT_TO_AMOUNT_DISCRIMINATOR })
  );
}
function getUiAmountToAmountInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["uiAmount", getUtf8Decoder()]
  ]);
}
function getUiAmountToAmountInstructionDataCodec() {
  return combineCodec(
    getUiAmountToAmountInstructionDataEncoder(),
    getUiAmountToAmountInstructionDataDecoder()
  );
}
function getUiAmountToAmountInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    mint: { value: input.mint ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [getAccountMeta(accounts.mint)],
    programAddress,
    data: getUiAmountToAmountInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseUiAmountToAmountInstruction(instruction) {
  if (instruction.accounts.length < 1) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      mint: getNextAccount()
    },
    data: getUiAmountToAmountInstructionDataDecoder().decode(instruction.data)
  };
}
var UPDATE_CONFIDENTIAL_TRANSFER_MINT_DISCRIMINATOR = 27;
function getUpdateConfidentialTransferMintDiscriminatorBytes() {
  return getU8Encoder().encode(UPDATE_CONFIDENTIAL_TRANSFER_MINT_DISCRIMINATOR);
}
var UPDATE_CONFIDENTIAL_TRANSFER_MINT_CONFIDENTIAL_TRANSFER_DISCRIMINATOR = 1;
function getUpdateConfidentialTransferMintConfidentialTransferDiscriminatorBytes() {
  return getU8Encoder().encode(
    UPDATE_CONFIDENTIAL_TRANSFER_MINT_CONFIDENTIAL_TRANSFER_DISCRIMINATOR
  );
}
function getUpdateConfidentialTransferMintInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["confidentialTransferDiscriminator", getU8Encoder()],
      ["autoApproveNewAccounts", getBooleanEncoder()],
      [
        "auditorElgamalPubkey",
        getOptionEncoder(getAddressEncoder(), {
          prefix: null,
          noneValue: "zeroes"
        })
      ]
    ]),
    (value) => ({
      ...value,
      discriminator: UPDATE_CONFIDENTIAL_TRANSFER_MINT_DISCRIMINATOR,
      confidentialTransferDiscriminator: UPDATE_CONFIDENTIAL_TRANSFER_MINT_CONFIDENTIAL_TRANSFER_DISCRIMINATOR
    })
  );
}
function getUpdateConfidentialTransferMintInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["confidentialTransferDiscriminator", getU8Decoder()],
    ["autoApproveNewAccounts", getBooleanDecoder()],
    [
      "auditorElgamalPubkey",
      getOptionDecoder(getAddressDecoder(), {
        prefix: null,
        noneValue: "zeroes"
      })
    ]
  ]);
}
function getUpdateConfidentialTransferMintInstructionDataCodec() {
  return combineCodec(
    getUpdateConfidentialTransferMintInstructionDataEncoder(),
    getUpdateConfidentialTransferMintInstructionDataDecoder()
  );
}
function getUpdateConfidentialTransferMintInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    mint: { value: input.mint ?? null, isWritable: true },
    authority: { value: input.authority ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.mint),
      getAccountMeta(accounts.authority)
    ],
    programAddress,
    data: getUpdateConfidentialTransferMintInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseUpdateConfidentialTransferMintInstruction(instruction) {
  if (instruction.accounts.length < 2) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      mint: getNextAccount(),
      authority: getNextAccount()
    },
    data: getUpdateConfidentialTransferMintInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var UPDATE_DEFAULT_ACCOUNT_STATE_DISCRIMINATOR = 28;
function getUpdateDefaultAccountStateDiscriminatorBytes() {
  return getU8Encoder().encode(UPDATE_DEFAULT_ACCOUNT_STATE_DISCRIMINATOR);
}
var UPDATE_DEFAULT_ACCOUNT_STATE_DEFAULT_ACCOUNT_STATE_DISCRIMINATOR = 1;
function getUpdateDefaultAccountStateDefaultAccountStateDiscriminatorBytes() {
  return getU8Encoder().encode(
    UPDATE_DEFAULT_ACCOUNT_STATE_DEFAULT_ACCOUNT_STATE_DISCRIMINATOR
  );
}
function getUpdateDefaultAccountStateInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["defaultAccountStateDiscriminator", getU8Encoder()],
      ["state", getAccountStateEncoder()]
    ]),
    (value) => ({
      ...value,
      discriminator: UPDATE_DEFAULT_ACCOUNT_STATE_DISCRIMINATOR,
      defaultAccountStateDiscriminator: UPDATE_DEFAULT_ACCOUNT_STATE_DEFAULT_ACCOUNT_STATE_DISCRIMINATOR
    })
  );
}
function getUpdateDefaultAccountStateInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["defaultAccountStateDiscriminator", getU8Decoder()],
    ["state", getAccountStateDecoder()]
  ]);
}
function getUpdateDefaultAccountStateInstructionDataCodec() {
  return combineCodec(
    getUpdateDefaultAccountStateInstructionDataEncoder(),
    getUpdateDefaultAccountStateInstructionDataDecoder()
  );
}
function getUpdateDefaultAccountStateInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    mint: { value: input.mint ?? null, isWritable: true },
    freezeAuthority: {
      value: input.freezeAuthority ?? null,
      isWritable: false
    }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.mint),
      getAccountMeta(accounts.freezeAuthority),
      ...remainingAccounts
    ],
    programAddress,
    data: getUpdateDefaultAccountStateInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseUpdateDefaultAccountStateInstruction(instruction) {
  if (instruction.accounts.length < 2) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      mint: getNextAccount(),
      freezeAuthority: getNextAccount()
    },
    data: getUpdateDefaultAccountStateInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var UPDATE_GROUP_MEMBER_POINTER_DISCRIMINATOR = 41;
function getUpdateGroupMemberPointerDiscriminatorBytes() {
  return getU8Encoder().encode(UPDATE_GROUP_MEMBER_POINTER_DISCRIMINATOR);
}
var UPDATE_GROUP_MEMBER_POINTER_GROUP_MEMBER_POINTER_DISCRIMINATOR = 1;
function getUpdateGroupMemberPointerGroupMemberPointerDiscriminatorBytes() {
  return getU8Encoder().encode(
    UPDATE_GROUP_MEMBER_POINTER_GROUP_MEMBER_POINTER_DISCRIMINATOR
  );
}
function getUpdateGroupMemberPointerInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["groupMemberPointerDiscriminator", getU8Encoder()],
      [
        "memberAddress",
        getOptionEncoder(getAddressEncoder(), {
          prefix: null,
          noneValue: "zeroes"
        })
      ]
    ]),
    (value) => ({
      ...value,
      discriminator: UPDATE_GROUP_MEMBER_POINTER_DISCRIMINATOR,
      groupMemberPointerDiscriminator: UPDATE_GROUP_MEMBER_POINTER_GROUP_MEMBER_POINTER_DISCRIMINATOR
    })
  );
}
function getUpdateGroupMemberPointerInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["groupMemberPointerDiscriminator", getU8Decoder()],
    [
      "memberAddress",
      getOptionDecoder(getAddressDecoder(), {
        prefix: null,
        noneValue: "zeroes"
      })
    ]
  ]);
}
function getUpdateGroupMemberPointerInstructionDataCodec() {
  return combineCodec(
    getUpdateGroupMemberPointerInstructionDataEncoder(),
    getUpdateGroupMemberPointerInstructionDataDecoder()
  );
}
function getUpdateGroupMemberPointerInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    mint: { value: input.mint ?? null, isWritable: true },
    groupMemberPointerAuthority: {
      value: input.groupMemberPointerAuthority ?? null,
      isWritable: false
    }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.mint),
      getAccountMeta(accounts.groupMemberPointerAuthority),
      ...remainingAccounts
    ],
    programAddress,
    data: getUpdateGroupMemberPointerInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseUpdateGroupMemberPointerInstruction(instruction) {
  if (instruction.accounts.length < 2) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      mint: getNextAccount(),
      groupMemberPointerAuthority: getNextAccount()
    },
    data: getUpdateGroupMemberPointerInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var UPDATE_GROUP_POINTER_DISCRIMINATOR = 40;
function getUpdateGroupPointerDiscriminatorBytes() {
  return getU8Encoder().encode(UPDATE_GROUP_POINTER_DISCRIMINATOR);
}
var UPDATE_GROUP_POINTER_GROUP_POINTER_DISCRIMINATOR = 1;
function getUpdateGroupPointerGroupPointerDiscriminatorBytes() {
  return getU8Encoder().encode(
    UPDATE_GROUP_POINTER_GROUP_POINTER_DISCRIMINATOR
  );
}
function getUpdateGroupPointerInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["groupPointerDiscriminator", getU8Encoder()],
      [
        "groupAddress",
        getOptionEncoder(getAddressEncoder(), {
          prefix: null,
          noneValue: "zeroes"
        })
      ]
    ]),
    (value) => ({
      ...value,
      discriminator: UPDATE_GROUP_POINTER_DISCRIMINATOR,
      groupPointerDiscriminator: UPDATE_GROUP_POINTER_GROUP_POINTER_DISCRIMINATOR
    })
  );
}
function getUpdateGroupPointerInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["groupPointerDiscriminator", getU8Decoder()],
    [
      "groupAddress",
      getOptionDecoder(getAddressDecoder(), {
        prefix: null,
        noneValue: "zeroes"
      })
    ]
  ]);
}
function getUpdateGroupPointerInstructionDataCodec() {
  return combineCodec(
    getUpdateGroupPointerInstructionDataEncoder(),
    getUpdateGroupPointerInstructionDataDecoder()
  );
}
function getUpdateGroupPointerInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    mint: { value: input.mint ?? null, isWritable: true },
    groupPointerAuthority: {
      value: input.groupPointerAuthority ?? null,
      isWritable: false
    }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.mint),
      getAccountMeta(accounts.groupPointerAuthority),
      ...remainingAccounts
    ],
    programAddress,
    data: getUpdateGroupPointerInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseUpdateGroupPointerInstruction(instruction) {
  if (instruction.accounts.length < 2) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      mint: getNextAccount(),
      groupPointerAuthority: getNextAccount()
    },
    data: getUpdateGroupPointerInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var UPDATE_METADATA_POINTER_DISCRIMINATOR = 39;
function getUpdateMetadataPointerDiscriminatorBytes() {
  return getU8Encoder().encode(UPDATE_METADATA_POINTER_DISCRIMINATOR);
}
var UPDATE_METADATA_POINTER_METADATA_POINTER_DISCRIMINATOR = 1;
function getUpdateMetadataPointerMetadataPointerDiscriminatorBytes() {
  return getU8Encoder().encode(
    UPDATE_METADATA_POINTER_METADATA_POINTER_DISCRIMINATOR
  );
}
function getUpdateMetadataPointerInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["metadataPointerDiscriminator", getU8Encoder()],
      [
        "metadataAddress",
        getOptionEncoder(getAddressEncoder(), {
          prefix: null,
          noneValue: "zeroes"
        })
      ]
    ]),
    (value) => ({
      ...value,
      discriminator: UPDATE_METADATA_POINTER_DISCRIMINATOR,
      metadataPointerDiscriminator: UPDATE_METADATA_POINTER_METADATA_POINTER_DISCRIMINATOR
    })
  );
}
function getUpdateMetadataPointerInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["metadataPointerDiscriminator", getU8Decoder()],
    [
      "metadataAddress",
      getOptionDecoder(getAddressDecoder(), {
        prefix: null,
        noneValue: "zeroes"
      })
    ]
  ]);
}
function getUpdateMetadataPointerInstructionDataCodec() {
  return combineCodec(
    getUpdateMetadataPointerInstructionDataEncoder(),
    getUpdateMetadataPointerInstructionDataDecoder()
  );
}
function getUpdateMetadataPointerInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    mint: { value: input.mint ?? null, isWritable: true },
    metadataPointerAuthority: {
      value: input.metadataPointerAuthority ?? null,
      isWritable: false
    }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.mint),
      getAccountMeta(accounts.metadataPointerAuthority),
      ...remainingAccounts
    ],
    programAddress,
    data: getUpdateMetadataPointerInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseUpdateMetadataPointerInstruction(instruction) {
  if (instruction.accounts.length < 2) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      mint: getNextAccount(),
      metadataPointerAuthority: getNextAccount()
    },
    data: getUpdateMetadataPointerInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var UPDATE_MULTIPLIER_SCALED_UI_MINT_DISCRIMINATOR = 43;
function getUpdateMultiplierScaledUiMintDiscriminatorBytes() {
  return getU8Encoder().encode(UPDATE_MULTIPLIER_SCALED_UI_MINT_DISCRIMINATOR);
}
var UPDATE_MULTIPLIER_SCALED_UI_MINT_SCALED_UI_AMOUNT_MINT_DISCRIMINATOR = 1;
function getUpdateMultiplierScaledUiMintScaledUiAmountMintDiscriminatorBytes() {
  return getU8Encoder().encode(
    UPDATE_MULTIPLIER_SCALED_UI_MINT_SCALED_UI_AMOUNT_MINT_DISCRIMINATOR
  );
}
function getUpdateMultiplierScaledUiMintInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["scaledUiAmountMintDiscriminator", getU8Encoder()],
      ["multiplier", getF64Encoder()],
      ["effectiveTimestamp", getI64Encoder()]
    ]),
    (value) => ({
      ...value,
      discriminator: UPDATE_MULTIPLIER_SCALED_UI_MINT_DISCRIMINATOR,
      scaledUiAmountMintDiscriminator: UPDATE_MULTIPLIER_SCALED_UI_MINT_SCALED_UI_AMOUNT_MINT_DISCRIMINATOR
    })
  );
}
function getUpdateMultiplierScaledUiMintInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["scaledUiAmountMintDiscriminator", getU8Decoder()],
    ["multiplier", getF64Decoder()],
    ["effectiveTimestamp", getI64Decoder()]
  ]);
}
function getUpdateMultiplierScaledUiMintInstructionDataCodec() {
  return combineCodec(
    getUpdateMultiplierScaledUiMintInstructionDataEncoder(),
    getUpdateMultiplierScaledUiMintInstructionDataDecoder()
  );
}
function getUpdateMultiplierScaledUiMintInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    mint: { value: input.mint ?? null, isWritable: true },
    authority: { value: input.authority ?? null, isWritable: true }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.mint),
      getAccountMeta(accounts.authority),
      ...remainingAccounts
    ],
    programAddress,
    data: getUpdateMultiplierScaledUiMintInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseUpdateMultiplierScaledUiMintInstruction(instruction) {
  if (instruction.accounts.length < 2) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      mint: getNextAccount(),
      authority: getNextAccount()
    },
    data: getUpdateMultiplierScaledUiMintInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var UPDATE_RATE_INTEREST_BEARING_MINT_DISCRIMINATOR = 33;
function getUpdateRateInterestBearingMintDiscriminatorBytes() {
  return getU8Encoder().encode(UPDATE_RATE_INTEREST_BEARING_MINT_DISCRIMINATOR);
}
var UPDATE_RATE_INTEREST_BEARING_MINT_INTEREST_BEARING_MINT_DISCRIMINATOR = 1;
function getUpdateRateInterestBearingMintInterestBearingMintDiscriminatorBytes() {
  return getU8Encoder().encode(
    UPDATE_RATE_INTEREST_BEARING_MINT_INTEREST_BEARING_MINT_DISCRIMINATOR
  );
}
function getUpdateRateInterestBearingMintInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["interestBearingMintDiscriminator", getU8Encoder()],
      ["rate", getI16Encoder()]
    ]),
    (value) => ({
      ...value,
      discriminator: UPDATE_RATE_INTEREST_BEARING_MINT_DISCRIMINATOR,
      interestBearingMintDiscriminator: UPDATE_RATE_INTEREST_BEARING_MINT_INTEREST_BEARING_MINT_DISCRIMINATOR
    })
  );
}
function getUpdateRateInterestBearingMintInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["interestBearingMintDiscriminator", getU8Decoder()],
    ["rate", getI16Decoder()]
  ]);
}
function getUpdateRateInterestBearingMintInstructionDataCodec() {
  return combineCodec(
    getUpdateRateInterestBearingMintInstructionDataEncoder(),
    getUpdateRateInterestBearingMintInstructionDataDecoder()
  );
}
function getUpdateRateInterestBearingMintInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    mint: { value: input.mint ?? null, isWritable: true },
    rateAuthority: { value: input.rateAuthority ?? null, isWritable: true }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.mint),
      getAccountMeta(accounts.rateAuthority),
      ...remainingAccounts
    ],
    programAddress,
    data: getUpdateRateInterestBearingMintInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseUpdateRateInterestBearingMintInstruction(instruction) {
  if (instruction.accounts.length < 2) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      mint: getNextAccount(),
      rateAuthority: getNextAccount()
    },
    data: getUpdateRateInterestBearingMintInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var UPDATE_TOKEN_GROUP_MAX_SIZE_DISCRIMINATOR = new Uint8Array([
  108,
  37,
  171,
  143,
  248,
  30,
  18,
  110
]);
function getUpdateTokenGroupMaxSizeDiscriminatorBytes() {
  return getBytesEncoder().encode(UPDATE_TOKEN_GROUP_MAX_SIZE_DISCRIMINATOR);
}
function getUpdateTokenGroupMaxSizeInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getBytesEncoder()],
      ["maxSize", getU64Encoder()]
    ]),
    (value) => ({
      ...value,
      discriminator: UPDATE_TOKEN_GROUP_MAX_SIZE_DISCRIMINATOR
    })
  );
}
function getUpdateTokenGroupMaxSizeInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getBytesDecoder()],
    ["maxSize", getU64Decoder()]
  ]);
}
function getUpdateTokenGroupMaxSizeInstructionDataCodec() {
  return combineCodec(
    getUpdateTokenGroupMaxSizeInstructionDataEncoder(),
    getUpdateTokenGroupMaxSizeInstructionDataDecoder()
  );
}
function getUpdateTokenGroupMaxSizeInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    group: { value: input.group ?? null, isWritable: true },
    updateAuthority: {
      value: input.updateAuthority ?? null,
      isWritable: false
    }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.group),
      getAccountMeta(accounts.updateAuthority)
    ],
    programAddress,
    data: getUpdateTokenGroupMaxSizeInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseUpdateTokenGroupMaxSizeInstruction(instruction) {
  if (instruction.accounts.length < 2) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      group: getNextAccount(),
      updateAuthority: getNextAccount()
    },
    data: getUpdateTokenGroupMaxSizeInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var UPDATE_TOKEN_GROUP_UPDATE_AUTHORITY_DISCRIMINATOR = new Uint8Array(
  [161, 105, 88, 1, 237, 221, 216, 203]
);
function getUpdateTokenGroupUpdateAuthorityDiscriminatorBytes() {
  return getBytesEncoder().encode(
    UPDATE_TOKEN_GROUP_UPDATE_AUTHORITY_DISCRIMINATOR
  );
}
function getUpdateTokenGroupUpdateAuthorityInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getBytesEncoder()],
      [
        "newUpdateAuthority",
        getOptionEncoder(getAddressEncoder(), {
          prefix: null,
          noneValue: "zeroes"
        })
      ]
    ]),
    (value) => ({
      ...value,
      discriminator: UPDATE_TOKEN_GROUP_UPDATE_AUTHORITY_DISCRIMINATOR
    })
  );
}
function getUpdateTokenGroupUpdateAuthorityInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getBytesDecoder()],
    [
      "newUpdateAuthority",
      getOptionDecoder(getAddressDecoder(), {
        prefix: null,
        noneValue: "zeroes"
      })
    ]
  ]);
}
function getUpdateTokenGroupUpdateAuthorityInstructionDataCodec() {
  return combineCodec(
    getUpdateTokenGroupUpdateAuthorityInstructionDataEncoder(),
    getUpdateTokenGroupUpdateAuthorityInstructionDataDecoder()
  );
}
function getUpdateTokenGroupUpdateAuthorityInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    group: { value: input.group ?? null, isWritable: true },
    updateAuthority: {
      value: input.updateAuthority ?? null,
      isWritable: false
    }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.group),
      getAccountMeta(accounts.updateAuthority)
    ],
    programAddress,
    data: getUpdateTokenGroupUpdateAuthorityInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseUpdateTokenGroupUpdateAuthorityInstruction(instruction) {
  if (instruction.accounts.length < 2) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      group: getNextAccount(),
      updateAuthority: getNextAccount()
    },
    data: getUpdateTokenGroupUpdateAuthorityInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var UPDATE_TOKEN_METADATA_FIELD_DISCRIMINATOR = new Uint8Array([
  221,
  233,
  49,
  45,
  181,
  202,
  220,
  200
]);
function getUpdateTokenMetadataFieldDiscriminatorBytes() {
  return getBytesEncoder().encode(UPDATE_TOKEN_METADATA_FIELD_DISCRIMINATOR);
}
function getUpdateTokenMetadataFieldInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getBytesEncoder()],
      ["field", getTokenMetadataFieldEncoder()],
      ["value", addEncoderSizePrefix(getUtf8Encoder(), getU32Encoder())]
    ]),
    (value) => ({
      ...value,
      discriminator: UPDATE_TOKEN_METADATA_FIELD_DISCRIMINATOR
    })
  );
}
function getUpdateTokenMetadataFieldInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getBytesDecoder()],
    ["field", getTokenMetadataFieldDecoder()],
    ["value", addDecoderSizePrefix(getUtf8Decoder(), getU32Decoder())]
  ]);
}
function getUpdateTokenMetadataFieldInstructionDataCodec() {
  return combineCodec(
    getUpdateTokenMetadataFieldInstructionDataEncoder(),
    getUpdateTokenMetadataFieldInstructionDataDecoder()
  );
}
function getUpdateTokenMetadataFieldInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    metadata: { value: input.metadata ?? null, isWritable: true },
    updateAuthority: {
      value: input.updateAuthority ?? null,
      isWritable: false
    }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.metadata),
      getAccountMeta(accounts.updateAuthority)
    ],
    programAddress,
    data: getUpdateTokenMetadataFieldInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseUpdateTokenMetadataFieldInstruction(instruction) {
  if (instruction.accounts.length < 2) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      metadata: getNextAccount(),
      updateAuthority: getNextAccount()
    },
    data: getUpdateTokenMetadataFieldInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var UPDATE_TOKEN_METADATA_UPDATE_AUTHORITY_DISCRIMINATOR = new Uint8Array([215, 228, 166, 228, 84, 100, 86, 123]);
function getUpdateTokenMetadataUpdateAuthorityDiscriminatorBytes() {
  return getBytesEncoder().encode(
    UPDATE_TOKEN_METADATA_UPDATE_AUTHORITY_DISCRIMINATOR
  );
}
function getUpdateTokenMetadataUpdateAuthorityInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getBytesEncoder()],
      [
        "newUpdateAuthority",
        getOptionEncoder(getAddressEncoder(), {
          prefix: null,
          noneValue: "zeroes"
        })
      ]
    ]),
    (value) => ({
      ...value,
      discriminator: UPDATE_TOKEN_METADATA_UPDATE_AUTHORITY_DISCRIMINATOR
    })
  );
}
function getUpdateTokenMetadataUpdateAuthorityInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getBytesDecoder()],
    [
      "newUpdateAuthority",
      getOptionDecoder(getAddressDecoder(), {
        prefix: null,
        noneValue: "zeroes"
      })
    ]
  ]);
}
function getUpdateTokenMetadataUpdateAuthorityInstructionDataCodec() {
  return combineCodec(
    getUpdateTokenMetadataUpdateAuthorityInstructionDataEncoder(),
    getUpdateTokenMetadataUpdateAuthorityInstructionDataDecoder()
  );
}
function getUpdateTokenMetadataUpdateAuthorityInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    metadata: { value: input.metadata ?? null, isWritable: true },
    updateAuthority: {
      value: input.updateAuthority ?? null,
      isWritable: false
    }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.metadata),
      getAccountMeta(accounts.updateAuthority)
    ],
    programAddress,
    data: getUpdateTokenMetadataUpdateAuthorityInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseUpdateTokenMetadataUpdateAuthorityInstruction(instruction) {
  if (instruction.accounts.length < 2) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      metadata: getNextAccount(),
      updateAuthority: getNextAccount()
    },
    data: getUpdateTokenMetadataUpdateAuthorityInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var UPDATE_TRANSFER_HOOK_DISCRIMINATOR = 36;
function getUpdateTransferHookDiscriminatorBytes() {
  return getU8Encoder().encode(UPDATE_TRANSFER_HOOK_DISCRIMINATOR);
}
var UPDATE_TRANSFER_HOOK_TRANSFER_HOOK_DISCRIMINATOR = 1;
function getUpdateTransferHookTransferHookDiscriminatorBytes() {
  return getU8Encoder().encode(
    UPDATE_TRANSFER_HOOK_TRANSFER_HOOK_DISCRIMINATOR
  );
}
function getUpdateTransferHookInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["transferHookDiscriminator", getU8Encoder()],
      [
        "programId",
        getOptionEncoder(getAddressEncoder(), {
          prefix: null,
          noneValue: "zeroes"
        })
      ]
    ]),
    (value) => ({
      ...value,
      discriminator: UPDATE_TRANSFER_HOOK_DISCRIMINATOR,
      transferHookDiscriminator: UPDATE_TRANSFER_HOOK_TRANSFER_HOOK_DISCRIMINATOR
    })
  );
}
function getUpdateTransferHookInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["transferHookDiscriminator", getU8Decoder()],
    [
      "programId",
      getOptionDecoder(getAddressDecoder(), {
        prefix: null,
        noneValue: "zeroes"
      })
    ]
  ]);
}
function getUpdateTransferHookInstructionDataCodec() {
  return combineCodec(
    getUpdateTransferHookInstructionDataEncoder(),
    getUpdateTransferHookInstructionDataDecoder()
  );
}
function getUpdateTransferHookInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    mint: { value: input.mint ?? null, isWritable: true },
    authority: { value: input.authority ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.mint),
      getAccountMeta(accounts.authority),
      ...remainingAccounts
    ],
    programAddress,
    data: getUpdateTransferHookInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseUpdateTransferHookInstruction(instruction) {
  if (instruction.accounts.length < 2) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      mint: getNextAccount(),
      authority: getNextAccount()
    },
    data: getUpdateTransferHookInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var WITHDRAW_EXCESS_LAMPORTS_DISCRIMINATOR = 38;
function getWithdrawExcessLamportsDiscriminatorBytes() {
  return getU8Encoder().encode(WITHDRAW_EXCESS_LAMPORTS_DISCRIMINATOR);
}
function getWithdrawExcessLamportsInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([["discriminator", getU8Encoder()]]),
    (value) => ({
      ...value,
      discriminator: WITHDRAW_EXCESS_LAMPORTS_DISCRIMINATOR
    })
  );
}
function getWithdrawExcessLamportsInstructionDataDecoder() {
  return getStructDecoder([["discriminator", getU8Decoder()]]);
}
function getWithdrawExcessLamportsInstructionDataCodec() {
  return combineCodec(
    getWithdrawExcessLamportsInstructionDataEncoder(),
    getWithdrawExcessLamportsInstructionDataDecoder()
  );
}
function getWithdrawExcessLamportsInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    sourceAccount: { value: input.sourceAccount ?? null, isWritable: true },
    destinationAccount: {
      value: input.destinationAccount ?? null,
      isWritable: true
    },
    authority: { value: input.authority ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.sourceAccount),
      getAccountMeta(accounts.destinationAccount),
      getAccountMeta(accounts.authority),
      ...remainingAccounts
    ],
    programAddress,
    data: getWithdrawExcessLamportsInstructionDataEncoder().encode({})
  };
  return instruction;
}
function parseWithdrawExcessLamportsInstruction(instruction) {
  if (instruction.accounts.length < 3) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      sourceAccount: getNextAccount(),
      destinationAccount: getNextAccount(),
      authority: getNextAccount()
    },
    data: getWithdrawExcessLamportsInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var WITHDRAW_WITHHELD_TOKENS_FROM_ACCOUNTS_DISCRIMINATOR = 26;
function getWithdrawWithheldTokensFromAccountsDiscriminatorBytes() {
  return getU8Encoder().encode(
    WITHDRAW_WITHHELD_TOKENS_FROM_ACCOUNTS_DISCRIMINATOR
  );
}
var WITHDRAW_WITHHELD_TOKENS_FROM_ACCOUNTS_TRANSFER_FEE_DISCRIMINATOR = 3;
function getWithdrawWithheldTokensFromAccountsTransferFeeDiscriminatorBytes() {
  return getU8Encoder().encode(
    WITHDRAW_WITHHELD_TOKENS_FROM_ACCOUNTS_TRANSFER_FEE_DISCRIMINATOR
  );
}
function getWithdrawWithheldTokensFromAccountsInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["transferFeeDiscriminator", getU8Encoder()],
      ["numTokenAccounts", getU8Encoder()]
    ]),
    (value) => ({
      ...value,
      discriminator: WITHDRAW_WITHHELD_TOKENS_FROM_ACCOUNTS_DISCRIMINATOR,
      transferFeeDiscriminator: WITHDRAW_WITHHELD_TOKENS_FROM_ACCOUNTS_TRANSFER_FEE_DISCRIMINATOR
    })
  );
}
function getWithdrawWithheldTokensFromAccountsInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["transferFeeDiscriminator", getU8Decoder()],
    ["numTokenAccounts", getU8Decoder()]
  ]);
}
function getWithdrawWithheldTokensFromAccountsInstructionDataCodec() {
  return combineCodec(
    getWithdrawWithheldTokensFromAccountsInstructionDataEncoder(),
    getWithdrawWithheldTokensFromAccountsInstructionDataDecoder()
  );
}
function getWithdrawWithheldTokensFromAccountsInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    mint: { value: input.mint ?? null, isWritable: false },
    feeReceiver: { value: input.feeReceiver ?? null, isWritable: true },
    withdrawWithheldAuthority: {
      value: input.withdrawWithheldAuthority ?? null,
      isWritable: false
    }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = [
    ...(args.multiSigners ?? []).map((signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })),
    ...args.sources.map((address) => ({ address, role: AccountRole.WRITABLE }))
  ];
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.mint),
      getAccountMeta(accounts.feeReceiver),
      getAccountMeta(accounts.withdrawWithheldAuthority),
      ...remainingAccounts
    ],
    programAddress,
    data: getWithdrawWithheldTokensFromAccountsInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseWithdrawWithheldTokensFromAccountsInstruction(instruction) {
  if (instruction.accounts.length < 3) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      mint: getNextAccount(),
      feeReceiver: getNextAccount(),
      withdrawWithheldAuthority: getNextAccount()
    },
    data: getWithdrawWithheldTokensFromAccountsInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var WITHDRAW_WITHHELD_TOKENS_FROM_ACCOUNTS_FOR_CONFIDENTIAL_TRANSFER_FEE_DISCRIMINATOR = 37;
function getWithdrawWithheldTokensFromAccountsForConfidentialTransferFeeDiscriminatorBytes() {
  return getU8Encoder().encode(
    WITHDRAW_WITHHELD_TOKENS_FROM_ACCOUNTS_FOR_CONFIDENTIAL_TRANSFER_FEE_DISCRIMINATOR
  );
}
var WITHDRAW_WITHHELD_TOKENS_FROM_ACCOUNTS_FOR_CONFIDENTIAL_TRANSFER_FEE_CONFIDENTIAL_TRANSFER_FEE_DISCRIMINATOR = 2;
function getWithdrawWithheldTokensFromAccountsForConfidentialTransferFeeConfidentialTransferFeeDiscriminatorBytes() {
  return getU8Encoder().encode(
    WITHDRAW_WITHHELD_TOKENS_FROM_ACCOUNTS_FOR_CONFIDENTIAL_TRANSFER_FEE_CONFIDENTIAL_TRANSFER_FEE_DISCRIMINATOR
  );
}
function getWithdrawWithheldTokensFromAccountsForConfidentialTransferFeeInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["confidentialTransferFeeDiscriminator", getU8Encoder()],
      ["numTokenAccounts", getU8Encoder()],
      ["proofInstructionOffset", getI8Encoder()],
      ["newDecryptableAvailableBalance", getDecryptableBalanceEncoder()]
    ]),
    (value) => ({
      ...value,
      discriminator: WITHDRAW_WITHHELD_TOKENS_FROM_ACCOUNTS_FOR_CONFIDENTIAL_TRANSFER_FEE_DISCRIMINATOR,
      confidentialTransferFeeDiscriminator: WITHDRAW_WITHHELD_TOKENS_FROM_ACCOUNTS_FOR_CONFIDENTIAL_TRANSFER_FEE_CONFIDENTIAL_TRANSFER_FEE_DISCRIMINATOR
    })
  );
}
function getWithdrawWithheldTokensFromAccountsForConfidentialTransferFeeInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["confidentialTransferFeeDiscriminator", getU8Decoder()],
    ["numTokenAccounts", getU8Decoder()],
    ["proofInstructionOffset", getI8Decoder()],
    ["newDecryptableAvailableBalance", getDecryptableBalanceDecoder()]
  ]);
}
function getWithdrawWithheldTokensFromAccountsForConfidentialTransferFeeInstructionDataCodec() {
  return combineCodec(
    getWithdrawWithheldTokensFromAccountsForConfidentialTransferFeeInstructionDataEncoder(),
    getWithdrawWithheldTokensFromAccountsForConfidentialTransferFeeInstructionDataDecoder()
  );
}
function getWithdrawWithheldTokensFromAccountsForConfidentialTransferFeeInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    mint: { value: input.mint ?? null, isWritable: false },
    destination: { value: input.destination ?? null, isWritable: true },
    instructionsSysvarOrContextState: {
      value: input.instructionsSysvarOrContextState ?? null,
      isWritable: false
    },
    record: { value: input.record ?? null, isWritable: false },
    authority: { value: input.authority ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.mint),
      getAccountMeta(accounts.destination),
      getAccountMeta(accounts.instructionsSysvarOrContextState),
      getAccountMeta(accounts.record),
      getAccountMeta(accounts.authority),
      ...remainingAccounts
    ],
    programAddress,
    data: getWithdrawWithheldTokensFromAccountsForConfidentialTransferFeeInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseWithdrawWithheldTokensFromAccountsForConfidentialTransferFeeInstruction(instruction) {
  if (instruction.accounts.length < 5) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  const getNextOptionalAccount = () => {
    const accountMeta = getNextAccount();
    return accountMeta.address === TOKEN_2022_PROGRAM_ADDRESS ? void 0 : accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      mint: getNextAccount(),
      destination: getNextAccount(),
      instructionsSysvarOrContextState: getNextAccount(),
      record: getNextOptionalAccount(),
      authority: getNextAccount()
    },
    data: getWithdrawWithheldTokensFromAccountsForConfidentialTransferFeeInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var WITHDRAW_WITHHELD_TOKENS_FROM_MINT_DISCRIMINATOR = 26;
function getWithdrawWithheldTokensFromMintDiscriminatorBytes() {
  return getU8Encoder().encode(
    WITHDRAW_WITHHELD_TOKENS_FROM_MINT_DISCRIMINATOR
  );
}
var WITHDRAW_WITHHELD_TOKENS_FROM_MINT_TRANSFER_FEE_DISCRIMINATOR = 2;
function getWithdrawWithheldTokensFromMintTransferFeeDiscriminatorBytes() {
  return getU8Encoder().encode(
    WITHDRAW_WITHHELD_TOKENS_FROM_MINT_TRANSFER_FEE_DISCRIMINATOR
  );
}
function getWithdrawWithheldTokensFromMintInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["transferFeeDiscriminator", getU8Encoder()]
    ]),
    (value) => ({
      ...value,
      discriminator: WITHDRAW_WITHHELD_TOKENS_FROM_MINT_DISCRIMINATOR,
      transferFeeDiscriminator: WITHDRAW_WITHHELD_TOKENS_FROM_MINT_TRANSFER_FEE_DISCRIMINATOR
    })
  );
}
function getWithdrawWithheldTokensFromMintInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["transferFeeDiscriminator", getU8Decoder()]
  ]);
}
function getWithdrawWithheldTokensFromMintInstructionDataCodec() {
  return combineCodec(
    getWithdrawWithheldTokensFromMintInstructionDataEncoder(),
    getWithdrawWithheldTokensFromMintInstructionDataDecoder()
  );
}
function getWithdrawWithheldTokensFromMintInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    mint: { value: input.mint ?? null, isWritable: true },
    feeReceiver: { value: input.feeReceiver ?? null, isWritable: true },
    withdrawWithheldAuthority: {
      value: input.withdrawWithheldAuthority ?? null,
      isWritable: false
    }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.mint),
      getAccountMeta(accounts.feeReceiver),
      getAccountMeta(accounts.withdrawWithheldAuthority),
      ...remainingAccounts
    ],
    programAddress,
    data: getWithdrawWithheldTokensFromMintInstructionDataEncoder().encode({})
  };
  return instruction;
}
function parseWithdrawWithheldTokensFromMintInstruction(instruction) {
  if (instruction.accounts.length < 3) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      mint: getNextAccount(),
      feeReceiver: getNextAccount(),
      withdrawWithheldAuthority: getNextAccount()
    },
    data: getWithdrawWithheldTokensFromMintInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var WITHDRAW_WITHHELD_TOKENS_FROM_MINT_FOR_CONFIDENTIAL_TRANSFER_FEE_DISCRIMINATOR = 37;
function getWithdrawWithheldTokensFromMintForConfidentialTransferFeeDiscriminatorBytes() {
  return getU8Encoder().encode(
    WITHDRAW_WITHHELD_TOKENS_FROM_MINT_FOR_CONFIDENTIAL_TRANSFER_FEE_DISCRIMINATOR
  );
}
var WITHDRAW_WITHHELD_TOKENS_FROM_MINT_FOR_CONFIDENTIAL_TRANSFER_FEE_CONFIDENTIAL_TRANSFER_FEE_DISCRIMINATOR = 1;
function getWithdrawWithheldTokensFromMintForConfidentialTransferFeeConfidentialTransferFeeDiscriminatorBytes() {
  return getU8Encoder().encode(
    WITHDRAW_WITHHELD_TOKENS_FROM_MINT_FOR_CONFIDENTIAL_TRANSFER_FEE_CONFIDENTIAL_TRANSFER_FEE_DISCRIMINATOR
  );
}
function getWithdrawWithheldTokensFromMintForConfidentialTransferFeeInstructionDataEncoder() {
  return transformEncoder(
    getStructEncoder([
      ["discriminator", getU8Encoder()],
      ["confidentialTransferFeeDiscriminator", getU8Encoder()],
      ["proofInstructionOffset", getI8Encoder()],
      ["newDecryptableAvailableBalance", getDecryptableBalanceEncoder()]
    ]),
    (value) => ({
      ...value,
      discriminator: WITHDRAW_WITHHELD_TOKENS_FROM_MINT_FOR_CONFIDENTIAL_TRANSFER_FEE_DISCRIMINATOR,
      confidentialTransferFeeDiscriminator: WITHDRAW_WITHHELD_TOKENS_FROM_MINT_FOR_CONFIDENTIAL_TRANSFER_FEE_CONFIDENTIAL_TRANSFER_FEE_DISCRIMINATOR
    })
  );
}
function getWithdrawWithheldTokensFromMintForConfidentialTransferFeeInstructionDataDecoder() {
  return getStructDecoder([
    ["discriminator", getU8Decoder()],
    ["confidentialTransferFeeDiscriminator", getU8Decoder()],
    ["proofInstructionOffset", getI8Decoder()],
    ["newDecryptableAvailableBalance", getDecryptableBalanceDecoder()]
  ]);
}
function getWithdrawWithheldTokensFromMintForConfidentialTransferFeeInstructionDataCodec() {
  return combineCodec(
    getWithdrawWithheldTokensFromMintForConfidentialTransferFeeInstructionDataEncoder(),
    getWithdrawWithheldTokensFromMintForConfidentialTransferFeeInstructionDataDecoder()
  );
}
function getWithdrawWithheldTokensFromMintForConfidentialTransferFeeInstruction(input, config) {
  const programAddress = config?.programAddress ?? TOKEN_2022_PROGRAM_ADDRESS;
  const originalAccounts = {
    mint: { value: input.mint ?? null, isWritable: true },
    destination: { value: input.destination ?? null, isWritable: true },
    instructionsSysvarOrContextState: {
      value: input.instructionsSysvarOrContextState ?? null,
      isWritable: false
    },
    record: { value: input.record ?? null, isWritable: false },
    authority: { value: input.authority ?? null, isWritable: false }
  };
  const accounts = originalAccounts;
  const args = { ...input };
  const remainingAccounts = (args.multiSigners ?? []).map(
    (signer) => ({
      address: signer.address,
      role: AccountRole.READONLY_SIGNER,
      signer
    })
  );
  const getAccountMeta = getAccountMetaFactory(programAddress);
  const instruction = {
    accounts: [
      getAccountMeta(accounts.mint),
      getAccountMeta(accounts.destination),
      getAccountMeta(accounts.instructionsSysvarOrContextState),
      getAccountMeta(accounts.record),
      getAccountMeta(accounts.authority),
      ...remainingAccounts
    ],
    programAddress,
    data: getWithdrawWithheldTokensFromMintForConfidentialTransferFeeInstructionDataEncoder().encode(
      args
    )
  };
  return instruction;
}
function parseWithdrawWithheldTokensFromMintForConfidentialTransferFeeInstruction(instruction) {
  if (instruction.accounts.length < 5) {
    throw new Error("Not enough accounts");
  }
  let accountIndex = 0;
  const getNextAccount = () => {
    const accountMeta = instruction.accounts[accountIndex];
    accountIndex += 1;
    return accountMeta;
  };
  const getNextOptionalAccount = () => {
    const accountMeta = getNextAccount();
    return accountMeta.address === TOKEN_2022_PROGRAM_ADDRESS ? void 0 : accountMeta;
  };
  return {
    programAddress: instruction.programAddress,
    accounts: {
      mint: getNextAccount(),
      destination: getNextAccount(),
      instructionsSysvarOrContextState: getNextAccount(),
      record: getNextOptionalAccount(),
      authority: getNextAccount()
    },
    data: getWithdrawWithheldTokensFromMintForConfidentialTransferFeeInstructionDataDecoder().decode(
      instruction.data
    )
  };
}
var ONE_IN_BASIS_POINTS = 1e4;
var SECONDS_PER_YEAR = 60 * 60 * 24 * 365.24;
function calculateExponentForTimesAndRate(t1, t2, r) {
  const timespan = t2 - t1;
  if (timespan < 0) {
    throw new Error("Invalid timespan: end time before start time");
  }
  const numerator = r * timespan;
  const exponent = numerator / (SECONDS_PER_YEAR * ONE_IN_BASIS_POINTS);
  return Math.exp(exponent);
}
function calculateTotalScale({
  currentTimestamp,
  lastUpdateTimestamp,
  initializationTimestamp,
  preUpdateAverageRate,
  currentRate
}) {
  const preUpdateExp = calculateExponentForTimesAndRate(
    initializationTimestamp,
    lastUpdateTimestamp,
    preUpdateAverageRate
  );
  const postUpdateExp = calculateExponentForTimesAndRate(
    lastUpdateTimestamp,
    currentTimestamp,
    currentRate
  );
  return preUpdateExp * postUpdateExp;
}
function getDecimalFactor(decimals) {
  return Math.pow(10, decimals);
}
async function getSysvarClockTimestamp(rpc) {
  const info = await fetchSysvarClock(rpc);
  if (!info) {
    throw new Error("Failed to fetch sysvar clock");
  }
  return info.unixTimestamp;
}
function amountToUiAmountForInterestBearingMintWithoutSimulation(amount, decimals, currentTimestamp, lastUpdateTimestamp, initializationTimestamp, preUpdateAverageRate, currentRate) {
  const totalScale = calculateTotalScale({
    currentTimestamp,
    lastUpdateTimestamp,
    initializationTimestamp,
    preUpdateAverageRate,
    currentRate
  });
  const scaledAmount = Number(amount) * totalScale;
  const decimalFactor = getDecimalFactor(decimals);
  return (Math.trunc(scaledAmount) / decimalFactor).toString();
}
function uiAmountToAmountForInterestBearingMintWithoutSimulation(uiAmount, decimals, currentTimestamp, lastUpdateTimestamp, initializationTimestamp, preUpdateAverageRate, currentRate) {
  const uiAmountNumber = parseFloat(uiAmount);
  const decimalsFactor = getDecimalFactor(decimals);
  const uiAmountScaled = uiAmountNumber * decimalsFactor;
  const totalScale = calculateTotalScale({
    currentTimestamp,
    lastUpdateTimestamp,
    initializationTimestamp,
    preUpdateAverageRate,
    currentRate
  });
  const originalPrincipal = uiAmountScaled / totalScale;
  return BigInt(Math.trunc(originalPrincipal));
}
function amountToUiAmountForScaledUiAmountMintWithoutSimulation(amount, decimals, multiplier) {
  const scaledAmount = Number(amount) * multiplier;
  const decimalFactor = getDecimalFactor(decimals);
  return (Math.trunc(scaledAmount) / decimalFactor).toString();
}
function uiAmountToAmountForScaledUiAmountMintWithoutSimulation(uiAmount, decimals, multiplier) {
  const uiAmountNumber = parseFloat(uiAmount);
  const decimalsFactor = getDecimalFactor(decimals);
  const uiAmountScaled = uiAmountNumber * decimalsFactor;
  const rawAmount = uiAmountScaled / multiplier;
  return BigInt(Math.trunc(rawAmount));
}
async function amountToUiAmountForMintWithoutSimulation(rpc, mint, amount) {
  const accountInfo = await fetchMint(rpc, mint);
  const extensions = unwrapOption(accountInfo.data.extensions);
  const interestBearingMintConfigState = extensions?.find(
    (ext) => ext.__kind === "InterestBearingConfig"
  );
  const scaledUiAmountConfig = extensions?.find(
    (ext) => ext.__kind === "ScaledUiAmountConfig"
  );
  if (!interestBearingMintConfigState && !scaledUiAmountConfig) {
    const amountNumber = Number(amount);
    const decimalsFactor = getDecimalFactor(accountInfo.data.decimals);
    return (amountNumber / decimalsFactor).toString();
  }
  const timestamp = await getSysvarClockTimestamp(rpc);
  if (interestBearingMintConfigState) {
    return amountToUiAmountForInterestBearingMintWithoutSimulation(
      amount,
      accountInfo.data.decimals,
      Number(timestamp),
      Number(interestBearingMintConfigState.lastUpdateTimestamp),
      Number(interestBearingMintConfigState.initializationTimestamp),
      interestBearingMintConfigState.preUpdateAverageRate,
      interestBearingMintConfigState.currentRate
    );
  }
  if (scaledUiAmountConfig) {
    let multiplier = scaledUiAmountConfig.multiplier;
    if (timestamp >= scaledUiAmountConfig.newMultiplierEffectiveTimestamp) {
      multiplier = scaledUiAmountConfig.newMultiplier;
    }
    return amountToUiAmountForScaledUiAmountMintWithoutSimulation(
      amount,
      accountInfo.data.decimals,
      multiplier
    );
  }
  throw new Error("Unknown mint extension type");
}
async function uiAmountToAmountForMintWithoutSimulation(rpc, mint, uiAmount) {
  const accountInfo = await fetchMint(rpc, mint);
  const extensions = unwrapOption(accountInfo.data.extensions);
  const interestBearingMintConfigState = extensions?.find(
    (ext) => ext.__kind === "InterestBearingConfig"
  );
  const scaledUiAmountConfig = extensions?.find(
    (ext) => ext.__kind === "ScaledUiAmountConfig"
  );
  if (!interestBearingMintConfigState && !scaledUiAmountConfig) {
    const uiAmountScaled = parseFloat(uiAmount) * getDecimalFactor(accountInfo.data.decimals);
    return BigInt(Math.trunc(uiAmountScaled));
  }
  const timestamp = await getSysvarClockTimestamp(rpc);
  if (interestBearingMintConfigState) {
    return uiAmountToAmountForInterestBearingMintWithoutSimulation(
      uiAmount,
      accountInfo.data.decimals,
      Number(timestamp),
      Number(interestBearingMintConfigState.lastUpdateTimestamp),
      Number(interestBearingMintConfigState.initializationTimestamp),
      interestBearingMintConfigState.preUpdateAverageRate,
      interestBearingMintConfigState.currentRate
    );
  }
  if (scaledUiAmountConfig) {
    let multiplier = scaledUiAmountConfig.multiplier;
    if (timestamp >= scaledUiAmountConfig.newMultiplierEffectiveTimestamp) {
      multiplier = scaledUiAmountConfig.newMultiplier;
    }
    return uiAmountToAmountForScaledUiAmountMintWithoutSimulation(
      uiAmount,
      accountInfo.data.decimals,
      multiplier
    );
  }
  throw new Error("Unknown mint extension type");
}
function getPreInitializeInstructionsForMintExtensions(mint, extensions) {
  return extensions.flatMap((extension2) => {
    switch (extension2.__kind) {
      case "ConfidentialTransferMint":
        return [
          getInitializeConfidentialTransferMintInstruction({
            mint,
            ...extension2
          })
        ];
      case "DefaultAccountState":
        return [
          getInitializeDefaultAccountStateInstruction({
            mint,
            state: extension2.state
          })
        ];
      case "TransferFeeConfig":
        return [
          getInitializeTransferFeeConfigInstruction({
            mint,
            transferFeeConfigAuthority: extension2.transferFeeConfigAuthority,
            withdrawWithheldAuthority: extension2.withdrawWithheldAuthority,
            transferFeeBasisPoints: extension2.newerTransferFee.transferFeeBasisPoints,
            maximumFee: extension2.newerTransferFee.maximumFee
          })
        ];
      case "MetadataPointer":
        return [
          getInitializeMetadataPointerInstruction({
            mint,
            authority: extension2.authority,
            metadataAddress: extension2.metadataAddress
          })
        ];
      case "InterestBearingConfig":
        return [
          getInitializeInterestBearingMintInstruction({
            mint,
            rateAuthority: extension2.rateAuthority,
            rate: extension2.currentRate
          })
        ];
      case "ScaledUiAmountConfig":
        return [
          getInitializeScaledUiAmountMintInstruction({
            mint,
            authority: extension2.authority,
            multiplier: extension2.multiplier
          })
        ];
      case "PausableConfig":
        return [
          getInitializePausableConfigInstruction({
            mint,
            authority: extension2.authority
          })
        ];
      case "GroupPointer":
        return [
          getInitializeGroupPointerInstruction({
            mint,
            authority: extension2.authority,
            groupAddress: extension2.groupAddress
          })
        ];
      case "GroupMemberPointer":
        return [
          getInitializeGroupMemberPointerInstruction({
            mint,
            authority: extension2.authority,
            memberAddress: extension2.memberAddress
          })
        ];
      case "NonTransferable":
        return getInitializeNonTransferableMintInstruction({ mint });
      case "TransferHook":
        return [
          getInitializeTransferHookInstruction({
            mint,
            authority: extension2.authority,
            programId: extension2.programId
          })
        ];
      case "PermanentDelegate":
        return getInitializePermanentDelegateInstruction({
          mint,
          delegate: extension2.delegate
        });
      case "ConfidentialTransferFee":
        return [
          getInitializeConfidentialTransferFeeInstruction({
            mint,
            authority: extension2.authority,
            withdrawWithheldAuthorityElGamalPubkey: extension2.elgamalPubkey
          })
        ];
      case "MintCloseAuthority":
        return getInitializeMintCloseAuthorityInstruction({
          closeAuthority: extension2.closeAuthority,
          mint
        });
      default:
        return [];
    }
  });
}
function getPostInitializeInstructionsForMintExtensions(mint, authority, extensions) {
  return extensions.flatMap((extension2) => {
    switch (extension2.__kind) {
      case "TokenMetadata":
        const tokenMetadataUpdateAuthority = isOption(extension2.updateAuthority) ? extension2.updateAuthority : wrapNullable(extension2.updateAuthority);
        if (isNone(tokenMetadataUpdateAuthority)) {
          return [];
        }
        return [
          getInitializeTokenMetadataInstruction({
            metadata: mint,
            updateAuthority: tokenMetadataUpdateAuthority.value,
            mint,
            mintAuthority: authority,
            name: extension2.name,
            symbol: extension2.symbol,
            uri: extension2.uri
          })
        ];
      case "TokenGroup":
        return [
          getInitializeTokenGroupInstruction({
            group: mint,
            updateAuthority: isOption(extension2.updateAuthority) ? extension2.updateAuthority : wrapNullable(extension2.updateAuthority),
            mint,
            mintAuthority: authority,
            maxSize: extension2.maxSize
          })
        ];
      default:
        return [];
    }
  });
}
function getPostInitializeInstructionsForTokenExtensions(token, owner, extensions, multiSigners) {
  return extensions.flatMap((extension2) => {
    switch (extension2.__kind) {
      case "MemoTransfer":
        return [
          extension2.requireIncomingTransferMemos ? getEnableMemoTransfersInstruction({ owner, token, multiSigners }) : getDisableMemoTransfersInstruction({
            owner,
            token,
            multiSigners
          })
        ];
      case "CpiGuard":
        return [
          extension2.lockCpi ? getEnableCpiGuardInstruction({ owner, token, multiSigners }) : getDisableCpiGuardInstruction({
            owner,
            token,
            multiSigners
          })
        ];
      default:
        return [];
    }
  });
}
var TOKEN_BASE_SIZE = 165;
function getTokenSize(extensions) {
  if (extensions == null) return TOKEN_BASE_SIZE;
  const tvlEncoder = getHiddenPrefixEncoder(
    getArrayEncoder(getExtensionEncoder(), { size: "remainder" }),
    [getConstantEncoder(getU8Encoder().encode(2))]
  );
  return TOKEN_BASE_SIZE + tvlEncoder.encode(extensions).length;
}
var MINT_BASE_SIZE = 82;
function getMintSize(extensions) {
  if (extensions == null) return MINT_BASE_SIZE;
  const tvlEncoder = getHiddenPrefixEncoder(
    getArrayEncoder(getExtensionEncoder(), { size: "remainder" }),
    [getConstantEncoder(padLeftEncoder(getU8Encoder(), 83).encode(1))]
  );
  return MINT_BASE_SIZE + tvlEncoder.encode(extensions).length;
}

export { AMOUNT_TO_UI_AMOUNT_DISCRIMINATOR, APPLY_CONFIDENTIAL_PENDING_BALANCE_CONFIDENTIAL_TRANSFER_DISCRIMINATOR, APPLY_CONFIDENTIAL_PENDING_BALANCE_DISCRIMINATOR, APPROVE_CHECKED_DISCRIMINATOR, APPROVE_CONFIDENTIAL_TRANSFER_ACCOUNT_CONFIDENTIAL_TRANSFER_DISCRIMINATOR, APPROVE_CONFIDENTIAL_TRANSFER_ACCOUNT_DISCRIMINATOR, APPROVE_DISCRIMINATOR, ASSOCIATED_TOKEN_ERROR__INVALID_OWNER, ASSOCIATED_TOKEN_PROGRAM_ADDRESS, AccountState, AssociatedTokenInstruction, AuthorityType, BURN_CHECKED_DISCRIMINATOR, BURN_DISCRIMINATOR, CLOSE_ACCOUNT_DISCRIMINATOR, CONFIDENTIAL_DEPOSIT_CONFIDENTIAL_TRANSFER_DISCRIMINATOR, CONFIDENTIAL_DEPOSIT_DISCRIMINATOR, CONFIDENTIAL_TRANSFER_CONFIDENTIAL_TRANSFER_DISCRIMINATOR, CONFIDENTIAL_TRANSFER_DISCRIMINATOR, CONFIDENTIAL_TRANSFER_WITH_FEE_CONFIDENTIAL_TRANSFER_DISCRIMINATOR, CONFIDENTIAL_TRANSFER_WITH_FEE_DISCRIMINATOR, CONFIDENTIAL_WITHDRAW_CONFIDENTIAL_TRANSFER_DISCRIMINATOR, CONFIDENTIAL_WITHDRAW_DISCRIMINATOR, CONFIGURE_CONFIDENTIAL_TRANSFER_ACCOUNT_CONFIDENTIAL_TRANSFER_DISCRIMINATOR, CONFIGURE_CONFIDENTIAL_TRANSFER_ACCOUNT_DISCRIMINATOR, CREATE_ASSOCIATED_TOKEN_DISCRIMINATOR, CREATE_ASSOCIATED_TOKEN_IDEMPOTENT_DISCRIMINATOR, CREATE_NATIVE_MINT_DISCRIMINATOR, DISABLE_CONFIDENTIAL_CREDITS_CONFIDENTIAL_TRANSFER_DISCRIMINATOR, DISABLE_CONFIDENTIAL_CREDITS_DISCRIMINATOR, DISABLE_CPI_GUARD_CPI_GUARD_DISCRIMINATOR, DISABLE_CPI_GUARD_DISCRIMINATOR, DISABLE_HARVEST_TO_MINT_CONFIDENTIAL_TRANSFER_FEE_DISCRIMINATOR, DISABLE_HARVEST_TO_MINT_DISCRIMINATOR, DISABLE_MEMO_TRANSFERS_DISCRIMINATOR, DISABLE_MEMO_TRANSFERS_MEMO_TRANSFERS_DISCRIMINATOR, DISABLE_NON_CONFIDENTIAL_CREDITS_CONFIDENTIAL_TRANSFER_DISCRIMINATOR, DISABLE_NON_CONFIDENTIAL_CREDITS_DISCRIMINATOR, EMIT_TOKEN_METADATA_DISCRIMINATOR, EMPTY_CONFIDENTIAL_TRANSFER_ACCOUNT_CONFIDENTIAL_TRANSFER_DISCRIMINATOR, EMPTY_CONFIDENTIAL_TRANSFER_ACCOUNT_DISCRIMINATOR, ENABLE_CONFIDENTIAL_CREDITS_CONFIDENTIAL_TRANSFER_DISCRIMINATOR, ENABLE_CONFIDENTIAL_CREDITS_DISCRIMINATOR, ENABLE_CPI_GUARD_CPI_GUARD_DISCRIMINATOR, ENABLE_CPI_GUARD_DISCRIMINATOR, ENABLE_HARVEST_TO_MINT_CONFIDENTIAL_TRANSFER_FEE_DISCRIMINATOR, ENABLE_HARVEST_TO_MINT_DISCRIMINATOR, ENABLE_MEMO_TRANSFERS_DISCRIMINATOR, ENABLE_MEMO_TRANSFERS_MEMO_TRANSFERS_DISCRIMINATOR, ENABLE_NON_CONFIDENTIAL_CREDITS_CONFIDENTIAL_TRANSFER_DISCRIMINATOR, ENABLE_NON_CONFIDENTIAL_CREDITS_DISCRIMINATOR, ExtensionType, FREEZE_ACCOUNT_DISCRIMINATOR, GET_ACCOUNT_DATA_SIZE_DISCRIMINATOR, HARVEST_WITHHELD_TOKENS_TO_MINT_DISCRIMINATOR, HARVEST_WITHHELD_TOKENS_TO_MINT_FOR_CONFIDENTIAL_TRANSFER_FEE_CONFIDENTIAL_TRANSFER_FEE_DISCRIMINATOR, HARVEST_WITHHELD_TOKENS_TO_MINT_FOR_CONFIDENTIAL_TRANSFER_FEE_DISCRIMINATOR, HARVEST_WITHHELD_TOKENS_TO_MINT_TRANSFER_FEE_DISCRIMINATOR, INITIALIZE_ACCOUNT2_DISCRIMINATOR, INITIALIZE_ACCOUNT3_DISCRIMINATOR, INITIALIZE_ACCOUNT_DISCRIMINATOR, INITIALIZE_CONFIDENTIAL_TRANSFER_FEE_CONFIDENTIAL_TRANSFER_FEE_DISCRIMINATOR, INITIALIZE_CONFIDENTIAL_TRANSFER_FEE_DISCRIMINATOR, INITIALIZE_CONFIDENTIAL_TRANSFER_MINT_CONFIDENTIAL_TRANSFER_DISCRIMINATOR, INITIALIZE_CONFIDENTIAL_TRANSFER_MINT_DISCRIMINATOR, INITIALIZE_DEFAULT_ACCOUNT_STATE_DEFAULT_ACCOUNT_STATE_DISCRIMINATOR, INITIALIZE_DEFAULT_ACCOUNT_STATE_DISCRIMINATOR, INITIALIZE_GROUP_MEMBER_POINTER_DISCRIMINATOR, INITIALIZE_GROUP_MEMBER_POINTER_GROUP_MEMBER_POINTER_DISCRIMINATOR, INITIALIZE_GROUP_POINTER_DISCRIMINATOR, INITIALIZE_GROUP_POINTER_GROUP_POINTER_DISCRIMINATOR, INITIALIZE_IMMUTABLE_OWNER_DISCRIMINATOR, INITIALIZE_INTEREST_BEARING_MINT_DISCRIMINATOR, INITIALIZE_INTEREST_BEARING_MINT_INTEREST_BEARING_MINT_DISCRIMINATOR, INITIALIZE_METADATA_POINTER_DISCRIMINATOR, INITIALIZE_METADATA_POINTER_METADATA_POINTER_DISCRIMINATOR, INITIALIZE_MINT2_DISCRIMINATOR, INITIALIZE_MINT_CLOSE_AUTHORITY_DISCRIMINATOR, INITIALIZE_MINT_DISCRIMINATOR, INITIALIZE_MULTISIG2_DISCRIMINATOR, INITIALIZE_MULTISIG_DISCRIMINATOR, INITIALIZE_NON_TRANSFERABLE_MINT_DISCRIMINATOR, INITIALIZE_PAUSABLE_CONFIG_DISCRIMINATOR, INITIALIZE_PAUSABLE_CONFIG_PAUSABLE_DISCRIMINATOR, INITIALIZE_PERMANENT_DELEGATE_DISCRIMINATOR, INITIALIZE_SCALED_UI_AMOUNT_MINT_DISCRIMINATOR, INITIALIZE_SCALED_UI_AMOUNT_MINT_SCALED_UI_AMOUNT_MINT_DISCRIMINATOR, INITIALIZE_TOKEN_GROUP_DISCRIMINATOR, INITIALIZE_TOKEN_GROUP_MEMBER_DISCRIMINATOR, INITIALIZE_TOKEN_METADATA_DISCRIMINATOR, INITIALIZE_TRANSFER_FEE_CONFIG_DISCRIMINATOR, INITIALIZE_TRANSFER_FEE_CONFIG_TRANSFER_FEE_DISCRIMINATOR, INITIALIZE_TRANSFER_HOOK_DISCRIMINATOR, INITIALIZE_TRANSFER_HOOK_TRANSFER_HOOK_DISCRIMINATOR, MINT_TO_CHECKED_DISCRIMINATOR, MINT_TO_DISCRIMINATOR, PAUSE_DISCRIMINATOR, PAUSE_PAUSABLE_DISCRIMINATOR, REALLOCATE_DISCRIMINATOR, RECOVER_NESTED_ASSOCIATED_TOKEN_DISCRIMINATOR, REMOVE_TOKEN_METADATA_KEY_DISCRIMINATOR, RESUME_DISCRIMINATOR, RESUME_PAUSABLE_DISCRIMINATOR, REVOKE_DISCRIMINATOR, SET_AUTHORITY_DISCRIMINATOR, SET_TRANSFER_FEE_DISCRIMINATOR, SET_TRANSFER_FEE_TRANSFER_FEE_DISCRIMINATOR, SYNC_NATIVE_DISCRIMINATOR, THAW_ACCOUNT_DISCRIMINATOR, TOKEN_2022_ERROR__ACCOUNT_FROZEN, TOKEN_2022_ERROR__ALREADY_IN_USE, TOKEN_2022_ERROR__AUTHORITY_TYPE_NOT_SUPPORTED, TOKEN_2022_ERROR__FIXED_SUPPLY, TOKEN_2022_ERROR__INSUFFICIENT_FUNDS, TOKEN_2022_ERROR__INVALID_INSTRUCTION, TOKEN_2022_ERROR__INVALID_MINT, TOKEN_2022_ERROR__INVALID_NUMBER_OF_PROVIDED_SIGNERS, TOKEN_2022_ERROR__INVALID_NUMBER_OF_REQUIRED_SIGNERS, TOKEN_2022_ERROR__INVALID_STATE, TOKEN_2022_ERROR__MINT_CANNOT_FREEZE, TOKEN_2022_ERROR__MINT_DECIMALS_MISMATCH, TOKEN_2022_ERROR__MINT_MISMATCH, TOKEN_2022_ERROR__NATIVE_NOT_SUPPORTED, TOKEN_2022_ERROR__NON_NATIVE_HAS_BALANCE, TOKEN_2022_ERROR__NON_NATIVE_NOT_SUPPORTED, TOKEN_2022_ERROR__NOT_RENT_EXEMPT, TOKEN_2022_ERROR__OVERFLOW, TOKEN_2022_ERROR__OWNER_MISMATCH, TOKEN_2022_ERROR__UNINITIALIZED_STATE, TOKEN_2022_PROGRAM_ADDRESS, TRANSFER_CHECKED_DISCRIMINATOR, TRANSFER_CHECKED_WITH_FEE_DISCRIMINATOR, TRANSFER_CHECKED_WITH_FEE_TRANSFER_FEE_DISCRIMINATOR, TRANSFER_DISCRIMINATOR, Token2022Account, Token2022Instruction, UI_AMOUNT_TO_AMOUNT_DISCRIMINATOR, UPDATE_CONFIDENTIAL_TRANSFER_MINT_CONFIDENTIAL_TRANSFER_DISCRIMINATOR, UPDATE_CONFIDENTIAL_TRANSFER_MINT_DISCRIMINATOR, UPDATE_DEFAULT_ACCOUNT_STATE_DEFAULT_ACCOUNT_STATE_DISCRIMINATOR, UPDATE_DEFAULT_ACCOUNT_STATE_DISCRIMINATOR, UPDATE_GROUP_MEMBER_POINTER_DISCRIMINATOR, UPDATE_GROUP_MEMBER_POINTER_GROUP_MEMBER_POINTER_DISCRIMINATOR, UPDATE_GROUP_POINTER_DISCRIMINATOR, UPDATE_GROUP_POINTER_GROUP_POINTER_DISCRIMINATOR, UPDATE_METADATA_POINTER_DISCRIMINATOR, UPDATE_METADATA_POINTER_METADATA_POINTER_DISCRIMINATOR, UPDATE_MULTIPLIER_SCALED_UI_MINT_DISCRIMINATOR, UPDATE_MULTIPLIER_SCALED_UI_MINT_SCALED_UI_AMOUNT_MINT_DISCRIMINATOR, UPDATE_RATE_INTEREST_BEARING_MINT_DISCRIMINATOR, UPDATE_RATE_INTEREST_BEARING_MINT_INTEREST_BEARING_MINT_DISCRIMINATOR, UPDATE_TOKEN_GROUP_MAX_SIZE_DISCRIMINATOR, UPDATE_TOKEN_GROUP_UPDATE_AUTHORITY_DISCRIMINATOR, UPDATE_TOKEN_METADATA_FIELD_DISCRIMINATOR, UPDATE_TOKEN_METADATA_UPDATE_AUTHORITY_DISCRIMINATOR, UPDATE_TRANSFER_HOOK_DISCRIMINATOR, UPDATE_TRANSFER_HOOK_TRANSFER_HOOK_DISCRIMINATOR, WITHDRAW_EXCESS_LAMPORTS_DISCRIMINATOR, WITHDRAW_WITHHELD_TOKENS_FROM_ACCOUNTS_DISCRIMINATOR, WITHDRAW_WITHHELD_TOKENS_FROM_ACCOUNTS_FOR_CONFIDENTIAL_TRANSFER_FEE_CONFIDENTIAL_TRANSFER_FEE_DISCRIMINATOR, WITHDRAW_WITHHELD_TOKENS_FROM_ACCOUNTS_FOR_CONFIDENTIAL_TRANSFER_FEE_DISCRIMINATOR, WITHDRAW_WITHHELD_TOKENS_FROM_ACCOUNTS_TRANSFER_FEE_DISCRIMINATOR, WITHDRAW_WITHHELD_TOKENS_FROM_MINT_DISCRIMINATOR, WITHDRAW_WITHHELD_TOKENS_FROM_MINT_FOR_CONFIDENTIAL_TRANSFER_FEE_CONFIDENTIAL_TRANSFER_FEE_DISCRIMINATOR, WITHDRAW_WITHHELD_TOKENS_FROM_MINT_FOR_CONFIDENTIAL_TRANSFER_FEE_DISCRIMINATOR, WITHDRAW_WITHHELD_TOKENS_FROM_MINT_TRANSFER_FEE_DISCRIMINATOR, amountToUiAmountForInterestBearingMintWithoutSimulation, amountToUiAmountForMintWithoutSimulation, amountToUiAmountForScaledUiAmountMintWithoutSimulation, decodeMint, decodeMultisig, decodeToken, extension, fetchAllMaybeMint, fetchAllMaybeMultisig, fetchAllMaybeToken, fetchAllMint, fetchAllMultisig, fetchAllToken, fetchMaybeMint, fetchMaybeMultisig, fetchMaybeToken, fetchMint, fetchMultisig, fetchToken, findAssociatedTokenPda, getAccountStateCodec, getAccountStateDecoder, getAccountStateEncoder, getAmountToUiAmountDiscriminatorBytes, getAmountToUiAmountInstruction, getAmountToUiAmountInstructionDataCodec, getAmountToUiAmountInstructionDataDecoder, getAmountToUiAmountInstructionDataEncoder, getApplyConfidentialPendingBalanceConfidentialTransferDiscriminatorBytes, getApplyConfidentialPendingBalanceDiscriminatorBytes, getApplyConfidentialPendingBalanceInstruction, getApplyConfidentialPendingBalanceInstructionDataCodec, getApplyConfidentialPendingBalanceInstructionDataDecoder, getApplyConfidentialPendingBalanceInstructionDataEncoder, getApproveCheckedDiscriminatorBytes, getApproveCheckedInstruction, getApproveCheckedInstructionDataCodec, getApproveCheckedInstructionDataDecoder, getApproveCheckedInstructionDataEncoder, getApproveConfidentialTransferAccountConfidentialTransferDiscriminatorBytes, getApproveConfidentialTransferAccountDiscriminatorBytes, getApproveConfidentialTransferAccountInstruction, getApproveConfidentialTransferAccountInstructionDataCodec, getApproveConfidentialTransferAccountInstructionDataDecoder, getApproveConfidentialTransferAccountInstructionDataEncoder, getApproveDiscriminatorBytes, getApproveInstruction, getApproveInstructionDataCodec, getApproveInstructionDataDecoder, getApproveInstructionDataEncoder, getAssociatedTokenErrorMessage, getAuthorityTypeCodec, getAuthorityTypeDecoder, getAuthorityTypeEncoder, getBurnCheckedDiscriminatorBytes, getBurnCheckedInstruction, getBurnCheckedInstructionDataCodec, getBurnCheckedInstructionDataDecoder, getBurnCheckedInstructionDataEncoder, getBurnDiscriminatorBytes, getBurnInstruction, getBurnInstructionDataCodec, getBurnInstructionDataDecoder, getBurnInstructionDataEncoder, getCloseAccountDiscriminatorBytes, getCloseAccountInstruction, getCloseAccountInstructionDataCodec, getCloseAccountInstructionDataDecoder, getCloseAccountInstructionDataEncoder, getConfidentialDepositConfidentialTransferDiscriminatorBytes, getConfidentialDepositDiscriminatorBytes, getConfidentialDepositInstruction, getConfidentialDepositInstructionDataCodec, getConfidentialDepositInstructionDataDecoder, getConfidentialDepositInstructionDataEncoder, getConfidentialTransferConfidentialTransferDiscriminatorBytes, getConfidentialTransferDiscriminatorBytes, getConfidentialTransferInstruction, getConfidentialTransferInstructionDataCodec, getConfidentialTransferInstructionDataDecoder, getConfidentialTransferInstructionDataEncoder, getConfidentialTransferWithFeeConfidentialTransferDiscriminatorBytes, getConfidentialTransferWithFeeDiscriminatorBytes, getConfidentialTransferWithFeeInstruction, getConfidentialTransferWithFeeInstructionDataCodec, getConfidentialTransferWithFeeInstructionDataDecoder, getConfidentialTransferWithFeeInstructionDataEncoder, getConfidentialWithdrawConfidentialTransferDiscriminatorBytes, getConfidentialWithdrawDiscriminatorBytes, getConfidentialWithdrawInstruction, getConfidentialWithdrawInstructionDataCodec, getConfidentialWithdrawInstructionDataDecoder, getConfidentialWithdrawInstructionDataEncoder, getConfigureConfidentialTransferAccountConfidentialTransferDiscriminatorBytes, getConfigureConfidentialTransferAccountDiscriminatorBytes, getConfigureConfidentialTransferAccountInstruction, getConfigureConfidentialTransferAccountInstructionDataCodec, getConfigureConfidentialTransferAccountInstructionDataDecoder, getConfigureConfidentialTransferAccountInstructionDataEncoder, getCreateAssociatedTokenDiscriminatorBytes, getCreateAssociatedTokenIdempotentDiscriminatorBytes, getCreateAssociatedTokenIdempotentInstruction, getCreateAssociatedTokenIdempotentInstructionAsync, getCreateAssociatedTokenIdempotentInstructionDataCodec, getCreateAssociatedTokenIdempotentInstructionDataDecoder, getCreateAssociatedTokenIdempotentInstructionDataEncoder, getCreateAssociatedTokenInstruction, getCreateAssociatedTokenInstructionAsync, getCreateAssociatedTokenInstructionDataCodec, getCreateAssociatedTokenInstructionDataDecoder, getCreateAssociatedTokenInstructionDataEncoder, getCreateNativeMintDiscriminatorBytes, getCreateNativeMintInstruction, getCreateNativeMintInstructionDataCodec, getCreateNativeMintInstructionDataDecoder, getCreateNativeMintInstructionDataEncoder, getDecryptableBalanceCodec, getDecryptableBalanceDecoder, getDecryptableBalanceEncoder, getDisableConfidentialCreditsConfidentialTransferDiscriminatorBytes, getDisableConfidentialCreditsDiscriminatorBytes, getDisableConfidentialCreditsInstruction, getDisableConfidentialCreditsInstructionDataCodec, getDisableConfidentialCreditsInstructionDataDecoder, getDisableConfidentialCreditsInstructionDataEncoder, getDisableCpiGuardCpiGuardDiscriminatorBytes, getDisableCpiGuardDiscriminatorBytes, getDisableCpiGuardInstruction, getDisableCpiGuardInstructionDataCodec, getDisableCpiGuardInstructionDataDecoder, getDisableCpiGuardInstructionDataEncoder, getDisableHarvestToMintConfidentialTransferFeeDiscriminatorBytes, getDisableHarvestToMintDiscriminatorBytes, getDisableHarvestToMintInstruction, getDisableHarvestToMintInstructionDataCodec, getDisableHarvestToMintInstructionDataDecoder, getDisableHarvestToMintInstructionDataEncoder, getDisableMemoTransfersDiscriminatorBytes, getDisableMemoTransfersInstruction, getDisableMemoTransfersInstructionDataCodec, getDisableMemoTransfersInstructionDataDecoder, getDisableMemoTransfersInstructionDataEncoder, getDisableMemoTransfersMemoTransfersDiscriminatorBytes, getDisableNonConfidentialCreditsConfidentialTransferDiscriminatorBytes, getDisableNonConfidentialCreditsDiscriminatorBytes, getDisableNonConfidentialCreditsInstruction, getDisableNonConfidentialCreditsInstructionDataCodec, getDisableNonConfidentialCreditsInstructionDataDecoder, getDisableNonConfidentialCreditsInstructionDataEncoder, getEmitTokenMetadataDiscriminatorBytes, getEmitTokenMetadataInstruction, getEmitTokenMetadataInstructionDataCodec, getEmitTokenMetadataInstructionDataDecoder, getEmitTokenMetadataInstructionDataEncoder, getEmptyConfidentialTransferAccountConfidentialTransferDiscriminatorBytes, getEmptyConfidentialTransferAccountDiscriminatorBytes, getEmptyConfidentialTransferAccountInstruction, getEmptyConfidentialTransferAccountInstructionDataCodec, getEmptyConfidentialTransferAccountInstructionDataDecoder, getEmptyConfidentialTransferAccountInstructionDataEncoder, getEnableConfidentialCreditsConfidentialTransferDiscriminatorBytes, getEnableConfidentialCreditsDiscriminatorBytes, getEnableConfidentialCreditsInstruction, getEnableConfidentialCreditsInstructionDataCodec, getEnableConfidentialCreditsInstructionDataDecoder, getEnableConfidentialCreditsInstructionDataEncoder, getEnableCpiGuardCpiGuardDiscriminatorBytes, getEnableCpiGuardDiscriminatorBytes, getEnableCpiGuardInstruction, getEnableCpiGuardInstructionDataCodec, getEnableCpiGuardInstructionDataDecoder, getEnableCpiGuardInstructionDataEncoder, getEnableHarvestToMintConfidentialTransferFeeDiscriminatorBytes, getEnableHarvestToMintDiscriminatorBytes, getEnableHarvestToMintInstruction, getEnableHarvestToMintInstructionDataCodec, getEnableHarvestToMintInstructionDataDecoder, getEnableHarvestToMintInstructionDataEncoder, getEnableMemoTransfersDiscriminatorBytes, getEnableMemoTransfersInstruction, getEnableMemoTransfersInstructionDataCodec, getEnableMemoTransfersInstructionDataDecoder, getEnableMemoTransfersInstructionDataEncoder, getEnableMemoTransfersMemoTransfersDiscriminatorBytes, getEnableNonConfidentialCreditsConfidentialTransferDiscriminatorBytes, getEnableNonConfidentialCreditsDiscriminatorBytes, getEnableNonConfidentialCreditsInstruction, getEnableNonConfidentialCreditsInstructionDataCodec, getEnableNonConfidentialCreditsInstructionDataDecoder, getEnableNonConfidentialCreditsInstructionDataEncoder, getEncryptedBalanceCodec, getEncryptedBalanceDecoder, getEncryptedBalanceEncoder, getExtensionCodec, getExtensionDecoder, getExtensionEncoder, getExtensionTypeCodec, getExtensionTypeDecoder, getExtensionTypeEncoder, getFreezeAccountDiscriminatorBytes, getFreezeAccountInstruction, getFreezeAccountInstructionDataCodec, getFreezeAccountInstructionDataDecoder, getFreezeAccountInstructionDataEncoder, getGetAccountDataSizeDiscriminatorBytes, getGetAccountDataSizeInstruction, getGetAccountDataSizeInstructionDataCodec, getGetAccountDataSizeInstructionDataDecoder, getGetAccountDataSizeInstructionDataEncoder, getHarvestWithheldTokensToMintDiscriminatorBytes, getHarvestWithheldTokensToMintForConfidentialTransferFeeConfidentialTransferFeeDiscriminatorBytes, getHarvestWithheldTokensToMintForConfidentialTransferFeeDiscriminatorBytes, getHarvestWithheldTokensToMintForConfidentialTransferFeeInstruction, getHarvestWithheldTokensToMintForConfidentialTransferFeeInstructionDataCodec, getHarvestWithheldTokensToMintForConfidentialTransferFeeInstructionDataDecoder, getHarvestWithheldTokensToMintForConfidentialTransferFeeInstructionDataEncoder, getHarvestWithheldTokensToMintInstruction, getHarvestWithheldTokensToMintInstructionDataCodec, getHarvestWithheldTokensToMintInstructionDataDecoder, getHarvestWithheldTokensToMintInstructionDataEncoder, getHarvestWithheldTokensToMintTransferFeeDiscriminatorBytes, getInitializeAccount2DiscriminatorBytes, getInitializeAccount2Instruction, getInitializeAccount2InstructionDataCodec, getInitializeAccount2InstructionDataDecoder, getInitializeAccount2InstructionDataEncoder, getInitializeAccount3DiscriminatorBytes, getInitializeAccount3Instruction, getInitializeAccount3InstructionDataCodec, getInitializeAccount3InstructionDataDecoder, getInitializeAccount3InstructionDataEncoder, getInitializeAccountDiscriminatorBytes, getInitializeAccountInstruction, getInitializeAccountInstructionDataCodec, getInitializeAccountInstructionDataDecoder, getInitializeAccountInstructionDataEncoder, getInitializeConfidentialTransferFeeConfidentialTransferFeeDiscriminatorBytes, getInitializeConfidentialTransferFeeDiscriminatorBytes, getInitializeConfidentialTransferFeeInstruction, getInitializeConfidentialTransferFeeInstructionDataCodec, getInitializeConfidentialTransferFeeInstructionDataDecoder, getInitializeConfidentialTransferFeeInstructionDataEncoder, getInitializeConfidentialTransferMintConfidentialTransferDiscriminatorBytes, getInitializeConfidentialTransferMintDiscriminatorBytes, getInitializeConfidentialTransferMintInstruction, getInitializeConfidentialTransferMintInstructionDataCodec, getInitializeConfidentialTransferMintInstructionDataDecoder, getInitializeConfidentialTransferMintInstructionDataEncoder, getInitializeDefaultAccountStateDefaultAccountStateDiscriminatorBytes, getInitializeDefaultAccountStateDiscriminatorBytes, getInitializeDefaultAccountStateInstruction, getInitializeDefaultAccountStateInstructionDataCodec, getInitializeDefaultAccountStateInstructionDataDecoder, getInitializeDefaultAccountStateInstructionDataEncoder, getInitializeGroupMemberPointerDiscriminatorBytes, getInitializeGroupMemberPointerGroupMemberPointerDiscriminatorBytes, getInitializeGroupMemberPointerInstruction, getInitializeGroupMemberPointerInstructionDataCodec, getInitializeGroupMemberPointerInstructionDataDecoder, getInitializeGroupMemberPointerInstructionDataEncoder, getInitializeGroupPointerDiscriminatorBytes, getInitializeGroupPointerGroupPointerDiscriminatorBytes, getInitializeGroupPointerInstruction, getInitializeGroupPointerInstructionDataCodec, getInitializeGroupPointerInstructionDataDecoder, getInitializeGroupPointerInstructionDataEncoder, getInitializeImmutableOwnerDiscriminatorBytes, getInitializeImmutableOwnerInstruction, getInitializeImmutableOwnerInstructionDataCodec, getInitializeImmutableOwnerInstructionDataDecoder, getInitializeImmutableOwnerInstructionDataEncoder, getInitializeInterestBearingMintDiscriminatorBytes, getInitializeInterestBearingMintInstruction, getInitializeInterestBearingMintInstructionDataCodec, getInitializeInterestBearingMintInstructionDataDecoder, getInitializeInterestBearingMintInstructionDataEncoder, getInitializeInterestBearingMintInterestBearingMintDiscriminatorBytes, getInitializeMetadataPointerDiscriminatorBytes, getInitializeMetadataPointerInstruction, getInitializeMetadataPointerInstructionDataCodec, getInitializeMetadataPointerInstructionDataDecoder, getInitializeMetadataPointerInstructionDataEncoder, getInitializeMetadataPointerMetadataPointerDiscriminatorBytes, getInitializeMint2DiscriminatorBytes, getInitializeMint2Instruction, getInitializeMint2InstructionDataCodec, getInitializeMint2InstructionDataDecoder, getInitializeMint2InstructionDataEncoder, getInitializeMintCloseAuthorityDiscriminatorBytes, getInitializeMintCloseAuthorityInstruction, getInitializeMintCloseAuthorityInstructionDataCodec, getInitializeMintCloseAuthorityInstructionDataDecoder, getInitializeMintCloseAuthorityInstructionDataEncoder, getInitializeMintDiscriminatorBytes, getInitializeMintInstruction, getInitializeMintInstructionDataCodec, getInitializeMintInstructionDataDecoder, getInitializeMintInstructionDataEncoder, getInitializeMultisig2DiscriminatorBytes, getInitializeMultisig2Instruction, getInitializeMultisig2InstructionDataCodec, getInitializeMultisig2InstructionDataDecoder, getInitializeMultisig2InstructionDataEncoder, getInitializeMultisigDiscriminatorBytes, getInitializeMultisigInstruction, getInitializeMultisigInstructionDataCodec, getInitializeMultisigInstructionDataDecoder, getInitializeMultisigInstructionDataEncoder, getInitializeNonTransferableMintDiscriminatorBytes, getInitializeNonTransferableMintInstruction, getInitializeNonTransferableMintInstructionDataCodec, getInitializeNonTransferableMintInstructionDataDecoder, getInitializeNonTransferableMintInstructionDataEncoder, getInitializePausableConfigDiscriminatorBytes, getInitializePausableConfigInstruction, getInitializePausableConfigInstructionDataCodec, getInitializePausableConfigInstructionDataDecoder, getInitializePausableConfigInstructionDataEncoder, getInitializePausableConfigPausableDiscriminatorBytes, getInitializePermanentDelegateDiscriminatorBytes, getInitializePermanentDelegateInstruction, getInitializePermanentDelegateInstructionDataCodec, getInitializePermanentDelegateInstructionDataDecoder, getInitializePermanentDelegateInstructionDataEncoder, getInitializeScaledUiAmountMintDiscriminatorBytes, getInitializeScaledUiAmountMintInstruction, getInitializeScaledUiAmountMintInstructionDataCodec, getInitializeScaledUiAmountMintInstructionDataDecoder, getInitializeScaledUiAmountMintInstructionDataEncoder, getInitializeScaledUiAmountMintScaledUiAmountMintDiscriminatorBytes, getInitializeTokenGroupDiscriminatorBytes, getInitializeTokenGroupInstruction, getInitializeTokenGroupInstructionDataCodec, getInitializeTokenGroupInstructionDataDecoder, getInitializeTokenGroupInstructionDataEncoder, getInitializeTokenGroupMemberDiscriminatorBytes, getInitializeTokenGroupMemberInstruction, getInitializeTokenGroupMemberInstructionDataCodec, getInitializeTokenGroupMemberInstructionDataDecoder, getInitializeTokenGroupMemberInstructionDataEncoder, getInitializeTokenMetadataDiscriminatorBytes, getInitializeTokenMetadataInstruction, getInitializeTokenMetadataInstructionDataCodec, getInitializeTokenMetadataInstructionDataDecoder, getInitializeTokenMetadataInstructionDataEncoder, getInitializeTransferFeeConfigDiscriminatorBytes, getInitializeTransferFeeConfigInstruction, getInitializeTransferFeeConfigInstructionDataCodec, getInitializeTransferFeeConfigInstructionDataDecoder, getInitializeTransferFeeConfigInstructionDataEncoder, getInitializeTransferFeeConfigTransferFeeDiscriminatorBytes, getInitializeTransferHookDiscriminatorBytes, getInitializeTransferHookInstruction, getInitializeTransferHookInstructionDataCodec, getInitializeTransferHookInstructionDataDecoder, getInitializeTransferHookInstructionDataEncoder, getInitializeTransferHookTransferHookDiscriminatorBytes, getMintCodec, getMintDecoder, getMintEncoder, getMintSize, getMintToCheckedDiscriminatorBytes, getMintToCheckedInstruction, getMintToCheckedInstructionDataCodec, getMintToCheckedInstructionDataDecoder, getMintToCheckedInstructionDataEncoder, getMintToDiscriminatorBytes, getMintToInstruction, getMintToInstructionDataCodec, getMintToInstructionDataDecoder, getMintToInstructionDataEncoder, getMultisigCodec, getMultisigDecoder, getMultisigEncoder, getMultisigSize, getPauseDiscriminatorBytes, getPauseInstruction, getPauseInstructionDataCodec, getPauseInstructionDataDecoder, getPauseInstructionDataEncoder, getPausePausableDiscriminatorBytes, getPostInitializeInstructionsForMintExtensions, getPostInitializeInstructionsForTokenExtensions, getPreInitializeInstructionsForMintExtensions, getReallocateDiscriminatorBytes, getReallocateInstruction, getReallocateInstructionDataCodec, getReallocateInstructionDataDecoder, getReallocateInstructionDataEncoder, getRecoverNestedAssociatedTokenDiscriminatorBytes, getRecoverNestedAssociatedTokenInstruction, getRecoverNestedAssociatedTokenInstructionAsync, getRecoverNestedAssociatedTokenInstructionDataCodec, getRecoverNestedAssociatedTokenInstructionDataDecoder, getRecoverNestedAssociatedTokenInstructionDataEncoder, getRemoveTokenMetadataKeyDiscriminatorBytes, getRemoveTokenMetadataKeyInstruction, getRemoveTokenMetadataKeyInstructionDataCodec, getRemoveTokenMetadataKeyInstructionDataDecoder, getRemoveTokenMetadataKeyInstructionDataEncoder, getResumeDiscriminatorBytes, getResumeInstruction, getResumeInstructionDataCodec, getResumeInstructionDataDecoder, getResumeInstructionDataEncoder, getResumePausableDiscriminatorBytes, getRevokeDiscriminatorBytes, getRevokeInstruction, getRevokeInstructionDataCodec, getRevokeInstructionDataDecoder, getRevokeInstructionDataEncoder, getSetAuthorityDiscriminatorBytes, getSetAuthorityInstruction, getSetAuthorityInstructionDataCodec, getSetAuthorityInstructionDataDecoder, getSetAuthorityInstructionDataEncoder, getSetTransferFeeDiscriminatorBytes, getSetTransferFeeInstruction, getSetTransferFeeInstructionDataCodec, getSetTransferFeeInstructionDataDecoder, getSetTransferFeeInstructionDataEncoder, getSetTransferFeeTransferFeeDiscriminatorBytes, getSyncNativeDiscriminatorBytes, getSyncNativeInstruction, getSyncNativeInstructionDataCodec, getSyncNativeInstructionDataDecoder, getSyncNativeInstructionDataEncoder, getThawAccountDiscriminatorBytes, getThawAccountInstruction, getThawAccountInstructionDataCodec, getThawAccountInstructionDataDecoder, getThawAccountInstructionDataEncoder, getToken2022ErrorMessage, getTokenCodec, getTokenDecoder, getTokenEncoder, getTokenMetadataFieldCodec, getTokenMetadataFieldDecoder, getTokenMetadataFieldEncoder, getTokenSize, getTransferCheckedDiscriminatorBytes, getTransferCheckedInstruction, getTransferCheckedInstructionDataCodec, getTransferCheckedInstructionDataDecoder, getTransferCheckedInstructionDataEncoder, getTransferCheckedWithFeeDiscriminatorBytes, getTransferCheckedWithFeeInstruction, getTransferCheckedWithFeeInstructionDataCodec, getTransferCheckedWithFeeInstructionDataDecoder, getTransferCheckedWithFeeInstructionDataEncoder, getTransferCheckedWithFeeTransferFeeDiscriminatorBytes, getTransferDiscriminatorBytes, getTransferFeeCodec, getTransferFeeDecoder, getTransferFeeEncoder, getTransferInstruction, getTransferInstructionDataCodec, getTransferInstructionDataDecoder, getTransferInstructionDataEncoder, getUiAmountToAmountDiscriminatorBytes, getUiAmountToAmountInstruction, getUiAmountToAmountInstructionDataCodec, getUiAmountToAmountInstructionDataDecoder, getUiAmountToAmountInstructionDataEncoder, getUpdateConfidentialTransferMintConfidentialTransferDiscriminatorBytes, getUpdateConfidentialTransferMintDiscriminatorBytes, getUpdateConfidentialTransferMintInstruction, getUpdateConfidentialTransferMintInstructionDataCodec, getUpdateConfidentialTransferMintInstructionDataDecoder, getUpdateConfidentialTransferMintInstructionDataEncoder, getUpdateDefaultAccountStateDefaultAccountStateDiscriminatorBytes, getUpdateDefaultAccountStateDiscriminatorBytes, getUpdateDefaultAccountStateInstruction, getUpdateDefaultAccountStateInstructionDataCodec, getUpdateDefaultAccountStateInstructionDataDecoder, getUpdateDefaultAccountStateInstructionDataEncoder, getUpdateGroupMemberPointerDiscriminatorBytes, getUpdateGroupMemberPointerGroupMemberPointerDiscriminatorBytes, getUpdateGroupMemberPointerInstruction, getUpdateGroupMemberPointerInstructionDataCodec, getUpdateGroupMemberPointerInstructionDataDecoder, getUpdateGroupMemberPointerInstructionDataEncoder, getUpdateGroupPointerDiscriminatorBytes, getUpdateGroupPointerGroupPointerDiscriminatorBytes, getUpdateGroupPointerInstruction, getUpdateGroupPointerInstructionDataCodec, getUpdateGroupPointerInstructionDataDecoder, getUpdateGroupPointerInstructionDataEncoder, getUpdateMetadataPointerDiscriminatorBytes, getUpdateMetadataPointerInstruction, getUpdateMetadataPointerInstructionDataCodec, getUpdateMetadataPointerInstructionDataDecoder, getUpdateMetadataPointerInstructionDataEncoder, getUpdateMetadataPointerMetadataPointerDiscriminatorBytes, getUpdateMultiplierScaledUiMintDiscriminatorBytes, getUpdateMultiplierScaledUiMintInstruction, getUpdateMultiplierScaledUiMintInstructionDataCodec, getUpdateMultiplierScaledUiMintInstructionDataDecoder, getUpdateMultiplierScaledUiMintInstructionDataEncoder, getUpdateMultiplierScaledUiMintScaledUiAmountMintDiscriminatorBytes, getUpdateRateInterestBearingMintDiscriminatorBytes, getUpdateRateInterestBearingMintInstruction, getUpdateRateInterestBearingMintInstructionDataCodec, getUpdateRateInterestBearingMintInstructionDataDecoder, getUpdateRateInterestBearingMintInstructionDataEncoder, getUpdateRateInterestBearingMintInterestBearingMintDiscriminatorBytes, getUpdateTokenGroupMaxSizeDiscriminatorBytes, getUpdateTokenGroupMaxSizeInstruction, getUpdateTokenGroupMaxSizeInstructionDataCodec, getUpdateTokenGroupMaxSizeInstructionDataDecoder, getUpdateTokenGroupMaxSizeInstructionDataEncoder, getUpdateTokenGroupUpdateAuthorityDiscriminatorBytes, getUpdateTokenGroupUpdateAuthorityInstruction, getUpdateTokenGroupUpdateAuthorityInstructionDataCodec, getUpdateTokenGroupUpdateAuthorityInstructionDataDecoder, getUpdateTokenGroupUpdateAuthorityInstructionDataEncoder, getUpdateTokenMetadataFieldDiscriminatorBytes, getUpdateTokenMetadataFieldInstruction, getUpdateTokenMetadataFieldInstructionDataCodec, getUpdateTokenMetadataFieldInstructionDataDecoder, getUpdateTokenMetadataFieldInstructionDataEncoder, getUpdateTokenMetadataUpdateAuthorityDiscriminatorBytes, getUpdateTokenMetadataUpdateAuthorityInstruction, getUpdateTokenMetadataUpdateAuthorityInstructionDataCodec, getUpdateTokenMetadataUpdateAuthorityInstructionDataDecoder, getUpdateTokenMetadataUpdateAuthorityInstructionDataEncoder, getUpdateTransferHookDiscriminatorBytes, getUpdateTransferHookInstruction, getUpdateTransferHookInstructionDataCodec, getUpdateTransferHookInstructionDataDecoder, getUpdateTransferHookInstructionDataEncoder, getUpdateTransferHookTransferHookDiscriminatorBytes, getWithdrawExcessLamportsDiscriminatorBytes, getWithdrawExcessLamportsInstruction, getWithdrawExcessLamportsInstructionDataCodec, getWithdrawExcessLamportsInstructionDataDecoder, getWithdrawExcessLamportsInstructionDataEncoder, getWithdrawWithheldTokensFromAccountsDiscriminatorBytes, getWithdrawWithheldTokensFromAccountsForConfidentialTransferFeeConfidentialTransferFeeDiscriminatorBytes, getWithdrawWithheldTokensFromAccountsForConfidentialTransferFeeDiscriminatorBytes, getWithdrawWithheldTokensFromAccountsForConfidentialTransferFeeInstruction, getWithdrawWithheldTokensFromAccountsForConfidentialTransferFeeInstructionDataCodec, getWithdrawWithheldTokensFromAccountsForConfidentialTransferFeeInstructionDataDecoder, getWithdrawWithheldTokensFromAccountsForConfidentialTransferFeeInstructionDataEncoder, getWithdrawWithheldTokensFromAccountsInstruction, getWithdrawWithheldTokensFromAccountsInstructionDataCodec, getWithdrawWithheldTokensFromAccountsInstructionDataDecoder, getWithdrawWithheldTokensFromAccountsInstructionDataEncoder, getWithdrawWithheldTokensFromAccountsTransferFeeDiscriminatorBytes, getWithdrawWithheldTokensFromMintDiscriminatorBytes, getWithdrawWithheldTokensFromMintForConfidentialTransferFeeConfidentialTransferFeeDiscriminatorBytes, getWithdrawWithheldTokensFromMintForConfidentialTransferFeeDiscriminatorBytes, getWithdrawWithheldTokensFromMintForConfidentialTransferFeeInstruction, getWithdrawWithheldTokensFromMintForConfidentialTransferFeeInstructionDataCodec, getWithdrawWithheldTokensFromMintForConfidentialTransferFeeInstructionDataDecoder, getWithdrawWithheldTokensFromMintForConfidentialTransferFeeInstructionDataEncoder, getWithdrawWithheldTokensFromMintInstruction, getWithdrawWithheldTokensFromMintInstructionDataCodec, getWithdrawWithheldTokensFromMintInstructionDataDecoder, getWithdrawWithheldTokensFromMintInstructionDataEncoder, getWithdrawWithheldTokensFromMintTransferFeeDiscriminatorBytes, identifyAssociatedTokenInstruction, identifyToken2022Account, identifyToken2022Instruction, isAssociatedTokenError, isExtension, isToken2022Error, isTokenMetadataField, parseAmountToUiAmountInstruction, parseApplyConfidentialPendingBalanceInstruction, parseApproveCheckedInstruction, parseApproveConfidentialTransferAccountInstruction, parseApproveInstruction, parseBurnCheckedInstruction, parseBurnInstruction, parseCloseAccountInstruction, parseConfidentialDepositInstruction, parseConfidentialTransferInstruction, parseConfidentialTransferWithFeeInstruction, parseConfidentialWithdrawInstruction, parseConfigureConfidentialTransferAccountInstruction, parseCreateAssociatedTokenIdempotentInstruction, parseCreateAssociatedTokenInstruction, parseCreateNativeMintInstruction, parseDisableConfidentialCreditsInstruction, parseDisableCpiGuardInstruction, parseDisableHarvestToMintInstruction, parseDisableMemoTransfersInstruction, parseDisableNonConfidentialCreditsInstruction, parseEmitTokenMetadataInstruction, parseEmptyConfidentialTransferAccountInstruction, parseEnableConfidentialCreditsInstruction, parseEnableCpiGuardInstruction, parseEnableHarvestToMintInstruction, parseEnableMemoTransfersInstruction, parseEnableNonConfidentialCreditsInstruction, parseFreezeAccountInstruction, parseGetAccountDataSizeInstruction, parseHarvestWithheldTokensToMintForConfidentialTransferFeeInstruction, parseHarvestWithheldTokensToMintInstruction, parseInitializeAccount2Instruction, parseInitializeAccount3Instruction, parseInitializeAccountInstruction, parseInitializeConfidentialTransferFeeInstruction, parseInitializeConfidentialTransferMintInstruction, parseInitializeDefaultAccountStateInstruction, parseInitializeGroupMemberPointerInstruction, parseInitializeGroupPointerInstruction, parseInitializeImmutableOwnerInstruction, parseInitializeInterestBearingMintInstruction, parseInitializeMetadataPointerInstruction, parseInitializeMint2Instruction, parseInitializeMintCloseAuthorityInstruction, parseInitializeMintInstruction, parseInitializeMultisig2Instruction, parseInitializeMultisigInstruction, parseInitializeNonTransferableMintInstruction, parseInitializePausableConfigInstruction, parseInitializePermanentDelegateInstruction, parseInitializeScaledUiAmountMintInstruction, parseInitializeTokenGroupInstruction, parseInitializeTokenGroupMemberInstruction, parseInitializeTokenMetadataInstruction, parseInitializeTransferFeeConfigInstruction, parseInitializeTransferHookInstruction, parseMintToCheckedInstruction, parseMintToInstruction, parsePauseInstruction, parseReallocateInstruction, parseRecoverNestedAssociatedTokenInstruction, parseRemoveTokenMetadataKeyInstruction, parseResumeInstruction, parseRevokeInstruction, parseSetAuthorityInstruction, parseSetTransferFeeInstruction, parseSyncNativeInstruction, parseThawAccountInstruction, parseTransferCheckedInstruction, parseTransferCheckedWithFeeInstruction, parseTransferInstruction, parseUiAmountToAmountInstruction, parseUpdateConfidentialTransferMintInstruction, parseUpdateDefaultAccountStateInstruction, parseUpdateGroupMemberPointerInstruction, parseUpdateGroupPointerInstruction, parseUpdateMetadataPointerInstruction, parseUpdateMultiplierScaledUiMintInstruction, parseUpdateRateInterestBearingMintInstruction, parseUpdateTokenGroupMaxSizeInstruction, parseUpdateTokenGroupUpdateAuthorityInstruction, parseUpdateTokenMetadataFieldInstruction, parseUpdateTokenMetadataUpdateAuthorityInstruction, parseUpdateTransferHookInstruction, parseWithdrawExcessLamportsInstruction, parseWithdrawWithheldTokensFromAccountsForConfidentialTransferFeeInstruction, parseWithdrawWithheldTokensFromAccountsInstruction, parseWithdrawWithheldTokensFromMintForConfidentialTransferFeeInstruction, parseWithdrawWithheldTokensFromMintInstruction, tokenMetadataField, uiAmountToAmountForInterestBearingMintWithoutSimulation, uiAmountToAmountForMintWithoutSimulation, uiAmountToAmountForScaledUiAmountMintWithoutSimulation };
//# sourceMappingURL=index.mjs.map
//# sourceMappingURL=index.mjs.map