/**
 * This code was AUTOGENERATED using the codama library.
 * Please DO NOT EDIT THIS FILE, instead use visitors
 * to add features, then rerun codama to update it.
 *
 * @see https://github.com/codama-idl/codama
 */
import { type Address, type Codec, type Decoder, type Encoder, type IAccountMeta, type IAccountSignerMeta, type IInstruction, type IInstructionWithAccounts, type IInstructionWithData, type ReadonlyAccount, type ReadonlySignerAccount, type TransactionSigner, type WritableAccount } from '@solana/kit';
import { STAKE_PROGRAM_ADDRESS } from '../programs';
export declare const WITHDRAW_DISCRIMINATOR = 4;
export declare function getWithdrawDiscriminatorBytes(): import("@solana/kit").ReadonlyUint8Array;
export type WithdrawInstruction<TProgram extends string = typeof STAKE_PROGRAM_ADDRESS, TAccountStake extends string | IAccountMeta<string> = string, TAccountRecipient extends string | IAccountMeta<string> = string, TAccountClockSysvar extends string | IAccountMeta<string> = 'SysvarC1ock11111111111111111111111111111111', TAccountStakeHistory extends string | IAccountMeta<string> = string, TAccountWithdrawAuthority extends string | IAccountMeta<string> = string, TAccountLockupAuthority extends string | IAccountMeta<string> | undefined = undefined, TRemainingAccounts extends readonly IAccountMeta<string>[] = []> = IInstruction<TProgram> & IInstructionWithData<Uint8Array> & IInstructionWithAccounts<[
    TAccountStake extends string ? WritableAccount<TAccountStake> : TAccountStake,
    TAccountRecipient extends string ? WritableAccount<TAccountRecipient> : TAccountRecipient,
    TAccountClockSysvar extends string ? ReadonlyAccount<TAccountClockSysvar> : TAccountClockSysvar,
    TAccountStakeHistory extends string ? ReadonlyAccount<TAccountStakeHistory> : TAccountStakeHistory,
    TAccountWithdrawAuthority extends string ? ReadonlySignerAccount<TAccountWithdrawAuthority> & IAccountSignerMeta<TAccountWithdrawAuthority> : TAccountWithdrawAuthority,
    ...(TAccountLockupAuthority extends undefined ? [] : [
        TAccountLockupAuthority extends string ? ReadonlySignerAccount<TAccountLockupAuthority> & IAccountSignerMeta<TAccountLockupAuthority> : TAccountLockupAuthority
    ]),
    ...TRemainingAccounts
]>;
export type WithdrawInstructionData = {
    discriminator: number;
    args: bigint;
};
export type WithdrawInstructionDataArgs = {
    args: number | bigint;
};
export declare function getWithdrawInstructionDataEncoder(): Encoder<WithdrawInstructionDataArgs>;
export declare function getWithdrawInstructionDataDecoder(): Decoder<WithdrawInstructionData>;
export declare function getWithdrawInstructionDataCodec(): Codec<WithdrawInstructionDataArgs, WithdrawInstructionData>;
export type WithdrawInput<TAccountStake extends string = string, TAccountRecipient extends string = string, TAccountClockSysvar extends string = string, TAccountStakeHistory extends string = string, TAccountWithdrawAuthority extends string = string, TAccountLockupAuthority extends string = string> = {
    /** Stake account from which to withdraw */
    stake: Address<TAccountStake>;
    /** Recipient account */
    recipient: Address<TAccountRecipient>;
    /** Clock sysvar */
    clockSysvar?: Address<TAccountClockSysvar>;
    /** Stake history sysvar */
    stakeHistory: Address<TAccountStakeHistory>;
    /** Withdraw authority */
    withdrawAuthority: TransactionSigner<TAccountWithdrawAuthority>;
    /** Lockup authority */
    lockupAuthority?: TransactionSigner<TAccountLockupAuthority>;
    args: WithdrawInstructionDataArgs['args'];
};
export declare function getWithdrawInstruction<TAccountStake extends string, TAccountRecipient extends string, TAccountClockSysvar extends string, TAccountStakeHistory extends string, TAccountWithdrawAuthority extends string, TAccountLockupAuthority extends string, TProgramAddress extends Address = typeof STAKE_PROGRAM_ADDRESS>(input: WithdrawInput<TAccountStake, TAccountRecipient, TAccountClockSysvar, TAccountStakeHistory, TAccountWithdrawAuthority, TAccountLockupAuthority>, config?: {
    programAddress?: TProgramAddress;
}): WithdrawInstruction<TProgramAddress, TAccountStake, TAccountRecipient, TAccountClockSysvar, TAccountStakeHistory, TAccountWithdrawAuthority, TAccountLockupAuthority>;
export type ParsedWithdrawInstruction<TProgram extends string = typeof STAKE_PROGRAM_ADDRESS, TAccountMetas extends readonly IAccountMeta[] = readonly IAccountMeta[]> = {
    programAddress: Address<TProgram>;
    accounts: {
        /** Stake account from which to withdraw */
        stake: TAccountMetas[0];
        /** Recipient account */
        recipient: TAccountMetas[1];
        /** Clock sysvar */
        clockSysvar: TAccountMetas[2];
        /** Stake history sysvar */
        stakeHistory: TAccountMetas[3];
        /** Withdraw authority */
        withdrawAuthority: TAccountMetas[4];
        /** Lockup authority */
        lockupAuthority?: TAccountMetas[5] | undefined;
    };
    data: WithdrawInstructionData;
};
export declare function parseWithdrawInstruction<TProgram extends string, TAccountMetas extends readonly IAccountMeta[]>(instruction: IInstruction<TProgram> & IInstructionWithAccounts<TAccountMetas> & IInstructionWithData<Uint8Array>): ParsedWithdrawInstruction<TProgram, TAccountMetas>;
//# sourceMappingURL=withdraw.d.ts.map