/// <reference types="node" />
/// <reference types="node" />
/**
 */
export interface TransactionInput {
    prevout: Buffer;
    script: Buffer;
    sequence: Buffer;
    tree?: Buffer;
}
/**
 */
export interface TransactionOutput {
    amount: Buffer;
    script: Buffer;
}
/**
 */
export interface Transaction {
    version: Buffer;
    inputs: TransactionInput[];
    outputs?: TransactionOutput[];
    locktime?: Buffer;
    witness?: Buffer;
    timestamp?: Buffer;
    nVersionGroupId?: Buffer;
    nExpiryHeight?: Buffer;
    extraData?: Buffer;
    consensusBranchId?: Buffer;
    sapling?: SaplingData;
    orchard?: OrchardData;
}
export interface TrustedInput {
    trustedInput: boolean;
    value: Buffer;
    sequence: Buffer;
}
/**
 */
export interface SaplingData {
    vSpendsSapling: SaplingSpendDescriptionV5[];
    vOutputSapling: SaplingOutputDescriptionV5[];
    valueBalanceSapling: Buffer;
    anchorSapling: Buffer;
    vSpendProofsSapling: Buffer;
    vSpendAuthSigsSapling: Buffer;
    vOutputProofsSapling: Buffer;
    bindingSigSapling: Buffer;
}
export interface SaplingSpendDescriptionV5 {
    cv: Buffer;
    nullifier: Buffer;
    rk: Buffer;
}
export interface SaplingOutputDescriptionV5 {
    cv: Buffer;
    cmu: Buffer;
    ephemeralKey: Buffer;
    encCiphertext: Buffer;
    outCiphertext: Buffer;
}
export interface OrchardAction {
    cv: Buffer;
    nullifier: Buffer;
    rk: Buffer;
    cmx: Buffer;
    ephemeralKey: Buffer;
    encCiphertext: Buffer;
    outCiphertext: Buffer;
}
export interface OrchardData {
    vActions: OrchardAction[];
    flags: Buffer;
    valueBalance: Buffer;
    anchor: Buffer;
    sizeProofs: Buffer;
    proofs: Buffer;
    vSpendsAuthSigs: Buffer;
    bindingSig: Buffer;
}
//# sourceMappingURL=types.d.ts.map