"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getWalletPublicKey = void 0;
const bip32_1 = require("./bip32");
const addressFormatMap = {
    legacy: 0,
    p2sh: 1,
    bech32: 2,
    cashaddr: 3,
};
async function getWalletPublicKey(transport, options) {
    const { path, verify, format } = {
        verify: false,
        format: "legacy",
        ...options,
    };
    if (!(format in addressFormatMap)) {
        throw new Error("btc.getWalletPublicKey invalid format=" + format);
    }
    const buffer = (0, bip32_1.bip32asBuffer)(path);
    const p1 = verify ? 1 : 0;
    const p2 = addressFormatMap[format];
    const response = await transport.send(0xe0, 0x40, p1, p2, buffer);
    const publicKeyLength = response[0];
    const addressLength = response[1 + publicKeyLength];
    const publicKey = response.slice(1, 1 + publicKeyLength).toString("hex");
    const bitcoinAddress = response
        .slice(1 + publicKeyLength + 1, 1 + publicKeyLength + 1 + addressLength)
        .toString("ascii");
    const chainCode = response
        .slice(1 + publicKeyLength + 1 + addressLength, 1 + publicKeyLength + 1 + addressLength + 32)
        .toString("hex");
    return {
        publicKey,
        bitcoinAddress,
        chainCode,
    };
}
exports.getWalletPublicKey = getWalletPublicKey;
//# sourceMappingURL=getWalletPublicKey.js.map