/// <reference types="node" />
export declare namespace encoder {
    const encodeBase64: (data: string | ArrayBuffer | NodeJS.TypedArray) => string;
    const decodeBase64: (str: string) => string | Uint8Array;
    const encodeBase64Url: (data: ArrayBuffer | Uint8Array) => string;
    const decodeBase64Url: (str: string) => string | Uint8Array;
    const arrayBufferToHexString: (data: ArrayBuffer | NodeJS.TypedArray) => string;
    const hexStringToArrayBuffer: (str: string) => Uint8Array;
    const stringToArrayBuffer: (str: string) => Uint8Array;
    const arrayBufferToString: (data: ArrayBuffer | NodeJS.TypedArray) => string;
}
export declare namespace formatter {
    const binToPem: (keydata: ArrayBuffer | NodeJS.TypedArray, type: "certificate" | "private" | "public" | "encryptedPrivate" | "certRequest") => string;
    const pemToBin: (keydataB64Pem: string) => string | Uint8Array;
}
declare const _default: {
    encoder: typeof encoder;
    formatter: typeof formatter;
};
export default _default;
