/**
 * encoder.js
 */
/// <reference types="node" />
import TypedArray = NodeJS.TypedArray;
/**
 * Encode ArrayBuffer or TypedArray To Base64
 * @param data
 * @return {*}
 */
export declare const encodeBase64: (data: string | ArrayBuffer | TypedArray) => string;
/**
 * Decode Base64 to Uint8Array
 * @param str
 * @return {Uint8Array|string|*}
 */
export declare const decodeBase64: (str: string) => Uint8Array | string;
/**
 * Encode ArrayBuffer or TypedArray to base64url string
 * @param data
 * @return {string}
 */
export declare const encodeBase64Url: (data: ArrayBuffer | Uint8Array) => string;
/**
 * Decode Base64Url string to Uint8Array
 * @param str
 * @return {Uint8Array}
 */
export declare const decodeBase64Url: (str: string) => string | Uint8Array;
/**
 * Encode ArrayBuffer or TypedArray to hex string
 * @param data
 * @return {string}
 */
export declare const arrayBufferToHexString: (data: ArrayBuffer | TypedArray) => string;
/**
 * Decode hex string to Uint8Array
 * @param str
 * @return {Uint8Array}
 */
export declare const hexStringToArrayBuffer: (str: string) => Uint8Array;
/**
 * Encode ArrayBuffer or TypedArray to string with code (like output of legacy atob)
 * @param data
 * @return {string}
 */
export declare const arrayBufferToString: (data: ArrayBuffer | TypedArray) => string;
/**
 * Decode string with code (like output of legacy atob) to Uint8Array
 * @param str
 * @return {Uint8Array}
 */
export declare const stringToArrayBuffer: (str: string) => Uint8Array;
