"use strict";

var path = require('path');

var isString = function isString(str) {
  return typeof str === 'string';
};

var checkIgnoreDepth = function checkIgnoreDepth() {
  var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      ignoreDepth = _ref.ignoreDepth,
      pathInput = _ref.path,
      allowDepthMoreOrLessThanEquality = _ref.allowDepthMoreOrLessThanEquality;

  if (!ignoreDepth || !isString(pathInput)) return false;
  var pathArray = path.normalize(pathInput).split(path.sep);
  var doubleDotsNumber = pathArray.findIndex(function (pathPart) {
    return pathPart !== '..';
  });
  return allowDepthMoreOrLessThanEquality ? ignoreDepth >= doubleDotsNumber : ignoreDepth === doubleDotsNumber;
};

module.exports = checkIgnoreDepth;