import WebSocket from 'ws';
import { TypedEmitter } from '@trezor/utils';
type WebsocketOptions = {
    url: string;
    timeout?: number;
    agent?: WebSocket.ClientOptions['agent'];
    headers?: WebSocket.ClientOptions['headers'];
};
type Options = WebsocketOptions & {
    pingTimeout?: number;
    connectionTimeout?: number;
    keepAlive?: boolean;
    onSending?: (message: Record<string, any>) => void;
};
type WebsocketClientEvents = {
    error: string;
    disconnected: undefined;
};
export type WebsocketRequest = Record<string, any>;
export type WebsocketResponse = WebSocket.Data;
export declare class WebsocketError extends Error {
}
export declare class WebsocketClient<Events extends Record<string, any>> extends TypedEmitter<Events & WebsocketClientEvents> {
    readonly options: Options;
    protected readonly messages: import("@trezor/utils").DeferredManager<any>;
    private readonly emitter;
    private ws?;
    private pingTimeout?;
    private connectPromise?;
    protected createWebsocket?(): WebSocket;
    protected ping(): Promise<any>;
    constructor(options: Options);
    protected initWebsocket({ url, timeout, headers, agent }: WebsocketOptions): WebSocket;
    private setPingTimeout;
    protected onPing(): Promise<any>;
    onMessageTimeout(_promiseId: number): void;
    private onError;
    sendMessage(message: WebsocketRequest, { timeout }?: {
        timeout?: number;
    }): Promise<any>;
    protected sendRawMessage(message: WebSocket.Data): void;
    protected onMessage(message: WebsocketResponse, messageValidation?: (data: Record<string, any>) => Record<string, any> | void): void;
    connect(): Promise<void>;
    private init;
    disconnect(): Promise<void>;
    isConnected(): boolean;
    private onClose;
    dispose(): void;
}
export {};
//# sourceMappingURL=client.d.ts.map