export declare function decodeBlake(buffer: Buffer): Buffer<ArrayBufferLike>;
export declare function decodeBlake256Key(key: string): Buffer<ArrayBufferLike>;
export declare function decodeBlake256(address: string): Buffer<ArrayBufferLike>;
export declare function encodeBlake256(payload: Buffer): string;
export declare function encode(payload: Buffer, network?: import("./networks").Network): string;
export declare function decode(payload: string, network?: import("./networks").Network): Uint8Array<ArrayBufferLike> | Buffer<ArrayBufferLike>;
export declare function decodeAddress(address: string, network?: import("./networks").Network): {
    version: number;
    hash: Buffer<ArrayBufferLike>;
};
export declare function encodeAddress(hash: Buffer, version: number, network?: import("./networks").Network): string;
//# sourceMappingURL=bs58check.d.ts.map