export const createZip = (buffers) => {
    const fileEntries = [];
    const centralDirectory = [];
    let offset = 0;
    buffers.forEach(({ name, content }) => {
        const fileData = content;
        const fileHeader = new Uint8Array(30 + name.length);
        const localFileHeader = new DataView(fileHeader.buffer);
        localFileHeader.setUint32(0, 0x04034b50, true);
        localFileHeader.setUint16(4, 0x0, true);
        localFileHeader.setUint16(6, 0x0, true);
        localFileHeader.setUint16(8, 0x0, true);
        localFileHeader.setUint16(10, 0x0, true);
        localFileHeader.setUint16(12, 0x0, true);
        localFileHeader.setUint32(14, 0, true);
        localFileHeader.setUint32(18, fileData.byteLength, true);
        localFileHeader.setUint32(22, fileData.byteLength, true);
        localFileHeader.setUint16(26, name.length, true);
        fileHeader.set(new TextEncoder().encode(name), 30);
        fileEntries.push(fileHeader, fileData);
        const centralHeader = new Uint8Array(46 + name.length);
        const centralView = new DataView(centralHeader.buffer);
        centralView.setUint32(0, 0x02014b50, true);
        centralView.setUint16(4, 0x0, true);
        centralView.setUint16(6, 0x0, true);
        centralView.setUint16(8, 0x0, true);
        centralView.setUint16(10, 0x0, true);
        centralView.setUint16(12, 0x0, true);
        centralView.setUint16(14, 0x0, true);
        centralView.setUint32(16, 0, true);
        centralView.setUint32(20, fileData.byteLength, true);
        centralView.setUint32(24, fileData.byteLength, true);
        centralView.setUint16(28, name.length, true);
        centralView.setUint32(42, offset, true);
        centralHeader.set(new TextEncoder().encode(name), 46);
        centralDirectory.push(centralHeader);
        offset += fileHeader.length + fileData.byteLength;
    });
    const eocd = new Uint8Array(22);
    const eocdView = new DataView(eocd.buffer);
    eocdView.setUint32(0, 0x06054b50, true);
    eocdView.setUint16(8, centralDirectory.length, true);
    eocdView.setUint16(10, centralDirectory.length, true);
    eocdView.setUint32(12, centralDirectory.reduce((sum, cd) => sum + cd.byteLength, 0), true);
    eocdView.setUint32(16, offset, true);
    return new Blob([...fileEntries, ...centralDirectory, eocd], {
        type: 'application/zip',
    });
};
//# sourceMappingURL=zip.js.map