import { throwError } from './throwError';
export const isVersionArray = (arr) => Array.isArray(arr) &&
    arr.length === 3 &&
    arr.every(number => typeof number === 'number' && number >= 0);
export const tryParse = (version) => version
    .match(/^(\d+)\.(\d+)\.(\d+)([+-].*)?$/)
    ?.slice(1, 4)
    .map(n => Number(n));
const validateArray = (version) => (isVersionArray(version) ? version : null);
const ensureArray = (version) => (typeof version === 'string' ? tryParse(version) : validateArray(version)) ??
    throwError(`version string is in wrong format: ${version}`);
const compare = ([majorX, minorX, patchX], [majorY, minorY, patchY]) => majorX - majorY || minorX - minorY || patchX - patchY;
export const isNewer = (versionX, versionY) => compare(ensureArray(versionX), ensureArray(versionY)) > 0;
export const isEqual = (versionX, versionY) => compare(ensureArray(versionX), ensureArray(versionY)) === 0;
export const isNewerOrEqual = (versionX, versionY) => compare(ensureArray(versionX), ensureArray(versionY)) >= 0;
export const normalizeVersion = (version) => version.replace(/\b0+(\d)/g, '$1');
//# sourceMappingURL=versionUtils.js.map