import { arrayPartition } from './arrayPartition';
export const topologicalSort = (elements, precedes, tie) => {
    const result = [];
    const filterRoots = (verts) => arrayPartition(verts, succ => !verts.some(pred => precedes(pred, succ)));
    let elem = elements;
    while (elem.length) {
        const [roots, rest] = filterRoots(elem);
        if (!roots.length)
            throw new Error('Cycle detected');
        result.push(...(tie ? roots.sort(tie) : roots));
        elem = rest;
    }
    return result;
};
//# sourceMappingURL=topologicalSort.js.map