"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.readWithExpectedHeaders = readWithExpectedHeaders;
const utils_1 = require("@trezor/utils");
const result_1 = require("./result");
const ATTEMPT_ERROR = 'Unexpected chunk';
async function readAndAssert(receiver, expectedHeaders, { signal, logger } = {}) {
    logger?.debug('readAndAssert start');
    const chunk = await receiver(signal);
    if (!chunk.success) {
        return chunk;
    }
    if (!expectedHeaders || expectedHeaders.length === 0) {
        logger?.debug('readAndAssert skip');
        return chunk;
    }
    const bytes = chunk.payload;
    const expected = expectedHeaders.find(header => {
        if (bytes.length < header.length) {
            return false;
        }
        return bytes.subarray(0, header.length).compare(header) === 0 ? true : false;
    });
    if (expected) {
        logger?.debug('readAndAssert done');
        return (0, result_1.success)(chunk.payload);
    }
    logger?.warn(`readAndAssert unexpected header`);
    throw new Error(ATTEMPT_ERROR);
}
function readWithExpectedHeaders(receiver, options = {}) {
    return (expectedHeaders) => (0, utils_1.scheduleAction)(attemptSignal => readAndAssert(receiver, expectedHeaders, { ...options, signal: attemptSignal }), {
        signal: options?.signal,
        graceful: true,
        attempts: options?.attempts || Infinity,
        timeout: options?.timeout,
        attemptFailureHandler: error => {
            if (error.message !== ATTEMPT_ERROR) {
                options.logger?.debug(`readAndAssert attempt error ${error.message}`);
                return error;
            }
        },
    });
}
//# sourceMappingURL=readWithExpectedHeaders.js.map