"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebUsbTransport = void 0;
const abstractApi_1 = require("./abstractApi");
const usb_1 = require("../api/usb");
const background_browser_1 = require("../sessions/background-browser");
const defaultSessionsBackgroundUrl = window.location.origin +
    `${process.env.ASSET_PREFIX || ''}/workers/sessions-background-sharedworker.js`
        .replace(/\/+/g, '/');
class WebUsbTransport extends abstractApi_1.AbstractApiTransport {
    name = 'WebUsbTransport';
    apiType = 'usb';
    sessionsBackgroundUrl;
    constructor({ logger, sessionsBackgroundUrl, ...rest }) {
        super({
            api: new usb_1.UsbApi({ usbInterface: navigator.usb, logger }),
            logger,
            ...rest,
        });
        this.sessionsBackgroundUrl = sessionsBackgroundUrl ?? defaultSessionsBackgroundUrl;
    }
    async trySetSessionsBackground() {
        try {
            const response = await fetch(this.sessionsBackgroundUrl, { method: 'HEAD' });
            if (!response.ok) {
                console.warn(`Failed to fetch sessions-background SharedWorker from url: ${this.sessionsBackgroundUrl}`);
            }
            else {
                this.sessionsBackground = new background_browser_1.BrowserSessionsBackground(this.sessionsBackgroundUrl);
                this.sessionsClient.setBackground(this.sessionsBackground);
            }
        }
        catch (err) {
            console.warn('Unable to load background-sharedworker. Falling back to use local module. Say bye bye to tabs synchronization. Error details: ', err.message);
        }
    }
    async init({ signal } = {}) {
        await this.trySetSessionsBackground();
        return super.init({ signal });
    }
}
exports.WebUsbTransport = WebUsbTransport;
//# sourceMappingURL=webusb.browser.js.map