"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NodeUsbTransport = void 0;
const usb_1 = require("usb");
const abstractApi_1 = require("./abstractApi");
const usb_2 = require("../api/usb");
class NodeUsbTransport extends abstractApi_1.AbstractApiTransport {
    name = 'NodeUsbTransport';
    apiType = 'usb';
    constructor(params) {
        const { logger, debugLink, ...rest } = params;
        super({
            api: new usb_2.UsbApi({
                usbInterface: new usb_1.WebUSB({
                    allowAllDevices: true,
                }),
                logger,
                debugLink,
            }),
            logger,
            ...rest,
        });
    }
}
exports.NodeUsbTransport = NodeUsbTransport;
//# sourceMappingURL=nodeusb.js.map