import { loadDefinitions } from '@trezor/protobuf';
import { PROTOCOL_MALFORMED, ThpState, TransportProtocol } from '@trezor/protocol';
import { ScheduleActionParams, ScheduledAction, TypedEmitter } from '@trezor/utils';
import type { BridgeCommonErrors } from './bridge';
import { TRANSPORT } from '../constants';
import * as ERRORS from '../errors';
import { AbortableParam, AnyError, AsyncResultWithTypedError, Descriptor, Logger, MessageResponse, PathPublic, ResultWithTypedError, Session, Success } from '../types';
export type AcquireInput = {
    path: PathPublic;
    previous: Session | null;
};
export type ReleaseInput = {
    path: PathPublic;
    session: Session;
};
export interface AbstractTransportParams {
    messages: Record<string, any>;
    logger?: Logger;
    debugLink?: boolean;
    id: string;
}
export declare const isTransportInstance: (transport?: AbstractTransport) => boolean;
export type ReadWriteError = typeof ERRORS.HTTP_ERROR | typeof ERRORS.WRONG_RESULT_TYPE | typeof ERRORS.OTHER_CALL_IN_PROGRESS | typeof PROTOCOL_MALFORMED | typeof ERRORS.DEVICE_DISCONNECTED_DURING_ACTION | typeof ERRORS.UNEXPECTED_ERROR | typeof ERRORS.SESSION_NOT_FOUND | typeof ERRORS.ABORTED_BY_TIMEOUT | typeof ERRORS.ABORTED_BY_SIGNAL | typeof ERRORS.WRONG_ENVIRONMENT | typeof ERRORS.DEVICE_NOT_FOUND | typeof ERRORS.INTERFACE_UNABLE_TO_OPEN_DEVICE | typeof ERRORS.INTERFACE_DATA_TRANSFER | typeof ERRORS.THP_STATE_MISSING;
type TransportEvents = {
    [TRANSPORT.DEVICE_CONNECTED]: Descriptor;
    [TRANSPORT.ERROR]: BridgeCommonErrors | typeof ERRORS.API_DISCONNECTED;
    [TRANSPORT.STOPPED]: void;
    [TRANSPORT.SEND_MESSAGE_PROGRESS]: number;
};
export type TransportDeviceEvent = {
    type: typeof TRANSPORT.DEVICE_DISCONNECTED;
} | {
    type: typeof TRANSPORT.DEVICE_REQUEST_RELEASE;
} | {
    type: typeof TRANSPORT.DEVICE_SESSION_CHANGED;
    descriptor: Descriptor;
};
export type TransportApiType = 'usb' | 'udp' | 'bluetooth';
export declare abstract class AbstractTransport extends TypedEmitter<TransportEvents> {
    abstract readonly name: 'BridgeTransport' | 'NodeUsbTransport' | 'WebUsbTransport' | 'UdpTransport' | 'NativeUsbTransport' | 'BluetoothTransport';
    abstract readonly apiType: TransportApiType;
    isOutdated: boolean;
    version: string;
    protected stopped: boolean;
    protected listening: boolean;
    protected messages: protobuf.Root;
    protected descriptors: Descriptor[];
    protected abortController: AbortController;
    protected logger?: Logger;
    protected id: string;
    readonly deviceEvents: TypedEmitter<{
        [path: PathPublic]: TransportDeviceEvent;
    }>;
    constructor({ messages, logger, id }: AbstractTransportParams);
    ping(_params?: AbortableParam): Promise<boolean>;
    abstract init(params?: AbortableParam): AsyncResultWithTypedError<undefined, typeof ERRORS.SESSION_BACKGROUND_TIMEOUT | typeof ERRORS.WRONG_ENVIRONMENT | typeof ERRORS.WRONG_RESULT_TYPE | typeof ERRORS.HTTP_ERROR | typeof ERRORS.UNEXPECTED_ERROR | typeof ERRORS.ABORTED_BY_TIMEOUT | typeof ERRORS.ABORTED_BY_SIGNAL>;
    abstract listen(): ResultWithTypedError<undefined, typeof ERRORS.ALREADY_LISTENING | typeof ERRORS.WRONG_ENVIRONMENT>;
    abstract enumerate(params?: AbortableParam): AsyncResultWithTypedError<Descriptor[], typeof ERRORS.HTTP_ERROR | typeof ERRORS.WRONG_RESULT_TYPE | typeof ERRORS.ABORTED_BY_TIMEOUT | typeof ERRORS.ABORTED_BY_SIGNAL | typeof ERRORS.UNEXPECTED_ERROR | typeof ERRORS.WRONG_ENVIRONMENT>;
    abstract acquire(params: {
        input: AcquireInput;
    } & AbortableParam): AsyncResultWithTypedError<Session, typeof ERRORS.INTERFACE_UNABLE_TO_OPEN_DEVICE | typeof ERRORS.WRONG_RESULT_TYPE | typeof ERRORS.HTTP_ERROR | typeof ERRORS.DEVICE_DISCONNECTED_DURING_ACTION | typeof ERRORS.DEVICE_NOT_FOUND | typeof ERRORS.SESSION_WRONG_PREVIOUS | typeof ERRORS.UNEXPECTED_ERROR | typeof ERRORS.ABORTED_BY_TIMEOUT | typeof ERRORS.ABORTED_BY_SIGNAL | typeof ERRORS.WRONG_ENVIRONMENT | typeof ERRORS.LIBUSB_ERROR_ACCESS>;
    abstract release(params: ReleaseInput & AbortableParam): AsyncResultWithTypedError<null, typeof ERRORS.SESSION_NOT_FOUND | typeof ERRORS.HTTP_ERROR | typeof ERRORS.WRONG_RESULT_TYPE | typeof ERRORS.DEVICE_DISCONNECTED_DURING_ACTION | typeof ERRORS.SESSION_WRONG_PREVIOUS | typeof ERRORS.DEVICE_NOT_FOUND | typeof ERRORS.INTERFACE_UNABLE_TO_OPEN_DEVICE | typeof ERRORS.UNEXPECTED_ERROR | typeof ERRORS.ABORTED_BY_TIMEOUT | typeof ERRORS.ABORTED_BY_SIGNAL | typeof ERRORS.WRONG_ENVIRONMENT>;
    abstract releaseDevice(session: Session): AsyncResultWithTypedError<void, string>;
    abstract releaseSync(session: Session): void;
    abstract send(params: {
        path?: string;
        session: Session;
        name: string;
        data: Record<string, unknown>;
        protocol?: TransportProtocol;
        thpState?: ThpState;
    } & AbortableParam): AsyncResultWithTypedError<undefined, ReadWriteError>;
    abstract receive(params: {
        path?: string;
        session: Session;
        protocol?: TransportProtocol;
        thpState?: ThpState;
    } & AbortableParam): AsyncResultWithTypedError<MessageResponse, ReadWriteError>;
    abstract call(params: {
        session: Session;
        name: string;
        data: Record<string, unknown>;
        protocol?: TransportProtocol;
        thpState?: ThpState;
    } & AbortableParam): AsyncResultWithTypedError<MessageResponse, ReadWriteError>;
    stop(): void;
    handleDescriptorsChange(nextDescriptors: Descriptor[]): void;
    getDescriptor(path: PathPublic): Descriptor | undefined;
    getMessage(message?: string): boolean;
    getMessages(): import("protobufjs").Root;
    updateMessages(messages: Record<string, any>): void;
    loadMessages(packageName: string, packageLoader: Parameters<typeof loadDefinitions>[2]): Promise<void>;
    protected success<T>(payload: T): Success<T>;
    protected error<E extends AnyError>(payload: {
        error: E;
        message?: string;
    }): {
        success: false;
        error: E;
        message: string | undefined;
    };
    protected unknownError: <E extends AnyError = never>(err: Error | string, expectedErrors?: E[]) => {
        success: false;
        error: E;
        message: string | undefined;
    } | {
        success: false;
        error: "unexpected error";
        message: string;
    };
    private mergeAbort;
    protected scheduleAction: <T, E extends AnyError = never>(action: ScheduledAction<T>, params?: ScheduleActionParams, errors?: E[]) => Promise<T | {
        success: false;
        error: NonNullable<"Aborted by signal" | "Aborted by timeout" | E>;
        message: string | undefined;
    } | {
        success: false;
        error: "unexpected error";
        message: string;
    }>;
}
export type AbstractTransportMethodParams<K extends keyof AbstractTransport> = AbstractTransport[K] extends (...args: any[]) => any ? Parameters<AbstractTransport[K]>[0] : never;
export {};
//# sourceMappingURL=abstract.d.ts.map