"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SessionsClient = void 0;
const utils_1 = require("@trezor/utils");
class SessionsClient extends utils_1.TypedEmitter {
    caller = (0, utils_1.getWeakRandomId)(3);
    id;
    background;
    constructor(background) {
        super();
        this.id = 0;
        this.background = background;
        background.on('descriptors', descriptors => this.emit('descriptors', descriptors));
        background.on('releaseRequest', descriptor => this.emit('releaseRequest', descriptor));
    }
    setBackground(background) {
        this.background.dispose();
        this.id = 0;
        this.background = background;
        background.on('descriptors', descriptors => this.emit('descriptors', descriptors));
        background.on('releaseRequest', descriptor => this.emit('releaseRequest', descriptor));
    }
    request(params) {
        return this.background.handleMessage({ ...params, caller: this.caller, id: this.id++ });
    }
    handshake() {
        return this.request({ type: 'handshake' });
    }
    enumerateDone(payload) {
        return this.request({ type: 'enumerateDone', payload });
    }
    acquireIntent(payload) {
        return this.request({ type: 'acquireIntent', payload });
    }
    acquireDone(payload) {
        return this.request({ type: 'acquireDone', payload });
    }
    releaseIntent(payload) {
        return this.request({ type: 'releaseIntent', payload });
    }
    releaseDone(payload) {
        return this.request({ type: 'releaseDone', payload });
    }
    getSessions() {
        return this.request({ type: 'getSessions' });
    }
    getPathBySession(payload) {
        return this.request({ type: 'getPathBySession', payload });
    }
    dispose() {
        this.removeAllListeners('descriptors');
        return this.request({ type: 'dispose' });
    }
}
exports.SessionsClient = SessionsClient;
//# sourceMappingURL=client.js.map