"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isErrorWithoutDeviceInteraction = void 0;
const tslib_1 = require("tslib");
const ERRORS = tslib_1.__importStar(require("./errors"));
const ERRORS_WITHOUT_DEVICE_INTERACTION = [
    ERRORS.HTTP_ERROR,
    ERRORS.OTHER_CALL_IN_PROGRESS,
    ERRORS.WRONG_ENVIRONMENT,
    ERRORS.NATIVE_INTERFACE_NOT_AVAILABLE,
    ERRORS.ALREADY_LISTENING,
    ERRORS.SESSION_BACKGROUND_TIMEOUT,
    ERRORS.SESSION_NOT_FOUND,
    ERRORS.SESSION_WRONG_PREVIOUS,
];
const isErrorWithoutDeviceInteraction = (error) => ERRORS_WITHOUT_DEVICE_INTERACTION.includes(error);
exports.isErrorWithoutDeviceInteraction = isErrorWithoutDeviceInteraction;
//# sourceMappingURL=errors-groups.js.map