"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.encode = exports.getHeaders = void 0;
const tslib_1 = require("tslib");
const ERRORS = tslib_1.__importStar(require("../errors"));
const constants_1 = require("./constants");
const constants_2 = require("../protocol-thp/constants");
const getChunkHeader = (data) => {
    if (data.byteLength < constants_1.HEADER_SIZE) {
        throw new Error(ERRORS.PROTOCOL_MALFORMED);
    }
    const channel = data.subarray(1, constants_1.HEADER_SIZE);
    const header = Buffer.concat([Buffer.from([constants_2.THP_CONTINUATION_PACKET]), channel]);
    return header;
};
const getHeaders = data => {
    const chunkHeader = getChunkHeader(data);
    return [data.subarray(0, constants_1.HEADER_SIZE), chunkHeader];
};
exports.getHeaders = getHeaders;
const encode = (data, options) => {
    if (options.messageType === constants_1.MESSAGE_TYPE) {
        if (!options.header || options.header.byteLength !== constants_1.HEADER_SIZE) {
            throw new Error(`${options.messageType} unexpected header ${options.header?.toString('hex')}`);
        }
        const length = Buffer.alloc(constants_1.MESSAGE_LEN_SIZE);
        length.writeUInt16BE(data.length);
        return Buffer.concat([options.header, length, data]);
    }
    throw new Error(`Use protocol-thp.encode for messageType ${options.messageType}`);
};
exports.encode = encode;
//# sourceMappingURL=encode.js.map