"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.decode = void 0;
const tslib_1 = require("tslib");
const ERRORS = tslib_1.__importStar(require("../errors"));
const constants_1 = require("./constants");
const encode_1 = require("./encode");
const decode = bytes => {
    const buffer = Buffer.from(bytes);
    if (buffer.byteLength < constants_1.HEADER_SIZE + constants_1.MESSAGE_LEN_SIZE) {
        throw new Error(ERRORS.PROTOCOL_MALFORMED);
    }
    const [header, chunkHeader] = (0, encode_1.getHeaders)(buffer);
    return {
        header,
        chunkHeader,
        length: buffer.readUint16BE(constants_1.HEADER_SIZE),
        messageType: constants_1.MESSAGE_TYPE,
        payload: buffer.subarray(constants_1.HEADER_SIZE + constants_1.MESSAGE_LEN_SIZE),
    };
};
exports.decode = decode;
//# sourceMappingURL=decode.js.map