"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isValidAddress = void 0;
const utxo_lib_1 = require("@trezor/utxo-lib");
const isValidBase58Address = (address, network) => {
    try {
        const decoded = utxo_lib_1.address.fromBase58Check(address, network);
        if (decoded.version !== network.pubKeyHash && decoded.version !== network.scriptHash) {
            return false;
        }
    }
    catch {
        return false;
    }
    return true;
};
const isValidBech32Address = (address, network) => {
    try {
        const decoded = utxo_lib_1.address.fromBech32(address);
        if (decoded.prefix !== network.bech32) {
            return false;
        }
    }
    catch {
        return false;
    }
    return true;
};
const isValidAddress = (address, coinInfo) => isValidBase58Address(address, coinInfo.network) ||
    isValidBech32Address(address, coinInfo.network);
exports.isValidAddress = isValidAddress;
//# sourceMappingURL=addressUtils.js.map