import { FeaturesNarrowing, FirmwareType } from '@trezor/device-utils';
import type { ThpStateSerialized } from '@trezor/protocol';
import { Branded } from '@trezor/type-utils';
import type { PROTO } from '../constants';
import type { FirmwareReleaseConfigInfo } from './firmware';
export type DeviceStatus = 'available' | 'occupied' | 'used' | 'busy';
export type DeviceMode = 'normal' | 'bootloader' | 'initialize' | 'seedless';
export type DeviceFirmwareStatus = 'valid' | 'outdated' | 'required' | 'unknown' | 'custom' | 'none';
export type UnavailableCapability = 'no-capability' | 'no-support' | 'update-required' | 'trezor-connect-outdated';
export type StaticSessionId = `${string}@${string}:${number}`;
export type DeviceState = {
    sessionId?: string;
    staticSessionId?: StaticSessionId;
    deriveCardano?: boolean;
};
export type UnavailableCapabilities = {
    [key: string]: UnavailableCapability;
};
export type FirmwareRevisionCheckError = 'revision-mismatch' | 'firmware-version-unknown' | 'cannot-perform-check-offline' | 'other-error';
export type FirmwareRevisionCheckResult = {
    success: true;
} | {
    success: false;
    error: FirmwareRevisionCheckError;
    errorPayload?: unknown;
};
export type FirmwareHashCheckError = 'hash-mismatch' | 'check-skipped' | 'check-unsupported' | 'unknown-release' | 'takes-too-long' | 'other-error';
export type FirmwareHashCheckResult = {
    success: true;
    attemptCount?: number;
    warningPayload?: unknown;
} | {
    success: false;
    error: FirmwareHashCheckError;
    attemptCount?: number;
    errorPayload?: unknown;
};
export type DeviceUniquePath = string & Branded<'DeviceUniquePath'>;
export declare const DeviceUniquePath: (id: string) => DeviceUniquePath;
type BaseDevice = {
    path: DeviceUniquePath;
    name: string;
};
export type BluetoothDeviceProps = {
    id: string;
};
export type KnownDevice = BaseDevice & {
    type: 'acquired';
    id: string | null;
    label: string;
    error?: typeof undefined;
    firmware: DeviceFirmwareStatus;
    firmwareReleaseConfigInfo?: FirmwareReleaseConfigInfo | null;
    firmwareType?: FirmwareType;
    color?: string;
    status: DeviceStatus;
    mode: DeviceMode;
    _state?: DeviceState;
    state?: DeviceState['staticSessionId'];
    features: PROTO.Features;
    thp?: ThpStateSerialized;
    unavailableCapabilities: UnavailableCapabilities;
    availableTranslations: Record<string, string>;
    authenticityChecks: {
        firmwareRevision: FirmwareRevisionCheckResult | null;
        firmwareHash: FirmwareHashCheckResult | null;
    };
    transportSessionOwner?: undefined;
    hid?: undefined;
    bluetoothProps?: BluetoothDeviceProps;
};
export type UnknownDevice = BaseDevice & {
    type: 'unacquired';
    label: 'Unacquired device';
    id?: typeof undefined;
    error?: typeof undefined;
    features?: typeof undefined;
    thp?: ThpStateSerialized;
    firmware?: typeof undefined;
    firmwareReleaseConfigInfo?: typeof undefined;
    firmwareType?: typeof undefined;
    color?: typeof undefined;
    status?: DeviceStatus;
    mode?: typeof undefined;
    _state?: typeof undefined;
    state?: typeof undefined;
    unavailableCapabilities?: typeof undefined;
    availableTranslations?: typeof undefined;
    transportSessionOwner?: string;
    hid?: undefined;
    bluetoothProps?: BluetoothDeviceProps;
};
export type UnreadableDevice = BaseDevice & {
    type: 'unreadable';
    label: 'Unreadable device';
    error: string;
    id?: typeof undefined;
    features?: typeof undefined;
    thp?: typeof undefined;
    firmware?: typeof undefined;
    firmwareReleaseConfigInfo?: typeof undefined;
    firmwareType?: typeof undefined;
    color?: typeof undefined;
    status?: typeof undefined;
    mode?: typeof undefined;
    _state?: typeof undefined;
    state?: typeof undefined;
    unavailableCapabilities?: typeof undefined;
    availableTranslations?: typeof undefined;
    transportSessionOwner?: undefined;
    hid: boolean;
    bluetoothProps?: typeof undefined;
};
export type Device = KnownDevice | UnknownDevice | UnreadableDevice;
export type Features = PROTO.Features;
export type DisplayRotation = PROTO.DisplayRotation;
export type StrictFeatures = Features & FeaturesNarrowing;
export {};
//# sourceMappingURL=device.d.ts.map