import { Static } from '@trezor/schema-utils';
export type SolanaPublicKey = Static<typeof SolanaPublicKey>;
export declare const SolanaPublicKey: import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
    publicKey: import("@trezor/schema-utils").TString;
    path: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    serializedPath: import("@trezor/schema-utils").TString;
}>, import("@trezor/schema-utils").TObject<{
    publicKey: import("@trezor/schema-utils").TString;
    publicKeyBase58: import("@trezor/schema-utils").TString;
}>]>;
export type SolanaTxTokenAccountInfo = Static<typeof SolanaTxTokenAccountInfo>;
export declare const SolanaTxTokenAccountInfo: import("@trezor/schema-utils").TObject<{
    baseAddress: import("@trezor/schema-utils").TString;
    tokenProgram: import("@trezor/schema-utils").TString;
    tokenMint: import("@trezor/schema-utils").TString;
    tokenAccount: import("@trezor/schema-utils").TString;
    symbol: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type SolanaTxAdditionalInfo = Static<typeof SolanaTxAdditionalInfo>;
export declare const SolanaTxAdditionalInfo: import("@trezor/schema-utils").TObject<{
    tokenAccountsInfos: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
        baseAddress: import("@trezor/schema-utils").TString;
        tokenProgram: import("@trezor/schema-utils").TString;
        tokenMint: import("@trezor/schema-utils").TString;
        tokenAccount: import("@trezor/schema-utils").TString;
        symbol: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>>>;
    isDevnet: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>;
export type SolanaSignTransaction = Static<typeof SolanaSignTransaction>;
export declare const SolanaSignTransaction: import("@trezor/schema-utils").TObject<{
    path: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>]>;
    serializedTx: import("@trezor/schema-utils").TString;
    additionalInfo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        tokenAccountsInfos: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            baseAddress: import("@trezor/schema-utils").TString;
            tokenProgram: import("@trezor/schema-utils").TString;
            tokenMint: import("@trezor/schema-utils").TString;
            tokenAccount: import("@trezor/schema-utils").TString;
            symbol: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>>>;
        isDevnet: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    }>>;
    serialize: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>;
export type SolanaSignedTransaction = Static<typeof SolanaSignedTransaction>;
export declare const SolanaSignedTransaction: import("@trezor/schema-utils").TObject<{
    signature: import("@trezor/schema-utils").TString;
    serializedTx: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type SolanaProgramName = Static<typeof SolanaProgramName>;
export declare const SolanaProgramName: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"spl-token">, import("@trezor/schema-utils").TLiteral<"spl-token-2022">]>;
export type SolanaComposeTransaction = Static<typeof SolanaComposeTransaction>;
export declare const SolanaComposeTransaction: import("@trezor/schema-utils").TObject<{
    fromAddress: import("@trezor/schema-utils").TString;
    toAddress: import("@trezor/schema-utils").TString;
    amount: import("@trezor/schema-utils").TString;
    blockHash: import("@trezor/schema-utils").TString;
    lastValidBlockHeight: import("@trezor/schema-utils").TNumber;
    priorityFees: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        computeUnitPrice: import("@trezor/schema-utils").TString;
        computeUnitLimit: import("@trezor/schema-utils").TString;
    }>>;
    token: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        mint: import("@trezor/schema-utils").TString;
        program: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"spl-token">, import("@trezor/schema-utils").TLiteral<"spl-token-2022">]>;
        decimals: import("@trezor/schema-utils").TNumber;
        accounts: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            publicKey: import("@trezor/schema-utils").TString;
            balance: import("@trezor/schema-utils").TString;
        }>>;
    }>>;
    coin: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    identity: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type SolanaComposedTransaction = Static<typeof SolanaComposedTransaction>;
export declare const SolanaComposedTransaction: import("@trezor/schema-utils").TObject<{
    serializedTx: import("@trezor/schema-utils").TString;
    additionalInfo: import("@trezor/schema-utils").TObject<{
        newAccountProgramName: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"spl-token">, import("@trezor/schema-utils").TLiteral<"spl-token-2022">]>>;
        tokenAccountInfo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            baseAddress: import("@trezor/schema-utils").TString;
            tokenProgram: import("@trezor/schema-utils").TString;
            tokenMint: import("@trezor/schema-utils").TString;
            tokenAccount: import("@trezor/schema-utils").TString;
            symbol: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>>;
    }>;
}>;
//# sourceMappingURL=index.d.ts.map