"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HDNodeResponse = exports.GetPublicKey = void 0;
const schema_utils_1 = require("@trezor/schema-utils");
const constants_1 = require("../../constants");
const params_1 = require("../params");
exports.GetPublicKey = schema_utils_1.Type.Intersect([
    params_1.GetPublicKey,
    schema_utils_1.Type.Object({
        coin: schema_utils_1.Type.Optional(schema_utils_1.Type.String({
            description: 'determines network definition specified in coins.json file. Coin shortcut, name or label can be used. If coin is not set API will try to get network definition from path.',
            default: 'btc',
        })),
        crossChain: schema_utils_1.Type.Optional(schema_utils_1.Type.Boolean()),
        scriptType: schema_utils_1.Type.Optional(constants_1.PROTO.InternalInputScriptType),
        ignoreXpubMagic: schema_utils_1.Type.Optional(schema_utils_1.Type.Boolean()),
        ecdsaCurveName: schema_utils_1.Type.Optional(schema_utils_1.Type.String()),
        unlockPath: schema_utils_1.Type.Optional(constants_1.PROTO.UnlockPath),
    }),
]);
exports.HDNodeResponse = schema_utils_1.Type.Intersect([
    params_1.PublicKey,
    schema_utils_1.Type.Object({
        childNum: schema_utils_1.Type.Number(),
        xpub: schema_utils_1.Type.String(),
        xpubSegwit: schema_utils_1.Type.Optional(schema_utils_1.Type.String()),
        descriptorChecksum: schema_utils_1.Type.Optional(schema_utils_1.Type.String()),
        chainCode: schema_utils_1.Type.String(),
        fingerprint: schema_utils_1.Type.Number(),
        depth: schema_utils_1.Type.Number(),
        descriptor: schema_utils_1.Type.Optional(schema_utils_1.Type.String()),
    }),
]);
//# sourceMappingURL=getPublicKey.js.map