import { Static } from '@trezor/schema-utils';
import { BundledParams, Params, Response } from '../params';
export type GetPublicKey = Static<typeof GetPublicKey>;
export declare const GetPublicKey: import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
    path: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>]>;
    showOnTrezor: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    suppressBackupWarning: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>, import("@trezor/schema-utils").TObject<{
    coin: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    crossChain: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    scriptType: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"SPENDADDRESS">, import("@trezor/schema-utils").TLiteral<"SPENDMULTISIG">, import("@trezor/schema-utils").TLiteral<"SPENDWITNESS">, import("@trezor/schema-utils").TLiteral<"SPENDP2SHWITNESS">, import("@trezor/schema-utils").TLiteral<"SPENDTAPROOT">]>>;
    ignoreXpubMagic: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    ecdsaCurveName: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    unlockPath: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        mac: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>>;
}>]>;
export type HDNodeResponse = Static<typeof HDNodeResponse>;
export declare const HDNodeResponse: import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
    publicKey: import("@trezor/schema-utils").TString;
    path: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    serializedPath: import("@trezor/schema-utils").TString;
}>, import("@trezor/schema-utils").TObject<{
    childNum: import("@trezor/schema-utils").TNumber;
    xpub: import("@trezor/schema-utils").TString;
    xpubSegwit: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    descriptorChecksum: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    chainCode: import("@trezor/schema-utils").TString;
    fingerprint: import("@trezor/schema-utils").TNumber;
    depth: import("@trezor/schema-utils").TNumber;
    descriptor: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>]>;
export declare function getPublicKey(params: Params<GetPublicKey>): Response<HDNodeResponse>;
export declare function getPublicKey(params: BundledParams<GetPublicKey>): Response<HDNodeResponse[]>;
//# sourceMappingURL=getPublicKey.d.ts.map