"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetOwnershipProof = void 0;
const schema_utils_1 = require("@trezor/schema-utils");
const constants_1 = require("../../constants");
const params_1 = require("../params");
exports.GetOwnershipProof = schema_utils_1.Type.Object({
    path: params_1.DerivationPath,
    coin: schema_utils_1.Type.Optional(schema_utils_1.Type.String()),
    multisig: schema_utils_1.Type.Optional(constants_1.PROTO.MultisigRedeemScriptType),
    scriptType: schema_utils_1.Type.Optional(constants_1.PROTO.InternalInputScriptType),
    userConfirmation: schema_utils_1.Type.Optional(schema_utils_1.Type.Boolean()),
    ownershipIds: schema_utils_1.Type.Optional(schema_utils_1.Type.Array(schema_utils_1.Type.String(), { minItems: 1 })),
    commitmentData: schema_utils_1.Type.Optional(schema_utils_1.Type.String()),
    preauthorized: schema_utils_1.Type.Optional(schema_utils_1.Type.Boolean()),
});
//# sourceMappingURL=getOwnershipProof.js.map