import type { BlockEvent, FiatRatesBySymbol, NotificationEvent, ServerInfo } from '@trezor/blockchain-link';
import type { CoinInfo } from '../types/coinInfo';
import type { MessageFactoryFn } from '../types/utils';
export declare const BLOCKCHAIN_EVENT = "BLOCKCHAIN_EVENT";
export declare const BLOCKCHAIN: {
    readonly CONNECT: "blockchain-connect";
    readonly RECONNECTING: "blockchain-reconnecting";
    readonly ERROR: "blockchain-error";
    readonly BLOCK: "blockchain-block";
    readonly NOTIFICATION: "blockchain-notification";
    readonly FIAT_RATES_UPDATE: "fiat-rates-update";
};
export interface BlockchainInfo extends ServerInfo {
    coin: CoinInfo;
    identity?: string;
    misc?: {
        reserve?: string;
    };
}
export interface BlockchainReconnecting {
    coin: CoinInfo;
    identity?: string;
    time: number;
}
export interface BlockchainError {
    coin: CoinInfo;
    identity?: string;
    error: string;
    code?: string;
}
export type BlockchainBlock = BlockEvent['payload'] & {
    coin: CoinInfo;
};
export interface BlockchainNotification {
    coin: CoinInfo;
    notification: NotificationEvent['payload'];
}
export interface BlockchainFiatRatesUpdate {
    coin: CoinInfo;
    rates: FiatRatesBySymbol;
}
export type BlockchainEvent = {
    type: typeof BLOCKCHAIN.CONNECT;
    payload: BlockchainInfo;
} | {
    type: typeof BLOCKCHAIN.RECONNECTING;
    payload: BlockchainReconnecting;
} | {
    type: typeof BLOCKCHAIN.ERROR;
    payload: BlockchainError;
} | {
    type: typeof BLOCKCHAIN.BLOCK;
    payload: BlockchainBlock;
} | {
    type: typeof BLOCKCHAIN.NOTIFICATION;
    payload: BlockchainNotification;
} | {
    type: typeof BLOCKCHAIN.FIAT_RATES_UPDATE;
    payload: BlockchainFiatRatesUpdate;
};
export type BlockchainEventMessage = BlockchainEvent & {
    event: typeof BLOCKCHAIN_EVENT;
};
export type BlockchainEventListenerFn = (type: typeof BLOCKCHAIN_EVENT, cb: (event: BlockchainEventMessage) => void) => void;
export declare const createBlockchainMessage: MessageFactoryFn<typeof BLOCKCHAIN_EVENT, BlockchainEvent>;
//# sourceMappingURL=blockchain.d.ts.map