"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveDescriptorForTaproot = void 0;
const utils_1 = require("@trezor/utils");
const resolveDescriptorForTaproot = ({ response, publicKey, }) => {
    if (publicKey.descriptor !== null && publicKey.descriptor !== undefined) {
        const [xpub, checksum] = publicKey.descriptor.split('#');
        const correctedXpub = (0, utils_1.convertTaprootXpub)({ xpub, direction: 'h-to-apostrophe' });
        if (correctedXpub !== null) {
            return { xpub: correctedXpub, checksum };
        }
    }
    const fingerprint = Number(publicKey.root_fingerprint || 0)
        .toString(16)
        .padStart(8, '0');
    const descriptorPath = `${fingerprint}${response.serializedPath.substring(1)}`;
    return {
        xpub: `tr([${descriptorPath}]${response.xpub}/<0;1>/*)`,
        checksum: undefined,
    };
};
exports.resolveDescriptorForTaproot = resolveDescriptorForTaproot;
//# sourceMappingURL=resolveDescriptorForTaproot.js.map