"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.suggestUdevInstaller = void 0;
const info = {
    packages: [
        {
            name: 'RPM package',
            platform: ['rpm32', 'rpm64'],
            url: '/udev/trezor-udev-2-1.noarch.rpm',
        },
        {
            name: 'DEB package',
            platform: ['deb32', 'deb64'],
            url: '/udev/trezor-udev_2_all.deb',
            preferred: true,
        },
    ],
};
const suggestUdevInstaller = (platform) => {
    if (platform !== undefined) {
        return {
            packages: info.packages.map(it => ({
                ...it,
                preferred: it.platform.indexOf(platform) >= 0,
            })),
        };
    }
    return info;
};
exports.suggestUdevInstaller = suggestUdevInstaller;
//# sourceMappingURL=udevInfo.js.map