"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.suggestBridgeInstaller = void 0;
const info = {
    version: [2, 0, 27],
    packages: [
        {
            name: 'Linux 64-bit (deb)',
            platform: ['deb64'],
            url: 'bridge/2.0.27/trezor-bridge_2.0.27_amd64.deb',
        },
        {
            name: 'Linux 64-bit (rpm)',
            platform: ['rpm64'],
            url: 'bridge/2.0.27/trezor-bridge-2.0.27-1.x86_64.rpm',
        },
        {
            name: 'Linux 32-bit (deb)',
            platform: ['deb32'],
            url: 'bridge/2.0.27/trezor-bridge_2.0.27_i386.deb',
        },
        {
            name: 'Linux 32-bit (rpm)',
            platform: ['rpm32'],
            url: 'bridge/2.0.27/trezor-bridge-2.0.27-1.i386.rpm',
        },
        {
            name: 'macOS',
            platform: ['mac'],
            signature: 'bridge/2.0.27/trezor-bridge-2.0.27.pkg.asc',
            url: 'bridge/2.0.27/trezor-bridge-2.0.27.pkg',
        },
        {
            name: 'Windows',
            platform: ['win32', 'win64'],
            signature: 'bridge/2.0.27/trezor-bridge-2.0.27-win32-install.exe.asc',
            url: 'bridge/2.0.27/trezor-bridge-2.0.27-win32-install.exe',
        },
    ],
    changelog: '',
};
const getBridgeInfo = () => info;
const suggestBridgeInstaller = (platform) => {
    const info2 = getBridgeInfo();
    if (platform) {
        info2.packages = info2.packages.map(p => ({
            ...p,
            preferred: p.platform.indexOf(platform) >= 0,
        }));
    }
    return info2;
};
exports.suggestBridgeInstaller = suggestBridgeInstaller;
//# sourceMappingURL=transportInfo.js.map