"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.enhanceMessageWithAnalytics = void 0;
const connect_analytics_1 = require("@trezor/connect-analytics");
const events_1 = require("../events");
const enhanceMessageWithAnalytics = (message, data) => {
    switch (message.type) {
        case events_1.UI_REQUEST.REQUEST_CONFIRMATION: {
            const { device } = data;
            return {
                ...message,
                payload: {
                    ...message.payload,
                    analytics: {
                        type: connect_analytics_1.EventType.DeviceSelected,
                        payload: {
                            mode: device?.mode || '',
                            pinProtection: device?.features?.pin_protection || '',
                            passphraseProtection: device?.features?.passphrase_protection || '',
                            backupType: device?.features?.backup_type || 'Bip39',
                            language: device?.features?.language || '',
                            model: device?.features?.internal_model || '',
                            vendor: device?.features?.vendor || '',
                            firmwareRevision: device?.features?.revision || '',
                            firmwareType: device?.firmwareType || '',
                            bootloaderHash: device?.features?.bootloader_hash || '',
                        },
                    },
                },
            };
        }
        default:
            return message;
    }
};
exports.enhanceMessageWithAnalytics = enhanceMessageWithAnalytics;
//# sourceMappingURL=analyticsInfo.js.map