"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MiscFeeLevels = void 0;
const bigNumber_1 = require("@trezor/utils/lib/bigNumber");
const cloneObject_1 = require("@trezor/utils/lib/cloneObject");
class MiscFeeLevels {
    coinInfo;
    levels;
    wasFetchedSuccessfully = false;
    constructor(coinInfo) {
        this.coinInfo = coinInfo;
        this.levels = (0, cloneObject_1.cloneObject)(coinInfo.defaultFees);
    }
    async load(blockchain, request) {
        try {
            const [response] = await blockchain.estimateFee(request);
            const fee = new bigNumber_1.BigNumber(response.feePerUnit).toNumber();
            const feePerUnit = Math.min(this.coinInfo.maxFee, Math.max(this.coinInfo.minFee, fee)).toString();
            this.levels[0] = {
                ...this.levels[0],
                ...response,
                feePerUnit,
            };
            this.wasFetchedSuccessfully = true;
        }
        catch {
        }
        return this.levels;
    }
}
exports.MiscFeeLevels = MiscFeeLevels;
//# sourceMappingURL=MiscFeeLevels.js.map