import { Blockchain, BlockchainOptions } from './Blockchain';
import type { BlockchainLink, CoinInfo } from '../types';
type CoinShortcut = CoinInfo['shortcut'];
type BackendParams = Pick<BlockchainOptions, 'coinInfo' | 'postMessage' | 'identity'>;
export declare class BackendManager {
    private readonly instances;
    private readonly reconnect;
    private readonly custom;
    private readonly preferred;
    get(shortcut: CoinShortcut, identity?: string): Blockchain | null;
    getOrConnect({ coinInfo, postMessage, identity }: BackendParams): Promise<Blockchain>;
    dispose(): void;
    reconnectAll(coin?: CoinInfo): Promise<Blockchain[]>;
    isSupported(coinInfo: CoinInfo): void;
    setCustom(shortcut: CoinShortcut, blockchainLink?: BlockchainLink): void;
    private setInstance;
    private setPreferred;
    private onDisconnect;
    private clearReconnect;
    private patchCoinInfo;
    private getReconnectFilter;
}
export {};
//# sourceMappingURL=BackendManager.d.ts.map