"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const schema_utils_1 = require("@trezor/schema-utils");
const constants_1 = require("../constants");
const AbstractMethod_1 = require("../core/AbstractMethod");
const paramsValidator_1 = require("./common/paramsValidator");
const coinInfo_1 = require("../data/coinInfo");
const types_1 = require("../types");
const formatUtils_1 = require("../utils/formatUtils");
const pathUtils_1 = require("../utils/pathUtils");
class VerifyMessage extends AbstractMethod_1.AbstractMethod {
    init() {
        this.requiredPermissions = ['read', 'write'];
        const { payload } = this;
        (0, schema_utils_1.Assert)(types_1.VerifyMessage, payload);
        const coinInfo = (0, coinInfo_1.getBitcoinNetwork)(payload.coin);
        if (!coinInfo) {
            throw constants_1.ERRORS.TypedError('Method_UnknownCoin');
        }
        else {
            this.firmwareRange = (0, paramsValidator_1.getFirmwareRange)(this.name, coinInfo, this.firmwareRange);
        }
        const messageHex = payload.hex
            ? (0, formatUtils_1.messageToHex)(payload.message)
            : Buffer.from(payload.message, 'utf8').toString('hex');
        const signatureHex = Buffer.from(payload.signature, 'base64').toString('hex');
        this.params = {
            address: payload.address,
            signature: signatureHex,
            message: messageHex,
            coin_name: coinInfo.name,
        };
    }
    get info() {
        const coinInfo = (0, coinInfo_1.getBitcoinNetwork)(this.payload.coin);
        if (!coinInfo) {
            return 'Verify message';
        }
        return (0, pathUtils_1.getLabel)('Verify #NETWORK message', coinInfo);
    }
    async run() {
        const cmd = this.device.getCommands();
        const response = await cmd.typedCall('VerifyMessage', 'Success', this.params);
        return response.message;
    }
}
exports.default = VerifyMessage;
//# sourceMappingURL=verifyMessage.js.map