"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.decodeSolanaTokenDefinition = exports.getSolanaTokenDefinition = void 0;
const tslib_1 = require("tslib");
const cross_fetch_1 = tslib_1.__importDefault(require("cross-fetch"));
const protobuf_1 = require("@trezor/protobuf");
const protocol_1 = require("@trezor/protocol");
const schema_utils_1 = require("@trezor/schema-utils");
const DataManager_1 = require("../../data/DataManager");
const getSolanaTokenDefinition = async ({ mintAddress }) => {
    try {
        if (mintAddress) {
            const tokenDefinitionUrl = `https://data.trezor.io/firmware/definitions/solana/token/${mintAddress}.dat`;
            const tokenDefinition = await (0, cross_fetch_1.default)(tokenDefinitionUrl);
            if (tokenDefinition.status === 200) {
                const arrayBuffer = await tokenDefinition.arrayBuffer();
                return arrayBuffer;
            }
            else if (tokenDefinition.status !== 404) {
                throw new Error(`unexpected status: $${tokenDefinition.status}`);
            }
        }
    }
    catch (err) {
        console.warn(`unable to download or parse solana token ${mintAddress} definition. detail: ${err.message}`);
    }
    return undefined;
};
exports.getSolanaTokenDefinition = getSolanaTokenDefinition;
const decodeSolanaTokenDefinition = (encodedDefinition) => {
    const messages = DataManager_1.DataManager.getProtobufMessages();
    const proto = (0, protobuf_1.parseConfigure)(messages);
    const { protobufPayload } = protocol_1.trzd.decode(encodedDefinition);
    const { message: decodedTokenDefinition } = (0, protobuf_1.decodeMessage)(proto, 'SolanaTokenInfo', protobufPayload);
    (0, schema_utils_1.Assert)(protobuf_1.MessagesSchema.SolanaTokenInfo, decodedTokenDefinition);
    return decodedTokenDefinition;
};
exports.decodeSolanaTokenDefinition = decodeSolanaTokenDefinition;
//# sourceMappingURL=solanaDefinitions.js.map