import { PROTO } from '../constants';
import { AbstractMethod } from '../core/AbstractMethod';
import type { AccountAddresses, BitcoinNetworkInfo } from '../types';
import type { RefTransaction, TransactionOptions } from '../types/api/bitcoin';
type Params = {
    inputs: PROTO.TxInputType[];
    outputs: PROTO.TxOutputType[];
    paymentRequests: PROTO.PaymentRequest[];
    coinjoinRequest?: PROTO.CoinJoinRequest;
    refTxs?: RefTransaction[];
    addresses?: AccountAddresses;
    options: TransactionOptions;
    coinInfo: BitcoinNetworkInfo;
    identity?: string;
    push: boolean;
    unlockPath?: PROTO.UnlockPath;
};
export default class SignTransaction extends AbstractMethod<'signTransaction', Params> {
    init(): void;
    get info(): string;
    payloadToPrecomposed(): Promise<{
        type: "final";
        inputs: (({
            sequence?: number | undefined;
            multisig?: {
                address_n?: number[] | undefined;
                nodes?: {
                    private_key?: string | undefined;
                    depth: number;
                    fingerprint: number;
                    child_num: number;
                    chain_code: string;
                    public_key: string;
                }[] | undefined;
                pubkeys_order?: PROTO.MultisigPubkeysOrder | undefined;
                pubkeys: {
                    address_n: number[];
                    node: string | {
                        private_key?: string | undefined;
                        depth: number;
                        fingerprint: number;
                        child_num: number;
                        chain_code: string;
                        public_key: string;
                    };
                }[];
                signatures: string[];
                m: number;
            } | undefined;
            decred_tree?: number | undefined;
            orig_hash?: string | undefined;
            orig_index?: number | undefined;
            decred_staking_spend?: PROTO.DecredStakingSpendType | undefined;
            script_pubkey?: string | undefined;
            coinjoin_flags?: number | undefined;
            script_sig?: string | undefined;
            witness?: string | undefined;
            ownership_proof?: string | undefined;
            commitment_data?: string | undefined;
            prev_hash: string;
            prev_index: number;
            amount: string | number;
        } & {
            script_type?: "SPENDADDRESS" | "SPENDMULTISIG" | "SPENDWITNESS" | "SPENDP2SHWITNESS" | "SPENDTAPROOT" | undefined;
            address_n: number[];
        }) | ({
            sequence?: number | undefined;
            multisig?: {
                address_n?: number[] | undefined;
                nodes?: {
                    private_key?: string | undefined;
                    depth: number;
                    fingerprint: number;
                    child_num: number;
                    chain_code: string;
                    public_key: string;
                }[] | undefined;
                pubkeys_order?: PROTO.MultisigPubkeysOrder | undefined;
                pubkeys: {
                    address_n: number[];
                    node: string | {
                        private_key?: string | undefined;
                        depth: number;
                        fingerprint: number;
                        child_num: number;
                        chain_code: string;
                        public_key: string;
                    };
                }[];
                signatures: string[];
                m: number;
            } | undefined;
            decred_tree?: number | undefined;
            orig_hash?: string | undefined;
            orig_index?: number | undefined;
            decred_staking_spend?: PROTO.DecredStakingSpendType | undefined;
            script_pubkey?: string | undefined;
            coinjoin_flags?: number | undefined;
            script_sig?: string | undefined;
            witness?: string | undefined;
            ownership_proof?: string | undefined;
            commitment_data?: string | undefined;
            prev_hash: string;
            prev_index: number;
            amount: string | number;
        } & {
            address_n?: undefined;
            script_pubkey: string;
            script_type: "EXTERNAL";
        }))[];
        outputs: ({
            address_n?: undefined;
            multisig?: {
                address_n?: number[] | undefined;
                nodes?: {
                    private_key?: string | undefined;
                    depth: number;
                    fingerprint: number;
                    child_num: number;
                    chain_code: string;
                    public_key: string;
                }[] | undefined;
                pubkeys_order?: PROTO.MultisigPubkeysOrder | undefined;
                pubkeys: {
                    address_n: number[];
                    node: string | {
                        private_key?: string | undefined;
                        depth: number;
                        fingerprint: number;
                        child_num: number;
                        chain_code: string;
                        public_key: string;
                    };
                }[];
                signatures: string[];
                m: number;
            } | undefined;
            orig_hash?: string | undefined;
            orig_index?: number | undefined;
            payment_req_index?: number | undefined;
            address: string;
            amount: string | number;
            script_type: "PAYTOADDRESS";
        } | {
            address?: undefined;
            multisig?: {
                address_n?: number[] | undefined;
                nodes?: {
                    private_key?: string | undefined;
                    depth: number;
                    fingerprint: number;
                    child_num: number;
                    chain_code: string;
                    public_key: string;
                }[] | undefined;
                pubkeys_order?: PROTO.MultisigPubkeysOrder | undefined;
                pubkeys: {
                    address_n: number[];
                    node: string | {
                        private_key?: string | undefined;
                        depth: number;
                        fingerprint: number;
                        child_num: number;
                        chain_code: string;
                        public_key: string;
                    };
                }[];
                signatures: string[];
                m: number;
            } | undefined;
            orig_hash?: string | undefined;
            orig_index?: number | undefined;
            script_type?: "PAYTOADDRESS" | "PAYTOSCRIPTHASH" | "PAYTOMULTISIG" | "PAYTOWITNESS" | "PAYTOP2SHWITNESS" | "PAYTOTAPROOT" | undefined;
            payment_req_index?: number | undefined;
            address_n: number[];
            amount: string | number;
        } | {
            address_n?: undefined;
            multisig?: {
                address_n?: number[] | undefined;
                nodes?: {
                    private_key?: string | undefined;
                    depth: number;
                    fingerprint: number;
                    child_num: number;
                    chain_code: string;
                    public_key: string;
                }[] | undefined;
                pubkeys_order?: PROTO.MultisigPubkeysOrder | undefined;
                pubkeys: {
                    address_n: number[];
                    node: string | {
                        private_key?: string | undefined;
                        depth: number;
                        fingerprint: number;
                        child_num: number;
                        chain_code: string;
                        public_key: string;
                    };
                }[];
                signatures: string[];
                m: number;
            } | undefined;
            orig_hash?: string | undefined;
            orig_index?: number | undefined;
            script_type?: "PAYTOADDRESS" | "PAYTOSCRIPTHASH" | "PAYTOMULTISIG" | "PAYTOWITNESS" | "PAYTOP2SHWITNESS" | "PAYTOTAPROOT" | undefined;
            payment_req_index?: number | undefined;
            address: string;
            amount: string | number;
        } | {
            address_n?: undefined;
            address?: undefined;
            orig_hash?: string | undefined;
            orig_index?: number | undefined;
            payment_req_index?: number | undefined;
            amount: 0 | "0";
            script_type: "PAYTOOPRETURN";
            op_return_data: string;
        })[];
        outputsPermutation: number[];
        totalSpent: string;
        fee: string;
        feePerByte: string;
        bytes: number;
    } | undefined>;
    private fetchAddresses;
    private fetchRefTxs;
    run(): Promise<import("../types").SignedTransaction>;
}
export {};
//# sourceMappingURL=signTransaction.d.ts.map