"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const AbstractMethod_1 = require("../core/AbstractMethod");
const events_1 = require("../events");
const paramsValidator_1 = require("./common/paramsValidator");
class ShowDeviceTutorial extends AbstractMethod_1.AbstractMethod {
    init() {
        this.firmwareRange = (0, paramsValidator_1.getFirmwareRange)(this.name, null, this.firmwareRange);
        this.useEmptyPassphrase = true;
        this.useDeviceState = false;
        this.allowDeviceMode = [events_1.UI.INITIALIZE];
    }
    get info() {
        return 'Show device tutorial';
    }
    async run() {
        const cmd = this.device.getCommands();
        const response = await cmd.typedCall('ShowDeviceTutorial', 'Success');
        return response.message;
    }
}
exports.default = ShowDeviceTutorial;
//# sourceMappingURL=showDeviceTutorial.js.map