"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const schema_utils_1 = require("@trezor/schema-utils");
const AbstractMethod_1 = require("../core/AbstractMethod");
const events_1 = require("../events");
const recoveryDevice_1 = require("../types/api/recoveryDevice");
class RecoveryDevice extends AbstractMethod_1.AbstractMethod {
    init() {
        this.requiredPermissions = ['management'];
        this.skipFinalReload = false;
        this.useEmptyPassphrase = true;
        const { payload } = this;
        (0, schema_utils_1.Assert)(recoveryDevice_1.RecoveryDevice, payload);
        this.params = {
            word_count: payload.word_count,
            passphrase_protection: payload.passphrase_protection,
            pin_protection: payload.pin_protection,
            language: payload.language,
            label: payload.label,
            enforce_wordlist: payload.enforce_wordlist,
            input_method: payload.input_method,
            type: payload.type,
            u2f_counter: payload.u2f_counter,
        };
        this.allowDeviceMode = [...this.allowDeviceMode, events_1.UI.INITIALIZE];
        this.useDeviceState = false;
    }
    get confirmation() {
        return {
            view: 'device-management',
            customConfirmButton: {
                className: 'confirm',
                label: 'Proceed',
            },
            label: 'Do you want to recover device from seed?',
        };
    }
    async run() {
        const cmd = this.device.getCommands();
        const response = await cmd.typedCall('RecoveryDevice', 'Success', this.params);
        return response.message;
    }
    get info() {
        return 'Recover device';
    }
}
exports.default = RecoveryDevice;
//# sourceMappingURL=recoveryDevice.js.map