"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const AbstractMethod_1 = require("../core/AbstractMethod");
const events_1 = require("../events");
class GetFeatures extends AbstractMethod_1.AbstractMethod {
    init() {
        this.requiredPermissions = [];
        this.useUi = false;
        this.allowDeviceMode = [...this.allowDeviceMode, events_1.UI.INITIALIZE, events_1.UI.BOOTLOADER];
        this.useDeviceState = false;
        this.skipFirmwareCheck = true;
        this.skipFinalReload = true;
    }
    run() {
        return Promise.resolve(this.device.features);
    }
}
exports.default = GetFeatures;
//# sourceMappingURL=getFeatures.js.map